/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.util;

import java.util.ArrayList;
import kiyut.sketsa.options.CodeFormatOptions;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XMLSupport;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class DOMUtilities {
    private DOMUtilities() {
        throw new Error("DOMUtilities is a utility class for static methods");
    }

    public static void normalizeDocument(Document doc) {
        ArrayList<Node> list = new ArrayList<Node>();
        DocumentTraversal travelsal = (DocumentTraversal)((Object)doc);
        NodeIterator iter = travelsal.createNodeIterator(doc, 4, null, false);
        Node node = iter.nextNode();
        if (node != null) {
            node = iter.nextNode();
        }
        while (node != null) {
            boolean preserve = XMLSupport.getXMLSpace((Element)((Element)node.getParentNode())).equals("preserve");
            if (!preserve && node.getNodeValue().trim().length() == 0) {
                list.add(node);
            }
            node = iter.nextNode();
        }
        for (int i = 0; i < list.size(); ++i) {
            node = (Node)list.get(i);
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
    }

    public static void updateProperty(SVGStylable stylable, String ns, String name, String value) {
        boolean stylingCSS = CodeFormatOptions.getInstance().isStylingCSS();
        CSSStyleDeclaration cssStyle = stylable.getStyle();
        if (stylingCSS) {
            if (value == null) {
                cssStyle.removeProperty(name);
                if (cssStyle.getLength() == 0) {
                    ((Element)stylable).removeAttribute("style");
                }
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < value.length(); ++i) {
                    char c = value.charAt(i);
                    if (c == '\"') {
                        sb.append("'");
                        continue;
                    }
                    sb.append(c);
                }
                cssStyle.setProperty(name, sb.toString(), "");
            }
            ((Element)stylable).removeAttribute(name);
        } else {
            Element element = (Element)stylable;
            if (value == null) {
                element.removeAttributeNS(ns, name);
            } else {
                element.setAttributeNS(ns, name, value);
            }
            cssStyle.removeProperty(name);
            if (cssStyle.getLength() == 0) {
                ((Element)stylable).removeAttribute("style");
            }
        }
    }

    @Deprecated
    public static Document copyDocument(Document srcDoc) {
        return DOMUtilities.deepCloneDocument(srcDoc);
    }

    public static Document deepCloneDocument(Document doc) {
        SVGOMDocument omDoc;
        String uri;
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document copy = org.apache.batik.dom.util.DOMUtilities.deepCloneDocument((Document)doc, (DOMImplementation)impl);
        if (doc instanceof SVGOMDocument && (uri = (omDoc = (SVGOMDocument)doc).getDocumentURI()) != null) {
            ((SVGOMDocument)copy).setDocumentURI(uri);
        }
        return copy;
    }
}

