/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.tool;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.List;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.ext.awt.geom.ExtendedPathIterator;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.apache.batik.gvt.ShapePainter;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegClosePath;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGTextElement;

public class PathModifier {
    private VectorCanvas canvas;

    @Deprecated
    public void convertToPath(VectorCanvas canvas) {
        this.objectToPath(canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectToPath(VectorCanvas canvas) {
        List<SVGElement> l = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (l.isEmpty()) {
            return;
        }
        this.canvas = canvas;
        CanvasModel model = canvas.getModel();
        SVGDocument doc = model.getSVGDocument();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Object To Path");
        try {
            for (int i = 0; i < l.size(); ++i) {
                SVGElement elt = l.get(i);
                if (this.isConvertableGraphicsElement(elt)) {
                    Shape shape = this.convertToShape(canvas, elt);
                    SVGElement newElt = this.convertToDOM(doc, shape.getPathIterator(null));
                    this.replaceSVGElement(elt, newElt);
                    newList.add(newElt);
                    continue;
                }
                newList.add(elt);
            }
        }
        finally {
            undoManager.end();
        }
        canvas.getCanvasSelection().setSelectionList(newList);
        if (canvas.getTool() != null) {
            canvas.getTool().startTool();
        }
        canvas.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void strokeToPath(VectorCanvas canvas) {
        List<SVGElement> l = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (l.isEmpty()) {
            return;
        }
        this.canvas = canvas;
        CanvasModel model = canvas.getModel();
        SVGDocument doc = model.getSVGDocument();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Stroke To Path");
        try {
            for (int i = 0; i < l.size(); ++i) {
                SVGElement elt = l.get(i);
                if (this.isConvertableGraphicsElement(elt)) {
                    Shape shape = this.convertToShape(canvas, elt, false);
                    GraphicsNode gn = model.getGraphicsNode(elt);
                    if (gn instanceof ShapeNode) {
                        ShapeNode sn = (ShapeNode)gn;
                        ShapePainter painter = sn.getShapePainter();
                        shape = painter.getPaintedArea();
                        SVGElement newElt = this.convertToDOM(doc, shape.getPathIterator(null));
                        this.replaceSVGElement(elt, newElt);
                        newElt.setAttributeNS(null, "stroke-width", "1");
                        newList.add(newElt);
                        continue;
                    }
                    newList.add(elt);
                    continue;
                }
                newList.add(elt);
            }
        }
        finally {
            undoManager.end();
        }
        canvas.getCanvasSelection().setSelectionList(newList);
        if (canvas.getTool() != null) {
            canvas.getTool().startTool();
        }
        canvas.refresh();
    }

    @Deprecated
    private void simplify(VectorCanvas canvas) {
    }

    private boolean isConvertableGraphicsElement(SVGElement elt) {
        boolean b = false;
        if (elt instanceof SVGRectElement || elt instanceof SVGEllipseElement || elt instanceof SVGCircleElement || elt instanceof SVGLineElement || elt instanceof SVGPolylineElement || elt instanceof SVGPolygonElement || elt instanceof SVGPathElement || elt instanceof SVGTextElement) {
            b = true;
        }
        return b;
    }

    @Deprecated
    private Shape convertToShape(VectorCanvas canvas, SVGElement elt) {
        return this.convertToShape(canvas, elt, false);
    }

    private Shape convertToShape(VectorCanvas canvas, SVGElement elt, boolean includeTransform) {
        Shape shape = null;
        CanvasModel model = canvas.getModel();
        if (this.isConvertableGraphicsElement(elt)) {
            GraphicsNode gn = model.getGraphicsNode(elt);
            shape = gn.getOutline();
            if (includeTransform) {
                AffineTransform at = gn.getGlobalTransform();
                shape = at.createTransformedShape(shape);
            }
        }
        return shape;
    }

    @Deprecated
    private SVGElement convertToDOM(SVGDocument doc, Shape shape) {
        return this.convertToDOM(doc, shape.getPathIterator(null));
    }

    private SVGElement convertToDOM(SVGDocument doc, PathIterator pi) {
        SVGPathElement pathElement = null;
        pathElement = (SVGPathElement)doc.createElementNS("http://www.w3.org/2000/svg", "path");
        float[] coords = new float[6];
        while (!pi.isDone()) {
            SVGPathSegCurvetoCubicAbs svgCubic;
            int segment = pi.currentSegment(coords);
            if (segment == 0) {
                SVGPathSegMovetoAbs svgMoveTo = pathElement.createSVGPathSegMovetoAbs(coords[0], coords[1]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgMoveTo);
            } else if (segment == 4) {
                SVGPathSegClosePath svgClosePath = pathElement.createSVGPathSegClosePath();
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgClosePath);
            } else if (segment == 1) {
                svgCubic = pathElement.createSVGPathSegCurvetoCubicAbs(coords[0], coords[1], coords[0], coords[1], coords[0], coords[1]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgCubic);
            } else if (segment == 2) {
                svgCubic = pathElement.createSVGPathSegCurvetoCubicAbs(coords[2], coords[3], coords[0], coords[1], coords[0], coords[1]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgCubic);
            } else if (segment == 3) {
                svgCubic = pathElement.createSVGPathSegCurvetoCubicAbs(coords[4], coords[5], coords[0], coords[1], coords[2], coords[3]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgCubic);
            }
            pi.next();
        }
        return pathElement;
    }

    private void replaceSVGElement(SVGElement elt1, SVGElement elt2) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("id");
        l.add("style");
        l.add("fill");
        l.add("fill-opacity");
        l.add("fill-rule");
        l.add("stroke");
        l.add("stroke-dasharray");
        l.add("stroke-dashoffset");
        l.add("stroke-linecap");
        l.add("stroke-linejoin");
        l.add("stroke-miterlimit");
        l.add("stroke-opacity");
        l.add("stroke-width");
        l.add("filter");
        l.add("transform");
        for (int i = 0; i < l.size(); ++i) {
            Attr attr = elt1.getAttributeNodeNS(null, (String)l.get(i));
            if (attr == null) continue;
            elt2.setAttributeNodeNS((Attr)attr.cloneNode(true));
        }
        Node parent = elt1.getParentNode();
        parent.replaceChild((Node)elt2, (Node)elt1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void combine(VectorCanvas canvas) {
        SVGElement elt;
        List<SVGElement> l = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (l.isEmpty()) {
            return;
        }
        if (l.size() <= 1) {
            return;
        }
        ExtendedGeneralPath shape = null;
        Shape curShape = null;
        for (int i = l.size() - 1; i >= 0; --i) {
            elt = l.get(i);
            if (!this.isConvertableGraphicsElement(elt)) continue;
            curShape = this.convertToShape(canvas, elt, true);
            if (shape == null) {
                shape = new ExtendedGeneralPath(curShape);
                continue;
            }
            ((ExtendedGeneralPath)shape).append(curShape, false);
        }
        CanvasModel model = canvas.getModel();
        SVGDocument doc = model.getSVGDocument();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Combine");
        try {
            AffineTransform invAt = null;
            SVGElement baseElt = l.get(l.size() - 1);
            if (this.isConvertableGraphicsElement(baseElt)) {
                GraphicsNode gn = model.getGraphicsNode(baseElt);
                try {
                    invAt = gn.getGlobalTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            SVGElement newElt = this.convertToDOM(doc, shape.getPathIterator(invAt));
            this.replaceSVGElement(baseElt, newElt);
            newList.add(newElt);
            if (l.size() > 1) {
                for (int i = 0; i < l.size() - 1; ++i) {
                    elt = l.get(i);
                    if (!this.isConvertableGraphicsElement(elt)) continue;
                    elt.getParentNode().removeChild((Node)elt);
                }
            }
        }
        finally {
            undoManager.end();
        }
        canvas.getCanvasSelection().setSelectionList(newList);
        if (canvas.getTool() != null) {
            canvas.getTool().startTool();
        }
        canvas.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakApart(VectorCanvas canvas) {
        List<SVGElement> l = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (l.isEmpty()) {
            return;
        }
        if (l.size() != 1) {
            return;
        }
        SVGElement elt = l.get(0);
        if (!(elt instanceof SVGPathElement)) {
            return;
        }
        ExtendedGeneralPath baseShape = (ExtendedGeneralPath)this.convertToShape(canvas, elt, false);
        ExtendedPathIterator pi = baseShape.getExtendedPathIterator();
        CanvasModel model = canvas.getModel();
        SVGDocument doc = model.getSVGDocument();
        ArrayList<SVGPathElement> pathList = new ArrayList<SVGPathElement>();
        SVGPathElement pathElement = null;
        float[] coords = new float[7];
        while (!pi.isDone()) {
            SVGPathSegClosePath svgPathSeg;
            int segment = pi.currentSegment(coords);
            if (segment == 0) {
                pathElement = (SVGPathElement)doc.createElementNS("http://www.w3.org/2000/svg", "path");
                pathList.add(pathElement);
                svgPathSeg = pathElement.createSVGPathSegMovetoAbs(coords[0], coords[1]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgPathSeg);
            } else if (segment == 4) {
                svgPathSeg = pathElement.createSVGPathSegClosePath();
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgPathSeg);
            } else if (segment == 1) {
                svgPathSeg = pathElement.createSVGPathSegLinetoAbs(coords[0], coords[1]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgPathSeg);
            } else if (segment == 2) {
                svgPathSeg = pathElement.createSVGPathSegCurvetoQuadraticAbs(coords[2], coords[3], coords[0], coords[1]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgPathSeg);
            } else if (segment == 3) {
                svgPathSeg = pathElement.createSVGPathSegCurvetoCubicAbs(coords[4], coords[5], coords[0], coords[1], coords[2], coords[3]);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgPathSeg);
            } else if (segment == 4321) {
                svgPathSeg = pathElement.createSVGPathSegArcAbs(coords[5], coords[6], coords[0], coords[1], coords[2], coords[3] != 0.0f, coords[4] != 0.0f);
                pathElement.getPathSegList().appendItem((SVGPathSeg)svgPathSeg);
            }
            pi.next();
        }
        if (pathList.size() == 1) {
            return;
        }
        ArrayList<String> attrNameList = new ArrayList<String>();
        attrNameList.add("style");
        attrNameList.add("fill");
        attrNameList.add("fill-opacity");
        attrNameList.add("fill-rule");
        attrNameList.add("stroke");
        attrNameList.add("stroke-dasharray");
        attrNameList.add("stroke-dashoffset");
        attrNameList.add("stroke-linecap");
        attrNameList.add("stroke-linejoin");
        attrNameList.add("stroke-miterlimit");
        attrNameList.add("stroke-opacity");
        attrNameList.add("stroke-width");
        attrNameList.add("filter");
        attrNameList.add("transform");
        ArrayList<Attr> attrList = new ArrayList<Attr>();
        Attr attr = null;
        for (int i = 0; i < attrNameList.size(); ++i) {
            attr = elt.getAttributeNodeNS(null, (String)attrNameList.get(i));
            if (attr == null) continue;
            attrList.add(attr);
        }
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        SVGPathElement newElt = null;
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Break Apart");
        try {
            Node parentNode = elt.getParentNode();
            Node sibling = elt.getNextSibling();
            for (int i = 0; i < pathList.size(); ++i) {
                newElt = (SVGPathElement)pathList.get(i);
                if (attrList.size() > 0) {
                    for (int j = 0; j < attrList.size(); ++j) {
                        attr = (Attr)attrList.get(j);
                        newElt.setAttributeNodeNS((Attr)attr.cloneNode(true));
                    }
                }
                newList.add((SVGElement)newElt);
                if (sibling == null) {
                    parentNode.appendChild((Node)newElt);
                    continue;
                }
                parentNode.insertBefore((Node)newElt, sibling);
            }
            parentNode.removeChild((Node)elt);
        }
        finally {
            undoManager.end();
        }
        canvas.getCanvasSelection().setSelectionList(newList);
        if (canvas.getTool() != null) {
            canvas.getTool().startTool();
        }
        canvas.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(VectorCanvas canvas) {
        SVGElement elt;
        List<SVGElement> l = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (l.isEmpty()) {
            return;
        }
        if (l.size() <= 1) {
            return;
        }
        Area area = new Area();
        for (int i = l.size() - 1; i >= 0; --i) {
            elt = l.get(i);
            if (!this.isConvertableGraphicsElement(elt)) continue;
            Shape shape = this.convertToShape(canvas, elt, true);
            area.add(new Area(shape));
        }
        CanvasModel model = canvas.getModel();
        SVGDocument doc = model.getSVGDocument();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Union");
        try {
            AffineTransform invAt = null;
            SVGElement baseElt = l.get(l.size() - 1);
            if (this.isConvertableGraphicsElement(baseElt)) {
                GraphicsNode gn = model.getGraphicsNode(baseElt);
                try {
                    invAt = gn.getGlobalTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            SVGElement newElt = this.convertToDOM(doc, area.getPathIterator(invAt));
            this.replaceSVGElement(baseElt, newElt);
            newList.add(newElt);
            if (l.size() > 1) {
                for (int i = 0; i < l.size() - 1; ++i) {
                    elt = l.get(i);
                    if (!this.isConvertableGraphicsElement(elt)) continue;
                    elt.getParentNode().removeChild((Node)elt);
                }
            }
        }
        finally {
            undoManager.end();
        }
        canvas.getCanvasSelection().setSelectionList(newList);
        if (canvas.getTool() != null) {
            canvas.getTool().startTool();
        }
        canvas.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtract(VectorCanvas canvas) {
        SVGElement elt;
        List<SVGElement> l = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (l.isEmpty()) {
            return;
        }
        if (l.size() <= 1) {
            return;
        }
        Area area = new Area();
        for (int i = l.size() - 1; i >= 0; --i) {
            elt = l.get(i);
            if (!this.isConvertableGraphicsElement(elt)) continue;
            Shape shape = this.convertToShape(canvas, elt, true);
            if (i == l.size() - 1) {
                area.add(new Area(shape));
                continue;
            }
            area.subtract(new Area(shape));
        }
        CanvasModel model = canvas.getModel();
        SVGDocument doc = model.getSVGDocument();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Subtract");
        try {
            AffineTransform invAt = null;
            SVGElement baseElt = l.get(l.size() - 1);
            if (this.isConvertableGraphicsElement(baseElt)) {
                GraphicsNode gn = model.getGraphicsNode(baseElt);
                try {
                    invAt = gn.getGlobalTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            SVGElement newElt = this.convertToDOM(doc, area.getPathIterator(invAt));
            this.replaceSVGElement(baseElt, newElt);
            newList.add(newElt);
            if (l.size() > 1) {
                for (int i = 0; i < l.size() - 1; ++i) {
                    elt = l.get(i);
                    if (!this.isConvertableGraphicsElement(elt)) continue;
                    elt.getParentNode().removeChild((Node)elt);
                }
            }
        }
        finally {
            undoManager.end();
        }
        canvas.getCanvasSelection().setSelectionList(newList);
        if (canvas.getTool() != null) {
            canvas.getTool().startTool();
        }
        canvas.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intersect(VectorCanvas canvas) {
        SVGElement elt;
        List<SVGElement> l = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (l.isEmpty()) {
            return;
        }
        if (l.size() <= 1) {
            return;
        }
        Area area = new Area();
        for (int i = l.size() - 1; i >= 0; --i) {
            elt = l.get(i);
            if (!this.isConvertableGraphicsElement(elt)) continue;
            Shape shape = this.convertToShape(canvas, elt, true);
            if (i == l.size() - 1) {
                area.add(new Area(shape));
                continue;
            }
            area.intersect(new Area(shape));
        }
        CanvasModel model = canvas.getModel();
        SVGDocument doc = model.getSVGDocument();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Intersect");
        try {
            AffineTransform invAt = null;
            SVGElement baseElt = l.get(l.size() - 1);
            if (this.isConvertableGraphicsElement(baseElt)) {
                GraphicsNode gn = model.getGraphicsNode(baseElt);
                try {
                    invAt = gn.getGlobalTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            SVGElement newElt = this.convertToDOM(doc, area.getPathIterator(invAt));
            this.replaceSVGElement(baseElt, newElt);
            newList.add(newElt);
            if (l.size() > 1) {
                for (int i = 0; i < l.size() - 1; ++i) {
                    elt = l.get(i);
                    if (!this.isConvertableGraphicsElement(elt)) continue;
                    elt.getParentNode().removeChild((Node)elt);
                }
            }
        }
        finally {
            undoManager.end();
        }
        canvas.getCanvasSelection().setSelectionList(newList);
        if (canvas.getTool() != null) {
            canvas.getTool().startTool();
        }
        canvas.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exclusiveOr(VectorCanvas canvas) {
        SVGElement elt;
        List<SVGElement> l = CanvasUtilities.getGraphicsElement(canvas.getCanvasSelection().getSelectionList());
        if (l.isEmpty()) {
            return;
        }
        if (l.size() <= 1) {
            return;
        }
        Area area = new Area();
        for (int i = l.size() - 1; i >= 0; --i) {
            elt = l.get(i);
            if (!this.isConvertableGraphicsElement(elt)) continue;
            Shape shape = this.convertToShape(canvas, elt, true);
            if (i == l.size() - 1) {
                area.add(new Area(shape));
                continue;
            }
            area.exclusiveOr(new Area(shape));
        }
        CanvasModel model = canvas.getModel();
        SVGDocument doc = model.getSVGDocument();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        DOMUndoManager undoManager = canvas.getUndoManager();
        undoManager.start("Exclusive Or");
        try {
            AffineTransform invAt = null;
            SVGElement baseElt = l.get(l.size() - 1);
            if (this.isConvertableGraphicsElement(baseElt)) {
                GraphicsNode gn = model.getGraphicsNode(baseElt);
                try {
                    invAt = gn.getGlobalTransform().createInverse();
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            SVGElement newElt = this.convertToDOM(doc, area.getPathIterator(invAt));
            this.replaceSVGElement(baseElt, newElt);
            newList.add(newElt);
            if (l.size() > 1) {
                for (int i = 0; i < l.size() - 1; ++i) {
                    elt = l.get(i);
                    if (!this.isConvertableGraphicsElement(elt)) continue;
                    elt.getParentNode().removeChild((Node)elt);
                }
            }
        }
        finally {
            undoManager.end();
        }
        canvas.getCanvasSelection().setSelectionList(newList);
        if (canvas.getTool() != null) {
            canvas.getTool().startTool();
        }
        canvas.refresh();
    }
}

