/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.tool;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.options.GeneralOptions;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.util.UnitConversion;
import kiyut.swing.combo.SeparatorComboBox;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGStylable;

public class NewDocumentPane
extends JPanel {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.tool.NewDocumentPane");
    private List<String[]> sizeList;
    private List<String[]> unitList;
    private String oldUnit;
    private int dpi = 96;
    private float width;
    private float height;
    private JComboBox colorInterpolationCombo;
    private JComboBox colorRenderingCombo;
    private JPanel geometryPane;
    private JTextField heightField;
    private JLabel heightLabel;
    private JComboBox imageRenderingCombo;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel renderingPane;
    private JComboBox shapeRenderingCombo;
    private JComboBox sizeCombo;
    private JComboBox textRenderingCombo;
    private JComboBox unitCombo;
    private JTextField widthField;
    private JLabel widthLabel;

    public NewDocumentPane() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.geometryPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel7 = new JLabel();
        this.widthLabel = new JLabel();
        this.heightLabel = new JLabel();
        this.sizeCombo = new SeparatorComboBox();
        this.unitCombo = new JComboBox();
        this.widthField = new JTextField();
        this.heightField = new JTextField();
        this.renderingPane = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.colorInterpolationCombo = new JComboBox();
        this.colorRenderingCombo = new JComboBox();
        this.shapeRenderingCombo = new JComboBox();
        this.textRenderingCombo = new JComboBox();
        this.imageRenderingCombo = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.setLayout(new GridBagLayout());
        this.geometryPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_GeometryProperty.Text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        this.geometryPane.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("CTL_Size.Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.geometryPane.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel7.setText(bundle.getString("CTL_Unit.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.geometryPane.add((Component)this.jLabel7, gridBagConstraints);
        this.widthLabel.setText(bundle.getString("CTL_Width.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.geometryPane.add((Component)this.widthLabel, gridBagConstraints);
        this.heightLabel.setText(bundle.getString("CTL_Height.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.geometryPane.add((Component)this.heightLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.geometryPane.add((Component)this.sizeCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.geometryPane.add((Component)this.unitCombo, gridBagConstraints);
        this.widthField.setColumns(10);
        this.widthField.setText("400");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.geometryPane.add((Component)this.widthField, gridBagConstraints);
        this.heightField.setText("400");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.geometryPane.add((Component)this.heightField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.geometryPane, gridBagConstraints);
        this.renderingPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_RenderingProperty.Text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        this.renderingPane.setLayout(new GridBagLayout());
        this.jLabel2.setText(bundle.getString("CTL_TextRendering.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.renderingPane.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(bundle.getString("CTL_ShapeRendering.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.renderingPane.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(bundle.getString("CTL_ColorInterpolation.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.renderingPane.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel5.setText(bundle.getString("CTL_ColorRendering.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.renderingPane.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(bundle.getString("CTL_ImageRendering.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.renderingPane.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.renderingPane.add((Component)this.colorInterpolationCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.renderingPane.add((Component)this.colorRenderingCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.renderingPane.add((Component)this.shapeRenderingCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.renderingPane.add((Component)this.textRenderingCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.renderingPane.add((Component)this.imageRenderingCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.renderingPane, gridBagConstraints);
    }

    private void initCustomComponents() {
        String[] item;
        int i;
        GeneralOptions opts = GeneralOptions.getInstance();
        this.sizeList = new ArrayList<String[]>();
        this.sizeList.add(new String[]{"Custom", "", "", ""});
        this.sizeList.add(new String[]{"Default", Float.toString(opts.getDefaultSVGWidth()), Float.toString(opts.getDefaultSVGHeight()), "px"});
        this.sizeList.add(new String[]{"--", "", "", ""});
        this.sizeList.add(new String[]{"640 x 480", "640", "480", "px"});
        this.sizeList.add(new String[]{"800 x 600", "800", "600", "px"});
        this.sizeList.add(new String[]{"1024 x 768", "1024", "768", "px"});
        this.sizeList.add(new String[]{"--", "", "", ""});
        this.sizeList.add(new String[]{"234 x 60 [Half Banner]", "234", "60", "px"});
        this.sizeList.add(new String[]{"468 x 60 [Banner]", "468", "60", "px"});
        this.sizeList.add(new String[]{"728 x 90 [Banner Leaderboard]", "728", "90", "px"});
        this.sizeList.add(new String[]{"120 x 240 [Vertical Banner]", "120", "240", "px"});
        this.sizeList.add(new String[]{"120 x 600 [Banner Skyscraper]", "120", "600", "px"});
        this.sizeList.add(new String[]{"160 x 600 [Banner Wide Skyscraper]", "160", "600", "px"});
        this.sizeList.add(new String[]{"125 x 125 [Web Button]", "125", "125", "px"});
        this.sizeList.add(new String[]{"--", "", "", ""});
        this.sizeList.add(new String[]{"A3", "297.01", "419.950", "mm"});
        this.sizeList.add(new String[]{"A4", "209.97", "297.01", "mm"});
        this.sizeList.add(new String[]{"A5", "148.51", "209.97", "mm"});
        this.sizeList.add(new String[]{"A6", "104.99", "148.51", "mm"});
        this.sizeList.add(new String[]{"B4", "250.02", "352.98", "mm"});
        this.sizeList.add(new String[]{"B5", "176.02", "250.00", "mm"});
        this.sizeList.add(new String[]{"US-Letter", "8.50", "11.00", "in"});
        this.sizeList.add(new String[]{"US-Legal", "8.50", "14.00", "in"});
        this.sizeList.add(new String[]{"--", "", "", ""});
        this.sizeList.add(new String[]{"CD Cover [120.99 x 119.97 mm]", "120.99", "119.97", "mm"});
        this.unitList = new ArrayList<String[]>();
        this.unitList.add(new String[]{"pixel", "px"});
        this.unitList.add(new String[]{"inch", "in"});
        this.unitList.add(new String[]{"centimeter", "cm"});
        this.unitList.add(new String[]{"millimeter", "mm"});
        for (i = 0; i < this.unitList.size(); ++i) {
            item = this.unitList.get(i);
            this.unitCombo.addItem(item[0]);
        }
        for (i = 0; i < this.sizeList.size(); ++i) {
            item = this.sizeList.get(i);
            this.sizeCombo.addItem(item[0]);
        }
        this.sizeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                int index = NewDocumentPane.this.sizeCombo.getSelectedIndex();
                if (index == 0) {
                    return;
                }
                String[] item = (String[])NewDocumentPane.this.sizeList.get(index);
                String unit = item[3];
                if (unit.length() < 1) {
                    unit = "px";
                }
                for (int i = 0; i < NewDocumentPane.this.unitList.size(); ++i) {
                    if (!unit.equals(((String[])NewDocumentPane.this.unitList.get(i))[1])) continue;
                    NewDocumentPane.this.unitCombo.setSelectedIndex(i);
                    break;
                }
                if (item[1].length() > 1) {
                    NewDocumentPane.this.widthField.setText(item[1]);
                }
                if (item[2].length() > 1) {
                    NewDocumentPane.this.heightField.setText(item[2]);
                }
            }
        });
        this.unitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 2) {
                    return;
                }
                int index = NewDocumentPane.this.unitCombo.getSelectedIndex();
                String unit = ((String[])NewDocumentPane.this.unitList.get(index))[1];
                try {
                    float value = Float.parseFloat(NewDocumentPane.this.widthField.getText());
                    NewDocumentPane.this.widthField.setText(Float.toString((float)UnitConversion.convert(value, NewDocumentPane.this.oldUnit, unit, NewDocumentPane.this.dpi)));
                    value = Float.parseFloat(NewDocumentPane.this.heightField.getText());
                    NewDocumentPane.this.heightField.setText(Float.toString((float)UnitConversion.convert(value, NewDocumentPane.this.oldUnit, unit, NewDocumentPane.this.dpi)));
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(NewDocumentPane.this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
                }
                NewDocumentPane.this.oldUnit = unit;
            }
        });
        ActionListener sizeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (NewDocumentPane.this.sizeCombo.getSelectedIndex() != 0) {
                    NewDocumentPane.this.sizeCombo.setSelectedIndex(0);
                }
            }
        };
        this.widthField.addActionListener(sizeActionListener);
        this.heightField.addActionListener(sizeActionListener);
        this.oldUnit = "px";
        this.sizeCombo.setSelectedIndex(1);
        String[] strs = new String[]{"auto", "sRGB", "linearRGB"};
        this.colorInterpolationCombo.setModel(new DefaultComboBoxModel<String>(strs));
        this.colorInterpolationCombo.setSelectedIndex(1);
        strs = new String[]{"auto", "optimizeSpeed", "optimizeQuality"};
        this.colorRenderingCombo.setModel(new DefaultComboBoxModel<String>(strs));
        this.colorRenderingCombo.setSelectedIndex(0);
        strs = new String[]{"auto", "optimizeSpeed", "crispEdges", "geometricPrecision"};
        this.shapeRenderingCombo.setModel(new DefaultComboBoxModel<String>(strs));
        this.shapeRenderingCombo.setSelectedIndex(0);
        strs = new String[]{"auto", "optimizeSpeed", "optimizeLegibility", "geometricPrecision"};
        this.textRenderingCombo.setModel(new DefaultComboBoxModel<String>(strs));
        this.textRenderingCombo.setSelectedIndex(0);
        strs = new String[]{"auto", "optimizeSpeed", "optimizeQuality"};
        this.imageRenderingCombo.setModel(new DefaultComboBoxModel<String>(strs));
        this.imageRenderingCombo.setSelectedIndex(0);
    }

    public String getTitle() {
        return bundle.getString("CTL_Title.Text");
    }

    public void validateValue() {
        this.width = -1.0f;
        this.height = -1.0f;
        try {
            this.width = Float.parseFloat(this.widthField.getText());
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidWidth.Text"));
        }
        try {
            this.height = Float.parseFloat(this.heightField.getText());
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidHeight.Text"));
        }
    }

    public SVGDocument createSVGDocument() {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGDocument doc = (SVGDocument)impl.createDocument(svgNS, "svg", null);
        Element svgRoot = doc.getDocumentElement();
        NamedNodeMap attrMap = svgRoot.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            Attr attr = (Attr)attrMap.item(i);
            attr.setValue(attr.getValue());
        }
        Comment comment = doc.createComment("Created with Sketsa SVG Editor (http://www.kiyut.com)");
        doc.insertBefore((Node)comment, (Node)svgRoot);
        int index = this.unitCombo.getSelectedIndex();
        String unit = this.unitList.get(index)[1];
        svgRoot.setAttributeNS(null, "width", Float.toString(this.width) + unit);
        svgRoot.setAttributeNS(null, "height", Float.toString(this.height) + unit);
        svgRoot.setAttributeNS(null, "version", "1.0");
        svgRoot.setAttributeNS(null, "baseProfile", "full");
        return doc;
    }

    public void updateSVGProperties(SVGDocument doc) {
        Element svgRoot = doc.getDocumentElement();
        SVGStylable stylable = (SVGStylable)svgRoot;
        String value = (String)this.colorInterpolationCombo.getSelectedItem();
        if (!value.equals("sRGB")) {
            DOMUtilities.updateProperty(stylable, null, "color-interpolation", value);
        }
        if (!(value = (String)this.colorRenderingCombo.getSelectedItem()).equals("auto")) {
            DOMUtilities.updateProperty(stylable, null, "color-rendering", value);
        }
        if (!(value = (String)this.shapeRenderingCombo.getSelectedItem()).equals("auto")) {
            DOMUtilities.updateProperty(stylable, null, "shape-rendering", value);
        }
        if (!(value = (String)this.textRenderingCombo.getSelectedItem()).equals("auto")) {
            DOMUtilities.updateProperty(stylable, null, "text-rendering", value);
        }
        if (!(value = (String)this.imageRenderingCombo.getSelectedItem()).equals("auto")) {
            DOMUtilities.updateProperty(stylable, null, "image-rendering", value);
        }
    }
}

