/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kiyut.sketsa.options.AbstractOptionsPane;
import kiyut.sketsa.options.CodeColoringOptions;
import kiyut.swing.button.ColorChooserButton;

public class CodeColoringOptionsPane
extends AbstractOptionsPane {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.options.CodeColoringOptionsPane");
    private Map<String, String> syntaxNameMap = null;
    private Map<String, Color> syntaxForegroundMap = null;
    private Map<String, Font> syntaxFontMap = null;
    private boolean valueIsAdjusting = false;
    private JComboBox fontCombo;
    private JComboBox fontSizeCombo;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JCheckBox syntaxFontBoldCheck;
    private JCheckBox syntaxFontItalicCheck;
    private JButton syntaxForegroundButton;
    private JTextField syntaxPreview;
    private JList syntaxStyleList;

    public CodeColoringOptionsPane() {
        this.initComponents();
        this.initCustomComponents();
        this.syntaxNameMap = new HashMap<String, String>();
        this.syntaxForegroundMap = new HashMap<String, Color>();
        this.syntaxFontMap = new HashMap<String, Font>();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.syntaxStyleList = new JList();
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.syntaxFontItalicCheck = new JCheckBox();
        this.syntaxFontBoldCheck = new JCheckBox();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.syntaxForegroundButton = new ColorChooserButton();
        this.jLabel2 = new JLabel();
        this.fontCombo = new JComboBox();
        this.fontSizeCombo = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel11 = new JLabel();
        this.jPanel3 = new JPanel();
        this.syntaxPreview = new JTextField();
        this.setLayout(new GridBagLayout());
        this.jScrollPane1.setMinimumSize(new Dimension(140, 140));
        this.jScrollPane1.setPreferredSize(new Dimension(170, 170));
        this.syntaxStyleList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.syntaxStyleList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 10);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jLabel1.setText(bundle.getString("CTL_SyntaxStyles.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.syntaxFontItalicCheck.setText(bundle.getString("CTL_Italic.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.syntaxFontItalicCheck, gridBagConstraints);
        this.syntaxFontBoldCheck.setText(bundle.getString("CTL_Bold.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.syntaxFontBoldCheck, gridBagConstraints);
        this.jLabel9.setText(bundle.getString("CTL_FontStyle.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.jPanel1.add((Component)this.jLabel9, gridBagConstraints);
        this.jLabel10.setText(bundle.getString("CTL_Font.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel1.add((Component)this.jLabel10, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        this.jPanel1.add((Component)this.jSeparator1, gridBagConstraints);
        this.syntaxForegroundButton.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.syntaxForegroundButton, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("CTL_FontSize.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.fontCombo, gridBagConstraints);
        this.fontSizeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"8", "9", "10", "12", "13", "14", "16", "20", "24", "36", "48"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.fontSizeCombo, gridBagConstraints);
        this.jLabel3.setText(bundle.getString("CTL_FontSizeInfo.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel12.setText(bundle.getString("CTL_FontColor.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.jPanel1.add((Component)this.jLabel12, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new BorderLayout(0, 6));
        this.jLabel11.setText(bundle.getString("CTL_Preview.Text"));
        this.jPanel2.add((Component)this.jLabel11, "North");
        this.jPanel3.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Separator.shadow")));
        this.jPanel3.setLayout(new BorderLayout());
        this.syntaxPreview.setHorizontalAlignment(0);
        this.syntaxPreview.setFocusable(false);
        this.jPanel3.add((Component)this.syntaxPreview, "Center");
        this.jPanel2.add((Component)this.jPanel3, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void initCustomComponents() {
        DefaultListModel listModel = new DefaultListModel();
        this.syntaxStyleList.setModel(listModel);
        this.syntaxStyleList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int i = CodeColoringOptionsPane.this.syntaxStyleList.getSelectedIndex();
                if (i < 0) {
                    return;
                }
                String str = (String)CodeColoringOptionsPane.this.syntaxStyleList.getModel().getElementAt(i);
                String syntaxName = CodeColoringOptionsPane.this.determineSyntaxName(i);
                Color color = (Color)CodeColoringOptionsPane.this.syntaxForegroundMap.get(syntaxName);
                Font font = (Font)CodeColoringOptionsPane.this.syntaxFontMap.get(syntaxName);
                CodeColoringOptionsPane.this.valueIsAdjusting = true;
                try {
                    CodeColoringOptionsPane.this.fontCombo.setSelectedItem(font.getName());
                    CodeColoringOptionsPane.this.fontSizeCombo.setSelectedItem(Integer.toString(font.getSize()));
                    ((ColorChooserButton)CodeColoringOptionsPane.this.syntaxForegroundButton).setColor((Color)CodeColoringOptionsPane.this.syntaxForegroundMap.get(syntaxName));
                    CodeColoringOptionsPane.this.syntaxFontBoldCheck.setSelected(font.isBold());
                    CodeColoringOptionsPane.this.syntaxFontItalicCheck.setSelected(font.isItalic());
                }
                finally {
                    CodeColoringOptionsPane.this.valueIsAdjusting = false;
                }
                CodeColoringOptionsPane.this.syntaxPreview.setFont(font);
                CodeColoringOptionsPane.this.syntaxPreview.setForeground(color);
                CodeColoringOptionsPane.this.syntaxPreview.setText(str);
            }
        });
        this.syntaxForegroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int i = CodeColoringOptionsPane.this.syntaxStyleList.getSelectedIndex();
                if (i == -1) {
                    return;
                }
                String syntaxName = CodeColoringOptionsPane.this.determineSyntaxName(i);
                Color color = ((ColorChooserButton)CodeColoringOptionsPane.this.syntaxForegroundButton).getColor();
                CodeColoringOptionsPane.this.syntaxForegroundMap.put(syntaxName, color);
                CodeColoringOptionsPane.this.syntaxPreview.setForeground(color);
            }
        });
        this.syntaxForegroundButton.setFocusPainted(false);
        ItemListener fontItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Font font;
                if (CodeColoringOptionsPane.this.valueIsAdjusting) {
                    return;
                }
                if (evt.getStateChange() == 2) {
                    return;
                }
                int i = CodeColoringOptionsPane.this.syntaxStyleList.getSelectedIndex();
                if (i == -1) {
                    return;
                }
                String syntaxName = CodeColoringOptionsPane.this.determineSyntaxName(i);
                String fontName = CodeColoringOptionsPane.this.fontCombo.getSelectedItem().toString();
                int size = 14;
                try {
                    size = Integer.parseInt((String)CodeColoringOptionsPane.this.fontSizeCombo.getSelectedItem());
                }
                catch (NumberFormatException ex) {
                    Logger logger = Logger.getLogger(this.getClass().getName());
                    logger.log(Level.FINE, ex.getMessage(), ex);
                    return;
                }
                for (String key : CodeColoringOptionsPane.this.syntaxFontMap.keySet()) {
                    Font oldFont = (Font)CodeColoringOptionsPane.this.syntaxFontMap.get(key);
                    font = new Font(fontName, oldFont.getStyle(), size);
                    CodeColoringOptionsPane.this.syntaxFontMap.put(key, font);
                }
                font = (Font)CodeColoringOptionsPane.this.syntaxFontMap.get(syntaxName);
                CodeColoringOptionsPane.this.syntaxPreview.setFont(font);
            }
        };
        this.fontCombo.addItemListener(fontItemListener);
        this.fontSizeCombo.addItemListener(fontItemListener);
        ItemListener fontDecorationItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (CodeColoringOptionsPane.this.valueIsAdjusting) {
                    return;
                }
                int i = CodeColoringOptionsPane.this.syntaxStyleList.getSelectedIndex();
                if (i == -1) {
                    return;
                }
                String syntaxName = CodeColoringOptionsPane.this.determineSyntaxName(i);
                Font font = (Font)CodeColoringOptionsPane.this.syntaxFontMap.get(syntaxName);
                font = font.deriveFont(0);
                if (CodeColoringOptionsPane.this.syntaxFontBoldCheck.isSelected() && CodeColoringOptionsPane.this.syntaxFontItalicCheck.isSelected()) {
                    font = font.deriveFont(3);
                } else {
                    if (CodeColoringOptionsPane.this.syntaxFontBoldCheck.isSelected()) {
                        font = font.deriveFont(1);
                    }
                    if (CodeColoringOptionsPane.this.syntaxFontItalicCheck.isSelected()) {
                        font = font.deriveFont(2);
                    }
                }
                CodeColoringOptionsPane.this.syntaxPreview.setFont(font);
                CodeColoringOptionsPane.this.syntaxFontMap.put(syntaxName, font);
            }
        };
        this.syntaxFontBoldCheck.addItemListener(fontDecorationItemListener);
        this.syntaxFontItalicCheck.addItemListener(fontDecorationItemListener);
        this.fontCombo.setModel(new DefaultComboBoxModel());
        this.fontSizeCombo.setPrototypeDisplayValue("999");
    }

    @Override
    public void refreshOptions() {
        this.refreshAvailableFont();
        CodeColoringOptions opts = CodeColoringOptions.getInstance();
        DefaultListModel listModel = (DefaultListModel)this.syntaxStyleList.getModel();
        listModel.clear();
        String syntaxName = "default";
        String displayedSyntaxName = "Default";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        syntaxName = "comment";
        displayedSyntaxName = "Comment";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        listModel.addElement(displayedSyntaxName);
        syntaxName = "xml_declaration";
        displayedSyntaxName = "XML Declaration";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        listModel.addElement(displayedSyntaxName);
        syntaxName = "doctype";
        displayedSyntaxName = "DOCTYPE Declaration";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        listModel.addElement(displayedSyntaxName);
        syntaxName = "element";
        displayedSyntaxName = "Element Name";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        listModel.addElement(displayedSyntaxName);
        syntaxName = "attribute_name";
        displayedSyntaxName = "Attribute Name";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        listModel.addElement(displayedSyntaxName);
        syntaxName = "attribute_value";
        displayedSyntaxName = "Attribute Value";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        listModel.addElement(displayedSyntaxName);
        syntaxName = "character_data";
        displayedSyntaxName = "Character Data";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        listModel.addElement(displayedSyntaxName);
        syntaxName = "cdata";
        displayedSyntaxName = "CDATA section";
        this.syntaxFontMap.put(syntaxName, opts.getSyntaxFont(syntaxName));
        this.syntaxForegroundMap.put(syntaxName, opts.getSyntaxForeground(syntaxName));
        this.syntaxNameMap.put(syntaxName, displayedSyntaxName);
        listModel.addElement(displayedSyntaxName);
        this.syntaxStyleList.setSelectedIndex(0);
    }

    @Override
    public void applyChanges() {
        String syntaxName;
        String key;
        CodeColoringOptions opts = CodeColoringOptions.getInstance();
        Iterator<String> i$ = this.syntaxFontMap.keySet().iterator();
        while (i$.hasNext()) {
            syntaxName = key = i$.next();
            Font font = this.syntaxFontMap.get(key);
            opts.setSyntaxFont(syntaxName, font);
        }
        i$ = this.syntaxForegroundMap.keySet().iterator();
        while (i$.hasNext()) {
            syntaxName = key = i$.next();
            Color fontForeground = this.syntaxForegroundMap.get(key);
            opts.setSyntaxForeground(syntaxName, fontForeground);
        }
    }

    private String determineSyntaxName(int index) {
        String str = (String)this.syntaxStyleList.getModel().getElementAt(index);
        String syntaxName = null;
        for (String key : this.syntaxNameMap.keySet()) {
            if (!this.syntaxNameMap.get(key).equals(str)) continue;
            syntaxName = key;
            break;
        }
        return syntaxName;
    }

    private void refreshAvailableFont() {
        DefaultComboBoxModel fontComboModel = (DefaultComboBoxModel)this.fontCombo.getModel();
        fontComboModel.removeAllElements();
        String[] fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontList.length; ++i) {
            fontComboModel.addElement(fontList[i]);
        }
    }
}

