/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.prefs.Preferences;
import kiyut.sketsa.options.AbstractOptions;
import kiyut.sketsa.options.OptionsUtilities;

public class CodeColoringOptions
extends AbstractOptions {
    private static CodeColoringOptions instance = new CodeColoringOptions();
    public static final String SYNTAX_FONT_MAP_PROPERTY = "syntax_font_map";
    public static final String SYNTAX_FOREGROUND_MAP_PROPERTY = "syntax_foreground_map";
    public static final String SYNTAX_FONT_PROPERTY = "_font";
    public static final String SYNTAX_FOREGROUND_PROPERTY = "_foreground";
    private Map<String, Color> syntaxForegroundMap = null;
    private Map<String, Font> syntaxFontMap = null;

    public static CodeColoringOptions getInstance() {
        return instance;
    }

    protected CodeColoringOptions() {
        this.nodeName = "code-coloring";
        this.syntaxForegroundMap = new HashMap<String, Color>();
        this.syntaxFontMap = new HashMap<String, Font>();
        this.retrieve();
    }

    public Color getSyntaxForeground(String syntaxName) {
        return this.syntaxForegroundMap.get(syntaxName);
    }

    public void setSyntaxForeground(String syntaxName, Color color) {
        Color old = this.getSyntaxForeground(syntaxName);
        this.syntaxForegroundMap.put(syntaxName, color);
        this.firePropertyChange(syntaxName + SYNTAX_FOREGROUND_PROPERTY, old, color);
        this.store();
    }

    public Font getSyntaxFont(String syntaxName) {
        return this.syntaxFontMap.get(syntaxName);
    }

    public void setSyntaxFont(String syntaxName, Font font) {
        Font old = this.getSyntaxFont(syntaxName);
        this.syntaxFontMap.put(syntaxName, font);
        this.firePropertyChange(syntaxName + SYNTAX_FONT_PROPERTY, old, font);
        this.store();
    }

    public Map<String, Font> getSyntaxFontMap() {
        return this.syntaxFontMap;
    }

    public void setSyntaxFontMap(Map<String, Font> syntaxFontMap) {
        Map<String, Font> old = this.syntaxFontMap;
        this.syntaxFontMap = syntaxFontMap;
        this.firePropertyChange(SYNTAX_FONT_MAP_PROPERTY, old, syntaxFontMap);
        this.store();
    }

    public Map<String, Color> getSyntaxForegroundMap() {
        return this.syntaxForegroundMap;
    }

    public void setSyntaxForegroundMap(Map<String, Color> syntaxForegroundMap) {
        Map<String, Color> old = this.syntaxForegroundMap;
        this.syntaxForegroundMap = syntaxForegroundMap;
        this.firePropertyChange(SYNTAX_FOREGROUND_MAP_PROPERTY, old, syntaxForegroundMap);
        this.store();
    }

    protected void store() {
        String syntaxName;
        String key;
        Preferences prefs = this.getPreferences();
        Iterator<String> i$ = this.syntaxFontMap.keySet().iterator();
        while (i$.hasNext()) {
            syntaxName = key = i$.next();
            Font font = this.syntaxFontMap.get(key);
            prefs.put(syntaxName + SYNTAX_FONT_PROPERTY, OptionsUtilities.fontToString(font));
        }
        i$ = this.syntaxForegroundMap.keySet().iterator();
        while (i$.hasNext()) {
            syntaxName = key = i$.next();
            Color fontForeground = this.syntaxForegroundMap.get(key);
            prefs.put(syntaxName + SYNTAX_FOREGROUND_PROPERTY, OptionsUtilities.colorToString(fontForeground));
        }
    }

    protected void retrieve() {
        Color fontForeground;
        Font font;
        Preferences prefs = this.getPreferences();
        int defaultFontSize = 13;
        try {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            if (size.width >= 1280 || size.height >= 1024) {
                defaultFontSize = 14;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        Font defaultFont = new Font("Monospaced", 0, defaultFontSize);
        String syntaxName = "default";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont;
            fontForeground = Color.BLACK;
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = "xml_declaration";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont.deriveFont(1);
            fontForeground = new Color(0, 0, 124);
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = "doctype";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont.deriveFont(1);
            fontForeground = new Color(0, 0, 124);
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = "comment";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont;
            fontForeground = new Color(128, 128, 128);
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = "element";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont;
            fontForeground = new Color(0, 0, 255);
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = "character_data";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont;
            fontForeground = Color.BLACK;
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = "attribute_name";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont;
            fontForeground = new Color(0, 124, 0);
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = "attribute_value";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont;
            fontForeground = new Color(153, 0, 107);
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
        syntaxName = "cdata";
        try {
            font = OptionsUtilities.stringToFont(prefs.get(syntaxName + SYNTAX_FONT_PROPERTY, null));
            fontForeground = OptionsUtilities.stringToColor(prefs.get(syntaxName + SYNTAX_FOREGROUND_PROPERTY, null));
        }
        catch (Exception ex) {
            font = defaultFont;
            fontForeground = new Color(124, 98, 0);
        }
        this.syntaxFontMap.put(syntaxName, font);
        this.syntaxForegroundMap.put(syntaxName, fontForeground);
    }
}

