/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.io;

import java.io.IOException;
import java.io.Writer;
import kiyut.sketsa.io.DOMTranscoder;
import kiyut.sketsa.io.NodeRange;
import kiyut.sketsa.options.CodeFormatOptions;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.svg.SVGDocument;

public class SVGWriter {
    private SVGWriter() {
        throw new Error("SVGWriter is only a wrapper for apache batik SVGTranscoder and all methods are static");
    }

    public static void write(SVGDocument doc, Writer writer) throws IOException {
        SVGWriter.write(doc, writer, null);
    }

    public static void write(SVGDocument doc, Writer writer, NodeRange nodeRange) throws IOException {
        try {
            TranscodingHints hints = new TranscodingHints();
            hints.put((Object)DOMTranscoder.KEY_XML_DECLARATION, (Object)"<?xml version=\"1.0\" standalone=\"no\"?>");
            DocumentType docType = doc.getDoctype();
            if (docType != null) {
                hints.put((Object)DOMTranscoder.KEY_PUBLIC_ID, (Object)docType.getPublicId());
                hints.put((Object)DOMTranscoder.KEY_SYSTEM_ID, (Object)docType.getSystemId());
            }
            CodeFormatOptions opts = CodeFormatOptions.getInstance();
            hints.put((Object)DOMTranscoder.KEY_FORMAT, (Object)Boolean.TRUE);
            hints.put((Object)DOMTranscoder.KEY_TABULATION_WIDTH, (Object)new Integer(opts.getTabWidth()));
            hints.put((Object)DOMTranscoder.KEY_DOCUMENT_WIDTH, (Object)new Integer(opts.getLineWidth()));
            hints.put((Object)DOMTranscoder.KEY_NEWLINE, (Object)new DOMTranscoder.NewlineValue(opts.getLineBreak()));
            DOMTranscoder transcoder = new DOMTranscoder();
            TranscoderInput in = new TranscoderInput((Document)doc);
            TranscoderOutput out = new TranscoderOutput(writer);
            transcoder.setNodeRange(nodeRange);
            transcoder.setTranscodingHints(hints);
            transcoder.transcode(in, out);
        }
        catch (TranscoderException ex) {
            throw new IOException(ex.getMessage());
        }
    }
}

