/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class DefaultFileFilter
extends FileFilter {
    protected static final String TYPE_UNKNOWN = "Type Unknown";
    protected static final String HIDDEN_FILE = "Hidden File";
    protected List<String> filters = new ArrayList<String>(2);
    protected String description = null;
    protected String fullDescription = null;
    protected boolean useExtensionsInDescription = true;

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null && this.filters.contains(this.getExtension(f))) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new ArrayList<String>(2);
        }
        this.filters.add(extension.toLowerCase());
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Iterator<String> it = this.filters.iterator();
                if (it != null) {
                    this.fullDescription = this.fullDescription + "." + it.next();
                    while (it.hasNext()) {
                        this.fullDescription = this.fullDescription + ", ." + it.next();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

