/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.GeomUtilities;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;

public class ScaleTool
extends AbstractTool {
    private VectorCanvas canvas;
    private Stroke stroke = new BasicStroke(1.0f);
    private int startX;
    private int startY;
    private int newX;
    private int newY;
    private boolean constraint = false;
    private List<SVGElement> selectionList = new ArrayList<SVGElement>();
    private List<Shape> outlineList = new ArrayList<Shape>();
    private List<Shape> newOutlineList = new ArrayList<Shape>();
    private Rectangle2D bounds;
    private int direction = -1;

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        if (this.direction != -1) {
            if (this.newOutlineList.size() > 0) {
                g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
                Rectangle2D rBounds = GeomUtilities.getBounds2D(this.newOutlineList);
                g2d.draw(rBounds);
            }
            g2d.setStroke(this.stroke);
            for (int i = 0; i < this.newOutlineList.size(); ++i) {
                Shape shape = this.newOutlineList.get(i);
                g2d.draw(shape);
            }
        } else {
            g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
            Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
            Rectangle2D r = border.get(Integer.toString(0));
            g2d.draw(r);
            for (int i = 1; i <= 9; ++i) {
                if (i == 5) continue;
                Rectangle2D handle = border.get(Integer.toString(i));
                g2d.fill(handle);
            }
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        if (this.canvas.getCursor().getType() != 0) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.direction = -1;
        this.canvas.repaint();
        this.fireMessageReceived(0, "Drag to scale selection using Transform Matrix");
    }

    @Override
    public void endTool() {
        this.selectionList.clear();
        this.outlineList.clear();
        this.newOutlineList.clear();
    }

    protected int determineDirection(int x, int y) {
        Rectangle2D r = null;
        int dir = -1;
        Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
        for (int i = 1; i <= 9; ++i) {
            if (i == 5 || !(r = border.get(Integer.toString(i))).contains(x, y)) continue;
            dir = i;
            if (i > 0) break;
        }
        return dir;
    }

    protected AffineTransform createTransform() {
        Rectangle2D r = this.canvas.getCanvasSelection().getSelectionBounds2D();
        float x = (float)r.getX();
        float y = (float)r.getY();
        float w = (float)r.getWidth();
        float h = (float)r.getHeight();
        float sx = 1.0f;
        float sy = 1.0f;
        if (w == 0.0f) {
            w = 1.0f;
        }
        if (h == 0.0f) {
            h = 1.0f;
        }
        if (this.direction == 1) {
            x += w;
            y += h;
            sx = (w - (float)(this.newX - this.startX)) / w;
            sy = (h - (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                if (sx >= 0.0f && sy < 0.0f) {
                    sx = sy;
                }
                sy = sx;
            }
        } else if (this.direction == 2) {
            y += h;
            sy = (h - (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                sx = sy;
                x = (float)r.getCenterX();
            }
        } else if (this.direction == 3) {
            y += h;
            sx = (w + (float)(this.newX - this.startX)) / w;
            sy = (h - (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                if (sx >= 0.0f && sy < 0.0f) {
                    sx = sy;
                }
                sy = sx;
            }
        } else if (this.direction == 4) {
            x += w;
            sx = (w - (float)(this.newX - this.startX)) / w;
            if (this.constraint) {
                sy = sx;
                y = (float)r.getCenterY();
            }
        } else if (this.direction == 6) {
            sx = (w + (float)(this.newX - this.startX)) / w;
            if (this.constraint) {
                sy = sx;
                y = (float)r.getCenterY();
            }
        } else if (this.direction == 7) {
            x += w;
            sx = (w - (float)(this.newX - this.startX)) / w;
            sy = (h + (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                if (sx >= 0.0f && sy < 0.0f) {
                    sx = sy;
                }
                sy = sx;
            }
        } else if (this.direction == 8) {
            sy = (h + (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                sx = sy;
                x = (float)r.getCenterX();
            }
        } else {
            sx = (w + (float)(this.newX - this.startX)) / w;
            sy = (h + (float)(this.newY - this.startY)) / h;
            if (this.constraint) {
                if (sx >= 0.0f && sy < 0.0f) {
                    sx = sy;
                }
                sy = sx;
            }
        }
        AffineTransform newAt = new AffineTransform();
        newAt.translate(x, y);
        newAt.scale(sx, sy);
        newAt.translate(-x, -y);
        return newAt;
    }

    private void updateDOM() {
        if (this.selectionList.isEmpty()) {
            return;
        }
        double[] values = new double[6];
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        AffineTransform resizeAt = this.createTransform();
        CanvasModel model = this.canvas.getModel();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            GraphicsNode gn;
            SVGElement element = this.selectionList.get(i);
            if (!(element instanceof SVGTransformable) || (gn = model.getGraphicsNode(element)) == null) continue;
            AffineTransform curAt = (AffineTransform)canvasAt.clone();
            curAt.concatenate(gn.getGlobalTransform());
            if (element instanceof SVGUseElement) {
                SVGUseElement elt = (SVGUseElement)element;
                SVGLength ex = elt.getX().getBaseVal();
                SVGLength ey = elt.getY().getBaseVal();
                float useX = ex.getValue();
                float useY = ey.getValue();
                AffineTransform useAt = AffineTransform.getTranslateInstance(-useX, -useY);
                curAt.concatenate(useAt);
            }
            AffineTransform at = new AffineTransform(resizeAt);
            at.concatenate(curAt);
            try {
                AffineTransform invAt = curAt.createInverse();
                invAt.concatenate(at);
                at = invAt;
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            at.getMatrix(values);
            SVGMatrix matrix = model.getSVGSVGElement().createSVGMatrix();
            matrix.setA((float)values[0]);
            matrix.setB((float)values[1]);
            matrix.setC((float)values[2]);
            matrix.setD((float)values[3]);
            matrix.setE((float)values[4]);
            matrix.setF((float)values[5]);
            SVGTransform transform = model.getSVGSVGElement().createSVGTransformFromMatrix(matrix);
            SVGTransformList transformList = ((SVGTransformable)element).getTransform().getBaseVal();
            transformList.appendItem(transform);
            transformList.consolidate();
        }
    }

    protected void updateOutline() {
        this.newOutlineList.clear();
        AffineTransform at = this.createTransform();
        for (int i = 0; i < this.outlineList.size(); ++i) {
            Shape shape = this.outlineList.get(i);
            shape = at.createTransformedShape(shape);
            this.newOutlineList.add(shape);
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        if (this.direction == -1) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        this.constraint = (evt.getModifiersEx() & 0x40) == 64;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        this.updateOutline();
        Rectangle2D newBounds = GeomUtilities.getBounds2D(this.newOutlineList);
        Rectangle2D.union(this.bounds, newBounds, this.bounds);
        Rectangle r = this.bounds.getBounds();
        this.canvas.repaint(r.x - 1, r.y - 1, r.width + 2, r.height + 2);
        this.bounds = newBounds;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        this.newX = this.startX;
        this.newY = this.startY;
        this.outlineList.clear();
        this.newOutlineList.clear();
        this.direction = this.determineDirection(this.startX, this.startY);
        if (this.direction == -1) {
            return;
        }
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        CanvasModel model = this.canvas.getModel();
        this.selectionList = CanvasUtilities.getGraphicsElement(this.canvas.getCanvasSelection().getSelectionList());
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGElement elt = this.selectionList.get(i);
            GraphicsNode gn = model.getGraphicsNode(elt);
            if (gn == null) continue;
            Shape shape = gn.getOutline();
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(gn.getGlobalTransform());
            shape = at.createTransformedShape(shape);
            this.outlineList.add(shape);
        }
        Rectangle2D r = this.canvas.getCanvasSelection().getSelectionBounds2D();
        if (this.direction == 1) {
            this.startX = (int)r.getX();
            this.startY = (int)r.getY();
        } else if (this.direction == 2) {
            this.startX = (int)r.getCenterX();
            this.startY = (int)r.getY();
        } else if (this.direction == 3) {
            this.startX = (int)(r.getX() + r.getWidth());
            this.startY = (int)r.getY();
        } else if (this.direction == 4) {
            this.startX = (int)r.getX();
            this.startY = (int)r.getCenterY();
        } else if (this.direction == 6) {
            this.startX = (int)(r.getX() + r.getWidth());
            this.startY = (int)r.getCenterY();
        } else if (this.direction == 7) {
            this.startX = (int)r.getX();
            this.startY = (int)(r.getY() + r.getHeight());
        } else if (this.direction == 8) {
            this.startX = (int)r.getCenterX();
            this.startY = (int)(r.getY() + r.getHeight());
        } else {
            this.startX = (int)(r.getX() + r.getWidth());
            this.startY = (int)(r.getY() + r.getHeight());
        }
        this.bounds = GeomUtilities.getBounds2D(this.outlineList);
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.constraint = (evt.getModifiersEx() & 0x40) == 64;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        this.outlineList.clear();
        this.newOutlineList.clear();
        if (this.direction != -1) {
            Cursor prevCursor = this.canvas.getCursor();
            this.canvas.setCursor(Cursor.getPredefinedCursor(3));
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Transform scale selections");
            try {
                this.updateDOM();
                this.canvas.refresh();
            }
            finally {
                undoManager.end();
                this.canvas.getCanvasSelection().updateBorder();
                this.direction = -1;
                this.selectionList.clear();
                this.canvas.setCursor(prevCursor);
                this.canvas.repaint();
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        Rectangle2D r = null;
        int x = evt.getX();
        int y = evt.getY();
        int type = -1;
        Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
        for (int i = 1; i <= 9; ++i) {
            if (i == 5 || !(r = border.get(Integer.toString(i))).contains(x, y)) continue;
            type = i;
            if (i > 0) break;
        }
        if (type == -1) {
            this.canvas.setCursor(Cursor.getDefaultCursor());
        } else if (type == 1) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(6));
        } else if (type == 2) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(8));
        } else if (type == 3) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(7));
        } else if (type == 4) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(10));
        } else if (type == 6) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(11));
        } else if (type == 7) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(4));
        } else if (type == 8) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(9));
        } else if (type == 9) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(5));
        }
    }
}

