/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.options.CanvasOptions;
import kiyut.sketsa.undo.DOMUndoManager;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;

public class RotateTool
extends AbstractTool {
    private VectorCanvas canvas;
    private Anchor anchor;
    private Cursor rotateCursor;
    private Stroke stroke = new BasicStroke(1.0f);
    private int newX;
    private int newY;
    private boolean constrained = false;
    private List<SVGElement> selectionList = new ArrayList<SVGElement>();
    private List<Shape> outlineList = new ArrayList<Shape>();
    private List<Shape> newOutlineList = new ArrayList<Shape>();
    private boolean rotating = false;
    private double origAngle;
    private double zoomFactor;

    public RotateTool() {
        this.anchor = new Anchor();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Dimension dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("Doesn't support custom cursor");
            }
            Image cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/canvas/tool/rotate-cursor32.png"));
            this.rotateCursor = toolkit.createCustomCursor(cursorImage, new Point(14, 15), "ROTATE_CURSOR");
        }
        catch (Exception ex) {
            this.rotateCursor = Cursor.getDefaultCursor();
        }
    }

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        if (this.rotating) {
            g2d.setStroke(this.stroke);
            for (int i = 0; i < this.newOutlineList.size(); ++i) {
                Shape shape = this.newOutlineList.get(i);
                g2d.draw(shape);
            }
        } else {
            g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
            Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
            Rectangle2D r = border.get(Integer.toString(0));
            g2d.draw(r);
            Rectangle2D handle = border.get(Integer.toString(1));
            g2d.fill(handle);
            handle = border.get(Integer.toString(3));
            g2d.fill(handle);
            handle = border.get(Integer.toString(7));
            g2d.fill(handle);
            handle = border.get(Integer.toString(9));
            g2d.fill(handle);
        }
        if (this.zoomFactor != this.canvas.getZoomFactor()) {
            double newZoomFactor = this.canvas.getZoomFactor();
            double scale = newZoomFactor / this.zoomFactor;
            AffineTransform at = new AffineTransform();
            at.setToScale(scale, scale);
            double[] pts = new double[2];
            double[] pts2 = new double[2];
            pts[0] = this.anchor.getX();
            pts[1] = this.anchor.getY();
            at.transform(pts, 0, pts2, 0, 1);
            this.anchor.setLocation(pts2[0], pts2[1]);
            this.zoomFactor = newZoomFactor;
        }
        g2d.fill(this.anchor.getShape());
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        if (this.canvas.getCursor().getType() != 0) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        Map<String, Rectangle2D> border = this.canvas.getCanvasSelection().getBorder();
        Rectangle2D r = border.get(Integer.toString(0));
        this.anchor.setLocation(r.getCenterX(), r.getCenterY());
        this.rotating = false;
        this.constrained = false;
        this.origAngle = 0.0;
        this.zoomFactor = this.canvas.getZoomFactor();
        this.canvas.repaint();
        this.fireMessageReceived(0, "Drag to rotate selection using Transform Matrix");
    }

    @Override
    public void endTool() {
        this.selectionList.clear();
        this.outlineList.clear();
        this.newOutlineList.clear();
    }

    private void updateDOM() {
        if (this.selectionList.isEmpty()) {
            return;
        }
        double[] values = new double[6];
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        AffineTransform rotateAt = this.createTransform();
        CanvasModel model = this.canvas.getModel();
        for (int i = 0; i < this.selectionList.size(); ++i) {
            GraphicsNode gn;
            SVGElement element = this.selectionList.get(i);
            if (!(element instanceof SVGTransformable) || (gn = model.getGraphicsNode(element)) == null) continue;
            AffineTransform curAt = (AffineTransform)canvasAt.clone();
            curAt.concatenate(gn.getGlobalTransform());
            if (element instanceof SVGUseElement) {
                SVGUseElement elt = (SVGUseElement)element;
                SVGLength ex = elt.getX().getBaseVal();
                SVGLength ey = elt.getY().getBaseVal();
                float useX = ex.getValue();
                float useY = ey.getValue();
                AffineTransform useAt = AffineTransform.getTranslateInstance(-useX, -useY);
                curAt.concatenate(useAt);
            }
            AffineTransform at = new AffineTransform(rotateAt);
            at.concatenate(curAt);
            try {
                AffineTransform invAt = curAt.createInverse();
                invAt.concatenate(at);
                at = invAt;
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            at.getMatrix(values);
            SVGMatrix matrix = model.getSVGSVGElement().createSVGMatrix();
            matrix.setA((float)values[0]);
            matrix.setB((float)values[1]);
            matrix.setC((float)values[2]);
            matrix.setD((float)values[3]);
            matrix.setE((float)values[4]);
            matrix.setF((float)values[5]);
            SVGTransform transform = model.getSVGSVGElement().createSVGTransformFromMatrix(matrix);
            SVGTransformList transformList = ((SVGTransformable)element).getTransform().getBaseVal();
            transformList.appendItem(transform);
            transformList.consolidate();
        }
    }

    private void updateOutline() {
        this.newOutlineList.clear();
        AffineTransform at = this.createTransform();
        for (int i = 0; i < this.outlineList.size(); ++i) {
            Shape shape = this.outlineList.get(i);
            shape = at.createTransformedShape(shape);
            this.newOutlineList.add(shape);
        }
    }

    protected AffineTransform createTransform() {
        double angle = this.calculateAngle(this.anchor.getX(), this.anchor.getY(), this.newX, this.newY);
        if (this.constrained) {
            if (angle >= -22.5 && angle < 22.5) {
                angle = 0.0;
            } else if (angle >= 22.5 && angle < 67.5) {
                angle = 45.0;
            } else if (angle >= 67.5 && angle < 112.5) {
                angle = 90.0;
            } else if (angle >= 112.5 && angle < 157.5) {
                angle = 135.0;
            } else if (angle >= 157.5 || angle < -157.5) {
                angle = 180.0;
            } else if (angle >= -157.5 && angle < -112.5) {
                angle = -135.0;
            } else if (angle >= -112.5 && angle < -67.5) {
                angle = -90.0;
            } else if (angle >= -67.5 && angle < -22.5) {
                angle = -45.0;
            }
        }
        AffineTransform newAt = AffineTransform.getRotateInstance(Math.toRadians((float)angle), this.anchor.getX(), this.anchor.getY());
        return newAt;
    }

    private double calculateAngle(double x, double y, double x1, double y1) {
        double angle = 0.0;
        angle = Math.atan2(y1 - y, x1 - x);
        angle = Math.toDegrees(angle);
        if (this.origAngle == 0.0) {
            this.origAngle = angle;
        }
        return angle -= this.origAngle;
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        this.constrained = (evt.getModifiersEx() & 0x40) == 64;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        if (this.rotating) {
            this.canvas.setCursor(this.rotateCursor);
            if (!this.selectionList.isEmpty()) {
                this.updateOutline();
                this.canvas.repaint();
            }
        } else {
            this.anchor.setLocation(this.newX, this.newY);
            this.canvas.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        int y;
        int x = evt.getX();
        if (this.anchor.contains(x, y = evt.getY())) {
            this.canvas.setCursor(Cursor.getPredefinedCursor(13));
        } else {
            this.canvas.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        this.outlineList.clear();
        this.newOutlineList.clear();
        if (this.anchor.contains(this.newX, this.newY)) {
            this.rotating = false;
            return;
        }
        this.rotating = true;
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        AffineTransform canvasAt = (AffineTransform)this.canvas.getTransform().clone();
        CanvasModel model = this.canvas.getModel();
        this.selectionList = CanvasUtilities.getGraphicsElement(this.canvas.getCanvasSelection().getSelectionList());
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGElement elt = this.selectionList.get(i);
            GraphicsNode gn = model.getGraphicsNode(elt);
            if (gn == null) continue;
            Shape shape = gn.getOutline();
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(gn.getGlobalTransform());
            shape = at.createTransformedShape(shape);
            this.outlineList.add(shape);
        }
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.outlineList.clear();
        this.newOutlineList.clear();
        if (this.rotating) {
            this.constrained = (evt.getModifiersEx() & 0x40) == 64;
            this.canvas.setCursor(Cursor.getPredefinedCursor(3));
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Transform rotate selections");
            try {
                this.updateDOM();
                this.canvas.refresh();
            }
            finally {
                undoManager.end();
                this.canvas.getCanvasSelection().updateBorder();
                this.rotating = false;
                this.origAngle = 0.0;
                this.selectionList.clear();
                this.canvas.setCursor(Cursor.getDefaultCursor());
                this.canvas.repaint();
            }
        }
    }

    public class Anchor {
        private Ellipse2D shape = new Ellipse2D.Double(-1.0, -1.0, -1.0, -1.0);

        public Shape getShape() {
            return this.shape;
        }

        public void setLocation(double x, double y) {
            CanvasOptions prefs = CanvasOptions.getInstance();
            int size = prefs.getHandleSize();
            this.shape.setFrameFromCenter(x, y, x - (double)(size / 2), y - (double)(size / 2));
        }

        public double getX() {
            return this.shape.getCenterX();
        }

        public double getY() {
            return this.shape.getCenterY();
        }

        public boolean contains(double x, double y) {
            return this.shape.contains(x, y);
        }
    }
}

