/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;

public class PanTool
extends AbstractTool {
    private VectorCanvas canvas;
    private Cursor cursor;
    private int x;
    private int y;
    private JScrollBar hScrollBar;
    private JScrollBar vScrollBar;
    private boolean adjusting = false;

    public PanTool() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            Dimension dim = toolkit.getBestCursorSize(32, 32);
            if (dim.getWidth() == 0.0 || dim.getHeight() == 0.0) {
                throw new RuntimeException("doesn't support custom cursor");
            }
            Image cursorImage = toolkit.getImage(this.getClass().getResource("/kiyut/sketsa/canvas/tool/pan-cursor32.png"));
            this.cursor = toolkit.createCustomCursor(cursorImage, new Point(16, 16), "PAN_CURSOR");
        }
        catch (Exception e) {
            this.cursor = Cursor.getDefaultCursor();
        }
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
        if (canvas == null) {
            this.hScrollBar = null;
            this.vScrollBar = null;
        } else {
            Container comp = SwingUtilities.getAncestorOfClass(JScrollPane.class, canvas);
            if (comp instanceof JScrollPane) {
                this.hScrollBar = ((JScrollPane)comp).getHorizontalScrollBar();
                this.vScrollBar = ((JScrollPane)comp).getVerticalScrollBar();
            } else {
                this.hScrollBar = null;
                this.vScrollBar = null;
            }
        }
        this.adjusting = false;
    }

    @Override
    public void startTool() {
        this.canvas.getCanvasSelection().setEnabledVisible(false, true, false);
        this.canvas.setCursor(this.cursor);
        this.fireMessageReceived(0, "Drag on canvas to panning");
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (this.adjusting) {
            return;
        }
        this.adjusting = true;
        int newX = evt.getX();
        int val = this.hScrollBar.getValue();
        this.hScrollBar.setValue(val += this.x - newX);
        this.x = newX + (this.x - newX);
        int newY = evt.getY();
        val = this.vScrollBar.getValue();
        this.vScrollBar.setValue(val += this.y - newY);
        this.y = newY + (this.y - newY);
        this.adjusting = false;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.x = evt.getX();
        this.y = evt.getY();
    }
}

