/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.text;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretListener;
import javax.swing.event.EventListenerList;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.event.TextCaretEvent;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.text.Mark;

public class TextCaret {
    private VectorCanvas canvas;
    private TextNode textNode;
    private Timer blinker;
    private int blinkRate = 500;
    private int dot;
    private int mark;
    private Mark marker1;
    private Mark marker2;
    private Shape caretShape = new GeneralPath();
    private Shape selectionHighlight;
    private Color caretColor = Color.BLACK;
    private Color selectionBackground;
    private boolean blinkVisible = false;
    private EventListenerList listenerList = new EventListenerList();

    public TextCaret() {
        this.blinker = new Timer(this.blinkRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextCaret.this.repaint();
            }
        });
        Color col = UIManager.getColor("textHighlight");
        this.selectionBackground = col != null ? new Color(col.getRed(), col.getGreen(), col.getBlue(), 128) : new Color(100, 100, 255, 100);
    }

    protected final synchronized void repaint() {
        if (this.canvas != null) {
            AffineTransform at;
            try {
                at = this.canvas.getTransform();
            }
            catch (Exception ex) {
                return;
            }
            Shape shape = at.createTransformedShape(this.caretShape);
            Rectangle2D rect = shape.getBounds2D();
            this.canvas.repaint((int)rect.getX() - 2, (int)rect.getY() - 2, (int)rect.getWidth() + 4, (int)rect.getHeight() + 4);
        }
    }

    protected synchronized void damage(Rectangle2D r) {
        if (r != null) {
            this.canvas.repaint((int)r.getX() - 2, (int)r.getY() - 2, (int)r.getWidth() + 4, (int)r.getHeight() + 4);
        }
    }

    public void paint(Graphics2D g2d) {
        Shape shape;
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        Object oldAntiAlias = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AffineTransform at = this.canvas.getTransform();
        if (this.dot != this.mark && this.selectionHighlight != null) {
            shape = at.createTransformedShape(this.selectionHighlight);
            g2d.setPaint(this.selectionBackground);
            g2d.fill(shape);
        }
        if (this.blinkVisible) {
            shape = at.createTransformedShape(this.caretShape);
            g2d.setPaint(this.caretColor);
            g2d.fill(shape);
            this.blinkVisible = false;
        } else {
            this.blinkVisible = true;
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntiAlias);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    public void addCaretListener(CaretListener listener) {
        this.listenerList.add(CaretListener.class, listener);
    }

    public void removeCaretListener(CaretListener listener) {
        this.listenerList.remove(CaretListener.class, listener);
    }

    protected void fireCaretUpdate() {
        Object[] listeners = this.listenerList.getListenerList();
        TextCaretEvent event = new TextCaretEvent(this, this.dot, this.mark);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != CaretListener.class) continue;
            ((CaretListener)listeners[i + 1]).caretUpdate(event);
        }
    }

    public void prepareCaret(VectorCanvas canvas, TextNode textNode, int dot) {
        this.canvas = canvas;
        this.textNode = textNode;
        this.setDot(dot);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.blinker.start();
        } else {
            this.blinker.stop();
            this.blinkVisible = false;
            this.repaint();
        }
    }

    public void setDot(int dot) {
        this.dot = dot = this.setCaretPosition(dot);
        this.mark = dot;
        this.marker1 = this.textNode.getMarkerForChar(dot, true);
        this.marker2 = this.textNode.getMarkerForChar(dot, false);
        Shape oldSelectionHighlight = this.selectionHighlight;
        this.selectionHighlight = null;
        if (oldSelectionHighlight != null) {
            this.damage(oldSelectionHighlight.getBounds2D());
        }
        this.fireCaretUpdate();
    }

    public void moveDot(int dot) {
        this.dot = dot = this.setCaretPosition(dot);
        this.marker2 = this.textNode.getMarkerForChar(dot - 1 > 0 ? dot - 1 : dot, false);
        Shape oldSelectionHighlight = this.selectionHighlight;
        if (dot != this.mark) {
            this.textNode.setSelection(this.marker1, this.marker2);
            Shape shape = this.textNode.getHighlightShape();
            AffineTransform at = this.canvas.getTransform();
            this.selectionHighlight = at.createTransformedShape(shape);
        } else {
            this.selectionHighlight = null;
        }
        if (oldSelectionHighlight != null) {
            this.damage(oldSelectionHighlight.getBounds2D());
        }
        this.fireCaretUpdate();
    }

    public int getDot() {
        if (this.dot < 0) {
            return 0;
        }
        return this.dot;
    }

    @Deprecated
    public void setMark(int mark) {
        this.mark = mark;
    }

    public int getMark() {
        if (this.mark < 0) {
            return 0;
        }
        return this.mark;
    }

    protected int setCaretPosition(int dot) {
        AttributedCharacterIterator aci = this.textNode.getAttributedCharacterIterator();
        if (aci == null) {
            return 0;
        }
        if (dot < 0) {
            dot = 0;
        } else if (dot >= aci.getEndIndex()) {
            dot = aci.getEndIndex() - 1;
        }
        Rectangle2D oldR = this.caretShape.getBounds2D();
        this.caretShape = this.createCaretShape(dot);
        this.repaint();
        this.damage(oldR.getBounds2D());
        return dot;
    }

    private Shape createCaretShape(int dot) {
        Mark cMarker1 = this.textNode.getMarkerForChar(dot, true);
        Mark cMarker2 = this.textNode.getMarkerForChar(dot, false);
        this.textNode.setSelection(cMarker1, cMarker2);
        Shape shape = this.textNode.getHighlightShape();
        return shape;
    }
}

