/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.Color;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import kiyut.sketsa.canvas.CanvasTransferData;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPaint;
import org.w3c.dom.svg.SVGStylable;

public class CanvasSelectionTransferData
extends CanvasTransferData {
    public CanvasSelectionTransferData(List transferData) {
        super(transferData);
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (this.transferData == null) {
            return false;
        }
        List list = (List)this.transferData;
        boolean imported = false;
        VectorCanvas canvas = (VectorCanvas)comp;
        SVGDocument doc = canvas.getSVGDocument();
        Element svgRoot = doc.getDocumentElement();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        for (int i = list.size() - 1; i >= 0; --i) {
            Node node = ((Node)list.get(i)).cloneNode(true);
            if (node.getOwnerDocument() != doc) {
                SVGElement element = (SVGElement)node;
                SVGStylable stylable = (SVGStylable)element;
                ViewCSS viewCSS = (ViewCSS)((Object)element.getOwnerDocument().getDocumentElement());
                CSSStyleDeclaration computedStyle = viewCSS.getComputedStyle((Element)element, null);
                String colorHex = ColorConvertion.toHexString(Color.BLACK);
                boolean strokeNone = false;
                boolean fillNone = false;
                String attr = "stroke";
                SVGPaint svgPaint = (SVGPaint)computedStyle.getPropertyCSSValue(attr);
                short type = svgPaint.getPaintType();
                if (type == 107 || type == 104 || type == 103 || type == 105 || type == 106) {
                    DOMUtilities.updateProperty(stylable, null, attr, colorHex);
                } else if (type == 101) {
                    strokeNone = true;
                }
                attr = "fill";
                svgPaint = (SVGPaint)computedStyle.getPropertyCSSValue(attr);
                type = svgPaint.getPaintType();
                if (type == 107 || type == 104 || type == 103 || type == 105 || type == 106) {
                    DOMUtilities.updateProperty(stylable, null, attr, colorHex);
                } else if (type == 101) {
                    fillNone = true;
                }
                attr = "filter";
                if (!attr.equals("none")) {
                    DOMUtilities.updateProperty(stylable, null, attr, null);
                    if (strokeNone && fillNone) {
                        DOMUtilities.updateProperty(stylable, null, "stroke", colorHex);
                        DOMUtilities.updateProperty(stylable, null, "fill", colorHex);
                    }
                }
            }
            Node newNode = doc.importNode(node, true);
            newNode = svgRoot.appendChild(newNode);
            newList.add((SVGElement)newNode);
        }
        canvas.refresh();
        canvas.getCanvasSelection().setSelectionList(newList);
        imported = true;
        return imported;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (action != 2) {
            return;
        }
        VectorCanvas canvas = (VectorCanvas)source;
        List<SVGElement> selectionList = canvas.getCanvasSelection().getSelectionList();
        if (selectionList == null) {
            return;
        }
        for (int i = 0; i < selectionList.size(); ++i) {
            Node node = (Node)selectionList.get(i);
            Node parent = node.getParentNode();
            parent.removeChild(node);
        }
        canvas.getCanvasSelection().clearSelection();
        canvas.refresh();
    }
}

