/*
 * Decompiled with CFR 0.152.
 */
package com.group_finity.mascot.config;

import com.group_finity.mascot.Mascot;
import com.group_finity.mascot.action.Action;
import com.group_finity.mascot.behavior.Behavior;
import com.group_finity.mascot.config.ActionBuilder;
import com.group_finity.mascot.config.BehaviorBuilder;
import com.group_finity.mascot.config.Entry;
import com.group_finity.mascot.exception.ActionInstantiationException;
import com.group_finity.mascot.exception.BehaviorInstantiationException;
import com.group_finity.mascot.exception.ConfigurationException;
import com.group_finity.mascot.exception.VariableException;
import com.group_finity.mascot.script.VariableMap;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Configuration {
    private static final Logger log = Logger.getLogger(Configuration.class.getName());
    private final Map<String, ActionBuilder> actionBuilders = new LinkedHashMap<String, ActionBuilder>();
    private final Map<String, BehaviorBuilder> behaviorBuilders = new LinkedHashMap<String, BehaviorBuilder>();

    public void load(Entry configurationNode, String imageSet) throws IOException, ConfigurationException {
        log.log(Level.INFO, "Start Reading Configuration File...");
        for (Entry list : configurationNode.selectChildren("ActionList")) {
            log.log(Level.INFO, "Action List...");
            for (Entry node : list.selectChildren("Action")) {
                ActionBuilder action = new ActionBuilder(this, node, imageSet);
                if (this.getActionBuilders().containsKey(action.getName())) {
                    throw new ConfigurationException("Duplicate Action Found: " + action.getName());
                }
                this.getActionBuilders().put(action.getName(), action);
            }
        }
        for (Entry list : configurationNode.selectChildren("BehaviorList")) {
            log.log(Level.INFO, "Behavior List...");
            this.loadBehaviors(list, new ArrayList<String>());
        }
        log.log(Level.INFO, "Behavior List");
    }

    private void loadBehaviors(Entry list, List<String> conditions) {
        for (Entry node : list.getChildren()) {
            if (node.getName().equals("Condition")) {
                ArrayList<String> newConditions = new ArrayList<String>(conditions);
                newConditions.add(node.getAttribute("Condition"));
                this.loadBehaviors(node, newConditions);
                continue;
            }
            if (!node.getName().equals("Behavior")) continue;
            BehaviorBuilder behavior = new BehaviorBuilder(this, node, conditions);
            this.getBehaviorBuilders().put(behavior.getName(), behavior);
        }
    }

    public Action buildAction(String name, Map<String, String> params) throws ActionInstantiationException {
        ActionBuilder factory = this.actionBuilders.get(name);
        if (factory == null) {
            throw new ActionInstantiationException("Could not find the corresponding action: " + name);
        }
        return factory.buildAction(params);
    }

    public void validate() throws ConfigurationException {
        for (ActionBuilder actionBuilder : this.getActionBuilders().values()) {
            actionBuilder.validate();
        }
        for (BehaviorBuilder behaviorBuilder : this.getBehaviorBuilders().values()) {
            behaviorBuilder.validate();
        }
    }

    public Behavior buildBehavior(String previousName, Mascot mascot) throws BehaviorInstantiationException {
        VariableMap context = new VariableMap();
        context.put("mascot", (Object)mascot);
        ArrayList<BehaviorBuilder> candidates = new ArrayList<BehaviorBuilder>();
        long totalFrequency = 0L;
        for (BehaviorBuilder behaviorFactory : this.getBehaviorBuilders().values()) {
            try {
                if (!behaviorFactory.isEffective(context)) continue;
                candidates.add(behaviorFactory);
                totalFrequency += (long)behaviorFactory.getFrequency();
            }
            catch (VariableException e) {
                log.log(Level.WARNING, "An error occurred calculating the frequency of the action", e);
            }
        }
        if (previousName != null) {
            BehaviorBuilder previousBehaviorFactory = this.getBehaviorBuilders().get(previousName);
            if (!previousBehaviorFactory.isNextAdditive()) {
                totalFrequency = 0L;
                candidates.clear();
            }
            for (BehaviorBuilder behaviorFactory : previousBehaviorFactory.getNextBehaviorBuilders()) {
                try {
                    if (!behaviorFactory.isEffective(context)) continue;
                    candidates.add(behaviorFactory);
                    totalFrequency += (long)behaviorFactory.getFrequency();
                }
                catch (VariableException e) {
                    log.log(Level.WARNING, "An error occurred calculating the frequency of the behavior", e);
                }
            }
        }
        if (totalFrequency == 0L) {
            mascot.setAnchor(new Point((int)(Math.random() * (double)(mascot.getEnvironment().getScreen().getRight() - mascot.getEnvironment().getScreen().getLeft())) + mascot.getEnvironment().getScreen().getLeft(), mascot.getEnvironment().getScreen().getTop() - 256));
            return this.buildBehavior("Fall");
        }
        double random = Math.random() * (double)totalFrequency;
        for (BehaviorBuilder behaviorFactory : candidates) {
            if (!((random -= (double)behaviorFactory.getFrequency()) < 0.0)) continue;
            return behaviorFactory.buildBehavior();
        }
        return null;
    }

    public Behavior buildBehavior(String name) throws BehaviorInstantiationException {
        return this.getBehaviorBuilders().get(name).buildBehavior();
    }

    Map<String, ActionBuilder> getActionBuilders() {
        return this.actionBuilders;
    }

    private Map<String, BehaviorBuilder> getBehaviorBuilders() {
        return this.behaviorBuilders;
    }

    public Set<String> getBehaviorNames() {
        return this.behaviorBuilders.keySet();
    }
}

