/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.calllib.RongCallCommon;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:MACEMsg", flag=3)
public class MultiCallEndMessage
extends MessageContent {
    private static final String TAG = MultiCallEndMessage.class.getSimpleName();
    private String content;
    private RongCallCommon.CallDisconnectedReason reason = RongCallCommon.CallDisconnectedReason.REMOTE_NETWORK_ERROR;
    private RongIMClient.MediaType mediaType;
    public static final Parcelable.Creator<MultiCallEndMessage> CREATOR = new Parcelable.Creator<MultiCallEndMessage>(){

        public MultiCallEndMessage createFromParcel(Parcel source) {
            return new MultiCallEndMessage(source);
        }

        public MultiCallEndMessage[] newArray(int size) {
            return new MultiCallEndMessage[size];
        }
    };

    public MultiCallEndMessage() {
    }

    public MultiCallEndMessage(byte[] data) {
        try {
            JSONObject jsonObject = new JSONObject(new String(data));
            this.reason = RongCallCommon.CallDisconnectedReason.valueOf(jsonObject.getInt("reason"));
            this.mediaType = RongIMClient.MediaType.setValue((int)jsonObject.getInt("mediaType"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public RongIMClient.MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RongIMClient.MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("reason", this.reason != null ? this.reason.getValue() : 3);
            jsonObj.put("mediaType", this.mediaType != null ? this.mediaType.getValue() : 1);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getContent() {
        return this.content;
    }

    public RongCallCommon.CallDisconnectedReason getReason() {
        return this.reason;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setReason(RongCallCommon.CallDisconnectedReason reason) {
        this.reason = reason;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.content);
        dest.writeInt(this.reason == null ? -1 : this.reason.ordinal());
        dest.writeInt(this.mediaType == null ? -1 : this.mediaType.ordinal());
    }

    protected MultiCallEndMessage(Parcel in) {
        this.content = in.readString();
        int tmpReason = in.readInt();
        this.reason = tmpReason == -1 ? null : RongCallCommon.CallDisconnectedReason.values()[tmpReason];
        int tmpMediaType = in.readInt();
        this.mediaType = tmpMediaType == -1 ? null : RongIMClient.MediaType.values()[tmpMediaType];
    }
}

