/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.calllib.RongCallCommon;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:VCSummary", flag=1)
public class CallSummaryMessage
extends MessageContent {
    private static final String TAG = "VoIPSummaryMessage";
    private String caller;
    private String inviter;
    private RongCallCommon.CallMediaType mediaType;
    private List<String> memberIdList;
    private long startTime;
    private long activeTime;
    private long duration;
    private RongCallCommon.CallDisconnectedReason reason;
    public static final Parcelable.Creator<CallSummaryMessage> CREATOR = new Parcelable.Creator<CallSummaryMessage>(){

        public CallSummaryMessage createFromParcel(Parcel source) {
            return new CallSummaryMessage(source);
        }

        public CallSummaryMessage[] newArray(int size) {
            return new CallSummaryMessage[size];
        }
    };

    public CallSummaryMessage(Parcel in) {
        this.caller = ParcelUtils.readFromParcel((Parcel)in);
        this.inviter = ParcelUtils.readFromParcel((Parcel)in);
        this.mediaType = RongCallCommon.CallMediaType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
        this.memberIdList = ParcelUtils.readListFromParcel((Parcel)in, String.class);
        this.startTime = ParcelUtils.readLongFromParcel((Parcel)in);
        this.activeTime = ParcelUtils.readLongFromParcel((Parcel)in);
        this.duration = ParcelUtils.readLongFromParcel((Parcel)in);
        this.reason = RongCallCommon.CallDisconnectedReason.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
    }

    public CallSummaryMessage() {
    }

    public CallSummaryMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.caller = jsonObj.optString("caller");
            this.inviter = jsonObj.optString("inviter");
            this.mediaType = RongCallCommon.CallMediaType.valueOf(jsonObj.optInt("mediaType"));
            this.memberIdList = new ArrayList<String>();
            JSONArray jsonArray = jsonObj.optJSONArray("memberIdList");
            if (jsonArray != null) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    this.memberIdList.add((String)jsonArray.get(i));
                }
            }
            this.startTime = jsonObj.optLong("startTime");
            this.activeTime = jsonObj.optLong("activeTime");
            this.duration = jsonObj.optLong("duration");
            this.reason = RongCallCommon.CallDisconnectedReason.valueOf(jsonObj.optInt("hangupReason"));
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
    }

    public String getInviter() {
        return this.inviter;
    }

    public void setInviter(String inviter) {
        this.inviter = inviter;
    }

    public long getActiveTime() {
        return this.activeTime;
    }

    public void setActiveTime(long activeTime) {
        this.activeTime = activeTime;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public RongCallCommon.CallMediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RongCallCommon.CallMediaType mediaType) {
        this.mediaType = mediaType;
    }

    public List<String> getMemberIdList() {
        return this.memberIdList;
    }

    public void setMemberIdList(List<String> memberIdList) {
        this.memberIdList = memberIdList;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public RongCallCommon.CallDisconnectedReason getReason() {
        return this.reason;
    }

    public void setReason(RongCallCommon.CallDisconnectedReason reason) {
        this.reason = reason;
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("caller", (Object)this.caller);
            jsonObj.putOpt("inviter", (Object)this.inviter);
            jsonObj.putOpt("mediaType", (Object)this.mediaType.getValue());
            if (this.memberIdList != null) {
                JSONArray jsonArray = new JSONArray();
                for (String userId : this.memberIdList) {
                    jsonArray.put((Object)userId);
                }
                jsonObj.putOpt("memberIdList", (Object)jsonArray);
            }
            jsonObj.putOpt("startTime", (Object)this.startTime);
            jsonObj.putOpt("activeTime", (Object)this.activeTime);
            jsonObj.putOpt("duration", (Object)this.duration);
            jsonObj.putOpt("hangupReason", (Object)this.reason.getValue());
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.caller);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.inviter);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.mediaType.getValue());
        ParcelUtils.writeListToParcel((Parcel)dest, this.memberIdList);
        ParcelUtils.writeToParcel((Parcel)dest, (Long)this.startTime);
        ParcelUtils.writeToParcel((Parcel)dest, (Long)this.activeTime);
        ParcelUtils.writeToParcel((Parcel)dest, (Long)this.duration);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.reason.getValue());
    }

    public int describeContents() {
        return 0;
    }
}

