/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib.message;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import io.rong.calllib.RongCallCommon;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.UserInfo;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:VSTMsg", flag=3)
public class CallSTerminateMessage
extends MessageContent {
    private static final String TAG = "CallSTerminateMessage";
    private String content;
    private String direction;
    private RongCallCommon.CallDisconnectedReason reason;
    private RongCallCommon.CallMediaType mediaType;
    protected String extra;
    public static final Parcelable.Creator<CallSTerminateMessage> CREATOR = new Parcelable.Creator<CallSTerminateMessage>(){

        public CallSTerminateMessage createFromParcel(Parcel source) {
            return new CallSTerminateMessage(source);
        }

        public CallSTerminateMessage[] newArray(int size) {
            return new CallSTerminateMessage[size];
        }
    };

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public RongCallCommon.CallDisconnectedReason getReason() {
        return this.reason;
    }

    public void setReason(RongCallCommon.CallDisconnectedReason reason) {
        this.reason = reason;
    }

    public RongCallCommon.CallMediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RongCallCommon.CallMediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("content", (Object)this.content);
            jsonObj.put("reason", this.reason != null ? this.reason.getValue() : 3);
            jsonObj.put("mediaType", this.mediaType != null ? this.mediaType.getValue() : 1);
            jsonObj.put("direction", (Object)this.direction);
            if (!TextUtils.isEmpty((CharSequence)this.getExtra())) {
                jsonObj.put("extra", (Object)this.getExtra());
            }
            if (this.getJSONUserInfo() != null) {
                jsonObj.putOpt("user", (Object)this.getJSONUserInfo());
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CallSTerminateMessage() {
    }

    public static CallSTerminateMessage obtain(String text) {
        CallSTerminateMessage model = new CallSTerminateMessage();
        model.setContent(text);
        return model;
    }

    public CallSTerminateMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.content = jsonObj.optString("content");
            this.direction = jsonObj.optString("direction");
            this.reason = RongCallCommon.CallDisconnectedReason.valueOf(jsonObj.optInt("reason"));
            this.mediaType = RongCallCommon.CallMediaType.valueOf(jsonObj.optInt("mediaType"));
            if (jsonObj.has("extra")) {
                this.setExtra(jsonObj.optString("extra"));
            }
            if (jsonObj.has("user")) {
                this.setUserInfo(this.parseJsonToUserInfo(jsonObj.getJSONObject("user")));
            }
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.getExtra());
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.content);
        ParcelUtils.writeToParcel((Parcel)dest, (Parcelable)this.getUserInfo());
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)(this.reason != null ? this.reason.getValue() : 3));
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)(this.mediaType != null ? this.mediaType.getValue() : 1));
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.direction);
    }

    public CallSTerminateMessage(Parcel in) {
        this.setExtra(ParcelUtils.readFromParcel((Parcel)in));
        this.setContent(ParcelUtils.readFromParcel((Parcel)in));
        this.setUserInfo((UserInfo)ParcelUtils.readFromParcel((Parcel)in, UserInfo.class));
        this.reason = RongCallCommon.CallDisconnectedReason.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
        this.mediaType = RongCallCommon.CallMediaType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
        this.direction = ParcelUtils.readFromParcel((Parcel)in);
    }

    public CallSTerminateMessage(String content) {
        this.setContent(content);
    }

    public String getContent() {
        return this.content;
    }
}

