/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.calllib.CallUserProfile;
import io.rong.calllib.RongCallCommon;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:VCModifyMem", flag=0)
public class CallModifyMemberMessage
extends MessageContent {
    private static final String TAG = "VoIPModifyMemberMessage";
    private String callId;
    private String caller;
    private String inviter;
    private String mediaId;
    private boolean useSignalServer;
    private RongCallCommon.CallEngineType engineType;
    private RongCallCommon.CallMediaType mediaType;
    private RongCallCommon.CallModifyMemType modifyMemType;
    private List<String> inviteUserIds;
    private List<String> observerUserIds = new ArrayList<String>();
    private List<CallUserProfile> participantList;
    private String extra;
    public static final Parcelable.Creator<CallModifyMemberMessage> CREATOR = new Parcelable.Creator<CallModifyMemberMessage>(){

        public CallModifyMemberMessage createFromParcel(Parcel source) {
            return new CallModifyMemberMessage(source);
        }

        public CallModifyMemberMessage[] newArray(int size) {
            return new CallModifyMemberMessage[size];
        }
    };

    public CallModifyMemberMessage() {
    }

    public RongCallCommon.CallModifyMemType getModifyMemType() {
        return this.modifyMemType;
    }

    public void setModifyMemType(RongCallCommon.CallModifyMemType modifyMemType) {
        this.modifyMemType = modifyMemType;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public RongCallCommon.CallEngineType getEngineType() {
        return this.engineType;
    }

    public void setEngineType(RongCallCommon.CallEngineType engineType) {
        this.engineType = engineType;
    }

    public RongCallCommon.CallMediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RongCallCommon.CallMediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public boolean isUseSignalServer() {
        return this.useSignalServer;
    }

    public void setUseSignalServer(boolean useSignalServer) {
        this.useSignalServer = useSignalServer;
    }

    public List<String> getInvitedList() {
        return this.inviteUserIds;
    }

    public void setInvitedList(List<String> invitedList) {
        this.inviteUserIds = invitedList;
    }

    public List<String> getObserverList() {
        return this.observerUserIds;
    }

    public void setObserverList(List<String> observerList) {
        this.observerUserIds = observerList;
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public String getInviter() {
        return this.inviter;
    }

    public void setInviter(String inviter) {
        this.inviter = inviter;
    }

    public List<CallUserProfile> getParticipantList() {
        return this.participantList;
    }

    public void setParticipantList(List<CallUserProfile> participantList) {
        this.participantList = participantList;
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("callId", (Object)this.callId);
            JSONObject channelObj = new JSONObject();
            channelObj.putOpt("Id", (Object)this.callId);
            channelObj.putOpt("Key", (Object)"");
            jsonObj.putOpt("channelInfo", (Object)channelObj);
            jsonObj.putOpt("caller", (Object)this.caller);
            jsonObj.putOpt("inviter", (Object)this.inviter);
            jsonObj.putOpt("mediaId", (Object)this.mediaId);
            jsonObj.putOpt("useSignalServer", (Object)this.useSignalServer);
            JSONArray jsonArray = new JSONArray();
            for (String userId : this.inviteUserIds) {
                jsonArray.put((Object)userId);
            }
            jsonObj.put("inviteUserIds", (Object)jsonArray);
            if (this.observerUserIds != null) {
                jsonArray = new JSONArray();
                for (String userId : this.observerUserIds) {
                    jsonArray.put((Object)userId);
                }
                jsonObj.putOpt("observerUserIds", (Object)jsonArray);
            }
            jsonArray = new JSONArray();
            for (CallUserProfile profile : this.participantList) {
                JSONObject user = new JSONObject();
                user.put("userId", (Object)profile.getUserId());
                user.put("mediaId", (Object)profile.getMediaId());
                user.put("mediaType", profile.getMediaType().getValue());
                user.put("callStatus", profile.getCallStatus().getValue());
                jsonArray.put((Object)user);
            }
            jsonObj.putOpt("existedUserPofiles", (Object)jsonArray);
            jsonObj.putOpt("engineType", (Object)this.engineType.getValue());
            jsonObj.putOpt("mediaType", (Object)this.mediaType.getValue());
            jsonObj.putOpt("modifyMemType", (Object)this.modifyMemType.getValue());
            jsonObj.putOpt("extra", (Object)this.extra);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CallModifyMemberMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            int i;
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.callId = jsonObj.optString("callId");
            this.caller = jsonObj.optString("caller");
            this.inviter = jsonObj.optString("inviter");
            this.mediaId = jsonObj.optString("mediaId");
            this.useSignalServer = jsonObj.optBoolean("useSignalServer");
            JSONArray jsonArray = jsonObj.optJSONArray("inviteUserIds");
            this.inviteUserIds = new ArrayList<String>();
            for (i = 0; i < jsonArray.length(); ++i) {
                this.inviteUserIds.add((String)jsonArray.get(i));
            }
            this.observerUserIds = new ArrayList<String>();
            jsonArray = jsonObj.optJSONArray("observerUserIds");
            if (jsonArray != null) {
                for (i = 0; i < jsonArray.length(); ++i) {
                    this.observerUserIds.add((String)jsonArray.get(i));
                }
            }
            this.participantList = new ArrayList<CallUserProfile>();
            jsonArray = jsonObj.optJSONArray("existedUserPofiles");
            for (i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String userId = jsonObject.getString("userId");
                CallUserProfile participantProfile = new CallUserProfile();
                participantProfile.setUserId(userId);
                if (jsonObject.has("mediaId")) {
                    participantProfile.setMediaId(jsonObject.getString("mediaId"));
                }
                participantProfile.setCallStatus(RongCallCommon.CallStatus.valueOf(jsonObject.getInt("callStatus")));
                participantProfile.setMediaType(RongCallCommon.CallMediaType.valueOf(jsonObject.getInt("mediaType")));
                this.participantList.add(participantProfile);
            }
            this.engineType = RongCallCommon.CallEngineType.valueOf(jsonObj.optInt("engineType"));
            this.mediaType = RongCallCommon.CallMediaType.valueOf(jsonObj.optInt("mediaType"));
            this.modifyMemType = RongCallCommon.CallModifyMemType.valueOf(jsonObj.optInt("modifyMemType"));
            this.extra = jsonObj.optString("extra");
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.callId);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.caller);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.inviter);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.mediaId);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)(this.useSignalServer ? 1 : 0));
        ParcelUtils.writeListToParcel((Parcel)dest, this.inviteUserIds);
        ParcelUtils.writeListToParcel((Parcel)dest, this.observerUserIds);
        ParcelUtils.writeListToParcel((Parcel)dest, this.participantList);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.engineType.getValue());
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.mediaType.getValue());
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.modifyMemType.getValue());
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.extra);
    }

    public CallModifyMemberMessage(Parcel in) {
        this.callId = ParcelUtils.readFromParcel((Parcel)in);
        this.caller = ParcelUtils.readFromParcel((Parcel)in);
        this.inviter = ParcelUtils.readFromParcel((Parcel)in);
        this.mediaId = ParcelUtils.readFromParcel((Parcel)in);
        this.useSignalServer = ParcelUtils.readIntFromParcel((Parcel)in) == 1;
        this.inviteUserIds = ParcelUtils.readListFromParcel((Parcel)in, String.class);
        this.observerUserIds = ParcelUtils.readListFromParcel((Parcel)in, String.class);
        this.participantList = ParcelUtils.readListFromParcel((Parcel)in, CallUserProfile.class);
        this.engineType = RongCallCommon.CallEngineType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
        this.mediaType = RongCallCommon.CallMediaType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
        this.modifyMemType = RongCallCommon.CallModifyMemType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
        this.extra = ParcelUtils.readFromParcel((Parcel)in);
    }

    public int describeContents() {
        return 0;
    }
}

