/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.calllib.RongCallCommon;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:VCModifyMedia", flag=0)
public class CallModifyMediaMessage
extends MessageContent {
    private static final String TAG = "VoIPModifyMediaMessage";
    private String callId;
    private RongCallCommon.CallMediaType mediaType;
    public static final Parcelable.Creator<CallModifyMediaMessage> CREATOR = new Parcelable.Creator<CallModifyMediaMessage>(){

        public CallModifyMediaMessage createFromParcel(Parcel source) {
            return new CallModifyMediaMessage(source);
        }

        public CallModifyMediaMessage[] newArray(int size) {
            return new CallModifyMediaMessage[size];
        }
    };

    public CallModifyMediaMessage() {
    }

    public CallModifyMediaMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.callId = jsonObj.optString("callId");
            this.mediaType = RongCallCommon.CallMediaType.valueOf(jsonObj.optInt("mediaType"));
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public RongCallCommon.CallMediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RongCallCommon.CallMediaType mediaType) {
        this.mediaType = mediaType;
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("callId", (Object)this.callId);
            jsonObj.putOpt("mediaType", (Object)this.mediaType.getValue());
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CallModifyMediaMessage(Parcel in) {
        this.callId = ParcelUtils.readFromParcel((Parcel)in);
        this.mediaType = RongCallCommon.CallMediaType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.callId);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.mediaType.getValue());
    }

    public int describeContents() {
        return 0;
    }
}

