/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.calllib.RongCallCommon;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:VCInvite", flag=0)
public class CallInviteMessage
extends MessageContent {
    private static final String TAG = "VoIPInviteMessage";
    private String callId;
    private RongCallCommon.CallEngineType engineType;
    private String extra;
    private boolean useSignalServer;
    private List<String> inviteUserIds;
    private List<String> observerUserIds = new ArrayList<String>();
    private RongCallCommon.CallMediaType mediaType;
    private String mediaId;
    public static final Parcelable.Creator<CallInviteMessage> CREATOR = new Parcelable.Creator<CallInviteMessage>(){

        public CallInviteMessage createFromParcel(Parcel source) {
            return new CallInviteMessage(source);
        }

        public CallInviteMessage[] newArray(int size) {
            return new CallInviteMessage[size];
        }
    };

    public CallInviteMessage() {
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public RongCallCommon.CallEngineType getEngineType() {
        return this.engineType;
    }

    public void setEngineType(RongCallCommon.CallEngineType engineType) {
        this.engineType = engineType;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public List<String> getInviteUserIds() {
        return this.inviteUserIds;
    }

    public void setInviteUserIds(List<String> inviteUserIds) {
        this.inviteUserIds = inviteUserIds;
    }

    public List<String> getObserverUserIds() {
        return this.observerUserIds;
    }

    public void setObserverUserIds(List<String> observerUserIds) {
        if (observerUserIds != null) {
            this.observerUserIds = observerUserIds;
        }
    }

    public RongCallCommon.CallMediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RongCallCommon.CallMediaType mediaType) {
        this.mediaType = mediaType;
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        byte[] bytes = null;
        try {
            jsonObj.putOpt("callId", (Object)this.callId);
            JSONObject channelObj = new JSONObject();
            channelObj.putOpt("Id", (Object)this.callId);
            channelObj.putOpt("Key", (Object)"");
            jsonObj.putOpt("channelInfo", (Object)channelObj);
            jsonObj.putOpt("extra", (Object)this.extra);
            JSONArray jsonArray = new JSONArray();
            for (String userId : this.inviteUserIds) {
                jsonArray.put((Object)userId);
            }
            jsonObj.putOpt("inviteUserIds", (Object)jsonArray);
            if (this.observerUserIds != null) {
                jsonArray = new JSONArray();
                for (String userId : this.observerUserIds) {
                    jsonArray.put((Object)userId);
                }
                jsonObj.putOpt("observerUserIds", (Object)jsonArray);
            }
            jsonObj.putOpt("engineType", (Object)this.engineType.getValue());
            jsonObj.putOpt("mediaType", (Object)this.mediaType.getValue());
            jsonObj.putOpt("mediaId", (Object)this.mediaId);
            jsonObj.putOpt("useSignalServer", (Object)this.useSignalServer);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            bytes = jsonObj.toString().getBytes("UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public CallInviteMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            int i;
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.callId = jsonObj.optString("callId");
            this.extra = jsonObj.optString("extra");
            this.mediaId = jsonObj.optString("mediaId");
            this.useSignalServer = jsonObj.optBoolean("useSignalServer");
            this.inviteUserIds = new ArrayList<String>();
            JSONArray jsonArray = jsonObj.optJSONArray("inviteUserIds");
            for (i = 0; i < jsonArray.length(); ++i) {
                this.inviteUserIds.add((String)jsonArray.get(i));
            }
            this.observerUserIds = new ArrayList<String>();
            jsonArray = jsonObj.optJSONArray("observerUserIds");
            if (jsonArray != null) {
                for (i = 0; i < jsonArray.length(); ++i) {
                    this.observerUserIds.add((String)jsonArray.get(i));
                }
            }
            this.engineType = RongCallCommon.CallEngineType.valueOf(jsonObj.optInt("engineType"));
            this.mediaType = RongCallCommon.CallMediaType.valueOf(jsonObj.optInt("mediaType"));
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.callId);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.extra);
        ParcelUtils.writeListToParcel((Parcel)dest, this.inviteUserIds);
        ParcelUtils.writeListToParcel((Parcel)dest, this.observerUserIds);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.engineType.getValue());
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.mediaType.getValue());
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.mediaId);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)(this.useSignalServer ? 1 : 0));
    }

    public CallInviteMessage(Parcel in) {
        this.callId = ParcelUtils.readFromParcel((Parcel)in);
        this.extra = ParcelUtils.readFromParcel((Parcel)in);
        this.inviteUserIds = ParcelUtils.readListFromParcel((Parcel)in, String.class);
        this.observerUserIds = ParcelUtils.readListFromParcel((Parcel)in, String.class);
        this.engineType = RongCallCommon.CallEngineType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
        this.mediaType = RongCallCommon.CallMediaType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
        this.mediaId = ParcelUtils.readFromParcel((Parcel)in);
        this.useSignalServer = ParcelUtils.readIntFromParcel((Parcel)in) == 1;
    }

    public int describeContents() {
        return 0;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public boolean isUseSignalServer() {
        return this.useSignalServer;
    }

    public void setUseSignalServer(boolean useSignalServer) {
        this.useSignalServer = useSignalServer;
    }
}

