/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.calllib.RongCallCommon;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:VCHangup", flag=0)
public class CallHangupMessage
extends MessageContent {
    private static final String TAG = "VoIPHangupMessage";
    private String callId;
    private RongCallCommon.CallDisconnectedReason hangupReason;
    public static final Parcelable.Creator<CallHangupMessage> CREATOR = new Parcelable.Creator<CallHangupMessage>(){

        public CallHangupMessage createFromParcel(Parcel source) {
            return new CallHangupMessage(source);
        }

        public CallHangupMessage[] newArray(int size) {
            return new CallHangupMessage[size];
        }
    };

    public CallHangupMessage(Parcel in) {
        this.callId = ParcelUtils.readFromParcel((Parcel)in);
        this.hangupReason = RongCallCommon.CallDisconnectedReason.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
    }

    public CallHangupMessage() {
    }

    public CallHangupMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.callId = jsonObj.optString("callId");
            this.hangupReason = RongCallCommon.CallDisconnectedReason.valueOf(jsonObj.optInt("reason"));
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public RongCallCommon.CallDisconnectedReason getHangupReason() {
        return this.hangupReason;
    }

    public void setHangupReason(RongCallCommon.CallDisconnectedReason hangupReason) {
        this.hangupReason = hangupReason;
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("callId", (Object)this.callId);
            jsonObj.putOpt("reason", (Object)this.hangupReason.getValue());
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.callId);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.hangupReason.getValue());
    }

    public int describeContents() {
        return 0;
    }
}

