/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib.message;

import android.os.Parcel;
import android.os.Parcelable;
import io.rong.calllib.RongCallCommon;
import io.rong.common.ParcelUtils;
import io.rong.common.RLog;
import io.rong.imlib.MessageTag;
import io.rong.imlib.model.MessageContent;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@MessageTag(value="RC:VCAccept", flag=0)
public class CallAcceptMessage
extends MessageContent {
    private static final String TAG = "VoIPAcceptMessage";
    private String callId;
    private String mediaId;
    private String deviceId;
    private RongCallCommon.CallMediaType mediaType;
    public static final Parcelable.Creator<CallAcceptMessage> CREATOR = new Parcelable.Creator<CallAcceptMessage>(){

        public CallAcceptMessage createFromParcel(Parcel source) {
            return new CallAcceptMessage(source);
        }

        public CallAcceptMessage[] newArray(int size) {
            return new CallAcceptMessage[size];
        }
    };

    public CallAcceptMessage(Parcel in) {
        this.callId = ParcelUtils.readFromParcel((Parcel)in);
        this.mediaId = ParcelUtils.readFromParcel((Parcel)in);
        this.deviceId = ParcelUtils.readFromParcel((Parcel)in);
        this.mediaType = RongCallCommon.CallMediaType.valueOf(ParcelUtils.readIntFromParcel((Parcel)in));
    }

    public CallAcceptMessage() {
    }

    public CallAcceptMessage(byte[] data) {
        String jsonStr = null;
        try {
            jsonStr = new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            JSONObject jsonObj = new JSONObject(jsonStr);
            this.callId = jsonObj.optString("callId");
            this.mediaId = jsonObj.optString("mediaId");
            this.deviceId = jsonObj.optString("deviceId");
            this.mediaType = RongCallCommon.CallMediaType.valueOf(jsonObj.optInt("mediaType"));
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public RongCallCommon.CallMediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(RongCallCommon.CallMediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public byte[] encode() {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.putOpt("callId", (Object)this.callId);
            jsonObj.putOpt("mediaType", (Object)this.mediaType.getValue());
            jsonObj.putOpt("mediaId", (Object)this.mediaId);
            jsonObj.putOpt("deviceId", (Object)this.deviceId);
        }
        catch (JSONException e) {
            RLog.e((String)TAG, (String)("JSONException, " + e.getMessage()));
        }
        try {
            return jsonObj.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.callId);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.mediaId);
        ParcelUtils.writeToParcel((Parcel)dest, (String)this.deviceId);
        ParcelUtils.writeToParcel((Parcel)dest, (Integer)this.mediaType.getValue());
    }

    public int describeContents() {
        return 0;
    }
}

