/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib;

import android.text.TextUtils;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoInputStream;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import io.rong.calllib.ICallEngineListener;
import io.rong.common.RLog;
import io.rong.imlib.model.Message;
import java.util.List;

public class RongRTCEventHandler
extends IRCRTCRoomEventsListener {
    private ICallEngineListener engineListener;
    private static final String TAG = "RongRTCEventHandler";

    public RongRTCEventHandler(ICallEngineListener listener) {
        this.engineListener = listener;
    }

    public void onRemoteUserPublishResource(final RCRTCRemoteUser remoteUser, final List<RCRTCInputStream> publishResource) {
        RLog.i((String)TAG, (String)("onRemoteUserPublishResource()->publishResource size \uff1b" + publishResource.size()));
        boolean join = false;
        for (int i = 0; i < publishResource.size(); ++i) {
            RCRTCInputStream inputStream = publishResource.get(i);
            if (TextUtils.equals((CharSequence)inputStream.getTag(), (CharSequence)"RongCloudRTC")) {
                join = true;
            }
            if (!(inputStream instanceof RCRTCVideoInputStream) || this.engineListener == null) continue;
            ((RCRTCVideoInputStream)inputStream).setStreamType(RCRTCStreamType.NORMAL);
            if (TextUtils.equals((CharSequence)inputStream.getTag(), (CharSequence)"RongCloudRTC")) break;
            this.engineListener.onRemoteUserPublishStream(remoteUser.getUserId(), inputStream.getStreamId(), inputStream.getTag());
            break;
        }
        if (join && this.engineListener != null) {
            this.engineListener.onUserJoined(remoteUser.getUserId(), 1, 1);
        }
        RCRTCEngine.getInstance().getRoom().getLocalUser().subscribeStreams(publishResource, new IRCRTCResultCallback(){

            public void onSuccess() {
                RLog.i((String)RongRTCEventHandler.TAG, (String)("onRemoteUserPublishResource()->subscribeResources\uff1a " + remoteUser.getUserId() + "  success"));
                RongRTCEventHandler.this.modifyResource(remoteUser, publishResource);
            }

            public void onFailed(RTCErrorCode errorCode) {
                RLog.i((String)RongRTCEventHandler.TAG, (String)("onRemoteUserPublishResource()->subscribeResources\uff1a " + remoteUser.getUserId() + "   failed\uff0cerrorCode \uff1a" + errorCode));
            }
        });
    }

    private void modifyResource(RCRTCRemoteUser remoteUser, List<RCRTCInputStream> publishResource) {
        if (remoteUser == null || TextUtils.isEmpty((CharSequence)remoteUser.getUserId())) {
            RLog.e((String)TAG, (String)"publish Replacement message. error .");
            return;
        }
        for (RCRTCInputStream inputStream : publishResource) {
            if (inputStream == null || inputStream.getResourceState() == null || inputStream.getMediaType() == null || this.engineListener == null) continue;
            if (inputStream.getMediaType() == RCRTCMediaType.VIDEO && inputStream.getResourceState() == RCRTCResourceState.DISABLED) {
                RLog.i((String)TAG, (String)("publish Replacement message.onUserMuteVideo .. userid :" + remoteUser.getUserId()));
                this.engineListener.onUserMuteVideo(remoteUser.getUserId(), false);
                continue;
            }
            if (inputStream.getMediaType() != RCRTCMediaType.AUDIO || inputStream.getResourceState() != RCRTCResourceState.DISABLED) continue;
            RLog.i((String)TAG, (String)("publish Replacement message.onUserMuteAudio .. userid :" + remoteUser.getUserId()));
            this.engineListener.onUserMuteAudio(remoteUser.getUserId(), true);
        }
    }

    public void onRemoteUserMuteAudio(RCRTCRemoteUser remoteUser, RCRTCInputStream stream, boolean mute) {
        RLog.i((String)TAG, (String)("onRemoteUserAudioStreamMute()-> userid :" + remoteUser.getUserId() + ", mute :" + mute));
        if (this.engineListener != null) {
            this.engineListener.onUserMuteAudio(remoteUser.getUserId(), mute);
        }
    }

    public void onRemoteUserMuteVideo(RCRTCRemoteUser remoteUser, RCRTCInputStream stream, boolean enable) {
        RLog.i((String)TAG, (String)("onRemoteUserVideoStreamEnabled()-> userid :" + remoteUser.getUserId() + ", enable :" + enable));
        if (this.engineListener != null) {
            this.engineListener.onUserMuteVideo(remoteUser.getUserId(), enable);
        }
    }

    public void onRemoteUserUnpublishResource(RCRTCRemoteUser remoteUser, List<RCRTCInputStream> unPublishResource) {
        for (RCRTCInputStream inputStream : unPublishResource) {
            if (inputStream.getMediaType() != RCRTCMediaType.VIDEO || TextUtils.equals((CharSequence)"RongCloudRTC", (CharSequence)inputStream.getTag())) continue;
            this.engineListener.onRemoteUserUnpublishStream(remoteUser.getUserId(), inputStream.getStreamId(), inputStream.getTag());
        }
        RCRTCEngine.getInstance().getRoom().getLocalUser().unsubscribeStreams(unPublishResource, new IRCRTCResultCallback(){

            public void onSuccess() {
                RLog.i((String)RongRTCEventHandler.TAG, (String)"onRemoteUserUnPublishResource()->onUiSuccess");
            }

            public void onFailed(RTCErrorCode errorCode) {
                RLog.e((String)RongRTCEventHandler.TAG, (String)("onRemoteUserUnPublishResource()->onUiFailed : " + errorCode.getValue()));
            }
        });
    }

    public void onUserJoined(RCRTCRemoteUser remoteUser) {
        if (this.engineListener != null) {
            RLog.i((String)TAG, (String)("remote user: " + remoteUser.getUserId() + " join (signal)"));
            this.engineListener.onUserJoined(remoteUser.getUserId(), 1, 2);
        }
    }

    public void onUserLeft(RCRTCRemoteUser remoteUser) {
        if (this.engineListener != null) {
            this.engineListener.onUserOffline(remoteUser.getUserId(), 0);
            List streams = remoteUser.getStreams();
            if (streams == null) {
                return;
            }
            for (RCRTCInputStream stream : streams) {
                if (TextUtils.equals((CharSequence)"RongCloudRTC", (CharSequence)stream.getTag())) continue;
                this.engineListener.onRemoteUserUnpublishStream(remoteUser.getUserId(), stream.getStreamId(), stream.getTag());
            }
        }
    }

    public void onUserOffline(RCRTCRemoteUser remoteUser) {
        if (this.engineListener != null) {
            this.engineListener.onUserOffline(remoteUser.getUserId(), 0);
            List streams = remoteUser.getStreams();
            if (streams == null) {
                return;
            }
            for (RCRTCInputStream stream : streams) {
                if (TextUtils.equals((CharSequence)"RongCloudRTC", (CharSequence)stream.getTag())) continue;
                this.engineListener.onRemoteUserUnpublishStream(remoteUser.getUserId(), stream.getStreamId(), stream.getTag());
            }
        }
    }

    public void onVideoTrackAdd(String userId, String tag) {
    }

    public void onFirstRemoteVideoFrame(String userId, String tag) {
        if (this.engineListener != null) {
            this.engineListener.onFirstRemoteVideoFrame(userId, 0, 0, 0);
        }
    }

    public void onLeaveRoom(int reasonCode) {
        if (this.engineListener != null) {
            this.engineListener.onError(0);
        }
    }

    public void onReceiveMessage(Message message) {
    }

    public void onKickedByServer() {
        if (this.engineListener != null) {
            this.engineListener.onError(2);
        }
    }
}

