/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import io.rong.calllib.ICallEngineListener;
import io.rong.calllib.RongCallSession;
import io.rong.common.RLog;
import java.util.ArrayList;
import java.util.HashMap;

public class RongRTCCallEngineListener
implements ICallEngineListener {
    private static final String TAG = "RongRTCCallEngineListener";
    private Handler handler;

    public RongRTCCallEngineListener(Handler handler) {
        this.handler = handler;
    }

    @Override
    public void onJoinChannelSuccess(String channel, String sessionId, int elapsed) {
        RLog.d((String)TAG, (String)("onJoinChannelSuccess, sessionId = " + sessionId + ", channelId = " + channel));
        Message message = Message.obtain();
        message.what = 201;
        message.obj = sessionId;
        this.handler.sendMessage(message);
    }

    @Override
    public void onRejoinChannelSuccess(String channel, String mediaId, int elapsed) {
    }

    @Override
    public void onWarning(int warn) {
    }

    @Override
    public void onError(int err) {
        RLog.e((String)TAG, (String)("onError, err = " + err));
        if (err == 16) {
            this.handler.sendEmptyMessage(404);
        } else if (err == 100) {
            this.handler.sendEmptyMessage(601);
        } else if (err == 0) {
            this.handler.sendEmptyMessage(403);
        } else if (err == 2) {
            this.handler.sendEmptyMessage(405);
        } else if (err == 3) {
            this.handler.sendEmptyMessage(406);
        }
    }

    @Override
    public void onApiCallExecuted(String api, int error) {
    }

    @Override
    public void onCameraReady() {
    }

    @Override
    public void onVideoStopped() {
    }

    @Override
    public void onAudioQuality(String mediaId, int quality, short delay, short lost) {
    }

    @Override
    public void onLeaveChannel(int val) {
        RLog.d((String)TAG, (String)"onLeaveChannel");
        RongCallSession callInfo = new RongCallSession();
        Message message = Message.obtain();
        message.what = 202;
        message.obj = callInfo;
        Bundle bundle = new Bundle();
        bundle.putInt("hang_up_key", val);
        message.setData(bundle);
        this.handler.sendMessage(message);
    }

    @Override
    public void onRtcStats() {
    }

    @Override
    public void onAudioVolumeIndication(int totalVolume) {
    }

    @Override
    public void onUserJoined(String mediaId, int userType, int methodIdentification) {
        RLog.d((String)TAG, (String)("onUserJoined, mediaId = " + mediaId));
        Message message = Message.obtain();
        message.what = 203;
        message.obj = mediaId;
        message.arg1 = userType;
        message.arg2 = methodIdentification;
        this.handler.sendMessage(message);
    }

    @Override
    public void onRemoteUserPublishStream(String userId, String streamId, String tag) {
        RLog.d((String)TAG, (String)("onRemoteUserPublishStream, userId = " + userId + ", tag = " + tag));
        Message message = Message.obtain();
        message.what = 213;
        Bundle data = new Bundle();
        data.putString("userId", userId);
        data.putString("streamId", streamId);
        data.putString("tag", tag);
        message.setData(data);
        this.handler.sendMessage(message);
    }

    @Override
    public void onRemoteUserUnpublishStream(String userId, String streamId, String tag) {
        RLog.d((String)TAG, (String)("onRemoteUserUnpublishStream, userId = " + userId + ", tag = " + tag));
        Message message = Message.obtain();
        message.what = 214;
        Bundle data = new Bundle();
        data.putString("userId", userId);
        data.putString("streamId", streamId);
        data.putString("tag", tag);
        message.setData(data);
        this.handler.sendMessage(message);
    }

    @Override
    public void onUserOffline(String mediaId, int reason) {
        RLog.d((String)TAG, (String)("onUserOffline, mediaId = " + mediaId));
        Message message = Message.obtain();
        message.what = 204;
        message.obj = mediaId;
        this.handler.sendMessage(message);
    }

    @Override
    public void onUserMuteAudio(String mediaId, boolean muted) {
        RLog.d((String)TAG, (String)("onUserMuteAudio, mediaId = " + mediaId));
        Message message = Message.obtain();
        message.what = 210;
        message.obj = mediaId;
        message.arg1 = muted ? 1 : 0;
        this.handler.sendMessage(message);
    }

    @Override
    public void onUserMuteVideo(String mediaId, boolean muted) {
        RLog.d((String)TAG, (String)("onUserMuteVideo, mediaId = " + mediaId));
        Message message = Message.obtain();
        message.what = 208;
        message.obj = mediaId;
        message.arg1 = muted ? 1 : 0;
        this.handler.sendMessage(message);
    }

    @Override
    public void onRemoteVideoStat(String mediaId, int delay, int receivedBitrate, int receivedFrameRate) {
    }

    @Override
    public void onLocalVideoStat(int sentBitrate, int sentFrameRate) {
    }

    @Override
    public void onFirstRemoteVideoFrame(String mediaId, int width, int height, int elapsed) {
        RLog.d((String)TAG, (String)("onFirstRemoteVideoFrame, userId = " + mediaId));
        Message message = Message.obtain();
        message.what = 209;
        message.obj = mediaId;
        this.handler.sendMessage(message);
    }

    @Override
    public void onFirstLocalVideoFrame(int width, int height, int elapsed) {
    }

    @Override
    public void onFirstRemoteVideoDecoded(String mediaId, int width, int height, int elapsed) {
    }

    @Override
    public void onConnectionLost() {
        RLog.d((String)TAG, (String)"onConnectionLost");
        this.handler.sendEmptyMessage(401);
    }

    @Override
    public void onConnectionInterrupted() {
        RLog.d((String)TAG, (String)"onConnectionInterrupted");
    }

    @Override
    public void onMediaEngineEvent(int code) {
    }

    @Override
    public void onVendorMessage(String mediaId, byte[] data) {
        RLog.d((String)TAG, (String)("onVendorMessage : msg = " + new String(data)));
    }

    @Override
    public void onRefreshRecordingServiceStatus(int status) {
    }

    @Override
    public void onAudioLevelReceive(HashMap<String, String> audioLevel) {
        Message message = Message.obtain();
        message.what = 212;
        message.obj = audioLevel;
        this.handler.sendMessage(message);
    }

    @Override
    public void onAudioLevelSend(String audioLevel) {
        Message message = Message.obtain();
        message.what = 211;
        message.obj = audioLevel;
        this.handler.sendMessage(message);
    }

    @Override
    public void onWhiteBoardURL(String url) {
        Message message = Message.obtain();
        message.what = 301;
        message.obj = url;
        this.handler.sendMessage(message);
    }

    @Override
    public void onNetworkReceiveLost(String userId, int lossRate) {
        Message message = Message.obtain();
        message.what = 303;
        message.obj = userId;
        message.arg1 = lossRate;
        this.handler.sendMessage(message);
    }

    @Override
    public void onNetworkSendLost(int lossRate, int delay) {
        Message message = Message.obtain();
        message.what = 302;
        message.arg1 = lossRate;
        message.arg2 = delay;
        this.handler.sendMessage(message);
    }

    @Override
    public void onNotifySharingScreen(String userId, boolean isSharing) {
        Message message = Message.obtain();
        message.what = 308;
        message.obj = userId;
        message.arg1 = isSharing ? 1 : 0;
        this.handler.sendMessage(message);
    }

    @Override
    public void onNotifyDegradeNormalUserToObserver(String hostId, String userId) {
        Message message = Message.obtain();
        message.what = 304;
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(hostId);
        idList.add(userId);
        message.obj = idList;
        this.handler.sendMessage(message);
    }

    @Override
    public void onNotifyAnswerDegradeNormalUserToObserver(String s, boolean b) {
        if (b) {
            Message message = Message.obtain();
            message.what = 304;
            ArrayList<String> idList = new ArrayList<String>();
            idList.add("");
            idList.add(s);
            message.obj = idList;
            this.handler.sendMessage(message);
        } else {
            RLog.i((String)TAG, (String)("onNotifyAnswerDegradeNormalUserToObserver userID = " + s + ",isAccept = " + b));
        }
    }

    @Override
    public void onNotifyAnswerUpgradeObserverToNormalUser(String userId, boolean isAccept) {
        RLog.i((String)TAG, (String)("onNotifyAnswerUpgradeObserverToNormalUser userId = " + userId + ",isAccept = " + isAccept));
        if (isAccept) {
            Message message = Message.obtain();
            message.what = 309;
            message.obj = userId;
            this.handler.sendMessage(message);
        }
    }

    @Override
    public void sendinInvite() {
        Message message = Message.obtain();
        message.what = 1001;
        this.handler.sendMessage(message);
    }

    @Override
    public void onNotifyAnswerObserverRequestBecomeNormalUser(String userId, long status) {
        Message message = Message.obtain();
        message.what = 305;
        message.obj = userId;
        message.arg1 = (int)status;
        this.handler.sendMessage(message);
    }

    @Override
    public void onNotifyUpgradeObserverToNormalUser(String hostUid, String userId) {
        Message message = Message.obtain();
        message.what = 306;
        this.handler.sendMessage(message);
    }

    @Override
    public void onNotifyHostControlUserDevice(String userId, String hostId, int dType, boolean isOpen) {
        Message message = Message.obtain();
        message.what = 307;
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(userId);
        idList.add(hostId);
        message.obj = idList;
        message.arg1 = dType;
        message.arg2 = isOpen ? 1 : 0;
        this.handler.sendMessage(message);
    }
}

