/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.SurfaceView;
import cn.rongcloud.rtc.api.RCRTCConfig;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RTCErrorCode;
import io.rong.calllib.CallReceiver;
import io.rong.calllib.CallSessionImp;
import io.rong.calllib.CallUserProfile;
import io.rong.calllib.CallVideoFrame;
import io.rong.calllib.CameraSwitchCallBack;
import io.rong.calllib.ICallEngine;
import io.rong.calllib.ICallEngineVideoFrameListener;
import io.rong.calllib.IMediaResourceListener;
import io.rong.calllib.IRongCallListener;
import io.rong.calllib.IRongCallSignalSender;
import io.rong.calllib.IRongReceivedCallListener;
import io.rong.calllib.IVideoFrameListener;
import io.rong.calllib.PublishCallBack;
import io.rong.calllib.ReportUtil;
import io.rong.calllib.Role;
import io.rong.calllib.RongCallCommon;
import io.rong.calllib.RongCallMissedListener;
import io.rong.calllib.RongCallSession;
import io.rong.calllib.RongRTCCallEngineListener;
import io.rong.calllib.StartCameraCallback;
import io.rong.calllib.StreamProfile;
import io.rong.calllib.message.CallAcceptMessage;
import io.rong.calllib.message.CallHangupMessage;
import io.rong.calllib.message.CallInviteMessage;
import io.rong.calllib.message.CallModifyMediaMessage;
import io.rong.calllib.message.CallModifyMemberMessage;
import io.rong.calllib.message.CallRingingMessage;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imlib.IHandler;
import io.rong.imlib.ISendMessageCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.AndroidConfig;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.IOSConfig;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.MessagePushConfig;
import io.rong.imlib.stateMachine.IState;
import io.rong.imlib.stateMachine.State;
import io.rong.imlib.stateMachine.StateMachine;
import io.rong.push.RongPushClient;
import io.rong.push.notification.PushNotificationMessage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class RongCallManager
extends StateMachine {
    private static final String TAG = RongCallManager.class.getSimpleName();
    private static final int CALL_TIMEOUT_INTERVAL = 60000;
    private static RongCallManager sInstance;
    private static IRongReceivedCallListener receivedCallListener;
    private static IRongCallSignalSender callSignalSender;
    private static RongCallMissedListener missedListener;
    private static MessagePushConfig startPushConfig;
    private static MessagePushConfig hangupPushConfig;
    private IRongCallListener callListener;
    private CallSessionImp callSessionImp;
    private Context context;
    private Timer timer;
    private IHandler libStub;
    private Map<String, TimerTask> timerTasks;
    private ICallEngine voIPEngine;
    private List<String> unknownMediaIdList;
    private CallReceiver callReceiver;
    private Handler uiHandler;
    private int minRate;
    private int maxRate;
    private RCRTCConfig.Builder mBuilder = null;
    private RCRTCVideoStreamConfig.Builder mVCBuilder = null;
    private RCRTCAudioStreamConfig.Builder mACBuilder = null;
    private IVideoFrameListener videoFrameListener = null;
    private boolean enableBeauty = false;
    private int cameraId = -1;
    private boolean mirror;
    private StartCameraCallback startCameraCallback = null;
    private State mCheckPermissionState = new CheckPermissionState();
    private State mUnInitState = new UnInitState();
    private State mIdleState = new IdleState();
    private State mIncomingState = new IncomingState();
    private State mOutgoingState = new OutgoingState();
    private State mConnectingState = new ConnectingState();
    private State mConnectedState = new ConnectedState();
    private State mDisconnectingState = new DisconnectingState();
    private IRCRTCAudioDataListener mLocalAudioPCMBufferListener = null;
    private int cameraDisplayOrientation = 0;
    private int frameOrientation = -1;
    private String RTC_TAG = "_RongCloudRTC";
    private int userType = 1;
    private static final String HANG_UP_KEY = "hang_up_key";
    private String otherDeviceHangupCallId = "";
    private String alreadyHangupCallId = "";

    private RongCallManager(String name) {
        super(name);
        this.mVCBuilder = RCRTCVideoStreamConfig.Builder.create().setVideoResolution(RCRTCParamsType.RCRTCVideoResolution.RESOLUTION_480_640).setVideoFps(RCRTCParamsType.RCRTCVideoFps.Fps_15);
    }

    static RongCallManager getInstance() {
        if (sInstance == null) {
            sInstance = new RongCallManager(TAG);
        }
        return sInstance;
    }

    static void setMissedCallListener(RongCallMissedListener listener) {
        missedListener = listener;
    }

    static void setCallSignalSender(IRongCallSignalSender signalSender) {
        callSignalSender = signalSender;
    }

    static void setReceivedCallListener(final IRongReceivedCallListener listener) {
        RLog.i((String)TAG, (String)("setReceivedCallListener, listener = " + listener));
        receivedCallListener = new IRongReceivedCallListener(){

            @Override
            public void onReceivedCall(final RongCallSession callSession) {
                if (sInstance == null) {
                    RLog.e((String)TAG, (String)"RongVoIPManager does not init.");
                    ReportUtil.libError(ReportUtil.TAG.RECEIVE_CALL_LISTENER, "code|state|desc", RTCErrorCode.ILLEGALSTATE.getValue(), "onReceivedCall", "RongCallManager is null");
                    return;
                }
                sInstance.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        RLog.e((String)TAG, (String)"onReceivedCall.");
                        if (listener != null) {
                            listener.onReceivedCall(callSession);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.RECEIVE_CALL_LISTENER, "state|desc", "onReceivedCall", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onCheckPermission(final RongCallSession callSession) {
                if (sInstance == null) {
                    RLog.e((String)TAG, (String)"RongVoIPManager does not init.");
                    ReportUtil.libError(ReportUtil.TAG.RECEIVE_CALL_LISTENER, "code|state|desc", RTCErrorCode.ILLEGALSTATE.getValue(), "onCheckPermission", "RongCallManager is null");
                    return;
                }
                sInstance.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        RLog.i((String)TAG, (String)"onCheckPermission.");
                        if (listener != null) {
                            listener.onCheckPermission(callSession);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.RECEIVE_CALL_LISTENER, "state|desc", "onCheckPermission", "no callListener set");
                        }
                    }
                });
            }
        };
    }

    @SuppressLint(value={"MissingPermission"})
    public static String getDeviceIMEI(Context context) {
        SharedPreferences sp = context.getSharedPreferences("Statistics", 0);
        String imei = sp.getString("IMEI", "");
        if (TextUtils.isEmpty((CharSequence)imei)) {
            try {
                TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
                imei = tm.getDeviceId();
            }
            catch (SecurityException e) {
                Log.e((String)"DeviceUtils", (String)"SecurityException!!!");
            }
            if (TextUtils.isEmpty((CharSequence)imei) || "000000000000000".equals(imei) || "000000000000".equals(imei)) {
                SecureRandom random = new SecureRandom();
                imei = new BigInteger(64, random).toString(16);
            }
            SharedPreferences.Editor editor = sp.edit();
            editor.putString("IMEI", imei);
            editor.commit();
        }
        return imei;
    }

    private IRongCallListener getCallListener() {
        if (this.callListener == null) {
            return (IRongCallListener)Proxy.newProxyInstance(IRongCallListener.class.getClassLoader(), new Class[]{IRongCallListener.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    RLog.e((String)TAG, (String)("callListener is null method: " + method.getName()));
                    return null;
                }
            });
        }
        return this.callListener;
    }

    void setCallListener(final IRongCallListener voIPCallListener) {
        RLog.i((String)TAG, (String)("setCallListener, listener = " + voIPCallListener));
        this.callListener = new IRongCallListener(){

            @Override
            public void onCallOutgoing(final RongCallSession callProfile, final SurfaceView surfaceView) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onCallOutgoing(callProfile, surfaceView);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onCallOutgoing", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onRemoteUserRinging(final String userId) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onRemoteUserRinging(userId);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onCallOutgoing", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onCallDisconnected(final RongCallSession callProfile, final RongCallCommon.CallDisconnectedReason reason) {
                try {
                    RongCallManager.this.context.unregisterReceiver((BroadcastReceiver)RongCallManager.this.callReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onCallDisconnected(callProfile, reason);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onCallDisconnected", "no callListener set");
                        }
                    }
                });
                RongCallManager.this.sendHangupBroadcast(callProfile);
            }

            @Override
            public void onRemoteUserJoined(final String userId, final RongCallCommon.CallMediaType mediaType, final int userType, final SurfaceView videoView) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onRemoteUserJoined(userId, mediaType, userType, videoView);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onCallOutgoing", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onRemoteUserInvited(final String userId, final RongCallCommon.CallMediaType mediaType) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onRemoteUserInvited(userId, mediaType);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onRemoteUserInvited", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onMediaTypeChanged(final String userId, final RongCallCommon.CallMediaType mediaType, final SurfaceView videoView) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onMediaTypeChanged(userId, mediaType, videoView);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onMediaTypeChanged", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onError(final RongCallCommon.CallErrorCode errorCode) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onError(errorCode);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onError", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onRemoteUserLeft(final String userId, final RongCallCommon.CallDisconnectedReason reason) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onRemoteUserLeft(userId, reason);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onRemoteUserLeft", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onCallConnected(final RongCallSession callProfile, final SurfaceView localVideo) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onCallConnected(callProfile, localVideo);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onCallConnected", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onRemoteCameraDisabled(final String userId, final boolean muted) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onRemoteCameraDisabled(userId, muted);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onCallOutgoing", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onRemoteMicrophoneDisabled(final String userId, final boolean disabled) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onRemoteMicrophoneDisabled(userId, disabled);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onRemoteMicrophoneDisabled", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onNetworkSendLost(int lossRate, int delay) {
                if (voIPCallListener != null) {
                    voIPCallListener.onNetworkSendLost(lossRate, delay);
                } else {
                    ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onNetworkSendLost", "no callListener set");
                }
            }

            @Override
            public void onFirstRemoteVideoFrame(final String userId, final int height, final int width) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onFirstRemoteVideoFrame(userId, height, width);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onFirstRemoteVideoFrame", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onAudioLevelSend(final String audioLevel) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onAudioLevelSend(audioLevel);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onAudioLevelSend", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onRemoteUserPublishVideoStream(final String userId, final String streamId, final String tag, final SurfaceView surfaceView) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onRemoteUserPublishVideoStream(userId, streamId, tag, surfaceView);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onRemoteUserPublishVideoStream", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onAudioLevelReceive(final HashMap<String, String> audioLevel) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onAudioLevelReceive(audioLevel);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onAudioLevelReceive", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onRemoteUserUnpublishVideoStream(final String userId, final String streamId, final String tag) {
                RongCallManager.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (voIPCallListener != null) {
                            voIPCallListener.onRemoteUserUnpublishVideoStream(userId, streamId, tag);
                        } else {
                            ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onRemoteUserUnpublishVideoStream", "no callListener set");
                        }
                    }
                });
            }

            @Override
            public void onNetworkReceiveLost(String userId, int lossRate) {
                if (voIPCallListener != null) {
                    voIPCallListener.onNetworkReceiveLost(userId, lossRate);
                } else {
                    ReportUtil.libStatus(ReportUtil.TAG.CALL_LISTENER, "state|desc", "onNetworkReceiveLost", "no callListener set");
                }
            }
        };
    }

    private void sendHangupBroadcast(RongCallSession callProfile) {
        if (Build.VERSION.SDK_INT < 29 || callProfile == null) {
            return;
        }
        PushNotificationMessage pushMsg = new PushNotificationMessage();
        pushMsg.setConversationType(RongPushClient.ConversationType.setValue((int)callProfile.getConversationType().getValue()));
        pushMsg.setTargetId(callProfile.getTargetId());
        pushMsg.setSenderId(callProfile.getCallerUserId());
        pushMsg.setObjectName("RC:VCHangup");
        Intent intent = new Intent();
        intent.setPackage(this.context.getPackageName());
        intent.putExtra("message", (Parcelable)pushMsg);
        intent.putExtra("callsession", (Parcelable)callProfile);
        intent.setAction("action.push.CallInviteMessage");
        this.context.sendBroadcast(intent);
    }

    void reIninialization(Context context, IHandler libStub) {
        this.libStub = libStub;
        this.context = context.getApplicationContext();
    }

    void init(Context context, IHandler stub) {
        this.timer = new Timer();
        this.timerTasks = new HashMap<String, TimerTask>();
        this.context = context.getApplicationContext();
        this.unknownMediaIdList = new ArrayList<String>();
        this.libStub = stub;
        this.uiHandler = new Handler(Looper.getMainLooper());
        this.addState(this.mUnInitState);
        this.addState(this.mCheckPermissionState);
        this.addState(this.mIdleState);
        this.addState(this.mIncomingState, this.mIdleState);
        this.addState(this.mOutgoingState, this.mIdleState);
        this.addState(this.mConnectingState, this.mIdleState);
        this.addState(this.mConnectedState, this.mIdleState);
        this.addState(this.mDisconnectingState, this.mIdleState);
        this.setInitialState(this.mUnInitState);
        this.start();
    }

    private void runOnUiThread(Runnable runnable) {
        this.uiHandler.post(runnable);
    }

    RongCallCommon.CallEngineType getPreferEngineType() {
        try {
            String info = this.libStub.getVoIPCallInfo();
            if (TextUtils.isEmpty((CharSequence)info)) {
                this.getCallListener().onError(RongCallCommon.CallErrorCode.ENGINE_NOT_FOUND);
                RLog.e((String)TAG, (String)"The opened audio and video service did not take effect in time or the audio and video service was closed. \n Please wait 3-5 hours to reinstall the application or open the audio and video service before testing.");
                return null;
            }
            JSONObject jsonObject = new JSONObject(info);
            int strategy = jsonObject.getInt("strategy");
            if (strategy == 0) {
                RLog.e((String)TAG, (String)"VoIP call is not granted by navi data.");
                return null;
            }
            return RongCallCommon.CallEngineType.ENGINE_TYPE_RTC;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean checkedVoipEnable() {
        try {
            String info = this.libStub.getVoIPCallInfo();
            if (TextUtils.isEmpty((CharSequence)info)) {
                return false;
            }
            JSONObject jsonObject = new JSONObject(info);
            int strategy = jsonObject.getInt("strategy");
            return strategy != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkSupportEngine(RongCallCommon.CallEngineType engineType) {
        String engineName = null;
        if (engineType == RongCallCommon.CallEngineType.ENGINE_TYPE_AGORA) {
            engineName = "io.rong.agora.AgoraEngine";
        } else if (engineType == RongCallCommon.CallEngineType.ENGINE_TYPE_RONG) {
            engineName = "io.rong.webrtc.RongCallEngine";
        } else if (engineType == RongCallCommon.CallEngineType.ENGINE_TYPE_BLINK) {
            engineName = "io.rong.calllib.RongCallEngine";
        } else if (engineType == RongCallCommon.CallEngineType.ENGINE_TYPE_RTC) {
            engineName = "io.rong.calllib.RongCallEngine";
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(engineName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        RLog.e((String)TAG, (String)((Object)((Object)engineType) + " engine support " + (clazz != null)));
        return clazz != null;
    }

    private void printVoipLog() {
        RLog.i((String)TAG, (String)("print log  voipEngine " + this.voIPEngine));
        if (this.voIPEngine != null) {
            String logPath = FileUtils.getCachePath((Context)this.context, (String)"/ronglog");
            String filePath = logPath + "/rcvoip.log";
            this.voIPEngine.setLogFile(filePath);
        }
    }

    private boolean startEngine() {
        RLog.i((String)TAG, (String)"startEngine");
        try {
            String info = this.libStub.getVoIPCallInfo();
            if (TextUtils.isEmpty((CharSequence)info)) {
                this.getCallListener().onError(RongCallCommon.CallErrorCode.ENGINE_NOT_FOUND);
                RLog.e((String)TAG, (String)"The opened audio and video service did not take effect in time or the audio and video service was closed. \n Please wait 3-5 hours to reinstall the application or open the audio and video service before testing.");
                return false;
            }
            if (this.voIPEngine != null) {
                return true;
            }
            RongCallCommon.CallEngineType engineType = this.callSessionImp.getEngineType();
            JSONObject jsonObject = new JSONObject(info);
            JSONArray jsonArray = jsonObject.getJSONArray("callEngine");
            String vendorKey = null;
            JSONObject object = null;
            for (int i = 0; i < jsonArray.length(); ++i) {
                object = jsonArray.getJSONObject(i);
                int type = object.optInt("engineType");
                if (type != engineType.getValue()) continue;
                vendorKey = object.optString("vendorKey");
                break;
            }
            if (vendorKey == null && engineType != RongCallCommon.CallEngineType.ENGINE_TYPE_RTC) {
                RLog.e((String)TAG, (String)"the vendor key get from navi data is null.");
                return false;
            }
            if (engineType == RongCallCommon.CallEngineType.ENGINE_TYPE_RTC) {
                String engineName = "io.rong.calllib.RongCallEngine";
                Constructor<?> constructor = Class.forName(engineName).getConstructor(new Class[0]);
                this.voIPEngine = (ICallEngine)constructor.newInstance(new Object[0]);
                RongRTCCallEngineListener engineListener = new RongRTCCallEngineListener(this.getHandler());
                this.voIPEngine.setAudioConfig(this.mACBuilder);
                this.voIPEngine.setVideoConfig(this.mVCBuilder);
                this.voIPEngine.setRTCConfig(this.mBuilder);
                this.voIPEngine.create(this.context, vendorKey, engineListener);
                this.voIPEngine.setCameraOrientation(this.cameraDisplayOrientation, this.frameOrientation);
                if (this.mLocalAudioPCMBufferListener != null) {
                    this.voIPEngine.setLocalAudioPCMBufferListener(this.mLocalAudioPCMBufferListener);
                }
                if (this.videoFrameListener != null) {
                    this.voIPEngine.setVideoFrameListener(new ICallEngineVideoFrameListener(){

                        @Override
                        public CallVideoFrame processVideoFrame(CallVideoFrame videoFrame) {
                            return RongCallManager.this.videoFrameListener.processVideoFrame(videoFrame);
                        }
                    });
                }
                if (this.callSessionImp != null && this.callSessionImp.getMediaType() != null && this.callSessionImp.getMediaType() == RongCallCommon.CallMediaType.AUDIO) {
                    this.voIPEngine.setAudioOnly(true);
                } else {
                    this.voIPEngine.setAudioOnly(false);
                }
                return true;
            }
        }
        catch (Exception e) {
            this.voIPEngine = null;
            RLog.e((String)TAG, (String)("VOIP Init Error!" + e.getMessage()));
            e.printStackTrace();
        }
        return false;
    }

    private void stopEngine() {
        RLog.i((String)TAG, (String)"stopEngine");
        if (this.voIPEngine != null) {
            this.voIPEngine.destroy();
            this.voIPEngine = null;
        }
    }

    private String getMyUserId() {
        String userId = RongIMClient.getInstance().getCurrentUserId();
        if (TextUtils.isEmpty((CharSequence)userId)) {
            userId = PreferenceManager.getDefaultSharedPreferences((Context)this.context).getString("userId", "");
        }
        return userId;
    }

    private void sendInviteMessage(final List<String> userList, final SignalCallback callback) {
        final CallInviteMessage inviteMessage = new CallInviteMessage();
        inviteMessage.setMediaType(this.callSessionImp.getMediaType());
        inviteMessage.setEngineType(this.callSessionImp.getEngineType());
        inviteMessage.setInviteUserIds(userList);
        if (this.callSessionImp.getobserverUserList() != null) {
            inviteMessage.setObserverUserIds(this.callSessionImp.getobserverUserList());
        }
        inviteMessage.setExtra(this.callSessionImp.getExtra());
        inviteMessage.setCallId(this.callSessionImp.getCallId());
        final io.rong.imlib.model.Message message = io.rong.imlib.model.Message.obtain((String)this.callSessionImp.getTargetId(), (Conversation.ConversationType)this.callSessionImp.getConversationType(), (MessageContent)inviteMessage);
        String appCallId = "";
        if (this.callSessionImp.getConversationType().equals((Object)Conversation.ConversationType.PRIVATE)) {
            appCallId = this.callSessionImp.getCallId();
        }
        message.setMessagePushConfig(this.generateInvitePushConfig(appCallId));
        if (callSignalSender != null && this.callSessionImp.isUseSignalServer()) {
            callSignalSender.getMediaId(new IRongCallSignalSender.GetMediaIdCallback(){

                @Override
                public void onGotMediaId(final String mediaId) {
                    inviteMessage.setMediaId(mediaId);
                    inviteMessage.setUseSignalServer(true);
                    message.setObjectName("RC:VCInvite");
                    callSignalSender.sendSignal(userList, message, null, RongCallManager.this.getPushData(RongCallManager.this.callSessionImp.getMediaType(), userList, RongCallManager.this.callSessionImp.getCallId()), new IRongCallSignalSender.SendSignalCallback(){

                        @Override
                        public void onSuccess() {
                            if (callback != null) {
                                callback.onSuccess(RongCallManager.this.getMyUserId(), mediaId);
                            }
                        }

                        @Override
                        public void onError(int errorCode) {
                            Log.i((String)TAG, (String)("sendInviteMessage-> message.setObjectName errorCode=" + errorCode));
                            ReportUtil.appError(ReportUtil.TAG.START_CALL, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "user callSignalSender,sendSignal error");
                            if (callback != null) {
                                callback.onError();
                            }
                        }
                    });
                }

                @Override
                public void onError(int errorCode) {
                    Log.i((String)TAG, (String)("sendInviteMessage->callSignalSender.getMediaId errorCode=" + errorCode));
                    if (callback != null) {
                        callback.onError();
                    }
                }
            });
        } else {
            try {
                String[] userArray = userList.toArray(new String[userList.size()]);
                this.libStub.sendDirectionalMessage(message, null, this.getPushData(this.callSessionImp.getMediaType(), userList, this.callSessionImp.getCallId()), userArray, (ISendMessageCallback)new ISendMessageCallback.Stub(){

                    public void onAttached(io.rong.imlib.model.Message message) throws RemoteException {
                    }

                    public void onSuccess(io.rong.imlib.model.Message message) throws RemoteException {
                        if (callback != null) {
                            String mediaId = RongCallManager.this.getMediaId(message);
                            callback.onSuccess(message.getSenderUserId(), mediaId);
                        }
                    }

                    public void onError(io.rong.imlib.model.Message message, int errorCode) throws RemoteException {
                        Log.i((String)TAG, (String)("sendInviteMessage->libStub.sendDirectionalMessage errorCode=" + errorCode));
                        ReportUtil.appError(ReportUtil.TAG.START_CALL, 2, "code|targetId|conversationType|roomId|desc", errorCode, RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.getRoomId(), "send im invite message error");
                        if (callback != null) {
                            callback.onError();
                        }
                    }
                });
            }
            catch (RemoteException e) {
                RLog.e((String)TAG, (String)"sendInviteMessage exception");
                e.printStackTrace();
            }
        }
    }

    private void sendModifyMemberMessage(List<String> userList, List<String> observerUserIds, final SignalCallback callback) {
        final CallModifyMemberMessage modifyMemberMessage = new CallModifyMemberMessage();
        modifyMemberMessage.setCallId(this.callSessionImp.getCallId());
        modifyMemberMessage.setCaller(this.callSessionImp.getCallerUserId());
        modifyMemberMessage.setInviter(this.callSessionImp.getInviterUserId());
        modifyMemberMessage.setInvitedList(userList);
        modifyMemberMessage.setObserverList(observerUserIds);
        modifyMemberMessage.setEngineType(this.callSessionImp.getEngineType());
        modifyMemberMessage.setMediaType(this.callSessionImp.getMediaType());
        modifyMemberMessage.setModifyMemType(RongCallCommon.CallModifyMemType.MODIFY_MEM_TYPE_ADD);
        modifyMemberMessage.setExtra(this.callSessionImp.getExtra());
        final ArrayList<String> pushList = new ArrayList<String>();
        List<CallUserProfile> participantProfileList = this.callSessionImp.getParticipantProfileList();
        ArrayList<CallUserProfile> oriParticipants = new ArrayList<CallUserProfile>(participantProfileList);
        final ArrayList<String> targetIds = new ArrayList<String>();
        for (CallUserProfile profile : oriParticipants) {
            pushList.add(profile.getUserId());
            if (profile.getUserId().equals(this.callSessionImp.getSelfUserId())) continue;
            targetIds.add(profile.getUserId());
        }
        for (String id : userList) {
            CallUserProfile profile = new CallUserProfile();
            profile.setUserId(id);
            profile.setMediaType(this.callSessionImp.getMediaType());
            profile.setCallStatus(RongCallCommon.CallStatus.IDLE);
            if (null != modifyMemberMessage.getObserverList()) {
                profile.setUserType(modifyMemberMessage.getObserverList().contains(id) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
            }
            participantProfileList.add(profile);
            if (id.equals(this.callSessionImp.getSelfUserId())) continue;
            targetIds.add(id);
        }
        modifyMemberMessage.setParticipantList(oriParticipants);
        final io.rong.imlib.model.Message message = io.rong.imlib.model.Message.obtain((String)this.callSessionImp.getTargetId(), (Conversation.ConversationType)this.callSessionImp.getConversationType(), (MessageContent)modifyMemberMessage);
        String appCallId = "";
        if (this.callSessionImp.getConversationType().equals((Object)Conversation.ConversationType.PRIVATE)) {
            appCallId = this.callSessionImp.getCallId();
        }
        message.setMessagePushConfig(this.generateInvitePushConfig(appCallId));
        if (callSignalSender != null && this.callSessionImp.isUseSignalServer()) {
            callSignalSender.getMediaId(new IRongCallSignalSender.GetMediaIdCallback(){

                @Override
                public void onGotMediaId(final String mediaId) {
                    message.setObjectName("RC:VCModifyMem");
                    modifyMemberMessage.setMediaId(mediaId);
                    modifyMemberMessage.setUseSignalServer(true);
                    callSignalSender.sendSignal(targetIds, message, null, RongCallManager.this.getPushData(RongCallManager.this.callSessionImp.getMediaType(), pushList, RongCallManager.this.callSessionImp.getCallId()), new IRongCallSignalSender.SendSignalCallback(){

                        @Override
                        public void onSuccess() {
                            ReportUtil.appRes(ReportUtil.TAG.MODIFY_MEMBER, "code|roomId", 0, RongCallManager.this.getRoomId());
                            if (callback != null) {
                                callback.onSuccess(RongCallManager.this.getMyUserId(), mediaId);
                            }
                        }

                        @Override
                        public void onError(int errorCode) {
                            RLog.e((String)TAG, (String)("sendModifyMemberMessage->callSignalSender.getMediaId errorCode=" + errorCode));
                            ReportUtil.appError(ReportUtil.TAG.MODIFY_MEMBER, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "user callSignalSender,sendSignal error");
                            if (callback != null) {
                                callback.onError();
                            }
                        }
                    });
                }

                @Override
                public void onError(int errorCode) {
                    RLog.e((String)TAG, (String)("sendModifyMemberMessage->callSignalSender.getMediaId errorCode=" + errorCode));
                    if (callback != null) {
                        callback.onError();
                    }
                }
            });
        } else {
            try {
                List<String> participantUserListWithoutSelf = this.callSessionImp.getParticipantUserListWithoutSelf();
                String[] userArray = participantUserListWithoutSelf.toArray(new String[participantUserListWithoutSelf.size()]);
                this.libStub.sendDirectionalMessage(message, null, this.getPushData(this.callSessionImp.getMediaType(), pushList, this.callSessionImp.getCallId()), userArray, (ISendMessageCallback)new ISendMessageCallback.Stub(){

                    public void onAttached(io.rong.imlib.model.Message message) throws RemoteException {
                        RLog.e((String)TAG, (String)"sendModifyMemberMessage->sendDirectionalMessage->onAttached");
                    }

                    public void onSuccess(io.rong.imlib.model.Message message) throws RemoteException {
                        RLog.i((String)TAG, (String)"sendModifyMemberMessage->sendDirectionalMessage->onSuccess");
                        ReportUtil.appRes(ReportUtil.TAG.MODIFY_MEMBER, "code|roomId", 0, RongCallManager.this.getRoomId());
                        if (callback != null) {
                            String mediaId = RongCallManager.this.getMediaId(message);
                            callback.onSuccess(message.getSenderUserId(), mediaId);
                        }
                    }

                    public void onError(io.rong.imlib.model.Message message, int errorCode) throws RemoteException {
                        RLog.e((String)TAG, (String)("sendModifyMemberMessage->libStub.sendDirectionalMessage errorCode=" + errorCode));
                        ReportUtil.appError(ReportUtil.TAG.MODIFY_MEMBER, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "send im  message error");
                        if (callback != null) {
                            callback.onError();
                        }
                    }
                });
            }
            catch (RemoteException e) {
                RLog.e((String)TAG, (String)"sendModifyMemberMessage exception");
                e.printStackTrace();
            }
        }
    }

    private void sendRingingMessage(String callId) {
        CallRingingMessage content = new CallRingingMessage();
        content.setCallId(callId);
        io.rong.imlib.model.Message message = io.rong.imlib.model.Message.obtain((String)this.callSessionImp.getTargetId(), (Conversation.ConversationType)this.callSessionImp.getConversationType(), (MessageContent)content);
        ReportUtil.libTask(ReportUtil.TAG.CALL_RINGING, "targetId|conversationType|roomId", this.callSessionImp.getTargetId(), this.callSessionImp.getConversationType().getName(), callId);
        if (callSignalSender != null && this.callSessionImp.isUseSignalServer()) {
            message.setObjectName("RC:VCRinging");
            callSignalSender.sendSignal(this.callSessionImp.getParticipantUserListWithoutSelf(), message, null, null, new IRongCallSignalSender.SendSignalCallback(){

                @Override
                public void onSuccess() {
                    ReportUtil.libRes(ReportUtil.TAG.CALL_RINGING, "code|roomId", 0, RongCallManager.this.getRoomId());
                }

                @Override
                public void onError(int errorCode) {
                    ReportUtil.libError(ReportUtil.TAG.CALL_RINGING, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "sendRingingMessage sendSignal error");
                }
            });
        } else {
            try {
                List<String> userList = this.callSessionImp.getParticipantUserListWithoutSelf();
                String[] userArray = userList.toArray(new String[userList.size()]);
                this.libStub.sendDirectionalMessage(message, null, null, userArray, (ISendMessageCallback)new ISendMessageCallback.Stub(){

                    public void onAttached(io.rong.imlib.model.Message message) throws RemoteException {
                        RLog.e((String)TAG, (String)"sendRingingMessage->sendDirectionalMessage->onAttached");
                    }

                    public void onSuccess(io.rong.imlib.model.Message message) throws RemoteException {
                        RLog.i((String)TAG, (String)"sendRingingMessage->sendDirectionalMessage->onSuccess");
                        ReportUtil.appRes(ReportUtil.TAG.CALL_RINGING, "code|roomId", 0, RongCallManager.this.getRoomId());
                    }

                    public void onError(io.rong.imlib.model.Message message, int errorCode) throws RemoteException {
                        RLog.e((String)TAG, (String)("sendRingingMessage->libStub.sendDirectionalMessage errorCode=" + errorCode));
                        ReportUtil.appError(ReportUtil.TAG.CALL_RINGING, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "send im  message error");
                    }
                });
            }
            catch (RemoteException e) {
                RLog.e((String)TAG, (String)"sendRingingMessage exception");
                e.printStackTrace();
            }
        }
    }

    private void sendAcceptMessage(String callId, RongCallCommon.CallMediaType type, final SignalCallback callback) {
        final CallAcceptMessage content = new CallAcceptMessage();
        content.setCallId(callId);
        content.setMediaType(type);
        final io.rong.imlib.model.Message message = io.rong.imlib.model.Message.obtain((String)this.callSessionImp.getTargetId(), (Conversation.ConversationType)this.callSessionImp.getConversationType(), (MessageContent)content);
        if (callSignalSender != null && this.callSessionImp.isUseSignalServer()) {
            callSignalSender.getMediaId(new IRongCallSignalSender.GetMediaIdCallback(){

                @Override
                public void onGotMediaId(final String mediaId) {
                    message.setObjectName("RC:VCAccept");
                    String deviceId = "";
                    try {
                        deviceId = RongCallManager.getDeviceIMEI(RongCallManager.this.context);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    content.setDeviceId(deviceId);
                    content.setMediaId(mediaId);
                    callSignalSender.sendSignal(RongCallManager.this.callSessionImp.getParticipantUserList(), message, null, null, new IRongCallSignalSender.SendSignalCallback(){

                        @Override
                        public void onSuccess() {
                            if (callback != null) {
                                callback.onSuccess(RongCallManager.this.getMyUserId(), mediaId);
                            }
                        }

                        @Override
                        public void onError(int errorCode) {
                            Log.i((String)TAG, (String)("sendAcceptMessage-> callSignalSender.sendSignal errorCode=" + errorCode));
                            ReportUtil.appError(ReportUtil.TAG.ACCEPT_CALL, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "user callSignalSender,sendSignal error");
                            if (callback != null) {
                                callback.onError();
                            }
                        }
                    });
                }

                @Override
                public void onError(int errorCode) {
                    Log.i((String)TAG, (String)("sendAcceptMessage->callSignalSender.getMediaId errorCode=" + errorCode));
                    if (callback != null) {
                        callback.onError();
                    }
                }
            });
        } else {
            try {
                List<String> userList = this.callSessionImp.getParticipantUserList();
                String[] userArray = userList.toArray(new String[userList.size()]);
                this.libStub.sendDirectionalMessage(message, null, null, userArray, (ISendMessageCallback)new ISendMessageCallback.Stub(){

                    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
                        boolean result;
                        try {
                            result = super.onTransact(code, data, reply, flags);
                        }
                        catch (RuntimeException e) {
                            RLog.e((String)TAG, (String)"sendMessage Unexpected remote exception", (Throwable)e);
                            throw e;
                        }
                        return result;
                    }

                    public void onAttached(io.rong.imlib.model.Message message) throws RemoteException {
                    }

                    public void onSuccess(io.rong.imlib.model.Message message) throws RemoteException {
                        if (callback != null) {
                            String mediaId = RongCallManager.this.getMediaId(message);
                            callback.onSuccess(message.getSenderUserId(), mediaId);
                        }
                    }

                    public void onError(io.rong.imlib.model.Message message, int errorCode) throws RemoteException {
                        Log.i((String)TAG, (String)("sendAcceptMessage->libStub.sendDirectionalMessage(message errorCode=" + errorCode));
                        ReportUtil.appError(ReportUtil.TAG.ACCEPT_CALL, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "send im accept message error");
                        if (callback != null) {
                            callback.onError();
                        }
                    }
                });
            }
            catch (RemoteException e) {
                RLog.e((String)TAG, (String)"sendAcceptMessage exception");
                e.printStackTrace();
            }
        }
    }

    private MessagePushConfig generateInvitePushConfig(String notificationId) {
        IOSConfig iosConfig;
        MessagePushConfig pushConfig = startPushConfig;
        if (pushConfig == null) {
            return null;
        }
        this.callSessionImp.setPushConfig(startPushConfig);
        AndroidConfig androidConfig = pushConfig.getAndroidConfig();
        if (androidConfig != null) {
            androidConfig.setNotificationId(notificationId);
        }
        if ((iosConfig = pushConfig.getIOSConfig()) != null) {
            iosConfig.setApns_collapse_id(notificationId);
        }
        return new MessagePushConfig.Builder().setPushTitle(pushConfig.getPushTitle()).setPushContent(pushConfig.getPushContent()).setPushData(pushConfig.getPushData()).setForceShowDetailContent(pushConfig.isForceShowDetailContent()).setAndroidConfig(pushConfig.getAndroidConfig()).setIOSConfig(pushConfig.getIOSConfig()).build();
    }

    private MessagePushConfig generateHangupPushConfig(String notificationId) {
        IOSConfig iosConfig;
        MessagePushConfig pushConfig = hangupPushConfig;
        if (pushConfig == null) {
            return null;
        }
        this.callSessionImp.setPushConfig(hangupPushConfig);
        AndroidConfig androidConfig = pushConfig.getAndroidConfig();
        if (androidConfig != null) {
            androidConfig.setNotificationId(notificationId);
        }
        if ((iosConfig = pushConfig.getIOSConfig()) != null) {
            iosConfig.setApns_collapse_id(notificationId);
        }
        return new MessagePushConfig.Builder().setPushTitle(pushConfig.getPushTitle()).setPushContent(pushConfig.getPushContent()).setPushData(pushConfig.getPushData()).setForceShowDetailContent(pushConfig.isForceShowDetailContent()).setAndroidConfig(pushConfig.getAndroidConfig()).setIOSConfig(pushConfig.getIOSConfig()).build();
    }

    private void sendHangupMessage(Conversation.ConversationType conversationType, String targetId, String callId, RongCallCommon.CallDisconnectedReason reason, SignalCallback callback) {
        CallHangupMessage content = new CallHangupMessage();
        content.setCallId(callId);
        content.setHangupReason(reason);
        io.rong.imlib.model.Message message = io.rong.imlib.model.Message.obtain((String)targetId, (Conversation.ConversationType)conversationType, (MessageContent)content);
        String appCallId = "";
        if (this.callSessionImp.getConversationType().equals((Object)Conversation.ConversationType.PRIVATE)) {
            appCallId = this.callSessionImp.getCallId();
        }
        message.setMessagePushConfig(this.generateHangupPushConfig(appCallId));
        if (callSignalSender != null && this.callSessionImp.isUseSignalServer()) {
            message.setObjectName("RC:VCHangup");
            callSignalSender.sendSignal(this.callSessionImp.getParticipantUserListWithoutSelf(), message, null, this.getPushData(null, null, this.callSessionImp.getCallId()), new IRongCallSignalSender.SendSignalCallback(){

                @Override
                public void onSuccess() {
                    RLog.i((String)TAG, (String)"sendHangupMessage()->sendSignal()->onSuccess()");
                    ReportUtil.appRes(ReportUtil.TAG.HANGUP_CALL, "code|roomId", 0, RongCallManager.this.getRoomId());
                }

                @Override
                public void onError(int errorCode) {
                    RLog.e((String)TAG, (String)("sendHangupMessage()->sendSignal()->onError() code :" + errorCode));
                    ReportUtil.appError(ReportUtil.TAG.HANGUP_CALL, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "user callSignalSender,sendSignal error");
                }
            });
        } else {
            try {
                List<String> userList = this.callSessionImp.getParticipantUserListWithoutSelf();
                String[] userArray = userList.toArray(new String[userList.size()]);
                this.libStub.sendDirectionalMessage(message, null, this.getPushData(null, null, this.callSessionImp.getCallId()), userArray, (ISendMessageCallback)new ISendMessageCallback.Stub(){

                    public void onAttached(io.rong.imlib.model.Message message) throws RemoteException {
                        RLog.i((String)TAG, (String)"sendHangupMessage()->sendDirectionalMessage()->onAttached()");
                    }

                    public void onSuccess(io.rong.imlib.model.Message message) throws RemoteException {
                        RLog.i((String)TAG, (String)"sendHangupMessage()->sendDirectionalMessage()->onSuccess()");
                        ReportUtil.appRes(ReportUtil.TAG.HANGUP_CALL, "code|roomId", 0, RongCallManager.this.getRoomId());
                    }

                    public void onError(io.rong.imlib.model.Message message, int errorCode) throws RemoteException {
                        RLog.e((String)TAG, (String)("sendHangupMessage()->sendDirectionalMessage()->onError() code :" + errorCode));
                        ReportUtil.libError(ReportUtil.TAG.HANGUP_CALL, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "send im hangup message error");
                    }
                });
            }
            catch (RemoteException e) {
                RLog.e((String)TAG, (String)"sendHangupMessage exception");
                e.printStackTrace();
            }
        }
    }

    private void sendHangupMessageWhenInCall(CallInviteMessage message, String targetId, Conversation.ConversationType conversationType, String senderId) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(senderId);
        for (String userId : message.getInviteUserIds()) {
            if (TextUtils.equals((CharSequence)this.callSessionImp.getSelfUserId(), (CharSequence)userId)) continue;
            userIdList.add(userId);
        }
        for (String userId : message.getObserverUserIds()) {
            if (TextUtils.equals((CharSequence)this.callSessionImp.getSelfUserId(), (CharSequence)userId)) continue;
            userIdList.add(userId);
        }
        String[] userIds = new String[userIdList.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = (String)userIdList.get(i);
        }
        this.sendHangupMessageWhenInCall(targetId, userIds, message.getCallId(), conversationType);
    }

    private void sendHangupMessageWhenInCall(CallModifyMemberMessage message, String targetId, Conversation.ConversationType conversationType, String senderId) {
        ArrayList<String> userIdList = new ArrayList<String>();
        userIdList.add(senderId);
        for (String userId : message.getInvitedList()) {
            if (TextUtils.equals((CharSequence)this.callSessionImp.getSelfUserId(), (CharSequence)userId)) continue;
            userIdList.add(userId);
        }
        for (String userId : message.getObserverList()) {
            if (TextUtils.equals((CharSequence)this.callSessionImp.getSelfUserId(), (CharSequence)userId)) continue;
            userIdList.add(userId);
        }
        for (CallUserProfile profile : message.getParticipantList()) {
            if (TextUtils.equals((CharSequence)this.callSessionImp.getSelfUserId(), (CharSequence)profile.getUserId())) continue;
            userIdList.add(profile.getUserId());
        }
        String[] userIds = new String[userIdList.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = (String)userIdList.get(i);
        }
        this.sendHangupMessageWhenInCall(targetId, userIds, message.getCallId(), conversationType);
    }

    private void sendHangupMessageWhenInCall(final String targetId, String[] userIds, String callId, final Conversation.ConversationType conversationType) {
        CallHangupMessage content = new CallHangupMessage();
        content.setCallId(callId);
        content.setHangupReason(RongCallCommon.CallDisconnectedReason.BUSY_LINE);
        ReportUtil.libTask(ReportUtil.TAG.HANGUP_CALL_IN_CALL, "targetId|conversationType|roomId", targetId, conversationType.getName(), callId);
        io.rong.imlib.model.Message message = io.rong.imlib.model.Message.obtain((String)targetId, (Conversation.ConversationType)conversationType, (MessageContent)content);
        String callEnd = "[\u7ed3\u675f\u901a\u8bdd]";
        if (callSignalSender != null && this.callSessionImp.isUseSignalServer()) {
            message.setObjectName("RC:VCHangup");
            callSignalSender.sendSignal(Arrays.asList(userIds), message, callEnd, this.getPushData(null, null, this.callSessionImp.getCallId()), new IRongCallSignalSender.SendSignalCallback(){

                @Override
                public void onSuccess() {
                    ReportUtil.libRes(ReportUtil.TAG.HANGUP_CALL_IN_CALL, "code|roomId", 0, RongCallManager.this.getRoomId());
                }

                @Override
                public void onError(int errorCode) {
                    ReportUtil.appError(ReportUtil.TAG.HANGUP_CALL_IN_CALL, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "sendHangupMessageWhenInCall sendSignal error");
                }
            });
        } else {
            try {
                this.libStub.sendDirectionalMessage(message, callEnd, this.getPushData(null, null, this.callSessionImp.getCallId()), userIds, (ISendMessageCallback)new ISendMessageCallback.Stub(){

                    public void onAttached(io.rong.imlib.model.Message message) throws RemoteException {
                    }

                    public void onSuccess(io.rong.imlib.model.Message message) throws RemoteException {
                        ReportUtil.libRes(ReportUtil.TAG.HANGUP_CALL_IN_CALL, "code|roomId", 0, RongCallManager.this.getRoomId());
                    }

                    public void onError(io.rong.imlib.model.Message message, int errorCode) throws RemoteException {
                        ReportUtil.appError(ReportUtil.TAG.HANGUP_CALL_IN_CALL, 2, "code|targetId|conversationType|roomId|desc", errorCode, targetId, conversationType.getName(), RongCallManager.this.getRoomId(), "sendHangupMessageWhenInCall im  message error");
                        RLog.e((String)TAG, (String)("send hungup error: " + errorCode));
                    }
                });
            }
            catch (RemoteException e) {
                RLog.e((String)TAG, (String)"sendHangupMessage exception");
                e.printStackTrace();
            }
        }
    }

    private String getPushData(RongCallCommon.CallMediaType mediaType, List<String> userIds, String callId) {
        JSONObject jsonObject = new JSONObject();
        try {
            if (mediaType != null) {
                jsonObject.put("mediaType", mediaType.getValue());
            }
            jsonObject.put("callId", (Object)callId);
            JSONArray jsonArray = new JSONArray();
            if (userIds != null) {
                for (String userId : userIds) {
                    jsonArray.put((Object)userId);
                }
                jsonObject.put("userIdList", (Object)jsonArray);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject.toString();
    }

    private void changeEngineMediaType(String operatorUserId, RongCallCommon.CallMediaType mediaType) {
        if (this.voIPEngine == null) {
            return;
        }
        switch (mediaType) {
            case AUDIO: {
                this.voIPEngine.disableVideo();
                this.callSessionImp.setLocalVideo(null);
                for (CallUserProfile profile : this.callSessionImp.getParticipantProfileList()) {
                    if (!profile.getCallStatus().equals((Object)RongCallCommon.CallStatus.CONNECTED)) continue;
                    profile.setVideoView(null);
                }
                this.getCallListener().onMediaTypeChanged(operatorUserId, RongCallCommon.CallMediaType.AUDIO, null);
                break;
            }
            case VIDEO: {
                this.voIPEngine.enableVideo();
                if (this.callSessionImp.getLocalVideo() == null) {
                    SurfaceView localVideo = this.setupLocalVideo();
                    this.callSessionImp.setLocalVideo(localVideo);
                    this.getCallListener().onMediaTypeChanged(operatorUserId, RongCallCommon.CallMediaType.VIDEO, localVideo);
                }
                for (CallUserProfile profile : this.callSessionImp.getParticipantProfileList()) {
                    if (!profile.getCallStatus().equals((Object)RongCallCommon.CallStatus.CONNECTED)) continue;
                    SurfaceView remoteVideo = profile.getVideoView();
                    remoteVideo = this.reSetupRemoteVideo(profile.getUserId() + this.RTC_TAG, remoteVideo);
                    profile.setVideoView(remoteVideo);
                    this.getCallListener().onMediaTypeChanged(profile.getUserId(), RongCallCommon.CallMediaType.VIDEO, remoteVideo);
                }
                break;
            }
        }
        this.callSessionImp.setMediaType(mediaType);
    }

    private void sendChangeMediaTypeMessage(RongCallCommon.CallMediaType mediaType) {
        CallModifyMediaMessage content = new CallModifyMediaMessage();
        content.setCallId(this.callSessionImp.getCallId());
        content.setMediaType(mediaType);
        io.rong.imlib.model.Message message = io.rong.imlib.model.Message.obtain((String)this.callSessionImp.getTargetId(), (Conversation.ConversationType)this.callSessionImp.getConversationType(), (MessageContent)content);
        if (callSignalSender != null && this.callSessionImp.isUseSignalServer()) {
            message.setObjectName("RC:VCModifyMedia");
            callSignalSender.sendSignal(this.callSessionImp.getParticipantUserListWithoutSelf(), message, null, null, new IRongCallSignalSender.SendSignalCallback(){

                @Override
                public void onSuccess() {
                    ReportUtil.libRes(ReportUtil.TAG.CHANGE_MEDIA_TYPE, "code|roomId", 0, RongCallManager.this.getRoomId());
                }

                @Override
                public void onError(int errorCode) {
                    ReportUtil.appError(ReportUtil.TAG.CHANGE_MEDIA_TYPE, 2, "code|roomId|desc", errorCode, RongCallManager.this.getRoomId(), "sendChangeMediaTypeMessage sendSignal error");
                }
            });
        } else {
            try {
                List<String> userList = this.callSessionImp.getParticipantUserListWithoutSelf();
                String[] userArray = userList.toArray(new String[userList.size()]);
                this.libStub.sendDirectionalMessage(message, null, null, userArray, (ISendMessageCallback)new ISendMessageCallback.Stub(){

                    public void onAttached(io.rong.imlib.model.Message message) throws RemoteException {
                    }

                    public void onSuccess(io.rong.imlib.model.Message message) throws RemoteException {
                        ReportUtil.libRes(ReportUtil.TAG.CHANGE_MEDIA_TYPE, "code|roomId", 0, RongCallManager.this.getRoomId());
                    }

                    public void onError(io.rong.imlib.model.Message message, int errorCode) throws RemoteException {
                        Log.i((String)TAG, (String)("sendChangeMediaTypeMessage->libStub.sendDirectionalMessage errorCode=" + errorCode));
                        ReportUtil.appError(ReportUtil.TAG.CHANGE_MEDIA_TYPE, 2, "code|targetId|conversationType|roomId|desc", errorCode, RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getConversationType().getName(), RongCallManager.this.callSessionImp.getCallId(), "send im  message error");
                    }
                });
            }
            catch (RemoteException e) {
                RLog.e((String)TAG, (String)"sendChangeMediaTypeMessage exception");
                e.printStackTrace();
            }
        }
    }

    private void setupTimerTask(final String userId, final int event, int interval) {
        RLog.i((String)TAG, (String)("setupTimerTask start : " + userId + ", event : " + event + " , interval : " + interval));
        if (this.timerTasks != null && !this.timerTasks.containsKey(userId)) {
            RLog.i((String)TAG, (String)("setupTimerTask success : " + userId));
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    Message msg = Message.obtain();
                    msg.what = event;
                    msg.obj = userId;
                    RongCallManager.this.getHandler().sendMessage(msg);
                }
            };
            this.timerTasks.put(userId, task);
            this.timer.schedule(task, interval);
        } else {
            RLog.i((String)TAG, (String)("setupTimerTask error : " + userId));
        }
    }

    private void cancelTimerTask(String userId) {
        TimerTask task;
        if (this.timerTasks.size() > 0 && (task = this.timerTasks.get(userId)) != null) {
            task.cancel();
            this.timerTasks.remove(userId);
            RLog.i((String)TAG, (String)("cancelTimerTask success : " + userId));
        }
    }

    private void resetTimer() {
        if (this.timer != null) {
            RLog.i((String)TAG, (String)"resetTimer localTimer.");
            this.timer.cancel();
        }
        if (this.timerTasks != null && this.timerTasks.size() > 0) {
            RLog.i((String)TAG, (String)"timerTasks clear ...");
            this.timerTasks.clear();
        }
        this.timer = new Timer();
    }

    private void updateCallRongLog(io.rong.imlib.model.Message msg) {
        if (missedListener != null) {
            final RongCallSession callSession = this.makeBusyLineCallSession(msg);
            if (callSession == null) {
                return;
            }
            if (sInstance == null) {
                RLog.e((String)TAG, (String)"RongVoIPManager does not init.");
                return;
            }
            sInstance.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    RLog.d((String)TAG, (String)"BUSY LINE when receive new Call.");
                    missedListener.onRongCallMissed(callSession, RongCallCommon.CallDisconnectedReason.BUSY_LINE);
                }
            });
        }
    }

    private boolean updateParticipantCallStatus(String userId, RongCallCommon.CallStatus status) {
        List<CallUserProfile> userStatusList = this.callSessionImp.getParticipantProfileList();
        if (status.equals((Object)RongCallCommon.CallStatus.IDLE) && this.callSessionImp.getobserverUserList() != null && this.callSessionImp.getobserverUserList().contains(userId)) {
            this.callSessionImp.getobserverUserList().remove(userId);
        }
        for (CallUserProfile userStatus : userStatusList) {
            if (!userId.equals(userStatus.getUserId())) continue;
            if (status.equals((Object)RongCallCommon.CallStatus.IDLE)) {
                userStatusList.remove(userStatus);
                return true;
            }
            userStatus.setCallStatus(status);
            return true;
        }
        if (status.equals((Object)RongCallCommon.CallStatus.IDLE) && this.callSessionImp.getobserverUserList() != null && this.callSessionImp.getobserverUserList().contains(userId)) {
            this.callSessionImp.getobserverUserList().remove(userId);
        }
        return false;
    }

    private boolean hasConnectedUser() {
        List<CallUserProfile> userStatusList = this.callSessionImp.getParticipantProfileList();
        if (userStatusList != null) {
            for (CallUserProfile userStatus : userStatusList) {
                if (!userStatus.getCallStatus().equals((Object)RongCallCommon.CallStatus.CONNECTED) && !userStatus.getCallStatus().equals((Object)RongCallCommon.CallStatus.ACCEPTED)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateParticipantMediaType(String userId, RongCallCommon.CallMediaType type) {
        List<CallUserProfile> userStatusList = this.callSessionImp.getParticipantProfileList();
        for (CallUserProfile userStatus : userStatusList) {
            if (!userId.equals(userStatus.getUserId())) continue;
            userStatus.setMediaType(type);
            return;
        }
    }

    private void updateMediaId(String userId, String mediaId) {
        if (TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)mediaId)) {
            return;
        }
        List<CallUserProfile> profileList = this.callSessionImp.getParticipantProfileList();
        for (CallUserProfile profile : profileList) {
            if (!userId.equals(profile.getUserId())) continue;
            profile.setMediaId(mediaId);
            return;
        }
    }

    private void updateParticipantVideo(String userId, SurfaceView surfaceView) {
        List<CallUserProfile> userStatusList = this.callSessionImp.getParticipantProfileList();
        for (CallUserProfile userStatus : userStatusList) {
            if (!userId.equals(userStatus.getUserId())) continue;
            userStatus.setVideoView(surfaceView);
            return;
        }
    }

    private void updateParticipantUsertype(String userID, RongCallCommon.CallUserType userType) {
        List<CallUserProfile> userStatusList = this.callSessionImp.getParticipantProfileList();
        for (CallUserProfile userProfile : userStatusList) {
            if (!userID.equals(userProfile.getUserId())) continue;
            userProfile.setUserType(userType);
            break;
        }
        if (userType == RongCallCommon.CallUserType.OBSERVER) {
            if (this.callSessionImp.getobserverUserList() != null && !this.callSessionImp.getobserverUserList().contains(userID)) {
                this.callSessionImp.getobserverUserList().add(userID);
            }
        } else if (userType == RongCallCommon.CallUserType.NORMAL && this.callSessionImp.getobserverUserList() != null) {
            this.callSessionImp.getobserverUserList().remove(userID);
        }
    }

    private void joinChannel(String userId) {
        Message.obtain((Handler)this.getHandler(), (int)206).sendToTarget();
    }

    CallSessionImp getCallSessionImp() {
        return this.callSessionImp;
    }

    RongCallSession getCallSession() {
        if (this.callSessionImp == null) {
            return null;
        }
        return this.makeCallSession(this.callSessionImp);
    }

    private RongCallSession makeCallSession(CallSessionImp callSessionImp) {
        if (callSessionImp == null) {
            return null;
        }
        RongCallSession callSession = new RongCallSession();
        callSession.setExtra(callSessionImp.getExtra());
        callSession.setMediaType(callSessionImp.getMediaType());
        callSession.setEngineType(callSessionImp.getEngineType());
        if (callSessionImp.getUserType() != null) {
            callSession.setUserType(callSessionImp.getUserType());
        } else {
            callSession.setUserType(RongCallCommon.CallUserType.NORMAL);
        }
        callSession.setConversationType(callSessionImp.getConversationType());
        callSession.setTargetId(callSessionImp.getTargetId());
        callSession.setInviterUserId(callSessionImp.getInviterUserId());
        if (null != callSessionImp.getobserverUserList()) {
            callSession.setObserverUserList(callSessionImp.getobserverUserList());
        }
        callSession.setSelfUserId(this.getMyUserId());
        callSession.setCallId(callSessionImp.getCallId());
        callSession.setCallerUserId(callSessionImp.getCallerUserId());
        callSession.setActiveTime(callSessionImp.getActiveTime());
        callSession.setEndTime(callSessionImp.getEndTime());
        callSession.setStartTime(callSessionImp.getStartTime());
        callSession.setSessionId(callSessionImp.getSessionId());
        ArrayList<CallUserProfile> tmpList = new ArrayList<CallUserProfile>();
        for (CallUserProfile userProfile : callSessionImp.getParticipantProfileList()) {
            if (!tmpList.contains(userProfile = userProfile.clone())) {
                tmpList.add(userProfile);
                continue;
            }
            RLog.e((String)TAG, (String)("----------getCallSession already exist.userid :" + userProfile.getUserId()));
        }
        callSession.setParticipantUserList(tmpList);
        callSession.setPushConfig(callSessionImp.getPushConfig());
        return callSession;
    }

    private void initializeCallSessionFromInvite(io.rong.imlib.model.Message message) {
        CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
        this.callSessionImp = new CallSessionImp();
        this.callSessionImp.setCallId(inviteMessage.getCallId());
        this.callSessionImp.setMediaType(inviteMessage.getMediaType());
        this.callSessionImp.setEngineType(inviteMessage.getEngineType());
        this.callSessionImp.setObserverUserList(inviteMessage.getObserverUserIds());
        if (inviteMessage.isUseSignalServer()) {
            this.callSessionImp.setUseSignalServer(true);
            this.callSessionImp.setConversationType(Conversation.ConversationType.NONE);
        } else {
            this.callSessionImp.setTargetId(message.getTargetId());
            this.callSessionImp.setConversationType(message.getConversationType());
        }
        this.callSessionImp.setCallerUserId(message.getSenderUserId());
        this.callSessionImp.setInviterUserId(message.getSenderUserId());
        this.callSessionImp.setSelfUserId(this.getMyUserId());
        this.callSessionImp.setExtra(inviteMessage.getExtra());
        ArrayList<CallUserProfile> participantProfileList = new ArrayList<CallUserProfile>();
        CallUserProfile profile = new CallUserProfile();
        profile.setUserId(message.getSenderUserId());
        profile.setCallStatus(RongCallCommon.CallStatus.IDLE);
        String mediaId = this.getMediaId(message);
        profile.setMediaId(mediaId);
        profile.setMediaType(inviteMessage.getMediaType());
        if (inviteMessage.getObserverUserIds() != null) {
            profile.setUserType(inviteMessage.getObserverUserIds().contains(message.getSenderUserId()) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
        }
        participantProfileList.add(profile);
        RLog.i((String)TAG, (String)"initializeCallSessionFromInvite");
        for (String userId : inviteMessage.getInviteUserIds()) {
            profile = new CallUserProfile();
            profile.setUserId(userId);
            profile.setMediaType(inviteMessage.getMediaType());
            profile.setCallStatus(RongCallCommon.CallStatus.IDLE);
            if (inviteMessage.getObserverUserIds() != null) {
                profile.setUserType(inviteMessage.getObserverUserIds().contains(userId) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
            }
            participantProfileList.add(profile);
        }
        this.callSessionImp.setParticipantUserList(participantProfileList);
        this.callSessionImp.setUserType(RongCallCommon.CallUserType.NORMAL);
        if (this.callSessionImp.getobserverUserList() != null && this.callSessionImp.getobserverUserList().size() > 0) {
            for (String id : this.callSessionImp.getobserverUserList()) {
                if (!id.equals(this.callSessionImp.getSelfUserId())) continue;
                this.callSessionImp.setUserType(RongCallCommon.CallUserType.OBSERVER);
                break;
            }
        }
        this.callSessionImp.setPushConfig(message.getMessagePushConfig());
    }

    private void initializeCallInfoFromModifyMember(io.rong.imlib.model.Message message) {
        CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
        this.callSessionImp = new CallSessionImp();
        this.callSessionImp.setCallId(modifyMemberMessage.getCallId());
        if (modifyMemberMessage.isUseSignalServer()) {
            this.callSessionImp.setUseSignalServer(true);
            this.callSessionImp.setConversationType(Conversation.ConversationType.NONE);
        } else {
            this.callSessionImp.setTargetId(message.getTargetId());
            this.callSessionImp.setConversationType(message.getConversationType());
        }
        this.callSessionImp.setCallerUserId(message.getSenderUserId());
        this.callSessionImp.setInviterUserId(message.getSenderUserId());
        this.callSessionImp.setObserverUserList(modifyMemberMessage.getObserverList());
        this.callSessionImp.setSelfUserId(this.getMyUserId());
        this.callSessionImp.setMediaType(modifyMemberMessage.getMediaType());
        this.callSessionImp.setEngineType(modifyMemberMessage.getEngineType());
        this.callSessionImp.setExtra(modifyMemberMessage.getExtra());
        this.callSessionImp.setUserType(modifyMemberMessage.getObserverList().contains(this.getMyUserId()) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
        List<CallUserProfile> tmpParticipantList = modifyMemberMessage.getParticipantList();
        RLog.d((String)TAG, (String)("initializeCallInfoFromModifyMember()->  ParticipantList size :" + modifyMemberMessage.getParticipantList().size()));
        CallUserProfile tmpCallUserProfile = null;
        for (int i = 0; i < tmpParticipantList.size(); ++i) {
            tmpCallUserProfile = tmpParticipantList.get(i);
            if (tmpCallUserProfile != null && modifyMemberMessage.getObserverList() != null && modifyMemberMessage.getObserverList().contains(tmpCallUserProfile.getUserId())) {
                tmpParticipantList.get(i).setUserType(RongCallCommon.CallUserType.OBSERVER);
                continue;
            }
            tmpParticipantList.get(i).setUserType(RongCallCommon.CallUserType.NORMAL);
        }
        RLog.i((String)TAG, (String)"initializeCallInfoFromModifyMember");
        List<String> userList = modifyMemberMessage.getInvitedList();
        for (String id : userList) {
            CallUserProfile profile = new CallUserProfile();
            profile.setUserId(id);
            profile.setMediaType(this.callSessionImp.getMediaType());
            profile.setCallStatus(RongCallCommon.CallStatus.IDLE);
            if (null != modifyMemberMessage.getObserverList()) {
                profile.setUserType(modifyMemberMessage.getObserverList().contains(id) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
            } else {
                profile.setUserType(RongCallCommon.CallUserType.NORMAL);
            }
            tmpParticipantList.add(profile);
        }
        this.callSessionImp.setParticipantUserList(tmpParticipantList);
        this.callSessionImp.setPushConfig(message.getMessagePushConfig());
    }

    private boolean shouldTerminateCall(String userId) {
        List<CallUserProfile> participantProfileList = this.callSessionImp.getParticipantProfileList();
        return userId.equals(this.getMyUserId()) || participantProfileList == null || participantProfileList.size() == 0 || participantProfileList.size() == 1 && participantProfileList.get(0).getUserId().equals(this.getMyUserId());
    }

    private SurfaceView setupRemoteVideo(String userId) {
        RLog.i((String)TAG, (String)("setupRemoteVideo, userId = " + userId));
        SurfaceView remoteVideo = null;
        if (this.voIPEngine != null) {
            remoteVideo = this.voIPEngine.createRendererView(this.context);
            remoteVideo.setZOrderOnTop(true);
            remoteVideo.setZOrderMediaOverlay(true);
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                SurfaceView finalRemoteVideo = remoteVideo;
                this.voIPEngine.setupRemoteVideo(finalRemoteVideo, userId);
            }
        }
        return remoteVideo;
    }

    private SurfaceView reSetupRemoteVideo(String userId, SurfaceView video) {
        if (video == null) {
            video = this.voIPEngine.createRendererView(this.context);
        }
        video.setZOrderOnTop(true);
        video.setZOrderMediaOverlay(true);
        this.voIPEngine.setupRemoteVideo(video, userId);
        return video;
    }

    private SurfaceView setupLocalVideo() {
        RLog.i((String)TAG, (String)"setupLocalVideo");
        SurfaceView localVideo = this.voIPEngine.createRendererView(this.context);
        this.voIPEngine.setupLocalVideo(localVideo);
        RLog.i((String)TAG, (String)("setupLocalVideo()-> cameraId :" + this.cameraId));
        if (this.cameraId == -1) {
            this.voIPEngine.startPreview();
        } else {
            this.voIPEngine.startPreview(this.cameraId, this.mirror, this.startCameraCallback);
        }
        return localVideo;
    }

    private String getMediaId(io.rong.imlib.model.Message message) {
        if (callSignalSender != null && this.callSessionImp.isUseSignalServer()) {
            MessageContent content = message.getContent();
            if (content instanceof CallInviteMessage) {
                return ((CallInviteMessage)content).getMediaId();
            }
            if (content instanceof CallAcceptMessage) {
                return ((CallAcceptMessage)content).getMediaId();
            }
        }
        return (message.getSentTime() & Integer.MAX_VALUE) + "";
    }

    private String getMediaIdByUserId(String userId) {
        List<CallUserProfile> participantProfileList = this.callSessionImp.getParticipantProfileList();
        for (CallUserProfile profile : participantProfileList) {
            if (!profile.getUserId().equals(userId)) continue;
            return profile.getMediaId();
        }
        RLog.e((String)TAG, (String)("getMediaIdByUserId : [userId " + userId + "-> mediaId : null]"));
        return null;
    }

    private String getUserIdByMediaId(String mediaId) {
        List<CallUserProfile> participantProfileList = this.callSessionImp.getParticipantProfileList();
        for (CallUserProfile profile : participantProfileList) {
            if (profile.getMediaId() == null || !profile.getMediaId().equals(mediaId)) continue;
            return profile.getUserId();
        }
        RLog.e((String)TAG, (String)("getUserIdByMediaId : [mediaId " + mediaId + "-> userId : null]"));
        return null;
    }

    private RongCallCommon.CallDisconnectedReason transferRemoteReason(RongCallCommon.CallDisconnectedReason reason) {
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.CANCEL)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_CANCEL;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.REJECT)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_REJECT;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.HANGUP)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_HANGUP;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.BUSY_LINE)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_BUSY_LINE;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.NO_RESPONSE)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_NO_RESPONSE;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_ENGINE_UNSUPPORTED;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED)) {
            return RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED;
        }
        return RongCallCommon.CallDisconnectedReason.NETWORK_ERROR;
    }

    RongCallCommon.CallDisconnectedReason transferRemoteReason(RongCallCommon.CallDisconnectedReason reason, boolean isSelfHandle) {
        RLog.d((String)TAG, (String)("reason : " + (Object)((Object)reason) + " ,isSelf = " + isSelfHandle));
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.CANCEL)) {
            if (isSelfHandle) {
                return RongCallCommon.CallDisconnectedReason.CANCEL;
            }
            return RongCallCommon.CallDisconnectedReason.REMOTE_CANCEL;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.REJECT)) {
            if (isSelfHandle) {
                return RongCallCommon.CallDisconnectedReason.REJECT;
            }
            return RongCallCommon.CallDisconnectedReason.REMOTE_REJECT;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.HANGUP)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_HANGUP;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.BUSY_LINE)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_BUSY_LINE;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.NO_RESPONSE)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_NO_RESPONSE;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED)) {
            return RongCallCommon.CallDisconnectedReason.REMOTE_ENGINE_UNSUPPORTED;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.REMOTE_NO_RESPONSE)) {
            if (isSelfHandle) {
                return RongCallCommon.CallDisconnectedReason.REMOTE_NO_RESPONSE;
            }
            return RongCallCommon.CallDisconnectedReason.NO_RESPONSE;
        }
        if (reason.equals((Object)RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED)) {
            return RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED;
        }
        return RongCallCommon.CallDisconnectedReason.NETWORK_ERROR;
    }

    void switchCamera() {
        this.startCameraCapture(-1, false, null);
        if (this.voIPEngine != null) {
            this.voIPEngine.switchCamera();
        }
    }

    void switchCamera(int cameraId, boolean mirror, CameraSwitchCallBack callBack) {
        if (this.voIPEngine != null) {
            this.voIPEngine.switchCamera(cameraId, mirror, callBack);
        }
    }

    void startCameraCapture(int cameraId, boolean mirror, StartCameraCallback callback) {
        this.cameraId = cameraId;
        this.mirror = mirror;
        this.startCameraCallback = callback;
        RLog.i((String)TAG, (String)("startCameraCapture()->  id :" + cameraId + " , mirror :" + mirror));
    }

    void setEnableLocalVideo(boolean enabled) {
        if (this.voIPEngine != null) {
            this.voIPEngine.muteLocalVideoStream(!enabled);
        }
    }

    void setCameraOrientation(int cameraDisplayOrientation, int frameOrientation) {
        if (this.voIPEngine != null) {
            this.voIPEngine.setCameraOrientation(cameraDisplayOrientation, frameOrientation);
        } else {
            this.cameraDisplayOrientation = cameraDisplayOrientation;
            this.frameOrientation = frameOrientation;
        }
    }

    void setEnableLocalAudio(boolean enabled) {
        if (this.voIPEngine != null) {
            this.voIPEngine.muteLocalAudioStream(!enabled);
        } else {
            RLog.e((String)TAG, (String)"muteMicre error .voIPEngine = null .");
        }
    }

    void setEnableRemoteAudio(String userId, boolean enabled) {
        if (this.voIPEngine != null && userId != null) {
            this.voIPEngine.muteRemoteAudioStream(userId, !enabled);
        }
    }

    void setEnableAllRemoteAudio(boolean enabled) {
        if (this.voIPEngine != null) {
            this.voIPEngine.muteAllRemoteAudioStreams(!enabled);
        }
    }

    void setEnableRemoteVideo(String userId, boolean enabled) {
        if (this.voIPEngine != null && userId != null) {
            this.voIPEngine.muteRemoteVideoStream(userId, !enabled);
        }
    }

    void setEnableAllRemoteVideo(boolean enabled) {
        if (this.voIPEngine != null) {
            this.voIPEngine.muteAllRemoteVideoStreams(!enabled);
        }
    }

    void setEnableSpeakerphone(boolean enabled) {
        if (this.voIPEngine != null) {
            this.voIPEngine.setEnableSpeakerphone(enabled);
        }
    }

    void setSpeakerPhoneVolume(int level) {
        if (this.voIPEngine != null) {
            this.voIPEngine.setSpeakerphoneVolume(level);
        }
    }

    void switchVideo(String from, String to) {
        String fromMediaId = this.getMediaIdByUserId(from);
        String toMediaId = this.getMediaIdByUserId(to);
        if (this.voIPEngine != null && fromMediaId != null && toMediaId != null) {
            this.voIPEngine.switchView(fromMediaId, toMediaId);
        }
    }

    void setAudioOnly(boolean isAudioOnly) {
        if (this.voIPEngine != null) {
            this.voIPEngine.setAudioOnly(isAudioOnly);
        }
    }

    void startCapture() {
        if (this.voIPEngine != null) {
            this.voIPEngine.startCapture();
        }
    }

    public void setRTCConfig(RCRTCConfig.Builder builder) {
        this.mBuilder = builder;
    }

    public void setVideoConfig(RCRTCVideoStreamConfig.Builder builder) {
        this.mVCBuilder = builder;
    }

    public void setAudioConfig(RCRTCAudioStreamConfig.Builder builder) {
        this.mACBuilder = builder;
    }

    void registerVideoFrameListener(final IVideoFrameListener listener) {
        if (this.voIPEngine != null && listener != null) {
            this.voIPEngine.setVideoFrameListener(new ICallEngineVideoFrameListener(){

                @Override
                public CallVideoFrame processVideoFrame(CallVideoFrame videoFrame) {
                    return listener.processVideoFrame(videoFrame);
                }
            });
        } else {
            this.videoFrameListener = listener;
        }
    }

    void setLocalAudioPCMBufferListener(IRCRTCAudioDataListener listener) {
        if (this.voIPEngine != null) {
            this.voIPEngine.setLocalAudioPCMBufferListener(listener);
        } else {
            this.mLocalAudioPCMBufferListener = listener;
            RLog.e((String)TAG, (String)("setLocalAudioPCMBufferListener voIPEngine :" + this.voIPEngine + " ,listener : " + listener));
        }
    }

    void unregisterVideoFrameListener() {
        if (this.voIPEngine != null) {
            this.voIPEngine.setVideoFrameListener(null);
        }
        this.videoFrameListener = null;
    }

    void setLocalRenderMode(int mode) {
        if (this.voIPEngine != null) {
            this.voIPEngine.setLocalRenderMode(mode);
        }
    }

    void setRemoteRenderMode(String uid, int mode) {
        if (this.voIPEngine != null) {
            this.voIPEngine.setRemoteRenderMode(uid, mode);
        }
    }

    void requestWhiteBoard() {
        if (this.voIPEngine != null) {
            this.voIPEngine.requestWhiteBoard();
        }
    }

    void answerUpgradeObserverToNormalUser(String userID, boolean isOK) {
        if (this.voIPEngine != null) {
            this.voIPEngine.answerUpgradeObserverToNormalUser(userID, isOK);
        }
    }

    void answerHostControlUserDevice(String userID, int dType, boolean isOpen, boolean isAccept) {
        if (this.voIPEngine != null) {
            this.voIPEngine.answerHostControlUserDevice(userID, dType, isOpen, isAccept);
        }
    }

    void setEnableBeauty(boolean enable) {
        this.enableBeauty = enable;
    }

    void startAudiosRecording(String filePath) {
        if (this.voIPEngine != null) {
            this.voIPEngine.startAudioRecording(filePath);
        }
    }

    private boolean checkPermissionStatus(RongCallCommon.CallMediaType mediaType) {
        boolean camera = this.context.checkCallingOrSelfPermission("android.permission.CAMERA") == 0;
        boolean audio = this.context.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") == 0;
        boolean needCheckPermissions = false;
        RLog.d((String)TAG, (String)("camera permission : " + camera + ", audio permission : " + audio));
        if (mediaType.equals((Object)RongCallCommon.CallMediaType.AUDIO) && !audio) {
            needCheckPermissions = true;
        }
        if (!(!mediaType.equals((Object)RongCallCommon.CallMediaType.VIDEO) || camera && audio)) {
            needCheckPermissions = true;
        }
        return needCheckPermissions;
    }

    private void registerCallReceiver() {
        this.callReceiver = new CallReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.NEW_OUTGOING_CALL");
        filter.addAction("android.intent.action.PHONE_STATE");
        this.context.registerReceiver((BroadcastReceiver)this.callReceiver, filter);
    }

    public void updateAllParticipantVideo() {
        if (this.voIPEngine == null) {
            return;
        }
        List<CallUserProfile> userStatusList = this.callSessionImp.getParticipantProfileList();
        if (userStatusList != null && userStatusList.size() != 0) {
            for (CallUserProfile userStatus : userStatusList) {
                if (userStatus.getUserId().equals(this.callSessionImp.getSelfUserId())) {
                    SurfaceView localVideo = this.voIPEngine.createRendererView(this.context);
                    this.voIPEngine.setupLocalVideo(localVideo);
                    userStatus.setVideoView(localVideo);
                    continue;
                }
                userStatus.setVideoView(this.setupRemoteVideo(userStatus.getUserId() + this.RTC_TAG));
            }
        }
    }

    public boolean isVoIPEnabled(Context context) {
        try {
            String info = this.libStub.getVoIPCallInfo();
            if (TextUtils.isEmpty((CharSequence)info)) {
                this.getCallListener().onError(RongCallCommon.CallErrorCode.ENGINE_NOT_FOUND);
                RLog.e((String)TAG, (String)"The opened audio and video service did not take effect in time or the audio and video service was closed. \n Please wait 3-5 hours to reinstall the application or open the audio and video service before testing.");
                return false;
            }
            JSONObject jsonObject = new JSONObject(info);
            int strategy = jsonObject.getInt("strategy");
            if (strategy == 0) {
                RLog.e((String)TAG, (String)"VoIP call is not granted by navi data.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void publishMediaResourceSuccess(String userId) {
        RLog.e((String)TAG, (String)("publishMediaResourceSuccess userId :" + userId));
        if (this.callSessionImp != null) {
            if (this.callSessionImp.getobserverUserList() != null && this.callSessionImp.getobserverUserList().size() > 0) {
                this.callSessionImp.getobserverUserList().remove(userId);
            }
            if (this.callSessionImp.getParticipantProfileList() != null && this.callSessionImp.getParticipantProfileList().size() > 0) {
                for (int i = 0; i < this.callSessionImp.getParticipantProfileList().size(); ++i) {
                    if (!this.callSessionImp.getParticipantProfileList().get(i).getUserId().equals(userId)) continue;
                    this.callSessionImp.getParticipantProfileList().get(i).setUserType(RongCallCommon.CallUserType.NORMAL);
                    break;
                }
            }
        } else {
            RLog.e((String)TAG, (String)"publishSuccess callSessionImp error.");
        }
    }

    void publishMediaResource(RongCallCommon.CallMediaType callMediaType) {
        if (this.voIPEngine != null) {
            this.voIPEngine.publishMediaResource(callMediaType == null ? RongCallCommon.CallMediaType.VIDEO.getValue() : callMediaType.getValue(), new IMediaResourceListener(){

                @Override
                public void onUiSuccess() {
                    if (RongCallManager.this.callSessionImp != null) {
                        RongCallManager.this.callSessionImp.setUserType(RongCallCommon.CallUserType.NORMAL);
                    }
                    RongCallManager.this.publishMediaResourceSuccess(RongIMClient.getInstance().getCurrentUserId());
                    RLog.i((String)TAG, (String)"publishMediaResource onUiSuccess ! ");
                }

                @Override
                public void onUiFailed(String reason) {
                    RLog.e((String)TAG, (String)("publishMediaResource onUiFailed \uff1a" + reason));
                }
            });
        }
    }

    void publishCustomVideoStream(String tag, PublishCallBack callBack) {
        if (this.voIPEngine != null) {
            this.voIPEngine.publishCustomVideoStream(tag, callBack);
        } else {
            RLog.e((String)TAG, (String)"publishCustomVideoStream voIPEngine = null.");
        }
    }

    void unpublishCustomVideoStream(RCRTCOutputStream outputStream, IRCRTCResultCallback callBack) {
        if (this.voIPEngine != null) {
            this.voIPEngine.unpublishCustomVideoStream(outputStream, callBack);
        } else {
            RLog.e((String)TAG, (String)"unpublishCustomVideoStream voIPEngine = null.");
        }
    }

    private RongCallSession makeBusyLineCallSession(io.rong.imlib.model.Message message) {
        if (message == null || message.getContent() == null) {
            return null;
        }
        if (message.getContent() instanceof CallInviteMessage) {
            CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
            RongCallSession callSession = new RongCallSession();
            callSession.setCallId(inviteMessage.getCallId());
            callSession.setMediaType(inviteMessage.getMediaType());
            callSession.setEngineType(inviteMessage.getEngineType());
            callSession.setObserverUserList(inviteMessage.getObserverUserIds());
            if (inviteMessage.isUseSignalServer()) {
                callSession.setConversationType(Conversation.ConversationType.NONE);
            } else {
                callSession.setTargetId(message.getTargetId());
                callSession.setConversationType(message.getConversationType());
            }
            callSession.setCallerUserId(message.getSenderUserId());
            callSession.setInviterUserId(message.getSenderUserId());
            callSession.setSelfUserId(this.getMyUserId());
            callSession.setExtra(inviteMessage.getExtra());
            ArrayList<CallUserProfile> participantProfileList = new ArrayList<CallUserProfile>();
            CallUserProfile profile = new CallUserProfile();
            profile.setUserId(message.getSenderUserId());
            profile.setCallStatus(RongCallCommon.CallStatus.IDLE);
            String mediaId = this.getMediaId(message);
            profile.setMediaId(mediaId);
            profile.setMediaType(inviteMessage.getMediaType());
            if (inviteMessage.getObserverUserIds() != null) {
                profile.setUserType(inviteMessage.getObserverUserIds().contains(message.getSenderUserId()) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
            }
            participantProfileList.add(profile);
            for (String userId : inviteMessage.getInviteUserIds()) {
                profile = new CallUserProfile();
                profile.setUserId(userId);
                profile.setMediaType(inviteMessage.getMediaType());
                profile.setCallStatus(RongCallCommon.CallStatus.IDLE);
                if (inviteMessage.getObserverUserIds() != null) {
                    profile.setUserType(inviteMessage.getObserverUserIds().contains(userId) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
                }
                participantProfileList.add(profile);
            }
            callSession.setParticipantUserList(participantProfileList);
            callSession.setUserType(RongCallCommon.CallUserType.NORMAL);
            if (callSession.getObserverUserList() != null && callSession.getObserverUserList().size() > 0) {
                for (String id : callSession.getObserverUserList()) {
                    if (!id.equals(callSession.getSelfUserId())) continue;
                    callSession.setUserType(RongCallCommon.CallUserType.OBSERVER);
                    break;
                }
            }
            return callSession;
        }
        if (message.getContent() instanceof CallModifyMemberMessage) {
            CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
            RongCallSession callSession = new RongCallSession();
            callSession.setCallId(modifyMemberMessage.getCallId());
            if (modifyMemberMessage.isUseSignalServer()) {
                callSession.setConversationType(Conversation.ConversationType.NONE);
            } else {
                callSession.setTargetId(message.getTargetId());
                callSession.setConversationType(message.getConversationType());
            }
            callSession.setCallerUserId(message.getSenderUserId());
            callSession.setInviterUserId(message.getSenderUserId());
            callSession.setObserverUserList(modifyMemberMessage.getObserverList());
            callSession.setSelfUserId(this.getMyUserId());
            callSession.setMediaType(modifyMemberMessage.getMediaType());
            callSession.setEngineType(modifyMemberMessage.getEngineType());
            callSession.setExtra(modifyMemberMessage.getExtra());
            callSession.setUserType(modifyMemberMessage.getObserverList().contains(this.getMyUserId()) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
            List<CallUserProfile> tmpParticipantList = modifyMemberMessage.getParticipantList();
            CallUserProfile tmpCallUserProfile = null;
            for (int i = 0; i < tmpParticipantList.size(); ++i) {
                tmpCallUserProfile = tmpParticipantList.get(i);
                if (tmpCallUserProfile != null && modifyMemberMessage.getObserverList() != null && modifyMemberMessage.getObserverList().contains(tmpCallUserProfile.getUserId())) {
                    tmpParticipantList.get(i).setUserType(RongCallCommon.CallUserType.OBSERVER);
                    continue;
                }
                tmpParticipantList.get(i).setUserType(RongCallCommon.CallUserType.NORMAL);
            }
            List<String> userList = modifyMemberMessage.getInvitedList();
            for (String id : userList) {
                CallUserProfile profile = new CallUserProfile();
                profile.setUserId(id);
                profile.setMediaType(callSession.getMediaType());
                profile.setCallStatus(RongCallCommon.CallStatus.IDLE);
                if (null != modifyMemberMessage.getObserverList()) {
                    profile.setUserType(modifyMemberMessage.getObserverList().contains(id) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL);
                } else {
                    profile.setUserType(RongCallCommon.CallUserType.NORMAL);
                }
                tmpParticipantList.add(profile);
            }
            callSession.setParticipantUserList(tmpParticipantList);
            return callSession;
        }
        return null;
    }

    boolean isOngoingCallSession(String callId) {
        if (this.callSessionImp == null || TextUtils.isEmpty((CharSequence)callId)) {
            return false;
        }
        return callId.equals(this.callSessionImp.getCallId());
    }

    public boolean canCallContinued(String callId) {
        return TextUtils.isEmpty((CharSequence)this.alreadyHangupCallId) || !this.alreadyHangupCallId.equals(callId);
    }

    String getRoomId() {
        if (this.callSessionImp != null) {
            return this.callSessionImp.getCallId();
        }
        return "";
    }

    static void setPushConfig(MessagePushConfig start, MessagePushConfig hangup) {
        startPushConfig = start;
        hangupPushConfig = hangup;
    }

    private class DisconnectingState
    extends State {
        private DisconnectingState() {
        }

        public void enter() {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] enter"));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE, "state", this.getName());
            Bundle bundle = null;
            if (RongCallManager.this.getCurrentMessage() != null) {
                bundle = RongCallManager.this.getCurrentMessage().getData();
            }
            if (RongCallManager.this.callSessionImp != null) {
                RongCallManager.this.alreadyHangupCallId = RongCallManager.this.callSessionImp.getCallId();
            }
            if (RongCallManager.this.voIPEngine != null) {
                int tmpVal = 0;
                if (bundle != null) {
                    tmpVal = bundle.getInt(RongCallManager.HANG_UP_KEY);
                } else {
                    RLog.e((String)TAG, (String)"DisconnectingState->enter bundle ==null.");
                }
                RongCallManager.this.voIPEngine.leaveChannel(tmpVal);
                if (RongCallManager.this.callSessionImp != null && RongCallManager.this.callSessionImp.getMediaType().equals((Object)RongCallCommon.CallMediaType.VIDEO)) {
                    RongCallManager.this.voIPEngine.stopPreview();
                }
            } else {
                RLog.e((String)TAG, (String)"DisconnectingState->enter()->voIPEngine = null.");
                RongCallSession callInfo = new RongCallSession();
                Message message = Message.obtain();
                message.what = 202;
                message.obj = callInfo;
                message.setData(bundle);
                this.processMessage(message);
            }
            RongCallManager.this.resetTimer();
        }

        public boolean processMessage(Message msg) {
            int msgWhat = msg.what;
            if (msgWhat != 302 && msgWhat != 303 && msgWhat != 212 && msgWhat != 211) {
                ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE_EVENT, "state|event", this.getName(), ReportUtil.eventToString(msg.what));
                RLog.d((String)TAG, (String)("[" + this.getName() + "] processMessage : " + msgWhat));
            }
            Bundle bundle = msg.getData();
            switch (msgWhat) {
                case 402: {
                    break;
                }
                case 109: 
                case 204: 
                case 206: 
                case 211: 
                case 212: 
                case 302: 
                case 303: {
                    break;
                }
                case 202: 
                case 404: 
                case 405: {
                    RongCallManager.this.alreadyHangupCallId = "";
                    RongCallManager.this.stopEngine();
                    if (bundle != null) {
                        int tmpVal = bundle.getInt(RongCallManager.HANG_UP_KEY);
                        RongCallCommon.CallDisconnectedReason reason = RongCallCommon.CallDisconnectedReason.valueOf(tmpVal);
                        if (reason == null) {
                            RLog.e((String)TAG, (String)"EVENT_CALLSESSION_FREE , reason ==null !");
                            reason = RongCallCommon.CallDisconnectedReason.HANGUP;
                        }
                        RLog.d((String)TAG, (String)("onCallDisconnected :" + (Object)((Object)reason)));
                        RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), reason);
                    }
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                case 406: {
                    RongCallManager.this.stopEngine();
                    RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                default: {
                    RongCallManager.this.stopEngine();
                    if (bundle != null) {
                        int tmpVal = bundle.getInt(RongCallManager.HANG_UP_KEY);
                        RongCallCommon.CallDisconnectedReason reason = RongCallCommon.CallDisconnectedReason.valueOf(tmpVal);
                        if (reason == null) {
                            RLog.e((String)TAG, (String)"default--EVENT_CALLSESSION_FREE , reason ==null !");
                            reason = RongCallCommon.CallDisconnectedReason.HANGUP;
                        }
                        RLog.d((String)TAG, (String)("default--onCallDisconnected :" + (Object)((Object)reason)));
                        RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), reason);
                    }
                    RongCallManager.this.deferMessage(msg);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                }
            }
            return true;
        }
    }

    private class ConnectedState
    extends State {
        private ConnectedState() {
        }

        public void enter() {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] enter"));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE, "state", this.getName());
            RongCallManager.this.callSessionImp.setActiveTime(System.currentTimeMillis());
        }

        public boolean processMessage(Message msg) {
            int msgWhat = msg.what;
            if (msgWhat != 302 && msgWhat != 303 && msgWhat != 212 && msgWhat != 211) {
                ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE_EVENT, "state|event", this.getName(), ReportUtil.eventToString(msg.what));
                RLog.d((String)TAG, (String)("[" + this.getName() + "] processMessage : " + msgWhat));
            }
            switch (msgWhat) {
                case 208: {
                    String muteId = (String)msg.obj;
                    boolean muted = msg.arg1 == 0;
                    RongCallManager.this.getCallListener().onRemoteCameraDisabled(muteId, muted);
                    break;
                }
                case 210: {
                    RongCallManager.this.getCallListener().onRemoteMicrophoneDisabled((String)msg.obj, msg.arg1 == 1);
                    break;
                }
                case 103: {
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.HANGUP, null);
                    RLog.d((String)TAG, (String)("ConnectedState EVENT_HANG_UP callListener = " + RongCallManager.this.callListener));
                    RongCallManager.this.callSessionImp.setEndTime(System.currentTimeMillis());
                    Bundle bundle_hangUp = new Bundle();
                    bundle_hangUp.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.HANGUP.getValue());
                    msg.setData(bundle_hangUp);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 104: {
                    Bundle bundle = msg.getData();
                    final ArrayList newUserList = bundle.getStringArrayList("userIds");
                    final ArrayList observerUserIds = bundle.getStringArrayList("observerUserIds");
                    RongCallManager.this.sendModifyMemberMessage(newUserList, observerUserIds, new SignalCallback(){

                        @Override
                        public void onError() {
                            for (String userId : newUserList) {
                                RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                            }
                        }

                        @Override
                        public void onSuccess(String userId, String mediaId) {
                            for (String id : newUserList) {
                                RongCallManager.this.updateParticipantCallStatus(id, RongCallCommon.CallStatus.INCOMING);
                                RongCallManager.this.setupTimerTask(id, 402, 60000);
                                if (observerUserIds != null && observerUserIds.contains(id)) {
                                    if (RongCallManager.this.callSessionImp.getobserverUserList() != null) {
                                        if (!RongCallManager.this.callSessionImp.getobserverUserList().contains(id)) {
                                            RongCallManager.this.callSessionImp.getobserverUserList().add(id);
                                        }
                                    } else {
                                        ArrayList<String> list = new ArrayList<String>();
                                        list.add(id);
                                        RongCallManager.this.callSessionImp.setObserverUserList(list);
                                    }
                                }
                                RongCallManager.this.getCallListener().onRemoteUserInvited(id, RongCallManager.this.callSessionImp.getMediaType());
                            }
                        }
                    });
                    break;
                }
                case 402: {
                    String userId = (String)msg.obj;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                    if (RongCallManager.this.shouldTerminateCall(userId)) {
                        RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.REMOTE_NO_RESPONSE, null);
                        Bundle bundle = new Bundle();
                        bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.REMOTE_NO_RESPONSE.getValue());
                        msg.setData(bundle);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                        break;
                    }
                    if (RongCallManager.this.timerTasks != null) {
                        RLog.e((String)TAG, (String)("onRemoteUserLeft->>>timerTasks size:" + RongCallManager.this.timerTasks.size() + " ,userId :" + userId));
                    }
                    RongCallManager.this.cancelTimerTask(userId);
                    RongCallManager.this.getCallListener().onRemoteUserLeft(userId, RongCallCommon.CallDisconnectedReason.NO_RESPONSE);
                    break;
                }
                case 207: {
                    RongCallCommon.CallMediaType type = (RongCallCommon.CallMediaType)((Object)msg.obj);
                    if (type.equals((Object)RongCallManager.this.callSessionImp.getMediaType())) break;
                    RongCallManager.this.changeEngineMediaType(RongCallManager.this.callSessionImp.getSelfUserId(), type);
                    RongCallManager.this.sendChangeMediaTypeMessage(type);
                    break;
                }
                case 105: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
                    boolean isInvited = false;
                    for (String newUserId : inviteMessage.getInviteUserIds()) {
                        if (!RongCallManager.this.callSessionImp.getSelfUserId().equals(newUserId)) continue;
                        isInvited = true;
                        break;
                    }
                    if (!isInvited) break;
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(inviteMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 107: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
                    if (modifyMemberMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) {
                        for (String id : modifyMemberMessage.getInvitedList()) {
                            if (RongCallManager.this.callSessionImp.getParticipantUserList().contains(id)) {
                                RLog.e((String)TAG, (String)("The list of participants already exists. userid :" + id));
                                continue;
                            }
                            CallUserProfile profile = new CallUserProfile();
                            profile.setUserId(id);
                            profile.setMediaType(modifyMemberMessage.getMediaType());
                            profile.setCallStatus(RongCallCommon.CallStatus.INCOMING);
                            RongCallManager.this.setupTimerTask(id, 402, 60000);
                            if (modifyMemberMessage.getObserverList() != null && modifyMemberMessage.getObserverList().contains(id)) {
                                profile.setUserType(RongCallCommon.CallUserType.OBSERVER);
                                if (RongCallManager.this.callSessionImp.getobserverUserList() != null) {
                                    if (!RongCallManager.this.callSessionImp.getobserverUserList().contains(id)) {
                                        RongCallManager.this.callSessionImp.getobserverUserList().add(id);
                                    }
                                } else {
                                    ArrayList<String> list = new ArrayList<String>();
                                    list.add(id);
                                    RongCallManager.this.callSessionImp.setObserverUserList(list);
                                }
                            } else {
                                profile.setUserType(RongCallCommon.CallUserType.NORMAL);
                            }
                            RongCallManager.this.callSessionImp.getParticipantProfileList().add(profile);
                            RongCallManager.this.getCallListener().onRemoteUserInvited(id, modifyMemberMessage.getMediaType());
                        }
                        break;
                    }
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(modifyMemberMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 109: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallHangupMessage hangupMessage = (CallHangupMessage)message.getContent();
                    RongCallCommon.CallDisconnectedReason reason = hangupMessage.getHangupReason();
                    reason = RongCallManager.this.transferRemoteReason(reason);
                    if (!hangupMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) break;
                    String userId = message.getSenderUserId();
                    RongCallManager.this.cancelTimerTask(userId);
                    boolean result = RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                    if (result) {
                        if (RongCallManager.this.shouldTerminateCall(userId)) {
                            RongCallManager.this.callSessionImp.setEndTime(System.currentTimeMillis());
                            RongCallManager.this.callSessionImp.setPushConfig(message.getMessagePushConfig());
                            Bundle bundle = new Bundle();
                            bundle.putInt(RongCallManager.HANG_UP_KEY, reason.getValue());
                            msg.setData(bundle);
                            RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                            break;
                        }
                        RongCallManager.this.getCallListener().onRemoteUserLeft(userId, reason);
                        break;
                    }
                    RLog.e((String)TAG, (String)("user : " + userId + " had been deleted when RECEIVED_LEAVE_CHANNEL_ACTION"));
                    break;
                }
                case 110: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallModifyMediaMessage changeMediaTypeMessage = (CallModifyMediaMessage)message.getContent();
                    if (Conversation.ConversationType.GROUP.equals((Object)RongCallManager.this.callSessionImp.getConversationType()) || !changeMediaTypeMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) break;
                    RongCallCommon.CallMediaType mediaType = changeMediaTypeMessage.getMediaType();
                    RongCallManager.this.changeEngineMediaType(message.getSenderUserId(), mediaType);
                    break;
                }
                case 203: {
                    String userId = (String)msg.obj;
                    int userType = msg.arg1;
                    int methodIdentification = msg.arg2;
                    RongCallSession rongCallSession = RongCallManager.this.getCallSession();
                    if (rongCallSession != null) {
                        List<String> observerUserList = rongCallSession.getObserverUserList();
                        if (methodIdentification == 2) {
                            if (observerUserList != null && observerUserList.contains(userId)) {
                                RLog.e((String)TAG, (String)"observer signaling join room.");
                                userType = 2;
                            } else if (rongCallSession.getMediaType() != RongCallCommon.CallMediaType.AUDIO) {
                                RLog.e((String)TAG, (String)"normal person signaling join room.");
                                break;
                            }
                        } else if (methodIdentification == 1 && observerUserList != null && observerUserList.contains(userId)) {
                            RLog.e((String)TAG, (String)("onRemoteUserJoined observer upgrade. userType \uff1a" + userType));
                            RongCallManager.this.publishMediaResourceSuccess(userId);
                        }
                    }
                    if (!TextUtils.isEmpty((CharSequence)userId)) {
                        RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.CONNECTED);
                        RongCallManager.this.cancelTimerTask(userId);
                        SurfaceView remoteVideo = null;
                        RongCallCommon.CallMediaType mediaType = RongCallManager.this.callSessionImp.getMediaType();
                        if (mediaType != null && mediaType.equals((Object)RongCallCommon.CallMediaType.VIDEO)) {
                            remoteVideo = RongCallManager.this.setupRemoteVideo(userId + RongCallManager.this.RTC_TAG);
                            RongCallManager.this.updateParticipantVideo(userId, remoteVideo);
                        }
                        List<CallUserProfile> userProfileList = RongCallManager.this.callSessionImp.getParticipantProfileList();
                        boolean contain = false;
                        for (CallUserProfile userProfile : userProfileList) {
                            if (!TextUtils.equals((CharSequence)userId, (CharSequence)userProfile.getUserId())) continue;
                            contain = true;
                        }
                        if (!contain) {
                            CallUserProfile userProfile = new CallUserProfile();
                            userProfile.setUserId(userId);
                            userProfile.setMediaType(mediaType);
                            userProfile.setUserType(RongCallCommon.CallUserType.valueOf(userType));
                            userProfile.setCallStatus(RongCallCommon.CallStatus.CONNECTED);
                            userProfileList.add(userProfile);
                        }
                        RLog.e((String)TAG, (String)"ConnectedState.onRemoteUserJoined()");
                        RongCallManager.this.getCallListener().onRemoteUserJoined(userId, mediaType, userType, remoteVideo);
                        break;
                    }
                    RLog.e((String)TAG, (String)("can not find userId as " + msg.obj + ", cache it."));
                    RongCallManager.this.unknownMediaIdList.add((String)msg.obj);
                    break;
                }
                case 204: {
                    String userId = (String)msg.obj;
                    if (userId != null) {
                        boolean result = RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                        if (RongCallManager.this.shouldTerminateCall(userId)) {
                            RongCallManager.this.callSessionImp.setEndTime(System.currentTimeMillis());
                            Bundle bundle = new Bundle();
                            bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.REMOTE_HANGUP.getValue());
                            msg.setData(bundle);
                            RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                            break;
                        }
                        if (!result) break;
                        RongCallManager.this.cancelTimerTask(userId);
                        RongCallManager.this.getCallListener().onRemoteUserLeft(userId, RongCallCommon.CallDisconnectedReason.HANGUP);
                        break;
                    }
                    RLog.e((String)TAG, (String)("media : " + msg.obj + " had been deleted when RECEIVED_HANG_UP_MSG"));
                    break;
                }
                case 108: {
                    String userId = (String)msg.obj;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.RINGING);
                    RongCallManager.this.getCallListener().onRemoteUserRinging(userId);
                    break;
                }
                case 106: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String userId = message.getSenderUserId();
                    RongCallManager.this.updateMediaId(message.getSenderUserId(), userId);
                    if (RongCallManager.this.unknownMediaIdList.size() <= 0 || !RongCallManager.this.unknownMediaIdList.contains(userId)) break;
                    RLog.e((String)TAG, (String)("handle cached mediaId : " + userId));
                    RongCallManager.this.updateParticipantCallStatus(message.getSenderUserId(), RongCallCommon.CallStatus.CONNECTED);
                    RongCallManager.this.cancelTimerTask(message.getSenderUserId());
                    SurfaceView remoteVideo = null;
                    RongCallCommon.CallMediaType mediaType = RongCallManager.this.callSessionImp.getMediaType();
                    if (mediaType != null && mediaType.equals((Object)RongCallCommon.CallMediaType.VIDEO)) {
                        remoteVideo = RongCallManager.this.setupRemoteVideo(message.getSenderUserId() + RongCallManager.this.RTC_TAG);
                        RongCallManager.this.updateParticipantVideo(message.getSenderUserId(), remoteVideo);
                    }
                    RongCallManager.this.getCallListener().onRemoteUserJoined(message.getSenderUserId(), mediaType, 1, remoteVideo);
                    RongCallManager.this.unknownMediaIdList.remove(userId);
                    break;
                }
                case 213: {
                    Bundle data = msg.getData();
                    String userId = data.getString("userId");
                    String tag = data.getString("tag");
                    String streamId = data.getString("streamId");
                    SurfaceView remoteVideo = RongCallManager.this.setupRemoteVideo(streamId);
                    CallSessionImp csImp = RongCallManager.this.callSessionImp;
                    if (csImp != null) {
                        for (CallUserProfile userProfile : csImp.getParticipantProfileList()) {
                            if (!TextUtils.equals((CharSequence)userId, (CharSequence)userProfile.getUserId())) continue;
                            StreamProfile streamProfile = new StreamProfile(userId, streamId, tag, remoteVideo);
                            userProfile.streamProfiles.add(streamProfile);
                            break;
                        }
                    }
                    RongCallManager.this.getCallListener().onRemoteUserPublishVideoStream(userId, streamId, tag, remoteVideo);
                    break;
                }
                case 214: {
                    Bundle data = msg.getData();
                    String userId = data.getString("userId");
                    String tag = data.getString("tag");
                    String streamId = data.getString("streamId");
                    CallSessionImp csImp = RongCallManager.this.callSessionImp;
                    if (csImp != null) {
                        block30: for (CallUserProfile userProfile : csImp.getParticipantProfileList()) {
                            if (!TextUtils.equals((CharSequence)userId, (CharSequence)userProfile.getUserId())) continue;
                            Iterator<StreamProfile> iterator = userProfile.streamProfiles.iterator();
                            while (iterator.hasNext()) {
                                StreamProfile streamProfile = iterator.next();
                                if (!TextUtils.equals((CharSequence)streamId, (CharSequence)streamProfile.streamId)) continue;
                                iterator.remove();
                                break block30;
                            }
                            break block30;
                        }
                    }
                    RongCallManager.this.getCallListener().onRemoteUserUnpublishVideoStream(userId, streamId, tag);
                    break;
                }
                case 302: {
                    RongCallManager.this.getCallListener().onNetworkSendLost(msg.arg1, msg.arg2);
                    break;
                }
                case 303: {
                    RongCallManager.this.getCallListener().onNetworkReceiveLost(String.valueOf(msg.obj), msg.arg1);
                    break;
                }
                case 209: {
                    String userId = String.valueOf(msg.obj);
                    RLog.i((String)TAG, (String)("onFirstRemoteVideoFrame : userid: " + userId));
                    for (CallUserProfile profile : RongCallManager.this.callSessionImp.getParticipantProfileList()) {
                        if (!TextUtils.equals((CharSequence)profile.getUserId(), (CharSequence)userId)) continue;
                        profile.setDrawed(true);
                        break;
                    }
                    RongCallManager.this.getCallListener().onFirstRemoteVideoFrame(userId, 0, 0);
                    break;
                }
                case 600: {
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.HANGUP.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 401: 
                case 403: {
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.NETWORK_ERROR.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 405: {
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.KICKED_BY_SERVER.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 211: {
                    String audioLevel = (String)msg.obj;
                    RongCallManager.this.getCallListener().onAudioLevelSend(audioLevel);
                    break;
                }
                case 212: {
                    HashMap audioLevels = (HashMap)msg.obj;
                    RongCallManager.this.getCallListener().onAudioLevelReceive(audioLevels);
                    break;
                }
            }
            return true;
        }
    }

    private class ConnectingState
    extends State {
        private ConnectingState() {
        }

        public void enter() {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] enter"));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE, "state", this.getName());
        }

        public boolean processMessage(Message msg) {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] processMessage : " + msg.what));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE_EVENT, "state|event", this.getName(), ReportUtil.eventToString(msg.what));
            switch (msg.what) {
                case 402: {
                    String userId = (String)msg.obj;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                    if (RongCallManager.this.shouldTerminateCall(userId)) {
                        RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.NO_RESPONSE, null);
                        Bundle bundle = new Bundle();
                        bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.NO_RESPONSE.getValue());
                        msg.setData(bundle);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                        break;
                    }
                    if (RongCallManager.this.timerTasks != null) {
                        RLog.e((String)TAG, (String)("ConnectingState onRemoteUserLeft->>>timerTasks size:" + RongCallManager.this.timerTasks.size() + " ,userId :" + userId));
                    }
                    RongCallManager.this.cancelTimerTask(userId);
                    RongCallManager.this.getCallListener().onRemoteUserLeft(userId, RongCallCommon.CallDisconnectedReason.NO_RESPONSE);
                    break;
                }
                case 105: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(inviteMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 107: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
                    if (modifyMemberMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) {
                        for (String id : modifyMemberMessage.getInvitedList()) {
                            if (RongCallManager.this.callSessionImp.getParticipantUserList().contains(id)) {
                                RLog.e((String)TAG, (String)("The list of participants already exists. userid :" + id));
                                continue;
                            }
                            CallUserProfile profile = new CallUserProfile();
                            profile.setUserId(id);
                            profile.setMediaType(modifyMemberMessage.getMediaType());
                            profile.setCallStatus(RongCallCommon.CallStatus.INCOMING);
                            if (modifyMemberMessage.getObserverList() != null && modifyMemberMessage.getObserverList().contains(id)) {
                                profile.setUserType(RongCallCommon.CallUserType.OBSERVER);
                                if (RongCallManager.this.callSessionImp.getobserverUserList() != null) {
                                    if (!RongCallManager.this.callSessionImp.getobserverUserList().contains(id)) {
                                        RongCallManager.this.callSessionImp.getobserverUserList().add(id);
                                    }
                                } else {
                                    ArrayList<String> list = new ArrayList<String>();
                                    list.add(id);
                                    RongCallManager.this.callSessionImp.setObserverUserList(list);
                                }
                            } else {
                                profile.setUserType(RongCallCommon.CallUserType.NORMAL);
                            }
                            RongCallManager.this.callSessionImp.getParticipantProfileList().add(profile);
                            RongCallManager.this.getCallListener().onRemoteUserInvited(id, modifyMemberMessage.getMediaType());
                        }
                        break;
                    }
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(modifyMemberMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 109: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallHangupMessage hangupMessage = (CallHangupMessage)message.getContent();
                    String userId = message.getSenderUserId();
                    RongCallCommon.CallDisconnectedReason reason = hangupMessage.getHangupReason();
                    reason = RongCallManager.this.transferRemoteReason(reason);
                    if (!hangupMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) break;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                    RongCallManager.this.cancelTimerTask(userId);
                    if (RongCallManager.this.shouldTerminateCall(userId)) {
                        Bundle bundle = new Bundle();
                        bundle.putInt(RongCallManager.HANG_UP_KEY, reason.getValue());
                        msg.setData(bundle);
                        RongCallManager.this.callSessionImp.setPushConfig(message.getMessagePushConfig());
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                        break;
                    }
                    RongCallManager.this.getCallListener().onRemoteUserLeft(userId, reason);
                    break;
                }
                case 205: {
                    Bundle bundle = msg.getData();
                    if (RongCallManager.this.callSessionImp != null) {
                        RongCallManager.this.updateMediaId(bundle.getString("userId"), bundle.getString("mediaId"));
                        RongCallManager.this.joinChannel(bundle.getString("userId"));
                        break;
                    }
                    RLog.e((String)TAG, (String)"EVENT_GET_VOIP_KEY_ACTION callSessionImp == null !");
                    break;
                }
                case 206: {
                    Bundle bundle = msg.getData();
                    if (RongCallManager.this.callSessionImp != null && bundle != null) {
                        RongCallManager.this.callSessionImp.setDynamicKey(bundle.getString("result"));
                        if (RongCallManager.this.callSessionImp.getUserType() != null) {
                            RongCallManager.this.voIPEngine.setUserType(RongCallManager.this.callSessionImp.getUserType().getValue());
                        } else {
                            RongCallManager.this.voIPEngine.setUserType(bundle.getInt("userType", 1));
                        }
                        Role role = TextUtils.equals((CharSequence)RongCallManager.this.callSessionImp.getCallerUserId(), (CharSequence)RongCallManager.this.getMyUserId()) ? Role.INVITER : Role.INVITEE;
                        RongCallManager.this.voIPEngine.joinChannel(bundle.getString("result"), RongCallManager.this.callSessionImp.getCallId(), bundle.getString("userId"), bundle.getString("userId"), role);
                        break;
                    }
                    RLog.e((String)TAG, (String)"EVENT_JOIN_CHANNEL_ACTION callSessionImp == null !");
                    break;
                }
                case 201: {
                    RongCallManager.this.cancelTimerTask(RongCallManager.this.callSessionImp.getSelfUserId());
                    String sessionId = (String)msg.obj;
                    RongCallManager.this.callSessionImp.setSessionId(sessionId);
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.CONNECTED);
                    RongCallCommon.CallMediaType mediaType = RongCallManager.this.callSessionImp.getMediaType();
                    SurfaceView localVideo = RongCallManager.this.callSessionImp.getLocalVideo();
                    if (mediaType != null && mediaType.equals((Object)RongCallCommon.CallMediaType.VIDEO) && localVideo == null) {
                        localVideo = RongCallManager.this.setupLocalVideo();
                        RongCallManager.this.callSessionImp.setLocalVideo(localVideo);
                    }
                    RongCallManager.this.registerCallReceiver();
                    RongCallManager.this.getCallListener().onCallConnected(RongCallManager.this.getCallSession(), localVideo);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mConnectedState);
                    break;
                }
                case 108: {
                    String userId = (String)msg.obj;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.RINGING);
                    RongCallManager.this.getCallListener().onRemoteUserRinging(userId);
                    break;
                }
                case 401: {
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.NETWORK_ERROR.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 403: {
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.NETWORK_ERROR.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.NETWORK_ERROR, null);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                case 405: {
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.KICKED_BY_SERVER.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.HANGUP, null);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                case 406: {
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.getCallListener().onError(RongCallCommon.CallErrorCode.ENGINE_NOT_FOUND);
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED, null);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 103: {
                    RLog.d((String)TAG, (String)("ConnectingState EVENT_HANG_UP callListener = " + RongCallManager.this.callListener));
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.HANGUP, null);
                    Bundle bundle_hangUp = new Bundle();
                    bundle_hangUp.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.HANGUP.getValue());
                    msg.setData(bundle_hangUp);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 203: {
                    RLog.e((String)TAG, (String)"Invitee joined room before inviter ! ");
                    RongCallManager.this.deferMessage(msg);
                    break;
                }
                case 106: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String mediaId = RongCallManager.this.getMediaId(message);
                    RongCallManager.this.updateMediaId(message.getSenderUserId(), mediaId);
                    break;
                }
                case 213: 
                case 214: {
                    RongCallManager.this.deferMessage(msg);
                    break;
                }
                case 104: {
                    Bundle bundleModifyMember = msg.getData();
                    final ArrayList newUserList = bundleModifyMember.getStringArrayList("userIds");
                    ArrayList observerUserIds = bundleModifyMember.getStringArrayList("observerUserIds");
                    RongCallManager.this.sendModifyMemberMessage(newUserList, observerUserIds, new SignalCallback(){

                        @Override
                        public void onError() {
                            for (String userId : newUserList) {
                                RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                                RLog.i((String)TAG, (String)("ConnectingState->EVENT_MODIFY_MEMBER->>userId :" + userId));
                                RongCallManager.this.cancelTimerTask(userId);
                                RongCallManager.this.getCallListener().onRemoteUserLeft(userId, RongCallCommon.CallDisconnectedReason.NETWORK_ERROR);
                            }
                        }

                        @Override
                        public void onSuccess(String userId, String mediaId) {
                            for (String id : newUserList) {
                                RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.INCOMING);
                                RongCallManager.this.setupTimerTask(id, 402, 60000);
                            }
                        }
                    });
                    break;
                }
            }
            return true;
        }
    }

    private class OutgoingState
    extends State {
        private OutgoingState() {
        }

        public void enter() {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] enter"));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE, "state", this.getName());
            if (!RongCallManager.this.startEngine()) {
                RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED);
                RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                return;
            }
            SurfaceView localVideo = RongCallManager.this.callSessionImp.getLocalVideo();
            if (RongCallManager.this.callSessionImp.getMediaType().equals((Object)RongCallCommon.CallMediaType.VIDEO) && localVideo == null) {
                localVideo = RongCallManager.this.setupLocalVideo();
                RongCallManager.this.callSessionImp.setLocalVideo(localVideo);
            }
            RongCallManager.this.getCallListener().onCallOutgoing(RongCallManager.this.getCallSession(), localVideo);
            RongCallManager.this.callSessionImp.setStartTime(System.currentTimeMillis());
        }

        public boolean processMessage(Message msg) {
            int msgWhat = msg.what;
            if (msgWhat != 302 && msgWhat != 303 && msgWhat != 212 && msgWhat != 211) {
                ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE_EVENT, "state|event", this.getName(), ReportUtil.eventToString(msg.what));
                RLog.d((String)TAG, (String)("[" + this.getName() + "] processMessage : " + msgWhat));
            }
            switch (msgWhat) {
                case 104: {
                    Bundle bundle = msg.getData();
                    final ArrayList newUserList = bundle.getStringArrayList("userIds");
                    ArrayList observerUserIds = bundle.getStringArrayList("observerUserIds");
                    RongCallManager.this.sendModifyMemberMessage(newUserList, observerUserIds, new SignalCallback(){

                        @Override
                        public void onError() {
                            for (String userId : newUserList) {
                                RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                                RongCallManager.this.cancelTimerTask(userId);
                                RongCallManager.this.getCallListener().onRemoteUserLeft(userId, RongCallCommon.CallDisconnectedReason.NETWORK_ERROR);
                            }
                        }

                        @Override
                        public void onSuccess(String userId, String mediaId) {
                            for (String id : newUserList) {
                                RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.INCOMING);
                                RongCallManager.this.setupTimerTask(id, 402, 60000);
                            }
                        }
                    });
                    break;
                }
                case 108: {
                    String userId = (String)msg.obj;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.RINGING);
                    RongCallManager.this.getCallListener().onRemoteUserRinging(userId);
                    break;
                }
                case 106: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String mediaId = RongCallManager.this.getMediaId(message);
                    RongCallManager.this.updateMediaId(message.getSenderUserId(), mediaId);
                    RongCallManager.this.joinChannel(RongCallManager.this.callSessionImp.getSelfUserId());
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mConnectingState);
                    break;
                }
                case 105: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
                    boolean isInvited = false;
                    for (String id : inviteMessage.getInviteUserIds()) {
                        if (!RongCallManager.this.callSessionImp.getSelfUserId().equals(id)) continue;
                        isInvited = true;
                        break;
                    }
                    if (!isInvited) break;
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(inviteMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 107: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
                    if (modifyMemberMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) {
                        for (String id : modifyMemberMessage.getInvitedList()) {
                            if (RongCallManager.this.callSessionImp.getParticipantUserList().contains(id)) {
                                RLog.e((String)TAG, (String)("The list of participants already exists. userid :" + id));
                                continue;
                            }
                            CallUserProfile profile = new CallUserProfile();
                            profile.setUserId(id);
                            profile.setMediaType(modifyMemberMessage.getMediaType());
                            profile.setCallStatus(RongCallCommon.CallStatus.INCOMING);
                            if (modifyMemberMessage.getObserverList() != null && modifyMemberMessage.getObserverList().contains(id)) {
                                profile.setUserType(RongCallCommon.CallUserType.OBSERVER);
                                if (RongCallManager.this.callSessionImp.getobserverUserList() != null) {
                                    if (!RongCallManager.this.callSessionImp.getobserverUserList().contains(id)) {
                                        RongCallManager.this.callSessionImp.getobserverUserList().add(id);
                                    }
                                } else {
                                    ArrayList<String> list = new ArrayList<String>();
                                    list.add(id);
                                    RongCallManager.this.callSessionImp.setObserverUserList(list);
                                }
                            } else {
                                profile.setUserType(RongCallCommon.CallUserType.NORMAL);
                            }
                            RongCallManager.this.callSessionImp.getParticipantProfileList().add(profile);
                            RongCallManager.this.getCallListener().onRemoteUserInvited(id, modifyMemberMessage.getMediaType());
                        }
                        break;
                    }
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(modifyMemberMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 402: {
                    String userId = (String)msg.obj;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                    if (RongCallManager.this.shouldTerminateCall(userId)) {
                        try {
                            RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.REMOTE_NO_RESPONSE, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Bundle bundle = new Bundle();
                        bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.REMOTE_NO_RESPONSE.getValue());
                        msg.setData(bundle);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                        break;
                    }
                    RongCallManager.this.cancelTimerTask(userId);
                    RongCallManager.this.getCallListener().onRemoteUserLeft(userId, RongCallCommon.CallDisconnectedReason.NO_RESPONSE);
                    break;
                }
                case 103: {
                    try {
                        RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.CANCEL, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    RLog.d((String)TAG, (String)("OutgoingState EVENT_HANG_UP callListener = " + RongCallManager.this.callListener));
                    Bundle bundle_hangUp = new Bundle();
                    bundle_hangUp.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.CANCEL.getValue());
                    msg.setData(bundle_hangUp);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 109: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallHangupMessage hangupMessage = (CallHangupMessage)message.getContent();
                    String userId = message.getSenderUserId();
                    RongCallCommon.CallDisconnectedReason reason = hangupMessage.getHangupReason();
                    reason = RongCallManager.this.transferRemoteReason(reason);
                    if (!hangupMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) break;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                    RongCallManager.this.cancelTimerTask(userId);
                    if (RongCallManager.this.shouldTerminateCall(userId)) {
                        Bundle bundle = new Bundle();
                        bundle.putInt(RongCallManager.HANG_UP_KEY, reason.getValue());
                        RongCallManager.this.callSessionImp.setPushConfig(message.getMessagePushConfig());
                        if (RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED.equals((Object)reason)) {
                            RongCallManager.this.getCallListener().onError(RongCallCommon.CallErrorCode.ENGINE_NOT_FOUND);
                        }
                        msg.setData(bundle);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                        break;
                    }
                    RongCallManager.this.getCallListener().onRemoteUserLeft(userId, hangupMessage.getHangupReason());
                    break;
                }
                case 401: 
                case 403: 
                case 404: 
                case 405: {
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.HANGUP, null);
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    Bundle bundle = new Bundle();
                    if (msg.what == 404) {
                        bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.INIT_VIDEO_ERROR.getValue());
                    } else if (msg.what == 405) {
                        bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.KICKED_BY_SERVER.getValue());
                    } else {
                        bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.NETWORK_ERROR.getValue());
                    }
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 600: {
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.HANGUP.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
            }
            return true;
        }
    }

    private class IncomingState
    extends State {
        private IncomingState() {
        }

        public void enter() {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] enter"));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE, "state", this.getName());
            RongCallManager.this.callSessionImp.setStartTime(System.currentTimeMillis());
        }

        public boolean processMessage(Message msg) {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] processMessage : " + msg.what));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE_EVENT, "state|event", this.getName(), ReportUtil.eventToString(msg.what));
            switch (msg.what) {
                case 102: {
                    if (!RongCallManager.this.startEngine()) {
                        boolean serviceOpened = true;
                        try {
                            String info = RongCallManager.this.libStub.getVoIPCallInfo();
                            if (TextUtils.isEmpty((CharSequence)info)) {
                                serviceOpened = false;
                            }
                        }
                        catch (Exception info) {
                            // empty catch block
                        }
                        RongCallCommon.CallDisconnectedReason reason = serviceOpened ? RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED : RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED;
                        RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), reason);
                        RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), reason, null);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                        break;
                    }
                    RongCallCommon.CallMediaType mediaType = RongCallManager.this.callSessionImp.getMediaType();
                    SurfaceView localVideo = RongCallManager.this.callSessionImp.getLocalVideo();
                    if (mediaType != null && mediaType.equals((Object)RongCallCommon.CallMediaType.VIDEO) && localVideo == null) {
                        localVideo = RongCallManager.this.setupLocalVideo();
                        RongCallManager.this.callSessionImp.setLocalVideo(localVideo);
                    }
                    RongCallManager.this.sendAcceptMessage(RongCallManager.this.callSessionImp.getCallId(), RongCallManager.this.callSessionImp.getMediaType(), new SignalCallback(){

                        @Override
                        public void onError() {
                            RongCallManager.this.getHandler().sendEmptyMessage(401);
                        }

                        @Override
                        public void onSuccess(String userId, String mediaId) {
                            ReportUtil.appRes(ReportUtil.TAG.ACCEPT_CALL, "code|roomId", 0, RongCallManager.this.getRoomId());
                            Message msg = Message.obtain((Handler)RongCallManager.this.getHandler(), (int)205);
                            Bundle bundle = new Bundle();
                            bundle.putString("userId", userId);
                            bundle.putString("mediaId", mediaId);
                            msg.setData(bundle);
                            msg.sendToTarget();
                        }
                    });
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mConnectingState);
                    break;
                }
                case 402: {
                    RongCallManager.this.callSessionImp.setEndTime(System.currentTimeMillis());
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.NO_RESPONSE, null);
                    RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), RongCallCommon.CallDisconnectedReason.NO_RESPONSE);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                case 105: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
                    boolean isInvited = false;
                    for (String userId : inviteMessage.getInviteUserIds()) {
                        if (!RongCallManager.this.callSessionImp.getSelfUserId().equals(userId)) continue;
                        isInvited = true;
                        break;
                    }
                    if (!isInvited) break;
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(inviteMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 107: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
                    if (modifyMemberMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) {
                        for (String id : modifyMemberMessage.getInvitedList()) {
                            if (RongCallManager.this.callSessionImp.getParticipantUserList().contains(id)) {
                                RLog.e((String)TAG, (String)("The list of participants already exists. userid :" + id));
                                continue;
                            }
                            CallUserProfile profile = new CallUserProfile();
                            profile.setUserId(id);
                            profile.setMediaType(modifyMemberMessage.getMediaType());
                            profile.setCallStatus(RongCallCommon.CallStatus.INCOMING);
                            if (modifyMemberMessage.getObserverList() != null && modifyMemberMessage.getObserverList().contains(id)) {
                                profile.setUserType(RongCallCommon.CallUserType.OBSERVER);
                                if (RongCallManager.this.callSessionImp.getobserverUserList() != null) {
                                    if (!RongCallManager.this.callSessionImp.getobserverUserList().contains(id)) {
                                        RongCallManager.this.callSessionImp.getobserverUserList().add(id);
                                    }
                                } else {
                                    ArrayList<String> list = new ArrayList<String>();
                                    list.add(id);
                                    RongCallManager.this.callSessionImp.setObserverUserList(list);
                                }
                            } else {
                                profile.setUserType(RongCallCommon.CallUserType.NORMAL);
                            }
                            RongCallManager.this.callSessionImp.getParticipantProfileList().add(profile);
                            RongCallManager.this.getCallListener().onRemoteUserInvited(id, modifyMemberMessage.getMediaType());
                        }
                        break;
                    }
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(modifyMemberMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 103: {
                    RongCallManager.this.cancelTimerTask(RongCallManager.this.callSessionImp.getSelfUserId());
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.REJECT, null);
                    RLog.d((String)TAG, (String)("IncomingState EVENT_HANG_UP callListener = " + RongCallManager.this.callListener));
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.REJECT.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 109: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallHangupMessage hangupMessage = (CallHangupMessage)message.getContent();
                    RongCallCommon.CallDisconnectedReason reason = hangupMessage.getHangupReason();
                    reason = RongCallManager.this.transferRemoteReason(reason, RongCallManager.this.getMyUserId().equals(message.getSenderUserId()));
                    String userId = message.getSenderUserId();
                    if (!hangupMessage.getCallId().equals(RongCallManager.this.callSessionImp.getCallId())) break;
                    if (TextUtils.equals((CharSequence)message.getSenderUserId(), (CharSequence)RongCallManager.this.getMyUserId())) {
                        if (RongCallManager.this.callSessionImp != null) {
                            RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                            RongCallManager.this.callSessionImp.setPushConfig(message.getMessagePushConfig());
                        }
                        Bundle bundle = new Bundle();
                        bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.OTHER_DEVICE_HAD_ACCEPTED.getValue());
                        msg.setData(bundle);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                        break;
                    }
                    boolean result = RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.IDLE);
                    if (result) {
                        if (userId.equals(RongCallManager.this.callSessionImp.getCallerUserId()) && !RongCallManager.this.hasConnectedUser() || RongCallManager.this.shouldTerminateCall(userId)) {
                            RongCallManager.this.callSessionImp.setEndTime(System.currentTimeMillis());
                            RongCallManager.this.callSessionImp.setPushConfig(message.getMessagePushConfig());
                            Bundle bundle = new Bundle();
                            bundle.putInt(RongCallManager.HANG_UP_KEY, reason.getValue());
                            msg.setData(bundle);
                            RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                            break;
                        }
                        RongCallManager.this.cancelTimerTask(userId);
                        RLog.i((String)TAG, (String)("onRemoteUserLeft userid : " + userId));
                        RongCallManager.this.getCallListener().onRemoteUserLeft(userId, hangupMessage.getHangupReason());
                        break;
                    }
                    RLog.e((String)TAG, (String)("user : " + userId + " had been deleted when RECEIVED_LEAVE_CHANNEL_ACTION"));
                    break;
                }
                case 108: {
                    String userId = (String)msg.obj;
                    RongCallManager.this.updateParticipantCallStatus(userId, RongCallCommon.CallStatus.RINGING);
                    RongCallManager.this.getCallListener().onRemoteUserRinging(userId);
                    break;
                }
                case 401: {
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.NETWORK_ERROR.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                case 106: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String mediaId = RongCallManager.this.getMediaId(message);
                    RongCallManager.this.updateMediaId(message.getSenderUserId(), mediaId);
                    String deviceId = "";
                    try {
                        deviceId = RongCallManager.getDeviceIMEI(RongCallManager.this.context);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    RongCallManager.this.updateParticipantCallStatus(message.getSenderUserId(), RongCallCommon.CallStatus.ACCEPTED);
                    if ((callSignalSender == null || !RongCallManager.this.callSessionImp.isUseSignalServer() || deviceId.equals(((CallAcceptMessage)message.getContent()).getDeviceId()) || !message.getSenderUserId().equals(RongCallManager.this.getMyUserId())) && !message.getSenderUserId().equals(RongCallManager.this.getMyUserId())) break;
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.OTHER_DEVICE_HAD_ACCEPTED.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
                case 600: {
                    RongCallManager.this.cancelTimerTask(RongCallManager.this.callSessionImp.getSelfUserId());
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    Bundle bundle = new Bundle();
                    bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.HANGUP.getValue());
                    msg.setData(bundle);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    break;
                }
            }
            return true;
        }
    }

    private class IdleState
    extends State {
        private IdleState() {
        }

        public void enter() {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] enter, myUserId = " + RongCallManager.this.getMyUserId()));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE, "state", this.getName());
            RongCallManager.this.callSessionImp = null;
            RongCallManager.this.resetTimer();
        }

        public boolean processMessage(Message msg) {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] processMessage : " + msg.what));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE_EVENT, "state|event", this.getName(), ReportUtil.eventToString(msg.what));
            switch (msg.what) {
                case 101: {
                    RongCallCommon.CallEngineType preferEngineType = RongCallManager.this.getPreferEngineType();
                    if (preferEngineType == null) {
                        RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.makeCallSession((CallSessionImp)msg.obj), RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED);
                        break;
                    }
                    String myUserId = RongCallManager.this.getMyUserId();
                    RongCallManager.this.callSessionImp = (CallSessionImp)msg.obj;
                    RongCallManager.this.callSessionImp.setEngineType(preferEngineType);
                    RongCallManager.this.callSessionImp.setSelfUserId(myUserId);
                    RongCallManager.this.updateParticipantCallStatus(myUserId, RongCallCommon.CallStatus.OUTGOING);
                    if (!RongCallManager.this.startEngine()) {
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                        break;
                    }
                    ArrayList<String> userList = new ArrayList<String>();
                    for (CallUserProfile profile : RongCallManager.this.callSessionImp.getParticipantProfileList()) {
                        if (profile.getUserId().equals(RongCallManager.this.getMyUserId())) {
                            RongCallManager.this.setupTimerTask(RongCallManager.this.getMyUserId(), 402, 60000);
                            continue;
                        }
                        RongCallManager.this.setupTimerTask(profile.getUserId(), 402, 60000);
                        RongCallManager.this.updateParticipantCallStatus(profile.getUserId(), RongCallCommon.CallStatus.INCOMING);
                        userList.add(profile.getUserId());
                    }
                    RongCallManager.this.sendInviteMessage(userList, new SignalCallback(){

                        @Override
                        public void onError() {
                            RongCallManager.this.getHandler().sendEmptyMessage(401);
                        }

                        @Override
                        public void onSuccess(String userId, String mediaId) {
                            ReportUtil.appRes(ReportUtil.TAG.START_CALL, "code|roomId", 0, RongCallManager.this.getRoomId());
                            RongCallManager.this.updateMediaId(userId, mediaId);
                        }
                    });
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mOutgoingState);
                    break;
                }
                case 105: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
                    RongCallManager.this.initializeCallSessionFromInvite(message);
                    if (!RongCallManager.this.checkSupportEngine(inviteMessage.getEngineType())) {
                        RongCallManager.this.sendHangupMessage(message.getConversationType(), message.getTargetId(), inviteMessage.getCallId(), RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED, null);
                        RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED);
                        break;
                    }
                    if (!RongCallManager.this.checkedVoipEnable()) {
                        RongCallManager.this.sendHangupMessage(message.getConversationType(), message.getTargetId(), inviteMessage.getCallId(), RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED, null);
                        break;
                    }
                    boolean isInvited = false;
                    String myUserId = RongCallManager.this.getMyUserId();
                    for (String userId : inviteMessage.getInviteUserIds()) {
                        if (!myUserId.equals(userId)) continue;
                        isInvited = true;
                        break;
                    }
                    if (!isInvited) break;
                    if (RongCallManager.this.checkPermissionStatus(inviteMessage.getMediaType())) {
                        RongCallManager.this.initializeCallSessionFromInvite(message);
                        Message cachedMsg = Message.obtain();
                        cachedMsg.what = msg.what;
                        cachedMsg.obj = msg.obj;
                        RongCallManager.this.callSessionImp.setCachedMsg(cachedMsg);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mCheckPermissionState);
                        break;
                    }
                    for (CallUserProfile profile : RongCallManager.this.callSessionImp.getParticipantProfileList()) {
                        if (profile.getCallStatus().equals((Object)RongCallCommon.CallStatus.CONNECTED)) continue;
                        RongCallManager.this.setupTimerTask(profile.getUserId(), 402, 60000);
                    }
                    RongCallManager.this.sendRingingMessage(RongCallManager.this.callSessionImp.getCallId());
                    if (inviteMessage.getCallId().equals(RongCallManager.this.otherDeviceHangupCallId)) {
                        RLog.w((String)TAG, (String)("Don't handle this message!! Already received hangup message before invite for this call : " + RongCallManager.this.otherDeviceHangupCallId));
                        Bundle bundle = new Bundle();
                        bundle.putInt(RongCallManager.HANG_UP_KEY, RongCallCommon.CallDisconnectedReason.OTHER_DEVICE_HAD_ACCEPTED.getValue());
                        msg.setData(bundle);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mDisconnectingState);
                    } else {
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mIncomingState);
                    }
                    if (receivedCallListener == null) break;
                    receivedCallListener.onReceivedCall(RongCallManager.this.getCallSession());
                    break;
                }
                case 109: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallHangupMessage hangupMessage = (CallHangupMessage)message.getContent();
                    String senderUserId = message.getSenderUserId();
                    if (!RongCallManager.this.getMyUserId().equals(senderUserId)) break;
                    RongCallManager.this.otherDeviceHangupCallId = hangupMessage.getCallId();
                    break;
                }
                case 107: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
                    if (!RongCallManager.this.checkSupportEngine(modifyMemberMessage.getEngineType())) {
                        RongCallManager.this.sendHangupMessage(message.getConversationType(), message.getTargetId(), modifyMemberMessage.getCallId(), RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED, null);
                        RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED);
                        break;
                    }
                    String myUserId = RongCallManager.this.getMyUserId();
                    boolean invitedSelf = false;
                    for (String id : modifyMemberMessage.getInvitedList()) {
                        if (!myUserId.equals(id)) continue;
                        invitedSelf = true;
                        RongCallManager.this.initializeCallInfoFromModifyMember(message);
                        break;
                    }
                    if (!invitedSelf) break;
                    for (CallUserProfile profile : RongCallManager.this.callSessionImp.getParticipantProfileList()) {
                        if (profile.getCallStatus().equals((Object)RongCallCommon.CallStatus.CONNECTED)) continue;
                        RongCallManager.this.setupTimerTask(profile.getUserId(), 402, 60000);
                    }
                    RongCallManager.this.sendRingingMessage(RongCallManager.this.callSessionImp.getCallId());
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIncomingState);
                    if (receivedCallListener == null) break;
                    receivedCallListener.onReceivedCall(RongCallManager.this.getCallSession());
                    break;
                }
            }
            return true;
        }
    }

    private class UnInitState
    extends State {
        private UnInitState() {
        }

        public void enter() {
            super.enter();
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE, "state", this.getName());
            RLog.d((String)TAG, (String)("[" + this.getName() + "] enter"));
        }

        public boolean processMessage(Message msg) {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] processMessage : " + msg.what));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE_EVENT, "state|event", this.getName(), ReportUtil.eventToString(msg.what));
            switch (msg.what) {
                case 101: {
                    RongCallManager.this.deferMessage(msg);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                case 107: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
                    String myUserId = RongCallManager.this.getMyUserId();
                    boolean isInvited = false;
                    for (String id : modifyMemberMessage.getInvitedList()) {
                        if (!myUserId.equals(id)) continue;
                        isInvited = true;
                        break;
                    }
                    if (!isInvited) break;
                    if (RongCallManager.this.checkPermissionStatus(modifyMemberMessage.getMediaType())) {
                        RongCallManager.this.initializeCallInfoFromModifyMember(message);
                        Message cachedMsg = Message.obtain();
                        cachedMsg.what = msg.what;
                        cachedMsg.obj = msg.obj;
                        RongCallManager.this.callSessionImp.setCachedMsg(cachedMsg);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mCheckPermissionState);
                        break;
                    }
                    RongCallManager.this.deferMessage(msg);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                case 105: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
                    boolean isInvited = false;
                    String myUserId = RongCallManager.this.getMyUserId();
                    for (String userId : inviteMessage.getInviteUserIds()) {
                        if (!myUserId.equals(userId)) continue;
                        isInvited = true;
                        break;
                    }
                    if (!isInvited) break;
                    if (!RongCallManager.this.checkedVoipEnable()) {
                        RongCallManager.this.initializeCallSessionFromInvite(message);
                        RongCallManager.this.sendHangupMessage(message.getConversationType(), message.getTargetId(), inviteMessage.getCallId(), RongCallCommon.CallDisconnectedReason.SERVICE_NOT_OPENED, null);
                        RongCallManager.this.callSessionImp = null;
                        break;
                    }
                    if (RongCallManager.this.checkPermissionStatus(inviteMessage.getMediaType())) {
                        RongCallManager.this.initializeCallSessionFromInvite(message);
                        Message cachedMsg = Message.obtain();
                        cachedMsg.what = msg.what;
                        cachedMsg.obj = msg.obj;
                        RongCallManager.this.callSessionImp.setCachedMsg(cachedMsg);
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mCheckPermissionState);
                        break;
                    }
                    RongCallManager.this.deferMessage(msg);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                    break;
                }
                case 500: {
                    if (RongCallManager.this.callSessionImp == null) break;
                    if (RongCallManager.this.checkSupportEngine(RongCallManager.this.callSessionImp.getEngineType())) {
                        RongCallManager.this.deferMessage(RongCallManager.this.callSessionImp.getCachedMsg());
                        RongCallManager.this.transitionTo((IState)RongCallManager.this.mIdleState);
                        break;
                    }
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED, null);
                    RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), RongCallCommon.CallDisconnectedReason.ENGINE_UNSUPPORTED);
                }
            }
            return super.processMessage(msg);
        }
    }

    private class CheckPermissionState
    extends State {
        private CheckPermissionState() {
        }

        public void enter() {
            super.enter();
            RLog.d((String)TAG, (String)("[" + this.getName() + "] enter"));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE, "state", this.getName());
            if (receivedCallListener != null) {
                receivedCallListener.onCheckPermission(RongCallManager.this.getCallSession());
            }
        }

        public boolean processMessage(Message msg) {
            RLog.d((String)TAG, (String)("[" + this.getName() + "] processMessage : " + msg.what));
            ReportUtil.libStatus(ReportUtil.TAG.STATE_MACHINE_EVENT, "state|event", this.getName(), ReportUtil.eventToString(msg.what));
            switch (msg.what) {
                case 107: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallModifyMemberMessage modifyMemberMessage = (CallModifyMemberMessage)message.getContent();
                    boolean isInvited = false;
                    for (String userId : modifyMemberMessage.getInvitedList()) {
                        if (!RongCallManager.this.callSessionImp.getSelfUserId().equals(userId)) continue;
                        isInvited = true;
                        break;
                    }
                    if (!isInvited) break;
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(modifyMemberMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 105: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallInviteMessage inviteMessage = (CallInviteMessage)message.getContent();
                    boolean isInvited = false;
                    for (String userId : inviteMessage.getInviteUserIds()) {
                        if (!RongCallManager.this.callSessionImp.getSelfUserId().equals(userId)) continue;
                        isInvited = true;
                        break;
                    }
                    if (!isInvited) break;
                    RongCallManager.this.updateCallRongLog(message);
                    RongCallManager.this.sendHangupMessageWhenInCall(inviteMessage, message.getTargetId(), message.getConversationType(), message.getSenderUserId());
                    break;
                }
                case 500: {
                    RongCallManager.this.getHandler().sendEmptyMessage(500);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mUnInitState);
                    break;
                }
                case 103: 
                case 501: {
                    RongCallManager.this.sendHangupMessage(RongCallManager.this.callSessionImp.getConversationType(), RongCallManager.this.callSessionImp.getTargetId(), RongCallManager.this.callSessionImp.getCallId(), RongCallCommon.CallDisconnectedReason.REJECT, null);
                    RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), RongCallCommon.CallDisconnectedReason.REJECT);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mUnInitState);
                    break;
                }
                case 109: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    CallHangupMessage hangupMessage = (CallHangupMessage)message.getContent();
                    if (RongCallManager.this.callSessionImp != null) {
                        RongCallManager.this.callSessionImp.setPushConfig(message.getMessagePushConfig());
                    }
                    RongCallCommon.CallDisconnectedReason reason = hangupMessage.getHangupReason();
                    reason = RongCallManager.this.transferRemoteReason(reason, RongCallManager.this.getMyUserId().equals(message.getSenderUserId()));
                    RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), reason);
                    if (RongCallManager.this.callSessionImp != null) {
                        RongCallManager.this.callSessionImp = null;
                    }
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mUnInitState);
                    break;
                }
                case 106: {
                    io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)msg.obj;
                    String mediaId = RongCallManager.this.getMediaId(message);
                    RongCallManager.this.updateMediaId(message.getSenderUserId(), mediaId);
                    String deviceId = "";
                    try {
                        deviceId = RongCallManager.getDeviceIMEI(RongCallManager.this.context);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ((callSignalSender == null || !RongCallManager.this.callSessionImp.isUseSignalServer() || deviceId.equals(((CallAcceptMessage)message.getContent()).getDeviceId()) || !message.getSenderUserId().equals(RongCallManager.this.getMyUserId())) && !message.getSenderUserId().equals(RongCallManager.this.getMyUserId())) break;
                    RongCallManager.this.getCallListener().onCallDisconnected(RongCallManager.this.getCallSession(), RongCallCommon.CallDisconnectedReason.OTHER_DEVICE_HAD_ACCEPTED);
                    RongCallManager.this.updateParticipantCallStatus(RongCallManager.this.callSessionImp.getSelfUserId(), RongCallCommon.CallStatus.IDLE);
                    RongCallManager.this.transitionTo((IState)RongCallManager.this.mUnInitState);
                }
            }
            return super.processMessage(msg);
        }
    }

    private static interface SignalCallback {
        public void onError();

        public void onSuccess(String var1, String var2);
    }
}

