/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import io.rong.calllib.ICallEngineListener;
import io.rong.calllib.RongCallSession;
import io.rong.common.RLog;
import java.util.HashMap;

public class RongCallEngineListener
implements ICallEngineListener {
    private static final String TAG = "RongCallEngineListener";
    private Handler handler;

    public RongCallEngineListener(Handler handler) {
        this.handler = handler;
    }

    @Override
    public void onJoinChannelSuccess(String channel, String sessionId, int elapsed) {
        RLog.d((String)TAG, (String)("onJoinChannelSuccess, sessionId = " + sessionId + ", channelId = " + channel));
        Message message = Message.obtain();
        message.what = 201;
        message.obj = sessionId;
        this.handler.sendMessage(message);
    }

    @Override
    public void onRejoinChannelSuccess(String channel, String mediaId, int elapsed) {
    }

    @Override
    public void onWarning(int warn) {
    }

    @Override
    public void onError(int err) {
        RLog.e((String)TAG, (String)("onError, err = " + err));
        if (err == 16) {
            this.handler.sendEmptyMessage(404);
        } else if (err != 18) {
            this.handler.sendEmptyMessage(403);
        }
    }

    @Override
    public void onApiCallExecuted(String api, int error) {
    }

    @Override
    public void onCameraReady() {
    }

    @Override
    public void onVideoStopped() {
    }

    @Override
    public void onAudioQuality(String mediaId, int quality, short delay, short lost) {
    }

    @Override
    public void onLeaveChannel(int val) {
        RLog.d((String)TAG, (String)"onLeaveChannel");
        RongCallSession callInfo = new RongCallSession();
        Message message = Message.obtain();
        message.what = 202;
        message.obj = callInfo;
        Bundle bundle = new Bundle();
        bundle.putInt("hang_up_key", val);
        message.setData(bundle);
        this.handler.sendMessage(message);
    }

    @Override
    public void onRtcStats() {
    }

    @Override
    public void onAudioVolumeIndication(int totalVolume) {
    }

    @Override
    public void onUserJoined(String mediaId, int userType, int methodIdentification) {
        RLog.d((String)TAG, (String)("onUserJoined, mediaId = " + mediaId));
        Message message = Message.obtain();
        message.what = 203;
        message.obj = mediaId;
        message.arg2 = methodIdentification;
        this.handler.sendMessage(message);
    }

    @Override
    public void onRemoteUserPublishStream(String userId, String streamId, String tag) {
    }

    @Override
    public void onRemoteUserUnpublishStream(String userId, String streamId, String tag) {
    }

    @Override
    public void onUserOffline(String mediaId, int reason) {
        RLog.d((String)TAG, (String)("onUserOffline, mediaId = " + mediaId));
        Message message = Message.obtain();
        message.what = 204;
        message.obj = mediaId;
        this.handler.sendMessage(message);
    }

    @Override
    public void onUserMuteAudio(String mediaId, boolean muted) {
        RLog.d((String)TAG, (String)("onUserMuteVideo, mediaId = " + mediaId));
        Message message = Message.obtain();
        message.what = 210;
        message.obj = mediaId;
        message.arg1 = muted ? 1 : 0;
        this.handler.sendMessage(message);
    }

    @Override
    public void onUserMuteVideo(String mediaId, boolean muted) {
        RLog.d((String)TAG, (String)("onUserMuteVideo, mediaId = " + mediaId));
        Message message = Message.obtain();
        message.what = 208;
        message.obj = mediaId;
        message.arg1 = muted ? 1 : 0;
        this.handler.sendMessage(message);
    }

    @Override
    public void onRemoteVideoStat(String mediaId, int delay, int receivedBitrate, int receivedFrameRate) {
    }

    @Override
    public void onLocalVideoStat(int sentBitrate, int sentFrameRate) {
    }

    @Override
    public void onFirstRemoteVideoFrame(String mediaId, int width, int height, int elapsed) {
    }

    @Override
    public void onFirstLocalVideoFrame(int width, int height, int elapsed) {
    }

    @Override
    public void onFirstRemoteVideoDecoded(String mediaId, int width, int height, int elapsed) {
    }

    @Override
    public void onConnectionLost() {
        RLog.d((String)TAG, (String)"onConnectionLost");
        this.handler.sendEmptyMessage(403);
    }

    @Override
    public void onConnectionInterrupted() {
        RLog.d((String)TAG, (String)"onConnectionInterrupted");
    }

    @Override
    public void onMediaEngineEvent(int code) {
    }

    @Override
    public void onVendorMessage(String mediaId, byte[] data) {
        RLog.d((String)TAG, (String)("onVendorMessage : msg = " + new String(data)));
    }

    @Override
    public void onRefreshRecordingServiceStatus(int status) {
    }

    @Override
    public void onAudioLevelReceive(HashMap<String, String> audioLevel) {
    }

    @Override
    public void onAudioLevelSend(String audioLevel) {
    }

    @Override
    public void onWhiteBoardURL(String url) {
    }

    @Override
    public void onNetworkReceiveLost(String userId, int lossRate) {
    }

    @Override
    public void onNetworkSendLost(int lossRate, int delay) {
    }

    @Override
    public void onNotifySharingScreen(String s, boolean isSharing) {
    }

    @Override
    public void onNotifyDegradeNormalUserToObserver(String hostUid, String userId) {
    }

    @Override
    public void onNotifyAnswerObserverRequestBecomeNormalUser(String userId, long status) {
    }

    @Override
    public void onNotifyUpgradeObserverToNormalUser(String hostUid, String userId) {
    }

    @Override
    public void onNotifyHostControlUserDevice(String userId, String hostId, int dType, boolean isOpen) {
    }

    @Override
    public void onNotifyAnswerDegradeNormalUserToObserver(String s, boolean b) {
    }

    @Override
    public void onNotifyAnswerUpgradeObserverToNormalUser(String userId, boolean isAccept) {
    }

    @Override
    public void sendinInvite() {
    }
}

