/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.SurfaceView;
import cn.rongcloud.rtc.api.RCRTCConfig;
import cn.rongcloud.rtc.api.RCRTCEngine;
import cn.rongcloud.rtc.api.RCRTCLocalUser;
import cn.rongcloud.rtc.api.RCRTCRemoteUser;
import cn.rongcloud.rtc.api.RCRTCRoom;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCResultDataCallback;
import cn.rongcloud.rtc.api.callback.IRCRTCRoomEventsListener;
import cn.rongcloud.rtc.api.callback.IRCRTCStatusReportListener;
import cn.rongcloud.rtc.api.callback.IRCRTCVideoOutputFrameListener;
import cn.rongcloud.rtc.api.report.StatusBean;
import cn.rongcloud.rtc.api.report.StatusReport;
import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCCameraOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoInputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCVideoView;
import cn.rongcloud.rtc.base.RCRTCMediaType;
import cn.rongcloud.rtc.base.RCRTCParamsType;
import cn.rongcloud.rtc.base.RCRTCResourceState;
import cn.rongcloud.rtc.base.RCRTCStreamType;
import cn.rongcloud.rtc.base.RCRTCVideoFrame;
import cn.rongcloud.rtc.base.RTCErrorCode;
import cn.rongcloud.rtc.core.CameraVideoCapturer;
import cn.rongcloud.rtc.utils.FinLog;
import io.rong.calllib.CallVideoFrame;
import io.rong.calllib.CameraSwitchCallBack;
import io.rong.calllib.ICallEngine;
import io.rong.calllib.ICallEngineListener;
import io.rong.calllib.ICallEngineVideoFrameListener;
import io.rong.calllib.IMediaResourceListener;
import io.rong.calllib.PublishCallBack;
import io.rong.calllib.Role;
import io.rong.calllib.RongRTCEventHandler;
import io.rong.calllib.StartCameraCallback;
import io.rong.calllib.Utils;
import io.rong.common.RLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RongCallEngine
extends IRCRTCStatusReportListener
implements ICallEngine {
    private static final String TAG = "RongCallEngine";
    Context context;
    ICallEngineListener listener;
    private static final String NORMAL_VIDEO_STREAM = "RongCloudRTC_video";
    boolean isLeaving = false;
    private static final String VD_480x640_15f = "VD_480x640_15f";
    boolean enableBeauty = false;
    private SurfaceView surfaceView = null;
    private HashMap<String, SurfaceView> videoViewCache = new HashMap();
    private RCRTCRoom rtcRoom;
    private int callUserType = 1;
    private int remoteUserType = 1;
    private CallVideoFrame mVideoFrame;
    private CallVideoFrame tmpCallVideoFrame;
    private RCRTCConfig.Builder mBuilder = null;
    private RCRTCVideoStreamConfig.Builder mVCBuilder = null;
    private RCRTCAudioStreamConfig.Builder mACBuilder = null;
    public static final int ERROR_INIT_VIDEO = 16;
    public static final int ERROR_JOIN_ROOM = 100;
    public static final int ERROR_ENGINE = 0;
    public static final int ERROR_KICKED = 2;
    public static final int ERROR_SERVICE_NOT_OPENED = 3;
    private ICallEngineListener mCallEngineListener;
    private Handler mUIHandler = new Handler(Looper.getMainLooper());
    private boolean isAudioOnly = false;
    private ICallEngineVideoFrameListener videoFrameListener;
    int lossRate = 0;

    public RongCallEngine() {
        FinLog.d((String)TAG, (String)"RongCallEngine int ");
    }

    @Override
    public void create(Context context, String vendorKey, ICallEngineListener listener) {
        this.context = context;
        this.listener = listener;
        this.setCallConfig();
        RCRTCEngine.getInstance().init(context, this.mBuilder.build());
        RCRTCEngine.getInstance().getDefaultVideoStream().enableTinyStream(false);
        if (this.videoFrameListener != null) {
            this.onSetVideoFrameListener();
        }
        this.mCallEngineListener = listener;
    }

    @Override
    public void destroy() {
        RCRTCEngine.getInstance().unInit();
        this.mUIHandler = null;
        this.videoFrameListener = null;
    }

    @Override
    public SurfaceView createRendererView(Context context) {
        return new RCRTCVideoView(context);
    }

    @Override
    public void setupLocalVideo(SurfaceView localView) {
        this.surfaceView = localView;
        if (this.surfaceView != null && this.surfaceView instanceof RCRTCVideoView) {
            RCRTCEngine.getInstance().getDefaultVideoStream().setVideoView((RCRTCVideoView)this.surfaceView);
        } else {
            RLog.e((String)TAG, (String)"setupLocalVideo localView isNull or Not RCRTCVideoView");
        }
    }

    @Override
    public void setupRemoteVideo(SurfaceView remoteVideo, String uid) {
        RCRTCRoom rongRTCRoom = RCRTCEngine.getInstance().getRoom();
        if (rongRTCRoom != null) {
            String realUserId = Utils.parseUserId(uid);
            String streamTag = Utils.parseTag(uid);
            RCRTCRemoteUser remoteUser = rongRTCRoom.getRemoteUser(realUserId);
            if (remoteUser != null) {
                List remoteAVStreams = remoteUser.getStreams();
                for (RCRTCInputStream inputStream : remoteAVStreams) {
                    if (!(inputStream instanceof RCRTCVideoInputStream) || !TextUtils.equals((CharSequence)inputStream.getTag(), (CharSequence)streamTag)) continue;
                    ((RCRTCVideoInputStream)inputStream).setVideoView((RCRTCVideoView)remoteVideo);
                    break;
                }
            } else {
                this.videoViewCache.put(uid, remoteVideo);
            }
        } else {
            this.videoViewCache.put(uid, remoteVideo);
        }
    }

    @Override
    public int enableVideo() {
        this.muteLocalVideoStream(false);
        return 0;
    }

    @Override
    public int disableVideo() {
        this.muteLocalVideoStream(true);
        return 0;
    }

    private void postMain(Runnable runnable) {
        this.mUIHandler.post(runnable);
    }

    @Override
    public int startPreview() {
        this.postMain(new Runnable(){

            @Override
            public void run() {
                RongCallEngine.this.isLeaving = false;
                RCRTCEngine.getInstance().getDefaultVideoStream().startCamera((IRCRTCResultDataCallback)new IRCRTCResultDataCallback<Boolean>(){

                    public void onSuccess(Boolean data) {
                    }

                    public void onFailed(RTCErrorCode errorCode) {
                        RLog.e((String)RongCallEngine.TAG, (String)("startPreview Failed: " + errorCode.getReason()));
                    }
                });
            }
        });
        return 0;
    }

    @Override
    public int stopPreview() {
        RCRTCEngine.getInstance().getDefaultVideoStream().stopCamera();
        return 0;
    }

    @Override
    public int joinChannel(String key, final String channelName, String optionalInfo, String mediaId, final Role role) {
        RCRTCEngine.getInstance().joinRoom(channelName, (IRCRTCResultDataCallback)new IRCRTCResultDataCallback<RCRTCRoom>(){

            public void onSuccess(RCRTCRoom rongRTCRoom) {
                RongCallEngine.this.rtcRoom = rongRTCRoom;
                if (RongCallEngine.this.rtcRoom == null || RongCallEngine.this.rtcRoom.getLocalUser() == null) {
                    return;
                }
                RongCallEngine.this.rtcRoom.registerRoomListener((IRCRTCRoomEventsListener)new RongRTCEventHandler(RongCallEngine.this.mCallEngineListener));
                RongCallEngine.this.registerStatusReport();
                RCRTCLocalUser localUser = RongCallEngine.this.rtcRoom.getLocalUser();
                localUser.setRole(role.getTag(), new IRCRTCResultCallback(){

                    public void onSuccess() {
                        FinLog.d((String)RongCallEngine.TAG, (String)"setRole Success ");
                    }

                    public void onFailed(RTCErrorCode errorCode) {
                        FinLog.e((String)RongCallEngine.TAG, (String)("setRole Failed: " + errorCode.getValue()));
                    }
                });
                if (RongCallEngine.this.callUserType != 2) {
                    if (!RongCallEngine.this.isAudioOnly) {
                        RongCallEngine.this.startCapture();
                        if (RongCallEngine.this.surfaceView != null) {
                            for (RCRTCOutputStream outputStream : localUser.getStreams()) {
                                if (!(outputStream instanceof RCRTCVideoOutputStream)) continue;
                                ((RCRTCVideoOutputStream)outputStream).setVideoView((RCRTCVideoView)RongCallEngine.this.surfaceView);
                            }
                        }
                    }
                    RongCallEngine.this.updateAVConfig();
                    ArrayList<Object> localAvStreams = new ArrayList<Object>();
                    localAvStreams.add(RCRTCEngine.getInstance().getDefaultAudioStream());
                    if (!RongCallEngine.this.isAudioOnly) {
                        localAvStreams.add(RCRTCEngine.getInstance().getDefaultVideoStream());
                    }
                    localUser.publishStreams(localAvStreams, new IRCRTCResultCallback(){

                        public void onSuccess() {
                            RLog.d((String)RongCallEngine.TAG, (String)"publishDefaultAVStream  onUiSuccess");
                        }

                        public void onFailed(RTCErrorCode errorCode) {
                            RLog.d((String)RongCallEngine.TAG, (String)("publishDefaultAVStream  onUiFailed errorCode \uff1a" + errorCode));
                        }
                    });
                }
                List remoteUsers = rongRTCRoom.getRemoteUsers();
                for (final RCRTCRemoteUser remoteUser : remoteUsers) {
                    List streams = remoteUser.getStreams();
                    for (RCRTCInputStream stream : streams) {
                        SurfaceView surfaceView = (SurfaceView)RongCallEngine.this.videoViewCache.get(remoteUser.getUserId());
                        if (stream instanceof RCRTCVideoInputStream) {
                            if (surfaceView != null) {
                                ((RCRTCVideoInputStream)stream).setVideoView((RCRTCVideoView)surfaceView);
                                RongCallEngine.this.videoViewCache.remove(remoteUser.getUserId());
                            }
                            ((RCRTCVideoInputStream)stream).setStreamType(RCRTCStreamType.NORMAL);
                        }
                        if (TextUtils.equals((CharSequence)"RongCloudRTC", (CharSequence)stream.getTag()) || RongCallEngine.this.listener == null) continue;
                        RongCallEngine.this.listener.onRemoteUserPublishStream(remoteUser.getUserId(), stream.getStreamId(), stream.getTag());
                    }
                    if (streams != null && streams.size() > 0) {
                        RongCallEngine.this.remoteUserType = 1;
                        localUser.subscribeStreams(remoteUser.getStreams(), new IRCRTCResultCallback(){

                            public void onSuccess() {
                                RLog.d((String)RongCallEngine.TAG, (String)"joinRoom Subscribe onUiSuccess!");
                                RongCallEngine.this.modifyResource(remoteUser, remoteUser.getStreams());
                            }

                            public void onFailed(RTCErrorCode errorCode) {
                                RLog.d((String)RongCallEngine.TAG, (String)("joinRoom Subscribe onUiFailed errorCode \uff1a" + errorCode));
                            }
                        });
                    } else {
                        RongCallEngine.this.remoteUserType = 2;
                    }
                    RongCallEngine.this.listener.onUserJoined(remoteUser.getUserId(), RongCallEngine.this.remoteUserType, RongCallEngine.this.remoteUserType);
                }
                if (RongCallEngine.this.listener != null && RongCallEngine.this.rtcRoom != null) {
                    RongCallEngine.this.listener.onJoinChannelSuccess(channelName, RongCallEngine.this.rtcRoom.getSessionId(), 0);
                }
            }

            public void onFailed(RTCErrorCode errorCode) {
                if (RongCallEngine.this.listener != null) {
                    if (errorCode.getValue() == 40010) {
                        RongCallEngine.this.listener.onError(3);
                    } else {
                        RongCallEngine.this.listener.onError(0);
                    }
                }
            }
        });
        this.isLeaving = false;
        return 0;
    }

    private void registerStatusReport() {
        if (this.rtcRoom != null) {
            RCRTCEngine.getInstance().registerStatusReportListener((IRCRTCStatusReportListener)this);
        }
    }

    @Override
    public int leaveChannel(final int val) {
        if (this.videoViewCache != null) {
            this.videoViewCache.clear();
        }
        if (this.rtcRoom != null) {
            RCRTCEngine.getInstance().unregisterStatusReportListener();
        }
        if (!this.isLeaving) {
            RCRTCEngine.getInstance().leaveRoom(new IRCRTCResultCallback(){

                public void onSuccess() {
                    FinLog.i((String)"RongCallManager", (String)"quitRoom onUiSuccess.");
                    if (RongCallEngine.this.listener != null) {
                        RongCallEngine.this.listener.onLeaveChannel(val);
                    }
                }

                public void onFailed(RTCErrorCode errorCode) {
                    FinLog.e((String)"RongCallManager", (String)("quitRoom onUiFailed : " + errorCode.getValue()));
                    if (RongCallEngine.this.listener != null) {
                        RongCallEngine.this.listener.onLeaveChannel(val);
                    }
                }
            });
            this.isLeaving = true;
        }
        return 0;
    }

    @Override
    public int setChannelProfile(int profile) {
        return 0;
    }

    @Override
    public int startEchoTest() {
        return 0;
    }

    @Override
    public int stopEchoTest() {
        return 0;
    }

    @Override
    public int muteLocalAudioStream(boolean muted) {
        RCRTCEngine.getInstance().getDefaultAudioStream().setMicrophoneDisable(muted);
        return 0;
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean muted) {
        return 0;
    }

    @Override
    public int muteRemoteAudioStream(String mediaId, boolean muted) {
        return 0;
    }

    @Override
    public int setEnableSpeakerphone(boolean enabled) {
        RCRTCEngine.getInstance().enableSpeaker(enabled);
        return 0;
    }

    @Override
    public int startAudioRecording(String filePath) {
        return 0;
    }

    @Override
    public String getCallId() {
        return null;
    }

    @Override
    public int rate(String callId, int rating, String description) {
        return 0;
    }

    @Override
    public int complain(String callId, String description) {
        return 0;
    }

    @Override
    public void monitorHeadsetEvent(boolean monitor) {
    }

    @Override
    public void monitorBluetoothHeadsetEvent(boolean monitor) {
    }

    @Override
    public void monitorConnectionEvent(boolean monitor) {
    }

    @Override
    public boolean isSpeakerphoneEnabled() {
        return false;
    }

    @Override
    public int setSpeakerphoneVolume(int volume) {
        return 0;
    }

    @Override
    public int enableAudioVolumeIndication(int interval, int smooth) {
        return 0;
    }

    private void setBeautyEnable(boolean enable) {
    }

    @Override
    public int setLocalRenderMode(int mode) {
        return 0;
    }

    @Override
    public int setRemoteRenderMode(String mediaId, int mode) {
        return 0;
    }

    @Override
    public void switchView(String mediaId1, String mediaId2) {
    }

    @Override
    public int switchCamera() {
        RCRTCEngine.getInstance().getDefaultVideoStream().switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

            public void onCameraSwitchDone(boolean isFrontCamera) {
            }

            public void onCameraSwitchError(String errorDescription) {
                RLog.e((String)RongCallEngine.TAG, (String)("switchCamera Failed: " + errorDescription));
            }
        });
        return 0;
    }

    @Override
    public int requestNormalUser() {
        return 0;
    }

    @Override
    public int requestWhiteBoard() {
        return 0;
    }

    @Override
    public int muteLocalVideoStream(boolean muted) {
        if (muted) {
            RCRTCEngine.getInstance().getDefaultVideoStream().stopCamera();
        } else {
            RCRTCEngine.getInstance().getDefaultVideoStream().startCamera(null);
        }
        return 0;
    }

    @Override
    public int muteAllRemoteVideoStreams(boolean muted) {
        return 0;
    }

    @Override
    public int muteRemoteVideoStream(String mediaId, boolean muted) {
        return 0;
    }

    @Override
    public int setLogFile(String filePath) {
        return 0;
    }

    @Override
    public int setEnableBeauty(Boolean enable) {
        this.enableBeauty = enable;
        return 0;
    }

    @Override
    public int setLogFilter(int filter) {
        return 0;
    }

    @Override
    public int startServerRecording(String key) {
        return 0;
    }

    @Override
    public int stopServerRecording(String key) {
        return 0;
    }

    @Override
    public int getServerRecordingStatus() {
        return 0;
    }

    @Override
    public void setUserType(int type) {
        this.callUserType = type;
    }

    @Override
    public void answerDegradeNormalUserToObserver(String hostId) {
    }

    @Override
    public int answerUpgradeObserverToNormalUser(String userID, boolean isAccept) {
        return 0;
    }

    @Override
    public int answerHostControlUserDevice(String userID, int dType, boolean isOpen, boolean isAccept) {
        return 0;
    }

    @Override
    public void setVideoFrameListener(ICallEngineVideoFrameListener iVideoFrameListener) {
        this.videoFrameListener = iVideoFrameListener;
        this.onSetVideoFrameListener();
    }

    private void onSetVideoFrameListener() {
        RCRTCCameraOutputStream defaultVideoStream = RCRTCEngine.getInstance().getDefaultVideoStream();
        if (defaultVideoStream == null) {
            return;
        }
        if (this.videoFrameListener == null) {
            defaultVideoStream.setVideoFrameListener(null);
            return;
        }
        FinLog.d((String)TAG, (String)"setVideoFrameListener");
        defaultVideoStream.setVideoFrameListener(new IRCRTCVideoOutputFrameListener(){

            public RCRTCVideoFrame processVideoFrame(RCRTCVideoFrame rtcVideoFrame) {
                if (RongCallEngine.this.mVideoFrame == null) {
                    RongCallEngine.this.mVideoFrame = new CallVideoFrame();
                }
                if (rtcVideoFrame.getCaptureType() == RCRTCVideoFrame.CaptureType.TEXTURE) {
                    RongCallEngine.this.mVideoFrame.setOesTextureId(rtcVideoFrame.getTextureId());
                } else {
                    RongCallEngine.this.mVideoFrame.setData(rtcVideoFrame.getData());
                }
                RongCallEngine.this.mVideoFrame.setTimestamp(rtcVideoFrame.getTimestamp());
                RongCallEngine.this.mVideoFrame.setRotation(rtcVideoFrame.getRotation());
                RongCallEngine.this.mVideoFrame.setHeight(rtcVideoFrame.getHeight());
                RongCallEngine.this.mVideoFrame.setWidth(rtcVideoFrame.getWidth());
                ICallEngineVideoFrameListener videoFrameListener = RongCallEngine.this.videoFrameListener;
                if (videoFrameListener != null) {
                    RongCallEngine.this.tmpCallVideoFrame = videoFrameListener.processVideoFrame(RongCallEngine.this.mVideoFrame);
                }
                if (RongCallEngine.this.tmpCallVideoFrame != null) {
                    if (RongCallEngine.this.tmpCallVideoFrame.getCurrentCaptureDataType()) {
                        rtcVideoFrame.setTextureId(RongCallEngine.this.tmpCallVideoFrame.getOesTextureId());
                    } else {
                        rtcVideoFrame.setData(RongCallEngine.this.tmpCallVideoFrame.getData());
                    }
                    rtcVideoFrame.setTimestamp(RongCallEngine.this.tmpCallVideoFrame.getTimestamp());
                    rtcVideoFrame.setRotation(RongCallEngine.this.tmpCallVideoFrame.getRotation());
                    rtcVideoFrame.setHeight(RongCallEngine.this.tmpCallVideoFrame.getHeight());
                    rtcVideoFrame.setWidth(RongCallEngine.this.tmpCallVideoFrame.getWidth());
                }
                return rtcVideoFrame;
            }
        });
    }

    @Override
    public void setAudioOnly(boolean isAudioOnly) {
        this.isAudioOnly = isAudioOnly;
    }

    public void onAudioReceivedLevel(HashMap<String, String> audioLevel) {
        this.listener.onAudioLevelReceive(audioLevel);
    }

    public void onAudioInputLevel(String audioLevel) {
        this.listener.onAudioLevelSend(audioLevel);
    }

    public void onConnectionStats(StatusReport statusReport) {
        if (statusReport != null && this.listener != null) {
            for (Map.Entry entry : statusReport.statusVideoSends.entrySet()) {
                if (!((String)entry.getKey()).contains(NORMAL_VIDEO_STREAM)) continue;
                this.lossRate = (int)((StatusBean)entry.getValue()).packetLostRate;
            }
            if (this.lossRate == 100) {
                for (StatusBean statusBean : statusReport.statusAudioSends.values()) {
                    this.lossRate = (int)statusBean.packetLostRate;
                }
            }
            this.listener.onNetworkSendLost(this.lossRate, statusReport.rtt);
            for (Map.Entry entry : statusReport.statusVideoRcvs.entrySet()) {
                int loss = (int)((StatusBean)entry.getValue()).packetLostRate;
                if (loss == 100) {
                    StatusBean bean = null;
                    for (Map.Entry audioEntry : statusReport.statusAudioRcvs.entrySet()) {
                        if (!TextUtils.equals((CharSequence)((StatusBean)audioEntry.getValue()).uid, (CharSequence)((StatusBean)entry.getValue()).uid)) continue;
                        bean = (StatusBean)audioEntry.getValue();
                        break;
                    }
                    if (bean != null) {
                        loss = (int)bean.packetLostRate;
                    }
                }
                this.listener.onNetworkReceiveLost(((StatusBean)entry.getValue()).uid, loss);
            }
        }
    }

    @Override
    public void publishMediaResource(int mediaType, final IMediaResourceListener iMediaResourceListener) {
        RLog.i((String)TAG, (String)("publishMediaResource mediaType :" + mediaType));
        RCRTCRoom rongRTCRoom = RCRTCEngine.getInstance().getRoom();
        if (rongRTCRoom == null || rongRTCRoom.getLocalUser() == null) {
            return;
        }
        RCRTCLocalUser localUser = rongRTCRoom.getLocalUser();
        ArrayList<Object> outputStreams = new ArrayList<Object>();
        this.updateAVConfig();
        if (mediaType == 2) {
            if (this.surfaceView != null) {
                RCRTCEngine.getInstance().getDefaultVideoStream().setVideoView((RCRTCVideoView)this.surfaceView);
            }
            outputStreams.add(RCRTCEngine.getInstance().getDefaultAudioStream());
            outputStreams.add(RCRTCEngine.getInstance().getDefaultVideoStream());
        } else if (mediaType == 1) {
            outputStreams.add(RCRTCEngine.getInstance().getDefaultAudioStream());
        }
        localUser.publishStreams(outputStreams, new IRCRTCResultCallback(){

            public void onSuccess() {
                RLog.d((String)RongCallEngine.TAG, (String)"requestNormalUser publishDefaultAVStream  onUiSuccess");
                if (iMediaResourceListener != null) {
                    iMediaResourceListener.onUiSuccess();
                }
            }

            public void onFailed(RTCErrorCode errorCode) {
                RLog.d((String)RongCallEngine.TAG, (String)("requestNormalUser publishDefaultAVStream  onUiFailed errorCode \uff1a" + errorCode));
                if (iMediaResourceListener != null) {
                    iMediaResourceListener.onUiFailed(errorCode.getReason());
                }
            }
        });
    }

    @Override
    public void unPublishMediaResource(final IMediaResourceListener iMediaResourceListener) {
        RCRTCRoom rongRTCRoom = RCRTCEngine.getInstance().getRoom();
        if (rongRTCRoom == null || rongRTCRoom.getLocalUser() == null) {
            return;
        }
        RCRTCLocalUser localUser = rongRTCRoom.getLocalUser();
        localUser.unpublishDefaultStreams(new IRCRTCResultCallback(){

            public void onSuccess() {
                if (iMediaResourceListener != null) {
                    iMediaResourceListener.onUiSuccess();
                }
            }

            public void onFailed(RTCErrorCode errorCode) {
                if (iMediaResourceListener != null) {
                    iMediaResourceListener.onUiFailed(errorCode.getReason());
                }
            }
        });
    }

    @Override
    public void startCapture() {
        if (RCRTCEngine.getInstance().getDefaultVideoStream() != null) {
            RCRTCEngine.getInstance().getDefaultVideoStream().startCamera((IRCRTCResultDataCallback)new IRCRTCResultDataCallback<Boolean>(){

                public void onSuccess(Boolean data) {
                }

                public void onFailed(RTCErrorCode errorCode) {
                    RLog.e((String)RongCallEngine.TAG, (String)("startCapture Failed: " + errorCode.getReason()));
                }
            });
        } else {
            RLog.w((String)TAG, (String)"startCapture. getDefaultVideoStream = null .");
        }
    }

    private void modifyResource(RCRTCRemoteUser remoteUser, List<RCRTCInputStream> publishResource) {
        if (remoteUser == null || TextUtils.isEmpty((CharSequence)remoteUser.getUserId())) {
            RLog.e((String)TAG, (String)"joinRoom. Replacement message. error .");
            return;
        }
        for (RCRTCInputStream inputStream : publishResource) {
            if (inputStream == null || inputStream.getResourceState() == null || inputStream.getMediaType() == null || this.listener == null) continue;
            if (inputStream.getMediaType() == RCRTCMediaType.VIDEO && inputStream.getResourceState() == RCRTCResourceState.DISABLED) {
                RLog.i((String)TAG, (String)("joinRoom Replacement message.onUserMuteVideo .. userid :" + remoteUser.getUserId()));
                this.listener.onUserMuteVideo(remoteUser.getUserId(), false);
                continue;
            }
            if (inputStream.getMediaType() != RCRTCMediaType.AUDIO || inputStream.getResourceState() != RCRTCResourceState.DISABLED) continue;
            RLog.i((String)TAG, (String)("joinRoom Replacement message.onUserMuteAudio .. userid :" + remoteUser.getUserId()));
            this.listener.onUserMuteAudio(remoteUser.getUserId(), true);
        }
    }

    @Override
    public void switchCamera(int cameraId, boolean mirror, final CameraSwitchCallBack callBack) {
        RCRTCEngine.getInstance().getDefaultVideoStream().switchCamera(cameraId, mirror, new CameraVideoCapturer.CameraSwitchHandler(){

            public void onCameraSwitchDone(boolean isFrontCamera) {
                if (callBack != null) {
                    callBack.onCameraSwitchDone(isFrontCamera);
                }
            }

            public void onCameraSwitchError(String errorDescription) {
                if (callBack != null) {
                    callBack.onCameraSwitchError(errorDescription);
                }
            }
        });
    }

    @Override
    public void startPreview(int cameraId, boolean mirror, final StartCameraCallback callback) {
        this.isLeaving = false;
        RCRTCEngine.getInstance().getDefaultVideoStream().startCamera(cameraId, mirror, (IRCRTCResultDataCallback)new IRCRTCResultDataCallback<Boolean>(){

            public void onSuccess(Boolean data) {
                if (callback != null) {
                    callback.onDone(data);
                }
            }

            public void onFailed(RTCErrorCode errorCode) {
                if (callback != null) {
                    callback.onError(errorCode.getValue());
                }
            }
        });
    }

    @Override
    public void setLocalAudioPCMBufferListener(IRCRTCAudioDataListener listener) {
        RCRTCEngine.getInstance().getDefaultAudioStream().setAudioDataListener(listener);
    }

    @Override
    public void publishCustomVideoStream(String tag, final PublishCallBack callBack) {
        if (this.context == null) {
            FinLog.e((String)TAG, (String)"publishCustomVideoStream error.Context=null.");
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.UnknownError);
            }
            return;
        }
        RCRTCLocalUser localUser = RCRTCEngine.getInstance().getRoom().getLocalUser();
        if (localUser == null) {
            FinLog.e((String)TAG, (String)"init publishCustomVideoStream. localUser =null.");
            if (callBack != null) {
                callBack.onFailed(RTCErrorCode.UnknownError);
            }
            return;
        }
        final RCRTCVideoOutputStream outputStream = RCRTCEngine.getInstance().createVideoStream(tag, this.mVCBuilder.build());
        localUser.publishStream((RCRTCOutputStream)outputStream, new IRCRTCResultCallback(){

            public void onSuccess() {
                if (callBack != null) {
                    RCRTCVideoView videoView = new RCRTCVideoView(RongCallEngine.this.context);
                    outputStream.setVideoView(videoView);
                    FinLog.i((String)RongCallEngine.TAG, (String)("PublishCustomVideoStream onUiSuccess.  outputStream : " + outputStream + " , videoView : " + videoView));
                    callBack.onSuccess(outputStream, (SurfaceView)videoView);
                }
            }

            public void onFailed(RTCErrorCode errorCode) {
                FinLog.i((String)RongCallEngine.TAG, (String)("PublishCustomVideoStream RTCErrorCode :" + errorCode.getReason()));
                if (callBack != null) {
                    callBack.onFailed(errorCode);
                }
            }
        });
    }

    @Override
    public void unpublishCustomVideoStream(RCRTCOutputStream outputStream, IRCRTCResultCallback callBack) {
        if (outputStream == null) {
            FinLog.e((String)TAG, (String)"unpublishCustomVideoStream outputStream =null;");
            return;
        }
        RCRTCLocalUser localUser = RCRTCEngine.getInstance().getRoom().getLocalUser();
        if (localUser != null) {
            localUser.unpublishStream(outputStream, callBack);
        }
    }

    @Override
    public void setCameraOrientation(int cameraDisplayOrientation, int frameOrientation) {
        RCRTCEngine.getInstance().getDefaultVideoStream().setFrameOrientation(frameOrientation);
        RCRTCEngine.getInstance().getDefaultVideoStream().setCameraDisplayOrientation(cameraDisplayOrientation);
    }

    @Override
    public void setRTCConfig(RCRTCConfig.Builder builder) {
        this.mBuilder = builder;
    }

    @Override
    public void setVideoConfig(RCRTCVideoStreamConfig.Builder builder) {
        this.mVCBuilder = builder;
    }

    @Override
    public void setAudioConfig(RCRTCAudioStreamConfig.Builder builder) {
        this.mACBuilder = builder;
    }

    private void setCallConfig() {
        if (this.mBuilder == null) {
            this.mBuilder = RCRTCConfig.Builder.create();
        }
        this.mBuilder.setHardwareEncoderBitrateMode(RCRTCParamsType.VideoBitrateMode.CBR);
        if (this.mVCBuilder == null) {
            this.mVCBuilder = RCRTCVideoStreamConfig.Builder.create();
        }
        if (this.mACBuilder == null) {
            this.mACBuilder = RCRTCAudioStreamConfig.Builder.create();
        }
    }

    @Override
    public void joinRoomAndPublishResource(String channelName) {
        RCRTCEngine.getInstance().joinRoom(channelName, (IRCRTCResultDataCallback)new IRCRTCResultDataCallback<RCRTCRoom>(){

            public void onSuccess(RCRTCRoom rongRTCRoom) {
                RongCallEngine.this.rtcRoom = rongRTCRoom;
                if (RongCallEngine.this.rtcRoom == null || RongCallEngine.this.rtcRoom.getLocalUser() == null) {
                    return;
                }
                RongCallEngine.this.rtcRoom.registerRoomListener((IRCRTCRoomEventsListener)new RongRTCEventHandler(RongCallEngine.this.mCallEngineListener));
                RongCallEngine.this.registerStatusReport();
                FinLog.d((String)RongCallEngine.TAG, (String)("joinRoomAndPublishResource-onUiSuccess(). callUserType : " + RongCallEngine.this.callUserType));
                if (RongCallEngine.this.callUserType != 2) {
                    if (!RongCallEngine.this.isAudioOnly) {
                        RongCallEngine.this.startCapture();
                    }
                    RCRTCLocalUser localUser = RongCallEngine.this.rtcRoom.getLocalUser();
                    if (RongCallEngine.this.surfaceView != null) {
                        List streams = localUser.getStreams();
                        for (RCRTCOutputStream outputStream : streams) {
                            if (!(outputStream instanceof RCRTCVideoInputStream)) continue;
                            ((RCRTCVideoInputStream)outputStream).setVideoView((RCRTCVideoView)RongCallEngine.this.surfaceView);
                        }
                    }
                    RongCallEngine.this.updateAVConfig();
                    ArrayList<Object> localAvStreams = new ArrayList<Object>();
                    localAvStreams.add(RCRTCEngine.getInstance().getDefaultAudioStream());
                    if (!RongCallEngine.this.isAudioOnly) {
                        localAvStreams.add(RCRTCEngine.getInstance().getDefaultVideoStream());
                    }
                    localUser.publishStreams(localAvStreams, new IRCRTCResultCallback(){

                        public void onSuccess() {
                            FinLog.d((String)RongCallEngine.TAG, (String)"publishDefaultAVStream  onUiSuccess");
                            if (RongCallEngine.this.listener != null) {
                                RongCallEngine.this.listener.sendinInvite();
                            }
                        }

                        public void onFailed(RTCErrorCode errorCode) {
                            FinLog.e((String)RongCallEngine.TAG, (String)("publishDefaultAVStream  onUiFailed errorCode \uff1a" + errorCode));
                            if (RongCallEngine.this.listener != null) {
                                RongCallEngine.this.listener.onError(0);
                            }
                        }
                    });
                } else if (RongCallEngine.this.listener != null) {
                    RongCallEngine.this.listener.sendinInvite();
                }
            }

            public void onFailed(RTCErrorCode errorCode) {
                FinLog.e((String)RongCallEngine.TAG, (String)("joinRoom  onUiFailed errorCode \uff1a" + errorCode));
                if (RongCallEngine.this.listener != null) {
                    RongCallEngine.this.listener.onError(100);
                }
            }
        });
        this.isLeaving = false;
    }

    private void updateAVConfig() {
        RCRTCEngine.getInstance().getDefaultVideoStream().setVideoConfig(this.mVCBuilder.build());
        RCRTCEngine.getInstance().getDefaultAudioStream().setAudioConfig(this.mACBuilder.build());
    }
}

