/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import cn.rongcloud.rtc.api.RCRTCConfig;
import cn.rongcloud.rtc.api.callback.IRCRTCAudioDataListener;
import cn.rongcloud.rtc.api.callback.IRCRTCResultCallback;
import cn.rongcloud.rtc.api.stream.RCRTCAudioStreamConfig;
import cn.rongcloud.rtc.api.stream.RCRTCOutputStream;
import cn.rongcloud.rtc.api.stream.RCRTCVideoStreamConfig;
import cn.rongcloud.rtc.base.RTCErrorCode;
import io.rong.calllib.CallSessionImp;
import io.rong.calllib.CallUserProfile;
import io.rong.calllib.CameraSwitchCallBack;
import io.rong.calllib.IRongCallListener;
import io.rong.calllib.IRongCallSignalSender;
import io.rong.calllib.IRongReceivedCallListener;
import io.rong.calllib.IVideoFrameListener;
import io.rong.calllib.PublishCallBack;
import io.rong.calllib.ReportUtil;
import io.rong.calllib.RongCallCommon;
import io.rong.calllib.RongCallManager;
import io.rong.calllib.RongCallMissedListener;
import io.rong.calllib.RongCallSession;
import io.rong.calllib.StartCameraCallback;
import io.rong.calllib.message.CallAcceptMessage;
import io.rong.calllib.message.CallHangupMessage;
import io.rong.calllib.message.CallInviteMessage;
import io.rong.calllib.message.CallModifyMediaMessage;
import io.rong.calllib.message.CallModifyMemberMessage;
import io.rong.calllib.message.CallRingingMessage;
import io.rong.calllib.message.CallSTerminateMessage;
import io.rong.calllib.message.CallSummaryMessage;
import io.rong.calllib.message.MultiCallEndMessage;
import io.rong.common.RLog;
import io.rong.imlib.IHandler;
import io.rong.imlib.IMLibExtensionModuleManager;
import io.rong.imlib.MessageTag;
import io.rong.imlib.ModuleManager;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MessageContent;
import io.rong.imlib.model.MessagePushConfig;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RongCallClient {
    private static final String TAG = RongCallClient.class.getSimpleName();
    private static final int CALL_TIMEOUT_INTERVAL = 60000;
    private static RongCallClient sInstance;
    private List<io.rong.imlib.model.Message> inviteMessages;
    private List<io.rong.imlib.model.Message> acceptMessages;
    private List<io.rong.imlib.model.Message> hangupMessages;
    private List<Class<? extends MessageContent>> VoIPMessageList;
    private Map<String, io.rong.imlib.model.Message> messagesMap;
    private ModuleManager.MessageRouter messageRouter;
    private ModuleManager.ConnectivityStateChangedListener connectivityStateChangedListener;
    private static RongCallMissedListener missedListener;
    private boolean localAudioEnabled = true;
    private boolean speakerphoneEnabled = true;
    private boolean localVideoEnabled = true;

    public RongCallClient(Context context, IHandler stub) {
        RLog.i((String)TAG, (String)("RongCallClient sInstance == null ?" + (sInstance == null)));
        if (sInstance == null) {
            sInstance = this;
            this.init(context, stub, false);
        } else {
            this.init(context, stub, true);
        }
    }

    public static RongCallClient getInstance() {
        return sInstance;
    }

    private void initMessage(IHandler stub) {
        this.VoIPMessageList = new ArrayList<Class<? extends MessageContent>>();
        this.VoIPMessageList.add(CallInviteMessage.class);
        this.VoIPMessageList.add(CallRingingMessage.class);
        this.VoIPMessageList.add(CallAcceptMessage.class);
        this.VoIPMessageList.add(CallHangupMessage.class);
        this.VoIPMessageList.add(CallSummaryMessage.class);
        this.VoIPMessageList.add(CallModifyMediaMessage.class);
        this.VoIPMessageList.add(CallModifyMemberMessage.class);
        this.VoIPMessageList.add(CallSTerminateMessage.class);
        this.VoIPMessageList.add(MultiCallEndMessage.class);
        for (Class<? extends MessageContent> cls : this.VoIPMessageList) {
            try {
                stub.registerMessageType(cls.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            stub.registerCmdMsgType(CallAcceptMessage.class.getAnnotation(MessageTag.class).value());
            stub.registerCmdMsgType(CallHangupMessage.class.getAnnotation(MessageTag.class).value());
            stub.registerCmdMsgType(CallInviteMessage.class.getAnnotation(MessageTag.class).value());
            stub.registerCmdMsgType(CallModifyMediaMessage.class.getAnnotation(MessageTag.class).value());
            stub.registerCmdMsgType(CallModifyMemberMessage.class.getAnnotation(MessageTag.class).value());
            stub.registerCmdMsgType(CallRingingMessage.class.getAnnotation(MessageTag.class).value());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init(Context context, IHandler stub, boolean reInitialization) {
        RLog.i((String)TAG, (String)("init Re Initialization = " + reInitialization));
        this.initMessage(stub);
        ArrayList<String> names = new ArrayList<String>();
        names.add("io.rong.calllib.RongCallExtensionModule");
        IMLibExtensionModuleManager.getInstance().registerModulesByName(names);
        this.inviteMessages = new ArrayList<io.rong.imlib.model.Message>();
        this.acceptMessages = new ArrayList<io.rong.imlib.model.Message>();
        this.hangupMessages = new ArrayList<io.rong.imlib.model.Message>();
        this.messagesMap = new HashMap<String, io.rong.imlib.model.Message>();
        if (reInitialization) {
            RongCallManager.getInstance().reIninialization(context, stub);
        } else {
            RongCallManager.getInstance().init(context, stub);
        }
        this.messageRouter = new ModuleManager.MessageRouter(){

            public boolean onReceived(io.rong.imlib.model.Message msg, int left, boolean offline, int cmdLeft) {
                long interval = RongCallClient.this.getDeltaTime(msg.getSentTime());
                if (interval < 60000L) {
                    RongCallClient.this.handleMessage(msg, left, offline, cmdLeft);
                } else {
                    Log.i((String)TAG, (String)("onReceived message objectName: " + msg.getObjectName()));
                    MessageContent content = msg.getContent();
                    if (missedListener != null) {
                        if (content instanceof CallInviteMessage) {
                            CallInviteMessage inviteMessage = (CallInviteMessage)content;
                            RongCallClient.this.messagesMap.put(inviteMessage.getCallId(), msg);
                        } else if (content instanceof CallHangupMessage) {
                            CallHangupMessage hangupMessage = (CallHangupMessage)content;
                            io.rong.imlib.model.Message message = (io.rong.imlib.model.Message)RongCallClient.this.messagesMap.remove(hangupMessage.getCallId());
                            if (message != null) {
                                RongCallSession callSession = RongCallClient.this.handleOfflineCallSession(message, msg);
                                missedListener.onRongCallMissed(callSession, RongCallManager.getInstance().transferRemoteReason(hangupMessage.getHangupReason(), msg.getSenderUserId().equals(RongIMClient.getInstance().getCurrentUserId())));
                            }
                        } else if (content instanceof CallModifyMemberMessage) {
                            CallModifyMemberMessage modifyMediaMessage = (CallModifyMemberMessage)content;
                            RongCallSession callSession = new RongCallSession();
                            for (String userId : modifyMediaMessage.getInvitedList()) {
                                if (!userId.equals(RongIMClient.getInstance().getCurrentUserId())) continue;
                                callSession.setCallId(modifyMediaMessage.getCallId());
                                callSession.setTargetId(msg.getTargetId());
                                callSession.setSelfUserId(RongIMClient.getInstance().getCurrentUserId());
                                callSession.setConversationType(msg.getConversationType());
                                callSession.setParticipantUserList(modifyMediaMessage.getParticipantList());
                                callSession.setMediaType(modifyMediaMessage.getMediaType());
                                callSession.setInviterUserId(msg.getSenderUserId());
                                callSession.setCallerUserId(msg.getSenderUserId());
                                callSession.setStartTime(msg.getSentTime());
                                break;
                            }
                            missedListener.onRongCallMissed(callSession, RongCallCommon.CallDisconnectedReason.NO_RESPONSE);
                        }
                    }
                }
                boolean contains = RongCallClient.this.VoIPMessageList.contains(msg.getContent().getClass());
                if (contains) {
                    RLog.e((String)TAG, (String)("ignore " + msg + ", interval = " + interval));
                }
                return contains;
            }
        };
        ModuleManager.addMessageRouter((ModuleManager.MessageRouter)this.messageRouter);
        this.connectivityStateChangedListener = new ModuleManager.ConnectivityStateChangedListener(){

            public void onChanged(RongIMClient.ConnectionStatusListener.ConnectionStatus state) {
                if (state != null) {
                    RLog.i((String)TAG, (String)("addConnectivityStateChangedListener ConnectionStatus : " + state.getMessage()));
                    if (state.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.KICKED_OFFLINE_BY_OTHER_CLIENT)) {
                        RongCallManager.getInstance().getHandler().sendEmptyMessage(401);
                    } else if (state.equals((Object)RongIMClient.ConnectionStatusListener.ConnectionStatus.UNCONNECTED)) {
                        RongCallManager.getInstance().getHandler().sendEmptyMessage(600);
                    }
                }
            }
        };
        ModuleManager.addConnectivityStateChangedListener((ModuleManager.ConnectivityStateChangedListener)this.connectivityStateChangedListener);
    }

    private RongCallSession handleOfflineCallSession(io.rong.imlib.model.Message inviteMsg, io.rong.imlib.model.Message hangupMsg) {
        CallUserProfile userProfile;
        RongCallSession callSession = new RongCallSession();
        CallInviteMessage inviteMessage = (CallInviteMessage)inviteMsg.getContent();
        CallHangupMessage hangupMessage = (CallHangupMessage)hangupMsg.getContent();
        callSession.setCallId(hangupMessage.getCallId());
        callSession.setTargetId(hangupMsg.getTargetId());
        callSession.setSelfUserId(RongIMClient.getInstance().getCurrentUserId());
        callSession.setConversationType(hangupMsg.getConversationType());
        callSession.setMediaType(inviteMessage.getMediaType());
        callSession.setCallerUserId(inviteMsg.getSenderUserId());
        callSession.setInviterUserId(inviteMsg.getSenderUserId());
        callSession.setStartTime(inviteMsg.getSentTime());
        callSession.setEndTime(hangupMsg.getSentTime());
        ArrayList<CallUserProfile> list = new ArrayList<CallUserProfile>();
        for (String userId : inviteMessage.getInviteUserIds()) {
            userProfile = new CallUserProfile();
            userProfile.setUserId(userId);
            list.add(userProfile);
        }
        userProfile = new CallUserProfile();
        userProfile.setUserId(hangupMsg.getSenderUserId());
        list.add(userProfile);
        callSession.setParticipantUserList(list);
        return callSession;
    }

    private void handleOfflineCallSessions() {
        for (int i = 0; i < this.hangupMessages.size(); ++i) {
            io.rong.imlib.model.Message hangupMsg = this.hangupMessages.get(i);
            CallHangupMessage hangupMessage = (CallHangupMessage)hangupMsg.getContent();
            io.rong.imlib.model.Message message = this.messagesMap.remove(hangupMessage.getCallId());
            if (message == null) {
                for (int j = 0; j < this.inviteMessages.size(); ++j) {
                    io.rong.imlib.model.Message inviteMsg = this.inviteMessages.get(j);
                    String callId = ((CallInviteMessage)inviteMsg.getContent()).getCallId();
                    if (!callId.equals(hangupMessage.getCallId())) continue;
                    message = inviteMsg;
                    break;
                }
            }
            if (message == null || missedListener == null) continue;
            RongCallSession callSession = this.handleOfflineCallSession(message, hangupMsg);
            missedListener.onRongCallMissed(callSession, RongCallManager.getInstance().transferRemoteReason(hangupMessage.getHangupReason(), hangupMsg.getSenderUserId().equals(RongIMClient.getInstance().getCurrentUserId())));
        }
    }

    public void unInit() {
        RLog.i((String)TAG, (String)"unInit");
        ModuleManager.removeMessageRouter((ModuleManager.MessageRouter)this.messageRouter);
        ModuleManager.removeConnectivityStateChangedListener((ModuleManager.ConnectivityStateChangedListener)this.connectivityStateChangedListener);
        this.messageRouter = null;
        this.connectivityStateChangedListener = null;
    }

    private void handleMessage(io.rong.imlib.model.Message msg, int left, boolean offline, int cmdLeft) {
        if (cmdLeft == 0 || !offline) {
            if (this.inviteMessages.size() == 0) {
                CallHangupMessage hangupMessage;
                io.rong.imlib.model.Message message;
                if (cmdLeft > 0 && this.storeOfflineVoIPMessage(msg)) {
                    return;
                }
                if (msg.getContent() instanceof CallHangupMessage && (message = this.messagesMap.remove((hangupMessage = (CallHangupMessage)msg.getContent()).getCallId())) != null && missedListener != null) {
                    RongCallSession callSession = this.handleOfflineCallSession(message, msg);
                    missedListener.onRongCallMissed(callSession, RongCallManager.getInstance().transferRemoteReason(hangupMessage.getHangupReason(), msg.getSenderUserId().equals(RongIMClient.getInstance().getCurrentUserId())));
                    return;
                }
                this.transferMessage(msg);
            } else {
                MessageContent messageContent = msg.getContent();
                if (messageContent instanceof CallInviteMessage || messageContent instanceof CallModifyMediaMessage) {
                    this.inviteMessages.add(msg);
                } else if (messageContent instanceof CallHangupMessage) {
                    this.hangupMessages.add(msg);
                } else if (messageContent instanceof CallAcceptMessage) {
                    this.acceptMessages.add(msg);
                }
                for (io.rong.imlib.model.Message im : this.inviteMessages) {
                    int i;
                    String callId;
                    if (this.hangupMessages.size() == 0 && this.acceptMessages.size() == 0) {
                        this.transferMessage(im);
                        break;
                    }
                    List<String> inviteUserIds = null;
                    if (im.getContent() instanceof CallInviteMessage) {
                        CallInviteMessage inviteMessage = (CallInviteMessage)im.getContent();
                        callId = inviteMessage.getCallId();
                        inviteUserIds = inviteMessage.getInviteUserIds();
                    } else {
                        CallModifyMediaMessage modifyMediaMessage = (CallModifyMediaMessage)im.getContent();
                        callId = modifyMediaMessage.getCallId();
                    }
                    int index = -1;
                    for (i = 0; i < this.hangupMessages.size(); ++i) {
                        CallHangupMessage hangupMessage = (CallHangupMessage)this.hangupMessages.get(i).getContent();
                        if (inviteUserIds != null && inviteUserIds.size() > 0) {
                            int inviteIndex = -1;
                            for (int j = 0; j < inviteUserIds.size(); ++j) {
                                if (inviteUserIds.get(i).equals(this.hangupMessages.get(i).getSenderUserId())) {
                                    inviteIndex = j;
                                    break;
                                }
                                if (!inviteUserIds.get(i).equals(RongIMClient.getInstance().getCurrentUserId())) continue;
                                inviteIndex = index;
                                break;
                            }
                            if (inviteIndex != -1) {
                                inviteUserIds.remove(inviteIndex);
                            }
                        }
                        if (!callId.equals(hangupMessage.getCallId()) || inviteUserIds != null && inviteUserIds.size() != 0) continue;
                        index = i;
                        break;
                    }
                    if (index == -1) {
                        for (i = 0; i < this.acceptMessages.size(); ++i) {
                            CallAcceptMessage acceptMessage = (CallAcceptMessage)this.acceptMessages.get(i).getContent();
                            io.rong.imlib.model.Message tMsg = this.acceptMessages.get(i);
                            if (!callId.equals(acceptMessage.getCallId()) || !tMsg.getConversationType().equals((Object)Conversation.ConversationType.PRIVATE) && (!tMsg.getConversationType().equals((Object)Conversation.ConversationType.GROUP) || !tMsg.getSenderUserId().equals(tMsg.getTargetId()))) continue;
                            index = i;
                            break;
                        }
                    }
                    if (index != -1) continue;
                    this.transferMessage(im);
                    break;
                }
                this.handleOfflineCallSessions();
                this.inviteMessages.clear();
                this.hangupMessages.clear();
                this.acceptMessages.clear();
            }
        } else {
            this.storeOfflineVoIPMessage(msg);
        }
    }

    private boolean storeOfflineVoIPMessage(io.rong.imlib.model.Message msg) {
        RLog.i((String)TAG, (String)("store offline " + msg));
        MessageContent messageContent = msg.getContent();
        if (messageContent instanceof CallInviteMessage || messageContent instanceof CallModifyMediaMessage) {
            this.inviteMessages.add(msg);
            return true;
        }
        if (messageContent instanceof CallHangupMessage) {
            CallHangupMessage hangupMessage = (CallHangupMessage)messageContent;
            if (RongCallManager.getInstance().isOngoingCallSession(hangupMessage.getCallId())) {
                this.transferMessage(msg);
            } else {
                this.hangupMessages.add(msg);
            }
            return true;
        }
        if (messageContent instanceof CallAcceptMessage) {
            this.acceptMessages.add(msg);
            return true;
        }
        if (messageContent instanceof CallModifyMemberMessage) {
            this.transferMessage(msg);
        }
        return false;
    }

    private void transferMessage(io.rong.imlib.model.Message msg) {
        RLog.i((String)TAG, (String)("transfer " + msg));
        MessageContent messageContent = msg.getContent();
        if (messageContent instanceof CallAcceptMessage) {
            Message message = Message.obtain();
            message.what = 106;
            message.obj = msg;
            RongCallManager.getInstance().sendMessage(message);
        } else if (messageContent instanceof CallInviteMessage) {
            Message message = Message.obtain();
            message.what = 105;
            message.obj = msg;
            RongCallManager.getInstance().sendMessage(message);
        } else if (messageContent instanceof CallRingingMessage) {
            Message message = Message.obtain();
            message.what = 108;
            message.obj = msg.getSenderUserId();
            RongCallManager.getInstance().sendMessage(message);
        } else if (messageContent instanceof CallHangupMessage) {
            Message message = Message.obtain();
            message.what = 109;
            message.obj = msg;
            RongCallManager.getInstance().sendMessage(message);
        } else if (messageContent instanceof CallModifyMediaMessage) {
            Message message = Message.obtain();
            message.what = 110;
            message.obj = msg;
            RongCallManager.getInstance().sendMessage(message);
        } else if (messageContent instanceof CallModifyMemberMessage) {
            Message message = Message.obtain();
            message.what = 107;
            message.obj = msg;
            RongCallManager.getInstance().sendMessage(message);
        }
    }

    public static void setReceivedCallListener(IRongReceivedCallListener listener) {
        RongCallManager.setReceivedCallListener(listener);
    }

    public static void setCallSignalSender(IRongCallSignalSender signalSender) {
        RongCallManager.setCallSignalSender(signalSender);
    }

    private long getDeltaTime(long sentTime) {
        long deltaTime = RongIMClient.getInstance().getDeltaTime();
        long normalTime = System.currentTimeMillis() - deltaTime;
        return normalTime - sentTime;
    }

    private String makeCallId(Conversation.ConversationType conversationType, String targetId, List<String> userIds) {
        String str = null;
        for (String id : userIds) {
            str = str + id;
        }
        long time = System.currentTimeMillis();
        return RongCallClient.ShortMD5(conversationType.getName() + targetId + str + time);
    }

    private static String ShortMD5(String ... args) {
        try {
            StringBuilder builder = new StringBuilder();
            for (String arg : args) {
                builder.append(arg);
            }
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(builder.toString().getBytes());
            byte[] mds = mdInst.digest();
            mds = Base64.encode((byte[])mds, (int)2);
            String result = new String(mds);
            result = result.replace("=", "").replace("+", "-").replace("/", "_").replace("\n", "");
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setVoIPCallListener(IRongCallListener callListener) {
        RongCallManager.getInstance().setCallListener(callListener);
    }

    public static void setMissedCallListener(RongCallMissedListener listener) {
        missedListener = listener;
        RongCallManager.setMissedCallListener(listener);
    }

    public static void setPushConfig(MessagePushConfig startCallPushConfig, MessagePushConfig hangupPushConfig) {
        RongCallManager.setPushConfig(startCallPushConfig, hangupPushConfig);
    }

    public String startCall(Conversation.ConversationType conversationType, String targetId, List<String> userIds, List<String> observerUserIds, RongCallCommon.CallMediaType mediaType, String extra) {
        RongCallManager.getInstance().startCameraCapture(-1, false, null);
        return this.startCallInternal(conversationType, targetId, userIds, observerUserIds, mediaType, extra);
    }

    public String startCall(int cameraId, boolean mirror, Conversation.ConversationType conversationType, String targetId, List<String> userIds, List<String> observerUserIds, RongCallCommon.CallMediaType mediaType, String extra, StartCameraCallback callback) {
        RongCallManager.getInstance().startCameraCapture(cameraId, mirror, callback);
        return this.startCallInternal(conversationType, targetId, userIds, observerUserIds, mediaType, extra);
    }

    private String startCallInternal(Conversation.ConversationType conversationType, String targetId, List<String> userIds, List<String> observerUserIds, RongCallCommon.CallMediaType mediaType, String extra) {
        if (conversationType == null || !conversationType.equals((Object)Conversation.ConversationType.NONE) && TextUtils.isEmpty((CharSequence)targetId) || userIds == null || userIds.size() == 0) {
            ReportUtil.appError(ReportUtil.TAG.START_CALL, 2, "code|targetId|conversationType|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), targetId, conversationType != null ? conversationType.getName() : "", "start call parameter error");
            RLog.e((String)TAG, (String)"startCall fail: Illegal Argument.");
            return null;
        }
        for (String userId : userIds) {
            if (userId != null) continue;
            ReportUtil.appError(ReportUtil.TAG.START_CALL, 2, "code|targetId|conversationType|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), targetId, conversationType != null ? conversationType.getName() : "", "start call userId is null");
            RLog.e((String)TAG, (String)"startCall fail: userId is null.");
            return null;
        }
        CallSessionImp callInfo = new CallSessionImp();
        if (conversationType.equals((Object)Conversation.ConversationType.NONE)) {
            targetId = null;
            callInfo.setUseSignalServer(true);
        }
        String callId = this.makeCallId(conversationType, targetId, userIds);
        String myId = RongIMClient.getInstance().getCurrentUserId();
        Message message = Message.obtain();
        message.what = 101;
        callInfo.setExtra(extra);
        callInfo.setConversationType(conversationType);
        callInfo.setMediaType(mediaType);
        callInfo.setTargetId(targetId);
        callInfo.setCallId(callId);
        callInfo.setCallerUserId(myId);
        callInfo.setInviterUserId(myId);
        callInfo.setObserverUserList(observerUserIds);
        ArrayList<CallUserProfile> list = new ArrayList<CallUserProfile>();
        CallUserProfile state = new CallUserProfile();
        state.setUserId(myId);
        state.setMediaType(mediaType);
        state.setCallStatus(RongCallCommon.CallStatus.IDLE);
        RongCallCommon.CallUserType localUserType = RongCallCommon.CallUserType.NORMAL;
        if (null != observerUserIds) {
            localUserType = observerUserIds.contains(myId) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL;
        }
        state.setUserType(localUserType);
        callInfo.setUserType(localUserType);
        list.add(state);
        RongCallCommon.CallUserType userType = RongCallCommon.CallUserType.NORMAL;
        for (String id : userIds) {
            state = new CallUserProfile();
            state.setUserId(id);
            state.setMediaType(mediaType);
            state.setCallStatus(RongCallCommon.CallStatus.IDLE);
            if (null != observerUserIds) {
                userType = observerUserIds.contains(id) ? RongCallCommon.CallUserType.OBSERVER : RongCallCommon.CallUserType.NORMAL;
                state.setUserType(userType);
            }
            list.add(state);
        }
        callInfo.setParticipantUserList(list);
        message.obj = callInfo;
        ReportUtil.appTask(ReportUtil.TAG.START_CALL, "targetId|conversationType|roomId|uid|mediaType", targetId, conversationType.getName(), callId, myId, mediaType.getValue());
        RongCallManager.getInstance().sendMessage(message);
        return callId;
    }

    public void acceptCall(String callId) {
        RongCallManager.getInstance().startCameraCapture(-1, false, null);
        this.acceptCallInternal(callId);
    }

    public void acceptCall(String callId, int cameraId, boolean mirror, StartCameraCallback callback) {
        RongCallManager.getInstance().startCameraCapture(cameraId, mirror, callback);
        this.acceptCallInternal(callId);
    }

    private void acceptCallInternal(String callId) {
        if (TextUtils.isEmpty((CharSequence)callId)) {
            ReportUtil.appError(ReportUtil.TAG.ACCEPT_CALL, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "acceptCall callId is null");
            RLog.e((String)TAG, (String)"acceptCall : Illegal Argument.");
            return;
        }
        ReportUtil.appTask(ReportUtil.TAG.ACCEPT_CALL, "roomId", callId);
        Message message = Message.obtain();
        message.what = 102;
        message.obj = callId;
        RongCallManager.getInstance().sendMessage(message);
    }

    public void hangUpCall(String callId) {
        this.resetAVStatus();
        if (TextUtils.isEmpty((CharSequence)callId)) {
            ReportUtil.appError(ReportUtil.TAG.HANGUP_CALL, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "hangUpCall callId is null");
            RLog.e((String)TAG, (String)"hangUpCall : Illegal Argument.");
            return;
        }
        ReportUtil.appTask(ReportUtil.TAG.HANGUP_CALL, "callId", callId);
        Message message = Message.obtain();
        message.what = 103;
        message.obj = callId;
        RongCallManager.getInstance().sendMessage(message);
    }

    public void hangUpCall() {
        this.resetAVStatus();
        RongCallSession session = this.getCallSession();
        if (session != null) {
            RongCallClient.getInstance().hangUpCall(session.getCallId());
        }
    }

    public RongCallSession getCallSession() {
        return RongCallManager.getInstance().getCallSession();
    }

    public void addParticipants(String callId, ArrayList<String> userIds, ArrayList<String> observerUserIds) {
        int i;
        if (TextUtils.isEmpty((CharSequence)callId) || userIds == null || userIds.size() == 0) {
            ReportUtil.appError(ReportUtil.TAG.MODIFY_MEMBER, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "addParticipants parameter error");
            RLog.e((String)TAG, (String)"addParticipants : Illegal Argument.");
            return;
        }
        CallSessionImp callInfo = RongCallManager.getInstance().getCallSessionImp();
        if (callInfo.getCallId() == null) {
            ReportUtil.appError(ReportUtil.TAG.MODIFY_MEMBER, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "callSession callId is null");
            RLog.e((String)TAG, (String)"addParticipants : Call don't start yet.");
            return;
        }
        if (!callInfo.getCallId().equals(callId)) {
            ReportUtil.appError(ReportUtil.TAG.MODIFY_MEMBER, 2, "code|roomId|callSessionId|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), callId, callInfo.getCallId(), "callId not match the callSession callId");
            RLog.e((String)TAG, (String)"addParticipants : callId does not exist.");
            return;
        }
        String selfUserId = callInfo.getSelfUserId();
        if (!TextUtils.isEmpty((CharSequence)selfUserId)) {
            int index = -1;
            for (i = 0; i < userIds.size(); ++i) {
                if (!userIds.get(i).equals(selfUserId)) continue;
                index = i;
                break;
            }
            if (index != -1) {
                userIds.remove(index);
                RLog.d((String)TAG, (String)("remove self userId with index = " + index));
            }
        }
        if (callInfo.getobserverUserList() != null && observerUserIds != null) {
            for (i = 0; i < callInfo.getobserverUserList().size(); ++i) {
                String userId = callInfo.getobserverUserList().get(i);
                if (observerUserIds.contains(userId)) continue;
                observerUserIds.add(userId);
            }
        }
        ReportUtil.appTask(ReportUtil.TAG.MODIFY_MEMBER, "roomId|userIds", callId, userIds.size());
        Message message = Message.obtain();
        message.what = 104;
        Bundle bundle = new Bundle();
        bundle.putStringArrayList("userIds", userIds);
        bundle.putStringArrayList("observerUserIds", observerUserIds);
        message.setData(bundle);
        RongCallManager.getInstance().sendMessage(message);
    }

    public void changeCallMediaType(RongCallCommon.CallMediaType mediaType) {
        if (mediaType == null) {
            ReportUtil.appError(ReportUtil.TAG.CHANGE_MEDIA_TYPE, 2, "code|desc", RTCErrorCode.RongRTCCodeParameterError.getValue(), "changeCallMediaType parameter error");
            RLog.e((String)TAG, (String)"changeLocalMediaType : Illegal Argument.");
            return;
        }
        ReportUtil.appTask(ReportUtil.TAG.CHANGE_MEDIA_TYPE, "roomId|mediaType", RongCallManager.getInstance().getRoomId(), mediaType.getValue());
        Message message = Message.obtain();
        message.what = 207;
        message.obj = mediaType;
        RongCallManager.getInstance().sendMessage(message);
    }

    public void switchCamera() {
        RongCallManager.getInstance().switchCamera();
    }

    public void switchCamera(int cameraId, boolean mirror, CameraSwitchCallBack callBack) {
        RongCallManager.getInstance().switchCamera(cameraId, mirror, callBack);
    }

    public void setEnableLocalVideo(boolean enabled) {
        this.localVideoEnabled = enabled;
        RongCallManager.getInstance().setEnableLocalVideo(enabled);
    }

    public void setEnableLocalAudio(boolean enabled) {
        this.localAudioEnabled = enabled;
        RongCallManager.getInstance().setEnableLocalAudio(enabled);
    }

    public void setEnableSpeakerphone(boolean enabled) {
        this.speakerphoneEnabled = enabled;
        RongCallManager.getInstance().setEnableSpeakerphone(enabled);
    }

    public void onPermissionGranted() {
        Message message = Message.obtain();
        message.what = 500;
        RongCallManager.getInstance().sendMessage(message);
    }

    public void onPermissionDenied() {
        Message message = Message.obtain();
        message.what = 501;
        RongCallManager.getInstance().sendMessage(message);
    }

    public void registerVideoFrameListener(IVideoFrameListener listener) {
        RongCallManager.getInstance().registerVideoFrameListener(listener);
    }

    public void registerAudioFrameListener(IRCRTCAudioDataListener listener) {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().setLocalAudioPCMBufferListener(listener);
        }
    }

    public void unregisterVideoFrameObserver() {
        RongCallManager.getInstance().unregisterVideoFrameListener();
    }

    private void reCreateVideoViews() {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().updateAllParticipantVideo();
        }
    }

    public boolean isVoIPEnabled(Context context) {
        if (RongCallManager.getInstance() != null) {
            return RongCallManager.getInstance().isVoIPEnabled(context);
        }
        return false;
    }

    public void publishMediaResource(RongCallCommon.CallMediaType callMediaType) {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().publishMediaResource(callMediaType);
        }
    }

    public boolean isLocalAudioEnabled() {
        return this.localAudioEnabled;
    }

    public boolean isSpeakerphoneEnabled() {
        return this.speakerphoneEnabled;
    }

    public boolean isLocalVideoEnabled() {
        return this.localVideoEnabled;
    }

    private void resetAVStatus() {
        this.localAudioEnabled = true;
        this.localVideoEnabled = true;
        this.speakerphoneEnabled = true;
    }

    public void startCapture() {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().startCapture();
        }
    }

    public void publishCustomVideoStream(String tag, PublishCallBack callBack) {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().publishCustomVideoStream(tag, callBack);
        }
    }

    public void unpublishCustomVideoStream(RCRTCOutputStream outputStream, IRCRTCResultCallback callBack) {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().unpublishCustomVideoStream(outputStream, callBack);
        }
    }

    public void setRTCConfig(RCRTCConfig.Builder builder) {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().setRTCConfig(builder);
        }
    }

    public void setVideoConfig(RCRTCVideoStreamConfig.Builder builder) {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().setVideoConfig(builder);
        }
    }

    public void setAudioConfig(RCRTCAudioStreamConfig.Builder builder) {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().setAudioConfig(builder);
        }
    }

    public void setCameraFrameOrientation(int cameraOrientation, int frameOrientation) {
        if (RongCallManager.getInstance() != null) {
            RongCallManager.getInstance().setCameraOrientation(cameraOrientation, frameOrientation);
        }
    }

    public boolean canCallContinued(String callId) {
        if (RongCallManager.getInstance() != null) {
            return RongCallManager.getInstance().canCallContinued(callId);
        }
        return true;
    }
}

