/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib;

import android.text.TextUtils;
import android.util.Pair;
import cn.rongcloud.rtc.base.RTCErrorCode;
import io.rong.calllib.RongCallSession;
import io.rong.calllib.Utils;
import io.rong.common.fwlog.LogSplitUtil;
import java.util.Arrays;

public class ReportUtil {
    public static final String PREFIX_APP = "A-";
    public static final String PREFIX_LIB = "L-";
    public static final String SUFFIX_OPERATE = "-O";
    public static final String SUFFIX_STATUS = "-S";
    public static final String SUFFIX_TASK = "-T";
    public static final String SUFFIX_RESULT = "-R";
    public static final String SUFFIX_ERROR = "-E";
    public static final String KEY_ROOMID = "roomId";
    public static final String KEY_CODE = "code";
    public static final int CODE_SUCCESS = 0;
    public static final String KEY_ROOMIDCODE = "roomId|code";

    public static void appTask(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_TASK, keys, values);
    }

    public static void appRes(TAG tag, String roomId) {
        ReportUtil.appRes(tag, KEY_ROOMIDCODE, roomId, 0);
    }

    public static void appRes(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_RESULT, keys, values);
    }

    public static void appError(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(code.getValue() + ""), (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void appError(TAG tag, int level, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.appError(tag, level, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void appError(TAG tag, RTCErrorCode code) {
        ReportUtil.appError(tag, code.getValue(), code.getReason());
    }

    public static void appError(TAG tag, int level, RTCErrorCode code) {
        ReportUtil.appError(tag, level, code.getValue(), code.getReason());
    }

    public static void appError(TAG tag, int code, String desc) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(code + ""), "code|desc", code, desc);
    }

    public static void appError(TAG tag, int level, int code, String desc) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, level, "code|desc", code, desc);
    }

    public static void appError(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    public static void appError(TAG tag, boolean checkErrorCodeAndDegradeLevel, String keys, Object ... values) {
        if (!checkErrorCodeAndDegradeLevel) {
            ReportUtil.appError(tag, keys, values);
            return;
        }
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    private static int degradeLogLevel(Object ... values) {
        int level = 1;
        for (Object obj : values) {
            String errorCode;
            if (obj == null || !(errorCode = obj.toString()).equals(RTCErrorCode.RongRTCCodeHttpTimeoutError.getValue() + "") && !errorCode.equals(RTCErrorCode.RongRTCCodeHttpResponseError.getValue() + "")) continue;
            level = 2;
            break;
        }
        return level;
    }

    public static void appError(TAG tag, int level, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_ERROR, level, keys, values);
    }

    public static void appOperate(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_OPERATE, keys, values);
    }

    public static void appStatus(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_STATUS, keys, values);
    }

    public static void appStatus(TAG tag, RongCallSession callSession, String keys, Object ... values) {
        String newKeys = "targetId|conversationType|roomId|" + keys;
        int length = values.length;
        Object[] newValues = new Object[3 + length];
        newValues[0] = Utils.getTargetId(callSession);
        newValues[1] = Utils.getConversationTypeName(callSession);
        newValues[2] = Utils.getRoomId(callSession);
        for (int i = 0; i < length; ++i) {
            newValues[3 + i] = values[i];
        }
        ReportUtil.report(PREFIX_APP, tag, SUFFIX_STATUS, newKeys, newValues);
    }

    public static void libTask(TAG tag) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_TASK, KEY_CODE, 0);
    }

    public static void libTask(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_TASK, keys, values);
    }

    public static void libRes(TAG tag) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_RESULT, KEY_CODE, 0);
    }

    public static void libRes(TAG tag, String roomId) {
        ReportUtil.libRes(tag, KEY_ROOMIDCODE, roomId, 0);
    }

    public static void libRes(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_RESULT, keys, values);
    }

    public static void libErrorW(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.libError(tag, 2, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void libError(TAG tag, RTCErrorCode code, String keys, Object ... values) {
        Pair<String, Object[]> commonParams = ReportUtil.getCommonParams(code, keys, values);
        ReportUtil.libError(tag, (String)commonParams.first, (Object[])commonParams.second);
    }

    public static void libError(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, keys, values);
    }

    public static void libError(TAG tag, int level, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, level, keys, values);
    }

    public static void libError(TAG tag, boolean checkErrorCodeAndDegradeLevel, String keys, Object ... values) {
        if (!checkErrorCodeAndDegradeLevel) {
            ReportUtil.libError(tag, keys, values);
            return;
        }
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_ERROR, ReportUtil.degradeLogLevel(values), keys, values);
    }

    public static void libStatus(TAG tag, String keys, Object ... values) {
        ReportUtil.report(PREFIX_LIB, tag, SUFFIX_STATUS, keys, values);
    }

    public static void report(String prefix, TAG tag, String suffix, String keys, Object ... values) {
        int level = 3;
        if (SUFFIX_ERROR.equals(suffix)) {
            level = 1;
        }
        ReportUtil.write(level, prefix + tag.tag + suffix, keys, values);
    }

    public static void report(String prefix, TAG tag, String suffix, int level, String keys, Object ... values) {
        ReportUtil.write(level, prefix + tag.tag + suffix, keys, values);
    }

    private static void write(int level, String tag, String keys, Object ... values) {
        LogSplitUtil.write((int)level, (String)tag, (String)keys, (Object[])values);
    }

    private static Pair<String, Object[]> getCommonParams(RTCErrorCode code, String keys, Object ... values) {
        String tmpKeys = keys;
        tmpKeys = TextUtils.isEmpty((CharSequence)tmpKeys) ? "code|desc" : tmpKeys + (tmpKeys.endsWith("|") ? "code|desc" : "|code|desc");
        Object[] tmpValues = values != null ? Arrays.copyOf(values, values.length + 2) : new Object[2];
        tmpValues[tmpValues.length - 2] = code.getValue();
        tmpValues[tmpValues.length - 1] = code.getReason();
        return Pair.create((Object)tmpKeys, (Object)tmpValues);
    }

    public static String eventToString(int event) {
        String desc = "";
        switch (event) {
            case 101: {
                desc = "invite";
                break;
            }
            case 102: {
                desc = "accept";
                break;
            }
            case 103: {
                desc = "hangup";
                break;
            }
            case 104: {
                desc = "modifyMember";
                break;
            }
            case 1001: {
                desc = "sendInviteMessage";
                break;
            }
            case 105: {
                desc = "receiveInviteMessage";
                break;
            }
            case 106: {
                desc = "receiveAcceptMessage";
                break;
            }
            case 107: {
                desc = "receiveModifyMemberMessage";
                break;
            }
            case 108: {
                desc = "receiveRingMessage";
                break;
            }
            case 109: {
                desc = "receiveHangupMessage";
                break;
            }
            case 110: {
                desc = "receiveModifyMediaTypeMessage";
                break;
            }
            case 201: {
                desc = "onJoinChannel";
                break;
            }
            case 202: {
                desc = "onLeaveChannel";
                break;
            }
            case 203: {
                desc = "receivedJoinChannel";
                break;
            }
            case 204: {
                desc = "receivedLeaveChannel";
                break;
            }
            case 205: {
                desc = "getVoipKey";
                break;
            }
            case 206: {
                desc = "joinChannel";
                break;
            }
            case 207: {
                desc = "changeMediaType";
                break;
            }
            case 208: {
                desc = "muteVideo";
                break;
            }
            case 209: {
                desc = "firstVideoFrame";
                break;
            }
            case 210: {
                desc = "muteAudio";
                break;
            }
            case 301: {
                desc = "whiteBoard";
                break;
            }
            case 211: {
                desc = "audioLevelSend";
                break;
            }
            case 212: {
                desc = "audioLevelReceive";
                break;
            }
            case 213: {
                desc = "remotePublishStream";
                break;
            }
            case 214: {
                desc = "remoteUnPublishStream";
                break;
            }
            case 302: {
                desc = "networkSendLossRate";
                break;
            }
            case 303: {
                desc = "networkReceiveLossRate";
                break;
            }
            case 304: {
                desc = "notify2Observer";
                break;
            }
            case 305: {
                desc = "answer2Normal";
                break;
            }
            case 306: {
                desc = "ask2Normal";
                break;
            }
            case 307: {
                desc = "ask2Control";
                break;
            }
            case 308: {
                desc = "sharingScreen";
                break;
            }
            case 309: {
                desc = "notifyObserver2Normal";
                break;
            }
            case 401: {
                desc = "signalError";
                break;
            }
            case 402: {
                desc = "timeOut";
                break;
            }
            case 403: {
                desc = "engineError";
                break;
            }
            case 404: {
                desc = "initVideoError";
                break;
            }
            case 405: {
                desc = "kickedByServer";
                break;
            }
            case 406: {
                desc = "serviceNotOpened";
                break;
            }
            case 500: {
                desc = "permissionGranted";
                break;
            }
            case 501: {
                desc = "permissionDenied";
                break;
            }
            case 600: {
                desc = "userBlocked";
                break;
            }
            case 601: {
                desc = "joinRoomError";
                break;
            }
        }
        return desc;
    }

    public static enum TAG {
        START_CALL("startCall"),
        ACCEPT_CALL("acceptCall"),
        CALL_RINGING("callRinging"),
        HANGUP_CALL("hangupCall"),
        HANGUP_CALL_IN_CALL("hangupCallInCall"),
        MODIFY_MEMBER("modifyMember"),
        CHANGE_MEDIA_TYPE("changeMediaType"),
        STATE_MACHINE("stateMachine"),
        STATE_MACHINE_EVENT("stateMachineEvent"),
        CALL_LISTENER("callListener"),
        RECEIVE_CALL_LISTENER("receiveCallListener");

        private String tag;

        private TAG(String tag) {
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

