/*
 * Decompiled with CFR 0.152.
 */
package io.rong.calllib;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.TelephonyManager;

public abstract class PhoneCallReceiver
extends BroadcastReceiver {
    private int lastState = 0;
    private boolean isIncoming;

    public void onReceive(Context context, Intent intent) {
        if (!intent.getAction().equals("android.intent.action.NEW_OUTGOING_CALL")) {
            String stateStr = intent.getExtras().getString("state");
            int state = 0;
            if (stateStr.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                state = 0;
            } else if (stateStr.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                state = 2;
            } else if (stateStr.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                state = 1;
            }
            this.onCallStateChanged(context, state);
        }
    }

    protected abstract void onIncomingCallReceived(Context var1);

    protected abstract void onIncomingCallAnswered(Context var1);

    protected abstract void onIncomingCallEnded(Context var1);

    protected abstract void onOutgoingCallStarted(Context var1);

    protected abstract void onOutgoingCallEnded(Context var1);

    protected abstract void onMissedCall(Context var1);

    public void onCallStateChanged(Context context, int state) {
        if (this.lastState == state) {
            return;
        }
        switch (state) {
            case 1: {
                this.isIncoming = true;
                this.onIncomingCallReceived(context);
                break;
            }
            case 2: {
                if (this.lastState != 1) {
                    this.isIncoming = false;
                    this.onOutgoingCallStarted(context);
                    break;
                }
                this.isIncoming = true;
                this.onIncomingCallAnswered(context);
                break;
            }
            case 0: {
                if (this.lastState == 1) {
                    this.onMissedCall(context);
                    break;
                }
                if (this.isIncoming) {
                    this.onIncomingCallEnded(context);
                    break;
                }
                this.onOutgoingCallEnded(context);
            }
        }
        this.lastState = state;
    }
}

