/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.record;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.sight.R;
import io.rong.sight.record.CameraView;
import java.io.File;

public class SightRecordActivity
extends RongBaseNoActionbarActivity {
    public static final String TAG = "Sight-SightRecordActivity";
    private CameraView mCameraView;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.rc_activity_sight_record);
        this.mCameraView = (CameraView)this.findViewById(R.id.cameraView);
        this.mCameraView.setAutoFocus(false);
        this.mCameraView.setSupportCapture(this.getIntent().getBooleanExtra("supportCapture", false));
        this.mCameraView.setSaveVideoPath(this.getIntent().getStringExtra("recordSightDir"));
        this.mCameraView.setMaxRecordDuration(this.getIntent().getIntExtra("maxRecordDuration", 10));
        this.mCameraView.setCameraViewListener(new CameraView.CameraViewListener(){

            @Override
            public void quit() {
                SightRecordActivity.this.finish();
            }

            @Override
            public void captureSuccess(Bitmap bitmap) {
            }

            @Override
            public void recordSuccess(String url, int recordTime) {
                if (TextUtils.isEmpty((CharSequence)url)) {
                    SightRecordActivity.this.setResult(0);
                    SightRecordActivity.this.finish();
                    return;
                }
                File file = new File(url);
                if (!file.exists()) {
                    SightRecordActivity.this.setResult(0);
                    SightRecordActivity.this.finish();
                    return;
                }
                Intent intent = new Intent();
                intent.putExtra("recordSightUrl", url);
                intent.putExtra("recordSightTime", recordTime);
                SightRecordActivity.this.setResult(-1, intent);
                SightRecordActivity.this.finish();
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.mCameraView.onResume();
    }

    protected void onPause() {
        super.onPause();
        this.mCameraView.onPause();
    }
}

