/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.record;

import android.graphics.Bitmap;
import android.os.Environment;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtil {
    private static final String TAG = "FileUtil";
    private static final File parentPath = Environment.getExternalStorageDirectory();
    private static String storagePath = "";
    private static final String DST_FOLDER_NAME = "PlayCamera";

    private static String initPath() {
        boolean mkdirSuccess;
        File f;
        if (storagePath.equals("") && !(f = new File(storagePath = parentPath.getAbsolutePath() + "/" + DST_FOLDER_NAME)).exists() && !(mkdirSuccess = f.mkdir())) {
            Log.e((String)TAG, (String)"initPath mkdir failed");
        }
        return storagePath;
    }

    public static void saveBitmap(Bitmap b) {
        String path = FileUtil.initPath();
        long dataTake = System.currentTimeMillis();
        String jpegName = path + "/" + dataTake + ".jpg";
        Log.i((String)TAG, (String)("saveBitmap:jpegName = " + jpegName));
        try {
            FileOutputStream fout = new FileOutputStream(jpegName);
            BufferedOutputStream bos = new BufferedOutputStream(fout);
            b.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            bos.flush();
            bos.close();
            Log.i((String)TAG, (String)"saveBitmap success");
        }
        catch (IOException e) {
            Log.i((String)TAG, (String)"saveBitmap:fail");
            e.printStackTrace();
        }
    }

    public static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }
}

