/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.record;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.Toast;
import io.rong.sight.R;

public class CaptureButton
extends View {
    public final String TAG = "Sight-CaptureButton";
    private Paint mPaint;
    private Context mContext;
    private float btn_center_Y;
    private float btn_center_X;
    private float btn_inside_radius;
    private float btn_outside_radius;
    private float btn_before_inside_radius;
    private float btn_before_outside_radius;
    private float btn_after_inside_radius;
    private float btn_after_outside_radius;
    private float btn_return_length;
    private float btn_return_X;
    private float btn_return_Y;
    private float btn_left_X;
    private float btn_right_X;
    private float btn_result_radius;
    private int STATE_SELECTED;
    private final int STATE_LESSNESS = 0;
    private final int STATE_KEY_DOWN = 1;
    private final int STATE_CAPTURED = 2;
    private final int STATE_RECORD = 3;
    private final int STATE_PICTURE_BROWSE = 4;
    private final int STATE_RECORD_BROWSE = 5;
    private static final int STATE_READYQUIT = 6;
    private final int STATE_RECORDED = 7;
    private float key_down_Y;
    private float progress = 0.0f;
    private int captureProgressed = 0;
    private LongPressRunnable longPressRunnable = new LongPressRunnable();
    private ValueAnimator record_anim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 360.0f});
    private CaptureListener mCaptureListener;
    private boolean supportCapture = false;
    private int maxDuration = 10;
    private RecordRunnable recordRunnable = new RecordRunnable();
    private boolean hideSomeView = true;

    public CaptureButton(Context context) {
        this(context, null);
    }

    public CaptureButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CaptureButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.STATE_SELECTED = 0;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = widthSize / 9 * 4;
        this.setMeasuredDimension(widthSize, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.btn_center_X = this.getWidth() / 2;
        this.btn_center_Y = this.getHeight() / 2;
        if (!this.hideSomeView) {
            this.btn_outside_radius = this.getWidth() / 9;
            this.btn_inside_radius = (float)((double)this.btn_outside_radius * 0.75);
            this.btn_before_outside_radius = this.getWidth() / 9;
            this.btn_before_inside_radius = (float)((double)this.btn_outside_radius * 0.75);
            this.btn_after_outside_radius = this.getWidth() / 6;
            this.btn_after_inside_radius = (float)((double)this.btn_outside_radius * 0.6);
        } else {
            this.initCaptureButtonRadius();
            this.btn_before_outside_radius = this.getResources().getDimension(R.dimen.sight_capture_button_circle_size_outer);
            this.btn_before_inside_radius = this.getResources().getDimension(R.dimen.sight_capture_button_circle_size_inner);
            this.btn_after_outside_radius = this.getResources().getDimension(R.dimen.sight_capture_button_record_circle_size_outer);
            this.btn_after_inside_radius = this.getResources().getDimension(R.dimen.sight_capture_button_record_circle_size_inner);
        }
        this.btn_return_length = (float)((double)this.btn_outside_radius * 0.35);
        this.btn_result_radius = this.getWidth() / 9;
        this.btn_left_X = this.getWidth() / 2;
        this.btn_right_X = this.getWidth() / 2;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.STATE_SELECTED == 0 || this.STATE_SELECTED == 3) {
            this.mPaint.setColor(this.getResources().getColor(R.color.color_sight_capture_button_circle_outer));
            canvas.drawCircle(this.btn_center_X, this.btn_center_Y, this.btn_outside_radius, this.mPaint);
            this.mPaint.setColor(-1);
            canvas.drawCircle(this.btn_center_X, this.btn_center_Y, this.btn_inside_radius, this.mPaint);
            Paint paintArc = new Paint();
            paintArc.setAntiAlias(true);
            paintArc.setColor(this.getResources().getColor(R.color.color_sight_primary));
            paintArc.setStyle(Paint.Style.STROKE);
            paintArc.setStrokeWidth(10.0f);
            RectF rectF = new RectF(this.btn_center_X - (this.btn_after_outside_radius - 5.0f), this.btn_center_Y - (this.btn_after_outside_radius - 5.0f), this.btn_center_X + (this.btn_after_outside_radius - 5.0f), this.btn_center_Y + (this.btn_after_outside_radius - 5.0f));
            canvas.drawArc(rectF, -90.0f, this.progress, false, paintArc);
            if (!this.hideSomeView) {
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                paint.setColor(-1);
                paint.setStyle(Paint.Style.STROKE);
                paint.setStrokeWidth(4.0f);
                Path path = new Path();
                this.btn_return_X = ((float)(this.getWidth() / 2) - this.btn_outside_radius) / 2.0f;
                this.btn_return_Y = (float)this.getHeight() / 2.0f + 10.0f;
                path.moveTo(this.btn_return_X - this.btn_return_length, this.btn_return_Y - this.btn_return_length);
                path.lineTo(this.btn_return_X, this.btn_return_Y);
                path.lineTo(this.btn_return_X + this.btn_return_length, this.btn_return_Y - this.btn_return_length);
                canvas.drawPath(path, paint);
            }
        } else if (this.STATE_SELECTED == 5 || this.STATE_SELECTED == 4) {
            if (this.hideSomeView) {
                return;
            }
            this.mPaint.setColor(this.getResources().getColor(R.color.color_sight_capture_button_circle_outer));
            canvas.drawCircle(this.btn_left_X, this.btn_center_Y, this.btn_result_radius, this.mPaint);
            this.mPaint.setColor(-1);
            canvas.drawCircle(this.btn_right_X, this.btn_center_Y, this.btn_result_radius, this.mPaint);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            paint.setColor(-16777216);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(3.0f);
            Path path = new Path();
            path.moveTo(this.btn_left_X - 2.0f, this.btn_center_Y + 14.0f);
            path.lineTo(this.btn_left_X + 14.0f, this.btn_center_Y + 14.0f);
            path.arcTo(new RectF(this.btn_left_X, this.btn_center_Y - 14.0f, this.btn_left_X + 28.0f, this.btn_center_Y + 14.0f), 90.0f, -180.0f);
            path.lineTo(this.btn_left_X - 14.0f, this.btn_center_Y - 14.0f);
            canvas.drawPath(path, paint);
            paint.setStyle(Paint.Style.FILL);
            path.reset();
            path.moveTo(this.btn_left_X - 14.0f, this.btn_center_Y - 22.0f);
            path.lineTo(this.btn_left_X - 14.0f, this.btn_center_Y - 6.0f);
            path.lineTo(this.btn_left_X - 23.0f, this.btn_center_Y - 14.0f);
            path.close();
            canvas.drawPath(path, paint);
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(-16724992);
            paint.setStrokeWidth(4.0f);
            path.reset();
            path.moveTo(this.btn_right_X - 28.0f, this.btn_center_Y);
            path.lineTo(this.btn_right_X - 8.0f, this.btn_center_Y + 22.0f);
            path.lineTo(this.btn_right_X + 30.0f, this.btn_center_Y - 20.0f);
            path.lineTo(this.btn_right_X - 8.0f, this.btn_center_Y + 18.0f);
            path.close();
            canvas.drawPath(path, paint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (this.STATE_SELECTED == 0) {
                    if (!this.hideSomeView) {
                        if (!(event.getY() > this.btn_return_Y - 37.0f) || !(event.getY() < this.btn_return_Y + 10.0f) || !(event.getX() > this.btn_return_X - 37.0f) || !(event.getX() < this.btn_return_X + 37.0f)) break;
                        this.STATE_SELECTED = 6;
                        break;
                    }
                    if (!(event.getY() > this.btn_center_Y - this.btn_outside_radius) || !(event.getY() < this.btn_center_Y + this.btn_outside_radius) || !(event.getX() > this.btn_center_X - this.btn_outside_radius) || !(event.getX() < this.btn_center_X + this.btn_outside_radius) || event.getPointerCount() != 1) break;
                    this.key_down_Y = event.getY();
                    this.STATE_SELECTED = 1;
                    this.postCheckForLongTouch();
                    break;
                }
                if (this.STATE_SELECTED != 5 && this.STATE_SELECTED != 4) break;
                if (event.getY() > this.btn_center_Y - this.btn_result_radius && event.getY() < this.btn_center_Y + this.btn_result_radius && event.getX() > this.btn_left_X - this.btn_result_radius && event.getX() < this.btn_left_X + this.btn_result_radius && event.getPointerCount() == 1) {
                    this.retryRecord();
                    break;
                }
                if (!(event.getY() > this.btn_center_Y - this.btn_result_radius) || !(event.getY() < this.btn_center_Y + this.btn_result_radius) || !(event.getX() > this.btn_right_X - this.btn_result_radius) || !(event.getX() < this.btn_right_X + this.btn_result_radius) || event.getPointerCount() != 1) break;
                this.submitRecord();
                break;
            }
            case 2: {
                if (!(event.getY() > this.btn_center_Y - this.btn_outside_radius) || !(event.getY() < this.btn_center_Y + this.btn_outside_radius) || !(event.getX() > this.btn_center_X - this.btn_outside_radius) || event.getX() < this.btn_center_X + this.btn_outside_radius) {
                    // empty if block
                }
                if (this.mCaptureListener == null) break;
                this.mCaptureListener.scale(this.key_down_Y - event.getY());
                break;
            }
            case 1: {
                this.removeCallbacks(this.longPressRunnable);
                if (this.STATE_SELECTED == 6) {
                    if (this.hideSomeView || !(event.getY() > this.btn_return_Y - 37.0f) || !(event.getY() < this.btn_return_Y + 10.0f) || !(event.getX() > this.btn_return_X - 37.0f) || !(event.getX() < this.btn_return_X + 37.0f)) break;
                    this.STATE_SELECTED = 0;
                    if (this.mCaptureListener == null) break;
                    this.mCaptureListener.quit();
                    break;
                }
                if (this.STATE_SELECTED == 1) {
                    if (this.supportCapture) {
                        if (!(event.getY() > this.btn_center_Y - this.btn_outside_radius) || !(event.getY() < this.btn_center_Y + this.btn_outside_radius) || !(event.getX() > this.btn_center_X - this.btn_outside_radius) || !(event.getX() < this.btn_center_X + this.btn_outside_radius)) break;
                        this.capture();
                        break;
                    }
                    this.STATE_SELECTED = 0;
                    this.initCaptureButtonRadius();
                    this.invalidate();
                    break;
                }
                if (this.STATE_SELECTED != 3) break;
                this.recordEnd(true);
            }
        }
        return true;
    }

    public void captureSuccess() {
        this.captureAnimation(this.getWidth() / 5, this.getWidth() / 5 * 4);
    }

    private void postCheckForLongTouch() {
        this.postDelayed(this.longPressRunnable, 500L);
    }

    private void startAnimation(float outside_start, float outside_end, float inside_start, float inside_end) {
        ValueAnimator outside_anim = ValueAnimator.ofFloat((float[])new float[]{outside_start, outside_end});
        ValueAnimator inside_anim = ValueAnimator.ofFloat((float[])new float[]{inside_start, inside_end});
        outside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.btn_outside_radius = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        outside_anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (CaptureButton.this.STATE_SELECTED == 3) {
                    CaptureButton.this.post(CaptureButton.this.recordRunnable);
                }
            }
        });
        inside_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.btn_inside_radius = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        outside_anim.setDuration(100L);
        inside_anim.setDuration(100L);
        outside_anim.start();
        inside_anim.start();
    }

    private void captureAnimation(float left, float right) {
        ValueAnimator left_anim = ValueAnimator.ofFloat((float[])new float[]{this.btn_left_X, left});
        ValueAnimator right_anim = ValueAnimator.ofFloat((float[])new float[]{this.btn_right_X, right});
        left_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.btn_left_X = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        right_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                CaptureButton.this.btn_right_X = ((Float)animation.getAnimatedValue()).floatValue();
                CaptureButton.this.invalidate();
            }
        });
        left_anim.setDuration(200L);
        right_anim.setDuration(200L);
        left_anim.start();
        right_anim.start();
    }

    public void setCaptureListener(CaptureListener mCaptureListener) {
        this.mCaptureListener = mCaptureListener;
    }

    public void setSupportCapture(boolean support) {
        this.supportCapture = support;
    }

    public void setMaxRecordDuration(int duration) {
        this.maxDuration = duration;
        if (this.record_anim != null) {
            this.record_anim.setDuration((long)(this.maxDuration * 1000));
        }
    }

    public void submitRecord() {
        if (this.mCaptureListener != null) {
            if (this.STATE_SELECTED == 5) {
                this.mCaptureListener.getRecordResult();
            } else if (this.STATE_SELECTED == 4) {
                this.mCaptureListener.determine();
            }
        }
        this.btn_left_X = this.btn_center_X;
        this.btn_right_X = this.btn_center_X;
        this.invalidate();
    }

    public void retryRecord() {
        if (this.mCaptureListener != null) {
            if (this.STATE_SELECTED == 5) {
                this.mCaptureListener.deleteRecordResult();
            } else if (this.STATE_SELECTED == 4) {
                this.mCaptureListener.cancel();
            }
        }
        this.STATE_SELECTED = 0;
        this.btn_left_X = this.btn_center_X;
        this.btn_right_X = this.btn_center_X;
        this.invalidate();
    }

    private void capture() {
        if (this.supportCapture) {
            if (this.mCaptureListener != null) {
                this.mCaptureListener.capture();
            }
            this.STATE_SELECTED = 4;
        } else {
            this.STATE_SELECTED = 0;
            this.initCaptureButtonRadius();
            this.invalidate();
        }
    }

    private void recordEnd(boolean needAnimation) {
        long playTime = this.record_anim.getCurrentPlayTime();
        Log.d((String)"Sight-CaptureButton", (String)("recordEnd " + playTime));
        this.progress = 0.0f;
        this.captureProgressed = 0;
        if (!this.record_anim.isRunning() || playTime < 1000L) {
            Log.d((String)"Sight-CaptureButton", (String)"recordEnd-retryRecord()");
            if (needAnimation) {
                Toast.makeText((Context)this.mContext, (int)R.string.rc_sight_record_too_short_time, (int)0).show();
            }
            if (this.mCaptureListener != null) {
                this.mCaptureListener.retryRecord();
            }
            this.STATE_SELECTED = 0;
            this.record_anim.cancel();
            this.invalidate();
        } else {
            this.STATE_SELECTED = 5;
            this.removeCallbacks(this.recordRunnable);
            if (needAnimation) {
                this.captureAnimation(this.getWidth() / 5, this.getWidth() / 5 * 4);
            }
            this.record_anim.cancel();
            this.invalidate();
            if (this.mCaptureListener != null) {
                this.mCaptureListener.recordEnd(playTime);
            }
        }
        if (needAnimation) {
            if (this.btn_outside_radius == this.btn_after_outside_radius && this.btn_inside_radius == this.btn_after_inside_radius) {
                this.startAnimation(this.btn_after_outside_radius, this.btn_before_outside_radius, this.btn_after_inside_radius, this.btn_before_inside_radius);
            } else {
                this.startAnimation(this.btn_after_outside_radius, this.btn_before_outside_radius, this.btn_after_inside_radius, this.btn_before_inside_radius);
            }
        } else {
            this.initCaptureButtonRadius();
        }
    }

    public void onPause() {
        Log.d((String)"Sight-CaptureButton", (String)"onPause");
        this.removeCallbacks(this.longPressRunnable);
        if (this.STATE_SELECTED == 1) {
            this.capture();
        } else if (this.STATE_SELECTED == 3) {
            this.recordEnd(false);
        }
    }

    private void initCaptureButtonRadius() {
        this.btn_outside_radius = this.getResources().getDimension(R.dimen.sight_capture_button_circle_size_outer);
        this.btn_inside_radius = this.getResources().getDimension(R.dimen.sight_capture_button_circle_size_inner);
    }

    public static interface CaptureListener {
        public void capture();

        public void cancel();

        public void determine();

        public void quit();

        public void record();

        public void recordEnd(long var1);

        public void getRecordResult();

        public void deleteRecordResult();

        public void scale(float var1);

        public void recordProgress(int var1);

        public void retryRecord();
    }

    private class RecordRunnable
    implements Runnable {
        public RecordRunnable() {
            CaptureButton.this.record_anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    if (CaptureButton.this.STATE_SELECTED == 3) {
                        CaptureButton.this.progress = ((Float)animation.getAnimatedValue()).floatValue();
                        int newProgress = (int)(animation.getCurrentPlayTime() / 1000L);
                        if (newProgress != CaptureButton.this.captureProgressed) {
                            CaptureButton.this.captureProgressed = newProgress;
                            if (CaptureButton.this.mCaptureListener != null && CaptureButton.this.captureProgressed >= 1) {
                                CaptureButton.this.mCaptureListener.recordProgress(CaptureButton.this.captureProgressed);
                            }
                        }
                        CaptureButton.this.invalidate();
                    }
                }
            });
            CaptureButton.this.record_anim.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    if (CaptureButton.this.STATE_SELECTED == 3) {
                        CaptureButton.this.STATE_SELECTED = 5;
                        CaptureButton.this.progress = 0.0f;
                        CaptureButton.this.captureProgressed = 0;
                        CaptureButton.this.invalidate();
                        CaptureButton.this.captureAnimation(CaptureButton.this.getWidth() / 5, CaptureButton.this.getWidth() / 5 * 4);
                        if (CaptureButton.this.btn_outside_radius == CaptureButton.this.btn_after_outside_radius && CaptureButton.this.btn_inside_radius == CaptureButton.this.btn_after_inside_radius) {
                            CaptureButton.this.startAnimation(CaptureButton.this.btn_after_outside_radius, CaptureButton.this.btn_before_outside_radius, CaptureButton.this.btn_after_inside_radius, CaptureButton.this.btn_before_inside_radius);
                        } else {
                            CaptureButton.this.startAnimation(CaptureButton.this.btn_after_outside_radius, CaptureButton.this.btn_before_outside_radius, CaptureButton.this.btn_after_inside_radius, CaptureButton.this.btn_before_inside_radius);
                        }
                        if (CaptureButton.this.mCaptureListener != null) {
                            CaptureButton.this.mCaptureListener.recordEnd(CaptureButton.this.maxDuration * 1000);
                        }
                    }
                }
            });
            CaptureButton.this.record_anim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            CaptureButton.this.record_anim.setDuration((long)(CaptureButton.this.maxDuration * 1000));
            CaptureButton.this.record_anim.setStartDelay(1000L);
        }

        @Override
        public void run() {
            if (CaptureButton.this.mCaptureListener != null) {
                CaptureButton.this.mCaptureListener.record();
            }
            CaptureButton.this.record_anim.start();
        }
    }

    private class LongPressRunnable
    implements Runnable {
        private LongPressRunnable() {
        }

        @Override
        public void run() {
            CaptureButton.this.startAnimation(CaptureButton.this.btn_before_outside_radius, CaptureButton.this.btn_after_outside_radius, CaptureButton.this.btn_before_inside_radius, CaptureButton.this.btn_after_inside_radius);
            CaptureButton.this.STATE_SELECTED = 3;
        }
    }
}

