/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.record;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.VideoView;
import io.rong.common.RLog;
import io.rong.imkit.utilities.KitStorageUtils;
import io.rong.sight.R;
import io.rong.sight.record.AudioUtil;
import io.rong.sight.record.CameraFocusListener;
import io.rong.sight.record.CameraParamUtil;
import io.rong.sight.record.CaptureButton;
import io.rong.sight.record.FocusView;
import io.rong.sight.util.ValueAnimatorUtil;
import java.io.File;
import java.util.List;

public class CameraView
extends RelativeLayout
implements SurfaceHolder.Callback,
Camera.AutoFocusCallback,
CameraFocusListener,
SensorEventListener {
    public final String TAG = "Sight-CameraView";
    private PowerManager.WakeLock wakeLock;
    private Context mContext;
    private VideoView mVideoView;
    private ImageView mImageViewClose;
    private ImageView mImageViewSwitch;
    private FocusView mFocusView;
    private TextView mReminderToast;
    private TextView mTextViewProgress;
    private ImageView mImageViewRetry;
    private ImageView mImageViewSubmit;
    private ImageView mImageViewPlayControl;
    private CaptureButton mCaptureButton;
    private int iconWidth;
    private int iconMargin;
    private int controlIconWidth;
    private int controlIconMargin;
    private int controlIconMarginBottom;
    private String saveVideoPath = "";
    private String videoFileName = "";
    private MediaRecorder mediaRecorder;
    private SurfaceHolder mHolder;
    private Camera mCamera;
    private Camera.Parameters mParam;
    private boolean autoFocus;
    private boolean isPlay = false;
    private boolean isInPreviewState = false;
    private boolean needPause;
    private int playbackPosition = 0;
    private boolean isRecorder = false;
    private float screenProp;
    private boolean supportCapture = false;
    private int maxDuration = 10;
    private long recordDuration = 0L;
    private boolean paused;
    private String fileName;
    private Bitmap pictureBitmap;
    private int SELECTED_CAMERA;
    private CameraViewListener cameraViewListener;
    private int nowScaleRate = 0;
    private AudioManager audioManager;
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    private int mSensorRotation = 0;
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private static final int SENSOR_UPTATE_INTERVAL_TIME = 200;
    private long lastSensorUpdateTime;

    public CameraView(Context context) {
        this(context, null);
    }

    public CameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        PowerManager powerManager = (PowerManager)this.mContext.getSystemService("power");
        if (powerManager != null) {
            this.wakeLock = powerManager.newWakeLock(26, "sight:sightWakeLockTag");
        }
        this.SELECTED_CAMERA = 0;
        this.iconWidth = (int)this.getResources().getDimension(R.dimen.sight_record_top_icon_size);
        this.iconMargin = (int)this.getResources().getDimension(R.dimen.sight_record_top_icon_margin);
        this.controlIconWidth = (int)this.getResources().getDimension(R.dimen.sight_record_control_icon_size);
        this.controlIconMargin = (int)this.getResources().getDimension(R.dimen.sight_record_control_icon_margin_left);
        this.controlIconMarginBottom = (int)this.getResources().getDimension(R.dimen.sight_record_control_icon_margin_bottom);
        this.initView();
        this.mHolder = this.mVideoView.getHolder();
        this.mHolder.addCallback((SurfaceHolder.Callback)this);
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
            }
        };
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        if (this.mSensorManager != null) {
            this.mSensor = this.mSensorManager.getDefaultSensor(1);
        }
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.mCaptureButton.setCaptureListener(new CaptureButton.CaptureListener(){

            @Override
            public void capture() {
                if (CameraView.this.supportCapture) {
                    CameraView.this.capture();
                }
            }

            @Override
            public void cancel() {
                CameraView.this.mImageViewSwitch.setVisibility(0);
                CameraView.this.releaseCamera();
                CameraView.this.mCamera = CameraView.this.getCamera(CameraView.this.SELECTED_CAMERA);
                CameraView.this.setStartPreview(CameraView.this.mCamera, CameraView.this.mHolder);
                CameraView.this.recordDuration = 0L;
            }

            @Override
            public void determine() {
                if (CameraView.this.cameraViewListener != null) {
                    CameraView.this.cameraViewListener.captureSuccess(CameraView.this.pictureBitmap);
                }
                CameraView.this.mImageViewSwitch.setVisibility(0);
                CameraView.this.releaseCamera();
                CameraView.this.mCamera = CameraView.this.getCamera(CameraView.this.SELECTED_CAMERA);
                CameraView.this.setStartPreview(CameraView.this.mCamera, CameraView.this.mHolder);
            }

            @Override
            public void quit() {
                if (CameraView.this.cameraViewListener != null) {
                    CameraView.this.cameraViewListener.quit();
                }
            }

            @Override
            public void record() {
                CameraView.this.recordDuration = 0L;
                CameraView.this.needPause = false;
                CameraView.this.mReminderToast.setVisibility(8);
                CameraView.this.startRecord();
                CameraView.this.mImageViewClose.setVisibility(8);
                CameraView.this.mImageViewSwitch.setVisibility(8);
            }

            @Override
            public void recordEnd(long duration) {
                CameraView.this.recordDuration = duration;
                CameraView.this.isInPreviewState = true;
                CameraView.this.stopRecord();
                CameraView.this.mTextViewProgress.setVisibility(8);
                CameraView.this.needPause = true;
                CameraView.this.playRecord();
                CameraView.this.setRecordControlViewVisibility(true);
                CameraView.this.mImageViewSubmit.setEnabled(true);
                CameraView.this.mImageViewRetry.setEnabled(true);
            }

            @Override
            public void getRecordResult() {
                if (CameraView.this.cameraViewListener != null) {
                    CameraView.this.cameraViewListener.recordSuccess(CameraView.this.fileName, Math.round((float)CameraView.this.recordDuration * 1.0f / 1000.0f));
                }
            }

            @Override
            public void deleteRecordResult() {
                CameraView.this.deleteRecordFile();
                CameraView.this.mVideoView.stopPlayback();
                CameraView.this.releaseCamera();
                if (!CameraView.this.paused) {
                    CameraView.this.mCamera = CameraView.this.getCamera(CameraView.this.SELECTED_CAMERA);
                    CameraView.this.setStartPreview(CameraView.this.mCamera, CameraView.this.mHolder);
                }
                CameraView.this.isPlay = false;
                CameraView.this.isInPreviewState = false;
                CameraView.this.recordDuration = 0L;
                CameraView.this.needPause = false;
                CameraView.this.setRecordControlViewVisibility(false);
                CameraView.this.mTextViewProgress.setVisibility(8);
                CameraView.this.updateReminderView();
            }

            @Override
            public void scale(float scaleValue) {
                int scaleRate;
                if (CameraView.this.mCamera == null || CameraView.this.mParam == null || !CameraView.this.mParam.isZoomSupported()) {
                    return;
                }
                if (scaleValue >= 0.0f && (scaleRate = (int)(scaleValue / 50.0f)) < CameraView.this.mParam.getMaxZoom() && scaleRate >= 0 && CameraView.this.nowScaleRate != scaleRate) {
                    try {
                        CameraView.this.mParam.setZoom(scaleRate);
                        CameraView.this.mCamera.setParameters(CameraView.this.mParam);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    CameraView.this.nowScaleRate = scaleRate;
                }
            }

            @Override
            public void recordProgress(int progress) {
                CameraView.this.updateProgressView(progress);
            }

            @Override
            public void retryRecord() {
                CameraView.this.stopRecord();
                CameraView.this.deleteRecordFile();
                CameraView.this.mVideoView.stopPlayback();
                CameraView.this.releaseCamera();
                if (!CameraView.this.paused) {
                    CameraView.this.mCamera = CameraView.this.getCamera(CameraView.this.SELECTED_CAMERA);
                    CameraView.this.setStartPreview(CameraView.this.mCamera, CameraView.this.mHolder);
                    CameraView.this.setRecordControlViewVisibility(false);
                }
                CameraView.this.mTextViewProgress.setVisibility(8);
                CameraView.this.recordDuration = 0L;
            }
        });
    }

    public void setCameraViewListener(CameraViewListener cameraViewListener) {
        this.cameraViewListener = cameraViewListener;
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.setBackgroundColor(-16777216);
        this.mVideoView = new VideoView(this.mContext);
        RelativeLayout.LayoutParams videoViewParam = new RelativeLayout.LayoutParams(-1, -2);
        videoViewParam.addRule(13, -1);
        this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        this.mVideoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CameraView.this.mCamera != null) {
                    RLog.i((String)"Sight-CameraView", (String)"Touch To Focus");
                    CameraView.this.mCamera.autoFocus((Camera.AutoFocusCallback)CameraView.this);
                }
            }
        });
        this.autoFocus = true;
        RelativeLayout.LayoutParams btnParams = new RelativeLayout.LayoutParams(-2, -2);
        btnParams.addRule(14, -1);
        btnParams.addRule(12, -1);
        this.mCaptureButton = new CaptureButton(this.mContext);
        this.mCaptureButton.setLayoutParams((ViewGroup.LayoutParams)btnParams);
        this.mCaptureButton.setId(R.id.rc_sight_record_bottom);
        this.mCaptureButton.setSupportCapture(this.supportCapture);
        ValueAnimatorUtil.resetDurationScaleIfDisable();
        this.mFocusView = new FocusView(this.mContext, 120);
        this.mFocusView.setVisibility(4);
        this.initReminderView();
        this.initCloseView();
        this.initSwitchView();
        this.initProgressView();
        this.initRetryView();
        this.initSubmitView();
        this.initPlayControlView();
        this.addView((View)this.mVideoView);
        this.addView(this.mCaptureButton);
        this.addView((View)this.mImageViewClose);
        this.addView((View)this.mImageViewSwitch);
        this.addView((View)this.mReminderToast);
        this.addView(this.mFocusView);
        this.addView((View)this.mTextViewProgress);
        this.addView((View)this.mImageViewRetry);
        this.addView((View)this.mImageViewSubmit);
        this.addView((View)this.mImageViewPlayControl);
        this.updateReminderView();
    }

    private void initReminderView() {
        this.mReminderToast = new TextView(this.mContext);
        this.mReminderToast.setText(R.string.rc_sight_reminder);
        this.mReminderToast.setTextColor(this.getResources().getColor(R.color.color_sight_white));
        this.mReminderToast.setTextSize(0, this.getResources().getDimension(R.dimen.sight_text_size_14));
        this.mReminderToast.setShadowLayer(16.0f, 0.0f, 2.0f, this.getResources().getColor(R.color.color_sight_record_reminder_shadow));
        int paddingHorizontal = (int)this.getResources().getDimension(R.dimen.sight_text_view_padding_horizontal);
        int paddingVertical = (int)this.getResources().getDimension(R.dimen.sight_text_view_padding_vertical);
        this.mReminderToast.setPadding(paddingHorizontal, paddingVertical, paddingHorizontal, paddingVertical);
        RelativeLayout.LayoutParams toastParams = new RelativeLayout.LayoutParams(-2, -2);
        toastParams.addRule(14, -1);
        toastParams.addRule(2, this.mCaptureButton.getId());
        this.mReminderToast.setLayoutParams((ViewGroup.LayoutParams)toastParams);
    }

    private void updateReminderView() {
        this.mReminderToast.setVisibility(0);
        this.mReminderToast.postDelayed(new Runnable(){

            @Override
            public void run() {
                CameraView.this.mReminderToast.setVisibility(8);
            }
        }, 5000L);
    }

    private void initCloseView() {
        this.mImageViewClose = new ImageView(this.mContext);
        RelativeLayout.LayoutParams imageViewCloseParam = new RelativeLayout.LayoutParams(this.iconWidth, this.iconWidth);
        imageViewCloseParam.addRule(9, -1);
        imageViewCloseParam.setMargins(this.iconMargin, this.iconMargin, 0, 0);
        this.mImageViewClose.setLayoutParams((ViewGroup.LayoutParams)imageViewCloseParam);
        this.mImageViewClose.setImageResource(R.drawable.rc_ic_sight_close);
        this.mImageViewClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CameraView.this.releaseCamera();
                if (CameraView.this.cameraViewListener != null) {
                    CameraView.this.cameraViewListener.quit();
                }
            }
        });
    }

    private void initSwitchView() {
        this.mImageViewSwitch = new ImageView(this.mContext);
        RelativeLayout.LayoutParams imageViewSwitchParam = new RelativeLayout.LayoutParams(this.iconWidth, this.iconWidth);
        imageViewSwitchParam.addRule(11, -1);
        imageViewSwitchParam.setMargins(0, this.iconMargin, this.iconMargin, 0);
        this.mImageViewSwitch.setLayoutParams((ViewGroup.LayoutParams)imageViewSwitchParam);
        this.mImageViewSwitch.setImageResource(R.drawable.rc_ic_sight_switch);
        this.mImageViewSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CameraView.this.mCamera != null) {
                    CameraView.this.releaseCamera();
                    if (CameraView.this.SELECTED_CAMERA == 0) {
                        CameraView.this.SELECTED_CAMERA = 1;
                    } else {
                        CameraView.this.SELECTED_CAMERA = 0;
                    }
                    CameraView.this.mCamera = CameraView.this.getCamera(CameraView.this.SELECTED_CAMERA);
                    CameraView.this.setStartPreview(CameraView.this.mCamera, CameraView.this.mHolder);
                }
            }
        });
    }

    private void initProgressView() {
        this.mTextViewProgress = new TextView(this.mContext);
        this.mTextViewProgress.setVisibility(8);
        this.mTextViewProgress.setTextColor(this.getResources().getColor(R.color.color_sight_white));
        RelativeLayout.LayoutParams progressParams = new RelativeLayout.LayoutParams(-2, -2);
        progressParams.addRule(14, -1);
        progressParams.addRule(2, this.mCaptureButton.getId());
        this.mTextViewProgress.setLayoutParams((ViewGroup.LayoutParams)progressParams);
    }

    private void initRetryView() {
        this.mImageViewRetry = new ImageView(this.mContext);
        RelativeLayout.LayoutParams imageViewRetryParam = new RelativeLayout.LayoutParams(this.controlIconWidth, this.controlIconWidth);
        imageViewRetryParam.addRule(9, -1);
        imageViewRetryParam.addRule(12, -1);
        imageViewRetryParam.setMargins(this.controlIconMargin, 0, 0, this.controlIconMarginBottom);
        this.mImageViewRetry.setLayoutParams((ViewGroup.LayoutParams)imageViewRetryParam);
        this.mImageViewRetry.setImageResource(R.drawable.rc_ic_sight_record_retry);
        this.mImageViewRetry.setVisibility(8);
        this.mImageViewRetry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CameraView.this.mImageViewSubmit.setEnabled(false);
                CameraView.this.mCaptureButton.retryRecord();
            }
        });
    }

    private void initSubmitView() {
        this.mImageViewSubmit = new ImageView(this.mContext);
        RelativeLayout.LayoutParams imageViewSubmitParam = new RelativeLayout.LayoutParams(this.controlIconWidth, this.controlIconWidth);
        imageViewSubmitParam.addRule(11, -1);
        imageViewSubmitParam.addRule(12, -1);
        imageViewSubmitParam.setMargins(0, 0, this.controlIconMargin, this.controlIconMarginBottom);
        this.mImageViewSubmit.setLayoutParams((ViewGroup.LayoutParams)imageViewSubmitParam);
        this.mImageViewSubmit.setImageResource(R.drawable.rc_ic_sight_record_submit);
        this.mImageViewSubmit.setVisibility(8);
        this.mImageViewSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CameraView.this.mImageViewRetry.setEnabled(false);
                CameraView.this.mCaptureButton.submitRecord();
            }
        });
    }

    private void initPlayControlView() {
        this.mImageViewPlayControl = new ImageView(this.mContext);
        RelativeLayout.LayoutParams imageViewPlayControlParam = new RelativeLayout.LayoutParams(this.controlIconWidth, this.controlIconWidth);
        imageViewPlayControlParam.addRule(14, -1);
        imageViewPlayControlParam.addRule(12, -1);
        imageViewPlayControlParam.setMargins(0, 0, 0, this.controlIconMarginBottom);
        this.mImageViewPlayControl.setLayoutParams((ViewGroup.LayoutParams)imageViewPlayControlParam);
        this.mImageViewPlayControl.setImageResource(R.drawable.rc_ic_sight_record_play);
        this.mImageViewPlayControl.setVisibility(8);
        this.mImageViewPlayControl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CameraView.this.isPlay) {
                    CameraView.this.pauseRecord();
                } else {
                    CameraView.this.playRecord();
                }
            }
        });
    }

    private void updateProgressView(int progress) {
        if (this.mTextViewProgress != null) {
            this.mTextViewProgress.setVisibility(0);
            this.mTextViewProgress.setText((CharSequence)(progress + "\""));
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    private Camera getCamera(int position) {
        Camera camera;
        try {
            camera = Camera.open((int)position);
        }
        catch (Exception e) {
            camera = null;
            e.printStackTrace();
        }
        return camera;
    }

    private void setStartPreview(Camera camera, SurfaceHolder holder) {
        if (camera == null) {
            RLog.e((String)"Sight-CameraView", (String)"Camera is null");
            return;
        }
        try {
            this.mParam = camera.getParameters();
            Camera.Size preferSize = this.getOptimalSize(this.mParam.getSupportedVideoSizes(), 1280, 720);
            Camera.Size previewSize = CameraParamUtil.getInstance().getPreviewSize(this.mParam.getSupportedPreviewSizes(), 1000, this.screenProp, preferSize);
            if (previewSize == null) {
                previewSize = this.mParam.getPreviewSize();
            }
            if (previewSize != null) {
                this.mParam.setPreviewSize(previewSize.width, previewSize.height);
            }
            if (this.supportCapture) {
                Camera.Size pictureSize = CameraParamUtil.getInstance().getPictureSize(this.mParam.getSupportedPictureSizes(), 1200, this.screenProp);
                this.mParam.setPictureSize(pictureSize.width, pictureSize.height);
                if (CameraParamUtil.getInstance().isSupportedPictureFormats(this.mParam.getSupportedPictureFormats(), 256)) {
                    this.mParam.setPictureFormat(256);
                    this.mParam.setJpegQuality(100);
                }
            }
            this.cameraAutoFocus(camera, this.mParam);
            this.mParam = camera.getParameters();
            camera.setPreviewDisplay(holder);
            camera.setDisplayOrientation(this.calculateCameraPreviewOrientation());
            camera.startPreview();
        }
        catch (Exception e) {
            RLog.e((String)"Sight-CameraView", (String)"startPreview failed");
            e.printStackTrace();
        }
    }

    private void cameraAutoFocus(Camera pCamera, Camera.Parameters pParam) {
        if (CameraParamUtil.getInstance().isSupportedFocusMode(this.mParam.getSupportedFocusModes(), "continuous-video")) {
            pParam.setFocusMode("continuous-video");
        }
        pCamera.setParameters(pParam);
        pCamera.cancelAutoFocus();
    }

    private void releaseCamera() {
        if (this.mCamera != null) {
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void capture() {
        if (!this.supportCapture) {
            return;
        }
        if (this.autoFocus) {
            this.mCamera.autoFocus((Camera.AutoFocusCallback)this);
        } else if (this.SELECTED_CAMERA == 0) {
            this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    Matrix matrix = new Matrix();
                    matrix.setRotate(90.0f);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    CameraView.this.pictureBitmap = bitmap;
                    CameraView.this.mImageViewSwitch.setVisibility(4);
                    CameraView.this.mCaptureButton.captureSuccess();
                }
            });
        } else if (this.SELECTED_CAMERA == 1) {
            this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                public void onPictureTaken(byte[] data, Camera camera) {
                    Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                    Matrix matrix = new Matrix();
                    matrix.setRotate(270.0f);
                    matrix.postScale(-1.0f, 1.0f);
                    bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    CameraView.this.pictureBitmap = bitmap;
                    CameraView.this.mImageViewSwitch.setVisibility(4);
                    CameraView.this.mCaptureButton.captureSuccess();
                }
            });
        }
    }

    public void onAutoFocus(boolean success, Camera camera) {
        this.cameraAutoFocus(camera, this.mParam);
        if (this.autoFocus) {
            if (this.SELECTED_CAMERA == 0 && success) {
                this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                        Matrix matrix = new Matrix();
                        matrix.setRotate(90.0f);
                        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                        CameraView.this.pictureBitmap = bitmap;
                        CameraView.this.mImageViewSwitch.setVisibility(4);
                        CameraView.this.mCaptureButton.captureSuccess();
                    }
                });
            } else if (this.SELECTED_CAMERA == 1) {
                this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                        Matrix matrix = new Matrix();
                        matrix.setRotate(270.0f);
                        matrix.postScale(-1.0f, 1.0f);
                        bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                        CameraView.this.pictureBitmap = bitmap;
                        CameraView.this.mImageViewSwitch.setVisibility(4);
                        CameraView.this.mCaptureButton.captureSuccess();
                    }
                });
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.screenProp = heightSize / widthSize;
    }

    public void surfaceCreated(SurfaceHolder holder) {
        RLog.i((String)"Sight-CameraView", (String)"surfaceCreated");
        if (!this.isInPreviewState && !this.paused) {
            this.setStartPreview(this.mCamera, holder);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        RLog.i((String)"Sight-CameraView", (String)"surfaceChanged");
        this.mHolder = holder;
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        RLog.i((String)"Sight-CameraView", (String)"surfaceDestroyed");
        if (this.cameraViewListener != null) {
            this.cameraViewListener.quit();
        }
        this.releaseCamera();
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
    }

    public void onResume() {
        RLog.i((String)"Sight-CameraView", (String)("onResume isInPreviewState = " + this.isInPreviewState));
        this.mCamera = this.getCamera(this.SELECTED_CAMERA);
        if (this.mCamera != null) {
            RLog.i((String)"Sight-CameraView", (String)("Camera = " + this.mCamera));
        } else {
            RLog.i((String)"Sight-CameraView", (String)"Camera is null!");
        }
        if (this.isInPreviewState) {
            this.mVideoView.resume();
        } else {
            this.paused = false;
        }
        if (this.wakeLock != null) {
            this.wakeLock.acquire(600000L);
        }
        if (this.mSensorManager != null) {
            this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
        }
    }

    public void onPause() {
        RLog.i((String)"Sight-CameraView", (String)"onPause");
        this.paused = true;
        this.mCaptureButton.onPause();
        this.releaseCamera();
        if (this.isInPreviewState) {
            this.playbackPosition = this.mVideoView.getCurrentPosition();
        }
        if (this.wakeLock != null) {
            this.wakeLock.release();
        }
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this, this.mSensor);
        }
    }

    private void startRecord() {
        RLog.i((String)"Sight-CameraView", (String)"startRecord");
        if (this.isRecorder) {
            try {
                this.mediaRecorder.stop();
                this.mediaRecorder.release();
            }
            catch (IllegalStateException e) {
                RLog.e((String)"Sight-CameraView", (String)"mediaRecorder got IllegalStateException", (Throwable)e);
                this.mediaRecorder = null;
                this.mediaRecorder = new MediaRecorder();
                this.mediaRecorder.stop();
                this.mediaRecorder.release();
            }
            catch (Exception e) {
                RLog.e((String)"Sight-CameraView", (String)"mediaRecorder got exception", (Throwable)e);
            }
            this.mediaRecorder = null;
        }
        if (this.mCamera == null) {
            RLog.i((String)"Sight-CameraView", (String)"Camera is null");
            this.stopRecord();
            return;
        }
        this.mCamera.unlock();
        try {
            if (this.mediaRecorder == null) {
                this.mediaRecorder = new MediaRecorder();
            }
            this.mediaRecorder.reset();
            this.mediaRecorder.setCamera(this.mCamera);
            this.mediaRecorder.setVideoSource(1);
            this.mediaRecorder.setAudioSource(1);
            this.mediaRecorder.setOutputFormat(2);
            this.mediaRecorder.setVideoEncoder(2);
            this.mediaRecorder.setAudioEncoder(3);
            if (this.mParam == null) {
                this.mParam = this.mCamera.getParameters();
            }
            Camera camera = this.mCamera;
            camera.getClass();
            Camera.Size preferSize = new Camera.Size(camera, 1280, 720);
            Camera.Size videoSize = CameraParamUtil.getInstance().getVideoSize(this.mParam.getSupportedVideoSizes(), 1000, this.screenProp, preferSize);
            if (videoSize == null) {
                String[] sizes;
                RLog.d((String)"Sight-CameraView", (String)"mParam.getSupportedVideoSizes() return null");
                String defaultVideoSize = this.mParam.get("video-size");
                if (defaultVideoSize != null && (sizes = defaultVideoSize.split("x")).length == 2) {
                    try {
                        Camera camera2 = this.mCamera;
                        camera2.getClass();
                        videoSize = new Camera.Size(camera2, Integer.parseInt(sizes[0]), Integer.parseInt(sizes[1]));
                    }
                    catch (NumberFormatException e) {
                        RLog.e((String)"Sight-CameraView", (String)"get video-size got NumberFormatException");
                    }
                }
            }
            if (videoSize != null) {
                this.mediaRecorder.setVideoSize(videoSize.width, videoSize.height);
            }
            int rotation = (this.calculateCameraPreviewOrientation() + this.mSensorRotation) % 360;
            if (this.SELECTED_CAMERA == 1) {
                rotation = (360 - rotation) % 360;
            }
            this.mediaRecorder.setOrientationHint(rotation);
            this.mediaRecorder.setMaxDuration(this.maxDuration * 1000);
            this.mediaRecorder.setVideoEncodingBitRate(0x300000);
            this.mediaRecorder.setPreviewDisplay(this.mHolder.getSurface());
            this.videoFileName = "video_" + System.currentTimeMillis() + ".mp4";
            if (this.saveVideoPath.equals("")) {
                this.saveVideoPath = KitStorageUtils.getVideoSavePath((Context)this.getContext());
            }
            this.mediaRecorder.setOutputFile(this.saveVideoPath + "/" + this.videoFileName);
            this.mediaRecorder.prepare();
            this.mediaRecorder.start();
            this.isRecorder = true;
            this.updateProgressView(0);
        }
        catch (Exception e) {
            RLog.e((String)"Sight-CameraView", (String)"startRecord got exception");
            e.printStackTrace();
        }
    }

    private void stopRecord() {
        RLog.i((String)"Sight-CameraView", (String)"stopRecord");
        if (this.mediaRecorder != null) {
            this.mediaRecorder.setOnErrorListener(null);
            this.mediaRecorder.setOnInfoListener(null);
            this.mediaRecorder.setPreviewDisplay(null);
            try {
                this.mediaRecorder.stop();
                this.mediaRecorder.release();
            }
            catch (Exception e) {
                RLog.e((String)"Sight-CameraView", (String)"stopRecord got exception");
                e.printStackTrace();
            }
            finally {
                this.isRecorder = false;
                this.mediaRecorder = null;
            }
            this.releaseCamera();
            this.fileName = this.saveVideoPath + "/" + this.videoFileName;
            if (this.isInPreviewState) {
                if (Build.VERSION.SDK_INT >= 26) {
                    this.mVideoView.setAudioFocusRequest(0);
                }
                try {
                    this.mVideoView.setVideoPath(this.fileName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void playRecord() {
        RLog.i((String)"Sight-CameraView", (String)("playRecord needPause:" + this.needPause));
        if (!this.needPause) {
            this.isPlay = true;
            this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 3, 2);
        } else {
            this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        }
        this.mImageViewPlayControl.setImageResource(this.needPause ? R.drawable.rc_ic_sight_record_play : R.drawable.rc_ic_sight_record_pause);
        try {
            this.mVideoView.start();
            this.mVideoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    RLog.i((String)"Sight-CameraView", (String)"playRecord mVideoView onPrepared ");
                    if (mp == null) {
                        return;
                    }
                    int duration = mp.getDuration();
                    if (duration > 1000) {
                        CameraView.this.recordDuration = duration;
                    }
                    if (CameraView.this.paused) {
                        CameraView.this.isPlay = true;
                        CameraView.this.needPause = false;
                        CameraView.this.paused = false;
                        CameraView.this.mImageViewPlayControl.setImageResource(R.drawable.rc_ic_sight_record_pause);
                    }
                    try {
                        if (CameraView.this.playbackPosition > 0 || CameraView.this.needPause) {
                            mp.seekTo(CameraView.this.playbackPosition);
                            mp.setOnSeekCompleteListener(new MediaPlayer.OnSeekCompleteListener(){

                                public void onSeekComplete(MediaPlayer mp) {
                                    if (CameraView.this.isInPreviewState && !CameraView.this.isPlay || CameraView.this.needPause) {
                                        CameraView.this.needPause = false;
                                        mp.pause();
                                    }
                                }
                            });
                            CameraView.this.playbackPosition = 0;
                        }
                        if (!CameraView.this.needPause) {
                            mp.start();
                        }
                        mp.setLooping(true);
                        mp.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                            public boolean onError(MediaPlayer mp, int what, int extra) {
                                RLog.e((String)"Sight-CameraView", (String)("record play error on MediaPlayer onPrepared ,what = " + what + " extra = " + extra));
                                return true;
                            }
                        });
                    }
                    catch (Exception e) {
                        RLog.e((String)"Sight-CameraView", (String)"mVideoView onPrepared got error");
                        e.printStackTrace();
                    }
                }
            });
            this.mVideoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    if (mp != null) {
                        mp.setDisplay(null);
                        mp.reset();
                        mp.setDisplay(CameraView.this.mVideoView.getHolder());
                    }
                    if (Build.VERSION.SDK_INT >= 26) {
                        CameraView.this.mVideoView.setAudioFocusRequest(0);
                    }
                    try {
                        CameraView.this.mVideoView.setVideoPath(CameraView.this.fileName);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    CameraView.this.mVideoView.start();
                }
            });
            this.mVideoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                public boolean onError(MediaPlayer mp, int what, int extra) {
                    RLog.e((String)"Sight-CameraView", (String)("record play error,what = " + what + " extra = " + extra));
                    CameraView.this.mImageViewSubmit.setEnabled(false);
                    return true;
                }
            });
        }
        catch (Exception e) {
            this.mImageViewSubmit.setEnabled(false);
            RLog.e((String)"Sight-CameraView", (String)"mVideoView play error");
            e.printStackTrace();
        }
    }

    private void pauseRecord() {
        RLog.i((String)"Sight-CameraView", (String)"pauseRecord");
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.mImageViewPlayControl.setImageResource(R.drawable.rc_ic_sight_record_play);
        this.mVideoView.pause();
        this.isPlay = false;
    }

    public void setSaveVideoPath(String saveVideoPath) {
        this.saveVideoPath = saveVideoPath;
    }

    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }

    @Override
    public void onFocusBegin(float x, float y) {
        this.mFocusView.setVisibility(0);
        this.mFocusView.setX(x - (float)this.mFocusView.getWidth() / 2.0f);
        this.mFocusView.setY(y - (float)this.mFocusView.getHeight() / 2.0f);
        if (this.mCamera != null) {
            try {
                this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                    public void onAutoFocus(boolean success, Camera camera) {
                        CameraView.this.cameraAutoFocus(camera, CameraView.this.mParam);
                        if (success) {
                            CameraView.this.onFocusEnd();
                        }
                    }
                });
            }
            catch (Exception e) {
                RLog.e((String)"Sight-CameraView", (String)"autoFocus failed ");
                this.onFocusEnd();
            }
        }
    }

    @Override
    public void onFocusEnd() {
        this.mFocusView.setVisibility(4);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.autoFocus && event.getAction() == 0 && this.SELECTED_CAMERA == 0 && !this.isInPreviewState) {
            this.onFocusBegin(event.getX(), event.getY());
        }
        return super.onTouchEvent(event);
    }

    public void cancelAudio() {
        AudioUtil.setAudioManage(this.mContext);
    }

    public void setSupportCapture(boolean support) {
        this.supportCapture = support;
        if (this.mCaptureButton != null) {
            this.mCaptureButton.setSupportCapture(support);
        }
    }

    public void setMaxRecordDuration(int duration) {
        this.maxDuration = duration;
        if (this.mCaptureButton != null) {
            this.mCaptureButton.setMaxRecordDuration(duration);
        }
    }

    private void setRecordControlViewVisibility(boolean visual) {
        this.mImageViewClose.setVisibility(visual ? 8 : 0);
        this.mImageViewSwitch.setVisibility(visual ? 8 : 0);
        this.mImageViewSubmit.setVisibility(visual ? 0 : 8);
        this.mImageViewRetry.setVisibility(visual ? 0 : 8);
        this.mImageViewPlayControl.setVisibility(visual ? 0 : 8);
    }

    private void deleteRecordFile() {
        File file;
        if (this.fileName == null || TextUtils.isEmpty((CharSequence)this.fileName)) {
            this.fileName = this.saveVideoPath + "/" + this.videoFileName;
        }
        if ((file = new File(this.fileName)).exists()) {
            file.delete();
        }
    }

    private Camera.Size getOptimalSize(@NonNull List<Camera.Size> sizes, int w, int h) {
        double ASPECT_TOLERANCE = 0.1;
        double targetRatio = (double)h / (double)w;
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.1 || !((double)Math.abs(size.height - h) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - h);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - h) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - h);
            }
        }
        return optimalSize;
    }

    private int calculateCameraPreviewOrientation() {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.SELECTED_CAMERA, (Camera.CameraInfo)info);
        int rotation = ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        RLog.d((String)"Sight-CameraView", (String)("calculateCameraPreviewOrientation result:" + result));
        return result;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() != 1) {
            return;
        }
        long currentUpdateTime = System.currentTimeMillis();
        long timeInterval = currentUpdateTime - this.lastSensorUpdateTime;
        if (timeInterval < 200L) {
            return;
        }
        this.lastSensorUpdateTime = currentUpdateTime;
        float x = event.values[0];
        float y = event.values[1];
        if (Math.abs(x) > 6.0f && Math.abs(y) < 4.0f) {
            this.mSensorRotation = x > 0.0f ? 270 : 90;
        } else if (Math.abs(y) > 6.0f && Math.abs(x) < 4.0f) {
            this.mSensorRotation = y > 0.0f ? 0 : 180;
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public static interface CameraViewListener {
        public void quit();

        public void captureSuccess(Bitmap var1);

        public void recordSuccess(String var1, int var2);
    }
}

