/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.record;

import android.hardware.Camera;
import android.util.Log;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CameraParamUtil {
    private static final String TAG = "Sight-CameraView";
    private CameraSizeComparator sizeComparator = new CameraSizeComparator();
    private static CameraParamUtil cameraParamUtil = null;

    private CameraParamUtil() {
    }

    public static CameraParamUtil getInstance() {
        if (cameraParamUtil == null) {
            cameraParamUtil = new CameraParamUtil();
            return cameraParamUtil;
        }
        return cameraParamUtil;
    }

    public Camera.Size getPreviewSize(List<Camera.Size> list, int th, float rate, Camera.Size preferSize) {
        if (list == null) {
            return null;
        }
        Camera.Size prefer = this.getPreferSize(list, preferSize);
        if (prefer != null) {
            return prefer;
        }
        Collections.sort(list, this.sizeComparator);
        int i = 0;
        for (Camera.Size s : list) {
            if (s.width > th && this.equalRate(s, rate)) {
                Log.i((String)TAG, (String)("MakeSure Preview :w = " + s.width + " h = " + s.height));
                break;
            }
            ++i;
        }
        if (i == list.size()) {
            return this.getBestSize(list, rate);
        }
        return list.get(i);
    }

    public Camera.Size getVideoSize(List<Camera.Size> list, int th, float rate, Camera.Size preferSize) {
        if (list == null) {
            return null;
        }
        Camera.Size prefer = this.getPreferSize(list, preferSize);
        if (prefer != null) {
            return prefer;
        }
        return this.getPictureSize(list, th, rate);
    }

    public Camera.Size getPictureSize(List<Camera.Size> list, int th, float rate) {
        if (list == null) {
            return null;
        }
        Collections.sort(list, this.sizeComparator);
        int i = 0;
        for (Camera.Size s : list) {
            if (s.width > th && this.equalRate(s, rate)) {
                Log.i((String)TAG, (String)("MakeSure Picture :w = " + s.width + " h = " + s.height));
                break;
            }
            ++i;
        }
        if (i == list.size()) {
            return this.getBestSize(list, rate);
        }
        return list.get(i);
    }

    public Camera.Size getBestSize(List<Camera.Size> list, float rate) {
        float previewDisparity = 100.0f;
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            Camera.Size cur = list.get(i);
            float prop = (float)cur.width / (float)cur.height;
            if (!(Math.abs(rate - prop) < previewDisparity)) continue;
            previewDisparity = Math.abs(rate - prop);
            index = i;
        }
        return list.get(index);
    }

    public boolean equalRate(Camera.Size s, float rate) {
        float r = (float)s.width / (float)s.height;
        return (double)Math.abs(r - rate) <= 0.2;
    }

    public boolean isSupportedFocusMode(List<String> focusList, String focusMode) {
        for (int i = 0; i < focusList.size(); ++i) {
            if (!focusMode.equals(focusList.get(i))) continue;
            Log.i((String)TAG, (String)("FocusMode supported " + focusMode));
            return true;
        }
        Log.i((String)TAG, (String)("FocusMode not supported " + focusMode));
        return false;
    }

    public boolean isSupportedPictureFormats(List<Integer> supportedPictureFormats, int jpeg) {
        for (int i = 0; i < supportedPictureFormats.size(); ++i) {
            if (jpeg != supportedPictureFormats.get(i)) continue;
            Log.i((String)TAG, (String)("Formats supported " + jpeg));
            return true;
        }
        Log.i((String)TAG, (String)("Formats not supported " + jpeg));
        return false;
    }

    public Camera.Size getPreferSize(List<Camera.Size> list, Camera.Size preferSize) {
        for (Camera.Size size : list) {
            if (!size.equals((Object)preferSize)) continue;
            return preferSize;
        }
        return null;
    }

    public class CameraSizeComparator
    implements Comparator<Camera.Size> {
        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            if (lhs.width == rhs.width) {
                return 0;
            }
            if (lhs.width > rhs.width) {
                return 1;
            }
            return -1;
        }
    }
}

