/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.player;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

class Util {
    Util() {
    }

    public static String getDurationString(long durationMs) {
        return String.format(Locale.getDefault(), "%s%02d:%02d", "", TimeUnit.MILLISECONDS.toMinutes(durationMs), TimeUnit.MILLISECONDS.toSeconds(durationMs) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(durationMs)));
    }

    public static boolean isColorDark(int color) {
        double darkness = 1.0 - (0.299 * (double)Color.red((int)color) + 0.587 * (double)Color.green((int)color) + 0.114 * (double)Color.blue((int)color)) / 255.0;
        return darkness >= 0.5;
    }

    public static int adjustAlpha(int color, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color) * factor);
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static int resolveColor(Context context, @AttrRes int attr) {
        return Util.resolveColor(context, attr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int resolveColor(Context context, @AttrRes int attr, int fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            int n = a.getColor(0, fallback);
            return n;
        }
        finally {
            a.recycle();
        }
    }

    public static Drawable resolveDrawable(Context context, @AttrRes int attr) {
        return Util.resolveDrawable(context, attr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Drawable resolveDrawable(Context context, @AttrRes int attr, Drawable fallback) {
        TypedArray a = context.getTheme().obtainStyledAttributes(new int[]{attr});
        try {
            Drawable d = a.getDrawable(0);
            if (d == null && fallback != null) {
                d = fallback;
            }
            Drawable drawable2 = d;
            return drawable2;
        }
        finally {
            a.recycle();
        }
    }
}

