/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.player;

import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.rong.common.RLog;
import io.rong.eventbus.EventBus;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.RongIM;
import io.rong.imkit.destruct.DestructManager;
import io.rong.imkit.model.Event;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.CircleProgressView;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Message;
import io.rong.message.SightMessage;
import io.rong.sight.R;
import io.rong.sight.player.EasyVideoCallback;
import io.rong.sight.player.EasyVideoPlayer;
import io.rong.sight.player.PlaybackVideoFragment;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Iterator;

public class SightPlayerActivity
extends RongBaseNoActionbarActivity
implements EasyVideoCallback {
    private static final String TAG = SightPlayerActivity.class.getSimpleName();
    private SightMessage mSightMessage;
    private Message mMessage;
    private int mProgress;
    private AsyncImageView mThumbImageView;
    private FrameLayout mContainer;
    private RelativeLayout rlSightDownload;
    private CircleProgressView mSightDownloadProgress;
    private RelativeLayout mSightDownloadFailedReminder;
    private TextView mCountDownView;
    private boolean isFinishing = false;
    private boolean fromSightListImageVisible = true;
    private PlaybackVideoFragment mPlaybackVideoFragment;
    private DownloadMediaMessageCallback downloadMediaMessageCallback;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.rc_activity_sight_player);
        this.mSightMessage = (SightMessage)this.getIntent().getParcelableExtra("SightMessage");
        this.mMessage = (Message)this.getIntent().getParcelableExtra("Message");
        this.mProgress = this.getIntent().getIntExtra("Progress", 0);
        this.fromSightListImageVisible = this.getIntent().getBooleanExtra("fromSightListImageVisible", true);
        this.mContainer = (FrameLayout)this.findViewById(R.id.container);
        this.rlSightDownload = (RelativeLayout)this.findViewById(R.id.rl_sight_download);
        this.mCountDownView = (TextView)this.findViewById(R.id.rc_count_down);
        this.downloadMediaMessageCallback = new DownloadMediaMessageCallback(this);
        if (this.isSightDownloaded(this.mSightMessage)) {
            this.initSightPlayer();
        } else {
            this.initDownloadView();
            if (this.mProgress == 0) {
                this.downloadSight();
            }
        }
        if (this.mSightMessage != null && this.mSightMessage.isDestruct() && this.mMessage != null && this.mMessage.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
            DestructManager.getInstance().stopDestruct(this.mMessage);
            EventBus.getDefault().post((Object)new Event.changeDestructionReadTimeEvent(this.mMessage));
        }
        EventBus.getDefault().register((Object)this);
    }

    protected void onDestroy() {
        if (this.isFinishing()) {
            this.isFinishing = true;
        }
        if (this.mSightMessage != null && this.mSightMessage.isDestruct() && this.mMessage != null && this.mMessage.getMessageDirection().equals((Object)Message.MessageDirection.RECEIVE)) {
            DestructManager.getInstance().startDestruct(this.mMessage);
            EventBus.getDefault().post((Object)new Event.changeDestructionReadTimeEvent(this.mMessage));
        }
        EventBus.getDefault().unregister((Object)this);
        this.downloadMediaMessageCallback = null;
        super.onDestroy();
    }

    private void initDownloadView() {
        this.rlSightDownload.setVisibility(0);
        this.mThumbImageView = (AsyncImageView)this.findViewById(R.id.rc_sight_thumb);
        this.mThumbImageView.setResource(this.mSightMessage.getThumbUri());
        this.mSightDownloadProgress = (CircleProgressView)this.findViewById(R.id.rc_sight_download_progress);
        this.mSightDownloadProgress.setVisibility(0);
        this.mSightDownloadProgress.setProgress(this.mProgress, true);
        this.findViewById(R.id.rc_sight_download_close).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SightPlayerActivity.this.finish();
            }
        });
    }

    public void onEventMainThread(Event.RemoteMessageRecallEvent event) {
        if (event.getMessageId() == this.mMessage.getMessageId()) {
            RongIM.getInstance().cancelDownloadMediaMessage(this.mMessage, null);
            if (this.mPlaybackVideoFragment != null) {
                this.mPlaybackVideoFragment.pause();
            }
            new AlertDialog.Builder((Context)this, 5).setMessage((CharSequence)this.getString(R.string.rc_recall_success)).setPositiveButton((CharSequence)this.getString(R.string.rc_dialog_ok), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    SightPlayerActivity.this.finish();
                }
            }).setCancelable(false).show();
        }
    }

    private void downloadSight() {
        RongIM.getInstance().downloadMediaMessage(this.mMessage, (IRongCallback.IDownloadMediaMessageCallback)this.downloadMediaMessageCallback);
    }

    private void initSightPlayer() {
        if (this.isFinishing()) {
            return;
        }
        this.mContainer.setVisibility(0);
        this.mPlaybackVideoFragment = PlaybackVideoFragment.newInstance(this.mSightMessage, this.mSightMessage.getLocalPath().toString(), this.mMessage.getTargetId(), this.mMessage.getConversationType(), this.getIntent().getBooleanExtra("fromList", false), this.fromSightListImageVisible);
        this.mPlaybackVideoFragment.setVideoCallback(this);
        if (this.mSightMessage != null && this.mSightMessage.isDestruct()) {
            this.mPlaybackVideoFragment.setplayBtnVisible(8);
            this.mPlaybackVideoFragment.setSeekBarClickable(false);
        }
        this.getFragmentManager().beginTransaction().replace(R.id.container, (Fragment)this.mPlaybackVideoFragment).commitAllowingStateLoss();
    }

    private void initDownloadFailedReminder() {
        this.mSightDownloadFailedReminder = (RelativeLayout)this.findViewById(R.id.rc_sight_download_failed_reminder);
        this.mSightDownloadFailedReminder.setVisibility(0);
        this.mSightDownloadFailedReminder.findViewById(R.id.rc_sight_download_failed_iv_reminder).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SightPlayerActivity.this.mSightDownloadFailedReminder.setVisibility(8);
                SightPlayerActivity.this.mProgress = 0;
                SightPlayerActivity.this.downloadSight();
            }
        });
    }

    private boolean isSightDownloaded(SightMessage sightMessage) {
        if (sightMessage.getLocalPath() != null && !TextUtils.isEmpty((CharSequence)sightMessage.getLocalPath().toString())) {
            String path = sightMessage.getLocalPath().toString();
            if (path.startsWith("file://")) {
                path = path.substring(7);
            }
            File file = new File(path);
            return file.exists();
        }
        return false;
    }

    public void onEventMainThread(Event.MessageDeleteEvent deleteEvent) {
        RLog.d((String)TAG, (String)"MessageDeleteEvent");
        if (deleteEvent.getMessageIds() != null && this.mMessage != null) {
            Iterator iterator = deleteEvent.getMessageIds().iterator();
            while (iterator.hasNext()) {
                int messageId = (Integer)iterator.next();
                if (messageId != this.mMessage.getMessageId()) continue;
                this.finish();
                break;
            }
        }
    }

    public void onEventMainThread(Event.FileMessageEvent fileMessageEvent) {
        RLog.d((String)TAG, (String)"FileMessageEvent");
        Message message = fileMessageEvent.getMessage();
        if (message != null && message.getContent() instanceof SightMessage && this.mSightMessage != null && this.mSightMessage.getMediaUrl() != null && this.mSightMessage.getMediaUrl().equals((Object)((SightMessage)message.getContent()).getMediaUrl())) {
            int callBackType = fileMessageEvent.getCallBackType();
            switch (callBackType) {
                case 100: {
                    this.downloadMediaMessageCallback.onSuccess(message);
                    break;
                }
                case 103: {
                    this.downloadMediaMessageCallback.onError(message, fileMessageEvent.getErrorCode());
                    break;
                }
                case 102: {
                    this.downloadMediaMessageCallback.onCanceled(message);
                    break;
                }
                case 101: {
                    this.downloadMediaMessageCallback.onProgress(message, fileMessageEvent.getProgress());
                }
            }
        }
    }

    @Override
    public void onStarted(EasyVideoPlayer player) {
    }

    @Override
    public void onPaused(EasyVideoPlayer player) {
    }

    @Override
    public void onPreparing(EasyVideoPlayer player) {
    }

    @Override
    public void onPrepared(EasyVideoPlayer player) {
    }

    @Override
    public void onBuffering(int percent) {
    }

    @Override
    public void onError(EasyVideoPlayer player, Exception e) {
    }

    @Override
    public void onCompletion(EasyVideoPlayer player) {
        if (this.mSightMessage != null && this.mSightMessage.isDestruct()) {
            this.finish();
        }
    }

    @Override
    public void onSightListRequest() {
    }

    @Override
    public void onClose() {
    }

    public static class DownloadMediaMessageCallback
    implements IRongCallback.IDownloadMediaMessageCallback {
        WeakReference<SightPlayerActivity> reference;

        public DownloadMediaMessageCallback(SightPlayerActivity activity) {
            this.reference = new WeakReference<SightPlayerActivity>(activity);
        }

        public void onSuccess(Message message) {
            SightPlayerActivity activity = (SightPlayerActivity)this.reference.get();
            if (activity != null && ((SightMessage)message.getContent()).getMediaUrl().equals((Object)((SightMessage)activity.mMessage.getContent()).getMediaUrl())) {
                if (activity.isFinishing) {
                    return;
                }
                activity.rlSightDownload.setVisibility(8);
                activity.mThumbImageView.setVisibility(8);
                activity.mSightDownloadProgress.setVisibility(8);
                activity.mSightMessage = (SightMessage)message.getContent();
                activity.mMessage = message;
                activity.initSightPlayer();
            }
        }

        public void onProgress(Message message, int progress) {
            SightPlayerActivity activity = (SightPlayerActivity)this.reference.get();
            if (activity != null && message.getContent() instanceof SightMessage && ((SightMessage)message.getContent()).getMediaUrl().equals((Object)((SightMessage)activity.mMessage.getContent()).getMediaUrl())) {
                activity.mProgress = progress;
                activity.mSightDownloadProgress.setVisibility(0);
                activity.mSightDownloadProgress.setProgress(activity.mProgress, true);
            }
        }

        public void onError(Message message, RongIMClient.ErrorCode code) {
            SightPlayerActivity activity = (SightPlayerActivity)this.reference.get();
            if (activity != null && ((SightMessage)message.getContent()).getMediaUrl().equals((Object)((SightMessage)activity.mMessage.getContent()).getMediaUrl())) {
                activity.mSightDownloadProgress.setVisibility(8);
                activity.initDownloadFailedReminder();
            }
        }

        public void onCanceled(Message message) {
        }
    }
}

