/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.player;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import io.rong.eventbus.EventBus;
import io.rong.imkit.RongBaseNoActionbarActivity;
import io.rong.imkit.RongIM;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utils.TimeUtils;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.UserInfo;
import io.rong.message.SightMessage;
import io.rong.sight.R;
import io.rong.sight.player.SightPlayerActivity;
import java.util.ArrayList;
import java.util.List;

public class SightListActivity
extends RongBaseNoActionbarActivity {
    private String targetId;
    private Conversation.ConversationType conversationType;
    private SightListAdapter sightListAdapter;
    private static final int DEFAULT_FILE_COUNT = 100;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rc_activity_sight_list);
        Intent intent = this.getIntent();
        this.targetId = intent.getStringExtra("targetId");
        this.conversationType = Conversation.ConversationType.setValue((int)intent.getIntExtra("conversationType", 0));
        ListView fileListView = (ListView)this.findViewById(R.id.sightList);
        this.sightListAdapter = new SightListAdapter();
        fileListView.setAdapter((ListAdapter)this.sightListAdapter);
        RongIM.getInstance().getHistoryMessages(this.conversationType, this.targetId, "RC:SightMsg", -1, 100, (RongIMClient.ResultCallback)new RongIMClient.ResultCallback<List<Message>>(){

            public void onSuccess(List<Message> messages) {
                if (messages != null && messages.size() > 0) {
                    SightListActivity.this.setListAdapterData(messages, SightListActivity.this.sightListAdapter);
                }
            }

            public void onError(RongIMClient.ErrorCode e) {
            }
        });
        this.findViewById(R.id.imgbtn_nav_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SightListActivity.this.finish();
            }
        });
        EventBus.getDefault().register((Object)this);
    }

    protected void onDestroy() {
        EventBus.getDefault().unregister((Object)this);
        super.onDestroy();
    }

    private void setListAdapterData(List<Message> messages, SightListAdapter sightListAdapter) {
        ArrayList<ItemData> itemDataList = new ArrayList<ItemData>();
        for (Message message : messages) {
            GroupUserInfo groupUserInfo;
            ItemData data = new ItemData();
            data.message = message;
            if (this.conversationType.equals((Object)Conversation.ConversationType.GROUP) && (groupUserInfo = RongUserInfoManager.getInstance().getGroupUserInfo(this.targetId, message.getSenderUserId())) != null && !TextUtils.isEmpty((CharSequence)groupUserInfo.getNickname())) {
                data.senderName = groupUserInfo.getNickname();
            }
            if (TextUtils.isEmpty((CharSequence)data.senderName)) {
                UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(message.getSenderUserId());
                data.senderName = userInfo != null ? userInfo.getName() : message.getSenderUserId();
            }
            itemDataList.add(data);
        }
        sightListAdapter.setFileData(itemDataList);
        sightListAdapter.notifyDataSetChanged();
    }

    public void onEventMainThread(UserInfo userInfo) {
        boolean needUpdate = false;
        for (ItemData itemData : this.sightListAdapter.getData()) {
            if (!itemData.message.getSenderUserId().equals(userInfo.getUserId())) continue;
            itemData.senderName = userInfo.getName();
            needUpdate = true;
        }
        if (needUpdate) {
            this.sightListAdapter.notifyDataSetChanged();
        }
    }

    public void onEventMainThread(GroupUserInfo groupUserInfo) {
        boolean needUpdate = false;
        if (groupUserInfo != null && this.conversationType.equals((Object)Conversation.ConversationType.GROUP) && this.targetId.equals(groupUserInfo.getGroupId())) {
            for (ItemData itemData : this.sightListAdapter.getData()) {
                if (!itemData.message.getSenderUserId().equals(groupUserInfo.getUserId())) continue;
                itemData.senderName = groupUserInfo.getNickname();
                needUpdate = true;
            }
            if (needUpdate) {
                this.sightListAdapter.notifyDataSetChanged();
            }
        }
    }

    private String convertFileSize(long size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if (size < kb) {
            return String.format("%.2f B", Float.valueOf(size));
        }
        if (size < mb) {
            return String.format("%.2f KB", Float.valueOf((float)size / (float)kb));
        }
        if (size < gb) {
            return String.format("%.2f MB", Float.valueOf((float)size / (float)mb));
        }
        return String.format("%.2f G", Float.valueOf((float)size / (float)gb));
    }

    private static class ItemData {
        Message message;
        String senderName;

        private ItemData() {
        }
    }

    private static class ViewHolder {
        ImageView itemIcon;
        TextView itemTitle;
        TextView itemDetail;

        private ViewHolder() {
        }
    }

    private class SightListAdapter
    extends BaseAdapter {
        List<ItemData> fileData = new ArrayList<ItemData>();

        private SightListAdapter() {
        }

        public void setFileData(List<ItemData> fileData) {
            this.fileData.addAll(fileData);
        }

        public List<ItemData> getData() {
            return this.fileData;
        }

        public int getCount() {
            return this.fileData.size();
        }

        public Object getItem(int position) {
            return this.fileData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
                convertView = inflater.inflate(R.layout.rc_sight_list_item, null);
                viewHolder = new ViewHolder();
                viewHolder.itemIcon = (ImageView)convertView.findViewById(R.id.rc_portrait);
                viewHolder.itemTitle = (TextView)convertView.findViewById(R.id.rc_title);
                viewHolder.itemDetail = (TextView)convertView.findViewById(R.id.rc_detail);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            ItemData itemData = this.fileData.get(position);
            final Message message = itemData.message;
            final SightMessage sightMessage = (SightMessage)message.getContent();
            viewHolder.itemTitle.setText((CharSequence)sightMessage.getName());
            String time = TimeUtils.formatData((long)message.getSentTime());
            String size = SightListActivity.this.convertFileSize(sightMessage.getSize());
            String detail = String.format("%s %s %s", itemData.senderName, time, size);
            viewHolder.itemDetail.setText((CharSequence)detail);
            viewHolder.itemIcon.setImageResource(R.drawable.rc_ic_sight_video);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent((Context)SightListActivity.this, SightPlayerActivity.class);
                    intent.putExtra("Message", (Parcelable)message);
                    intent.putExtra("SightMessage", (Parcelable)sightMessage);
                    intent.putExtra("fromList", true);
                    SightListActivity.this.startActivity(intent);
                }
            });
            return convertView;
        }
    }
}

