/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.player;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imlib.model.Conversation;
import io.rong.message.SightMessage;
import io.rong.sight.R;
import io.rong.sight.player.EasyVideoCallback;
import io.rong.sight.player.EasyVideoPlayer;
import io.rong.sight.player.SightListActivity;

public class PlaybackVideoFragment
extends Fragment
implements EasyVideoCallback {
    private EasyVideoPlayer mPlayer;
    private static Conversation.ConversationType conversationType;
    private static String targetId;
    private static boolean isFromSightList;
    static boolean fromSightListImageVisible;
    private EasyVideoCallback mVideoCallback;
    private int playBtnVisible = 0;
    private boolean seekBarClickable = true;
    private static SightMessage mSightMessage;

    public void setVideoCallback(EasyVideoCallback pVideoCallback) {
        this.mVideoCallback = pVideoCallback;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
    }

    public static PlaybackVideoFragment newInstance(SightMessage sightMessage, String outputUri, String id2, Conversation.ConversationType type, boolean fromSightList, boolean sightListImageVisible) {
        PlaybackVideoFragment fragment = new PlaybackVideoFragment();
        fragment.setRetainInstance(true);
        Bundle args = new Bundle();
        args.putString("output_uri", outputUri);
        mSightMessage = sightMessage;
        targetId = id2;
        conversationType = type;
        isFromSightList = fromSightList;
        fromSightListImageVisible = sightListImageVisible;
        fragment.setArguments(args);
        return fragment;
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
        if (this.mPlayer != null) {
            this.mPlayer.pause();
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.rc_fragment_sight_palyer, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mPlayer = (EasyVideoPlayer)view.findViewById(R.id.playbackView);
        this.mPlayer.setCallback(this);
        this.mPlayer.setplayBtnVisible(this.playBtnVisible);
        this.mPlayer.setSeekBarClickable(this.seekBarClickable);
        this.mPlayer.setSource(Uri.parse((String)this.getArguments().getString("output_uri")));
        if (!fromSightListImageVisible) {
            this.mPlayer.setFromSightListImageInVisible();
        }
        if (mSightMessage != null && mSightMessage.isDestruct()) {
            this.mPlayer.setFromSightListImageInVisible();
            this.setLongClickable(false);
        } else {
            this.setLongClickable(true);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mPlayer != null) {
            this.mPlayer.release();
            this.mPlayer = null;
        }
    }

    @Override
    public void onStarted(EasyVideoPlayer player) {
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onStarted(player);
        }
    }

    @Override
    public void onPaused(EasyVideoPlayer player) {
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onPaused(player);
        }
    }

    @Override
    public void onPreparing(EasyVideoPlayer player) {
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onPreparing(player);
        }
    }

    @Override
    public void onPrepared(EasyVideoPlayer player) {
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onPrepared(player);
        }
    }

    @Override
    public void onBuffering(int percent) {
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onBuffering(percent);
        }
    }

    @Override
    public void onError(EasyVideoPlayer player, Exception e) {
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onError(player, e);
        }
    }

    @Override
    public void onCompletion(EasyVideoPlayer player) {
        if (this.mVideoCallback != null) {
            this.mVideoCallback.onCompletion(player);
        }
    }

    @Override
    public void onSightListRequest() {
        if (isFromSightList) {
            if (this.getActivity() != null) {
                this.getActivity().finish();
            }
        } else {
            Intent intent = new Intent((Context)this.getActivity(), SightListActivity.class);
            intent.putExtra("conversationType", conversationType.getValue());
            intent.putExtra("targetId", targetId);
            this.startActivity(intent);
        }
    }

    @Override
    public void onClose() {
        if (this.getActivity() != null) {
            this.getActivity().finish();
        }
    }

    public void pause() {
        if (this.mPlayer != null) {
            this.mPlayer.pause();
        }
    }

    public void setplayBtnVisible(int visible) {
        this.playBtnVisible = visible;
        if (this.mPlayer != null) {
            this.mPlayer.setplayBtnVisible(visible);
        }
    }

    public void setSeekBarClickable(boolean pIsClickable) {
        this.seekBarClickable = pIsClickable;
        if (this.mPlayer != null) {
            this.mPlayer.setSeekBarClickable(pIsClickable);
        }
    }

    public void setLongClickable(boolean isLongClickable) {
        if (this.mPlayer != null) {
            this.mPlayer.setLongClickable(isLongClickable);
        }
    }

    static {
        fromSightListImageVisible = true;
    }
}

