/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight.player;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.ColorStateList;
import android.graphics.Matrix;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.CheckResult;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.common.FileUtils;
import io.rong.common.RLog;
import io.rong.imkit.utilities.KitStorageUtils;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.sight.R;
import io.rong.sight.player.EasyVideoCallback;
import io.rong.sight.player.EasyVideoProgressCallback;
import io.rong.sight.player.IUserMethods;
import io.rong.sight.player.Util;
import java.io.File;
import java.io.IOException;

@TargetApi(value=14)
public class EasyVideoPlayer
extends FrameLayout
implements IUserMethods,
TextureView.SurfaceTextureListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnVideoSizeChangedListener,
MediaPlayer.OnErrorListener,
View.OnClickListener,
View.OnLongClickListener,
SeekBar.OnSeekBarChangeListener,
MediaPlayer.OnInfoListener {
    public static final String TAG = "Sight-EasyVideoPlayer";
    private static final int UPDATE_INTERVAL = 100;
    private AudioManager audioManager;
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    private TextureView mTextureView;
    private Surface mSurface;
    private View mControlsFrame;
    private View mClickFrame;
    private ImageView mImageViewClose;
    private ImageView mImageViewSightList;
    private ImageView mImageViewPlay;
    private SeekBar mSeeker;
    private TextView mCurrent;
    private TextView mTime;
    private ImageView mBtnPlayPause;
    private MediaPlayer mPlayer;
    private boolean mSurfaceAvailable;
    private boolean mIsPrepared;
    private boolean mWasPlaying;
    private Handler mHandler;
    private Uri mSource;
    private EasyVideoCallback mCallback;
    private EasyVideoProgressCallback mProgressCallback;
    private boolean mHideControlsOnPlay = true;
    private boolean mAutoPlay;
    private int mInitialPosition = -1;
    private boolean mControlsDisabled;
    private int mThemeColor = 0;
    private boolean mAutoFullscreen = false;
    private boolean mLoop = false;
    private OnInfoCallBack onInfoCallBack;
    private int currentPos;
    private boolean isLongClickable;
    private final Runnable mUpdateCounters = new Runnable(){

        @Override
        public void run() {
            if (EasyVideoPlayer.this.mHandler == null || !EasyVideoPlayer.this.mIsPrepared || EasyVideoPlayer.this.mSeeker == null || EasyVideoPlayer.this.mPlayer == null) {
                return;
            }
            int pos = EasyVideoPlayer.this.mPlayer.getCurrentPosition();
            int dur = EasyVideoPlayer.this.mPlayer.getDuration();
            if ("oppo".equals(Build.BRAND.toLowerCase()) && "OPPO R9sk".equals(Build.MODEL) && pos <= EasyVideoPlayer.this.currentPos) {
                pos = EasyVideoPlayer.this.currentPos;
            }
            if (pos > dur) {
                pos = dur;
            }
            EasyVideoPlayer.this.mCurrent.setText((CharSequence)Util.getDurationString(pos));
            EasyVideoPlayer.this.mSeeker.setProgress(pos);
            EasyVideoPlayer.this.mSeeker.setMax(dur);
            if (EasyVideoPlayer.this.mProgressCallback != null) {
                EasyVideoPlayer.this.mProgressCallback.onVideoProgressUpdate(pos, dur);
            }
            if (EasyVideoPlayer.this.mHandler != null) {
                EasyVideoPlayer.this.mHandler.postDelayed((Runnable)this, 100L);
            }
        }
    };

    public EasyVideoPlayer(Context context) {
        super(context);
        this.init(context, null);
    }

    public EasyVideoPlayer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public EasyVideoPlayer(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.setBackgroundColor(-16777216);
        this.mHideControlsOnPlay = true;
        this.mAutoPlay = true;
        this.mControlsDisabled = false;
        this.mThemeColor = 4149685;
        this.mAutoFullscreen = false;
        this.mLoop = false;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
            }
        };
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setKeepScreenOn(true);
        this.mHandler = new Handler();
        this.mPlayer = new MediaPlayer();
        this.mPlayer.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mPlayer.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
        this.mPlayer.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
        this.mPlayer.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
        this.mPlayer.setOnErrorListener((MediaPlayer.OnErrorListener)this);
        this.mPlayer.setAudioStreamType(3);
        this.mPlayer.setLooping(this.mLoop);
        this.mPlayer.setOnInfoListener((MediaPlayer.OnInfoListener)this);
        FrameLayout.LayoutParams textureLp = new FrameLayout.LayoutParams(-1, -1);
        textureLp.gravity = 17;
        this.mTextureView = new TextureView(this.getContext());
        this.addView((View)this.mTextureView, (ViewGroup.LayoutParams)textureLp);
        this.mTextureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        LayoutInflater li = LayoutInflater.from((Context)this.getContext());
        this.mClickFrame = new FrameLayout(this.getContext());
        this.addView(this.mClickFrame, new ViewGroup.LayoutParams(-1, -1));
        this.initPlayView();
        this.initCloseView();
        this.initSightListView();
        this.mControlsFrame = li.inflate(R.layout.rc_sight_play_control, (ViewGroup)this, false);
        if (this.mControlsFrame == null) {
            return;
        }
        FrameLayout.LayoutParams controlsLp = new FrameLayout.LayoutParams(-1, -2);
        controlsLp.gravity = 80;
        this.addView(this.mControlsFrame, (ViewGroup.LayoutParams)controlsLp);
        this.mControlsFrame.setVisibility(4);
        if (this.mControlsDisabled) {
            this.mClickFrame.setOnClickListener(null);
            this.mControlsFrame.setVisibility(8);
            this.mClickFrame.setOnLongClickListener(null);
        } else {
            this.mClickFrame.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    EasyVideoPlayer.this.toggleControls();
                }
            });
            this.mClickFrame.setOnLongClickListener((View.OnLongClickListener)(this.isLongClickable ? this : null));
        }
        this.mSeeker = (SeekBar)this.mControlsFrame.findViewById(R.id.seeker);
        this.mSeeker.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.mCurrent = (TextView)this.mControlsFrame.findViewById(R.id.current);
        this.mCurrent.setText((CharSequence)Util.getDurationString(0L));
        this.mTime = (TextView)this.mControlsFrame.findViewById(R.id.time);
        this.mTime.setText((CharSequence)Util.getDurationString(0L));
        this.mBtnPlayPause = (ImageView)this.mControlsFrame.findViewById(R.id.btnPlayPause);
        this.mBtnPlayPause.setOnClickListener((View.OnClickListener)this);
        this.mBtnPlayPause.setImageResource(R.drawable.rc_ic_sight_pause);
        this.invalidateThemeColors();
        this.setControlsEnabled(false);
        this.prepare();
    }

    private void initPlayView() {
        this.mImageViewPlay = new ImageView(this.getContext());
        FrameLayout.LayoutParams imageViewPlayParam = new FrameLayout.LayoutParams(-2, -2);
        imageViewPlayParam.gravity = 17;
        this.mImageViewPlay.setImageResource(R.drawable.rc_ic_sight_player_paly);
        this.addView((View)this.mImageViewPlay, (ViewGroup.LayoutParams)imageViewPlayParam);
        this.mImageViewPlay.setVisibility(8);
        this.mImageViewPlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EasyVideoPlayer.this.start();
            }
        });
    }

    private void initCloseView() {
        this.mImageViewClose = new ImageView(this.getContext());
        FrameLayout.LayoutParams imageViewCloseParam = new FrameLayout.LayoutParams(-2, -2);
        imageViewCloseParam.gravity = 51;
        int iconMargin = (int)this.getResources().getDimension(R.dimen.sight_record_top_icon_margin);
        imageViewCloseParam.setMargins(iconMargin, iconMargin, 0, 0);
        this.mImageViewClose.setImageResource(R.drawable.rc_ic_sight_close);
        this.addView((View)this.mImageViewClose, (ViewGroup.LayoutParams)imageViewCloseParam);
        this.mImageViewClose.setVisibility(8);
        this.mImageViewClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EasyVideoPlayer.this.mCallback != null) {
                    EasyVideoPlayer.this.mCallback.onClose();
                }
            }
        });
    }

    private void initSightListView() {
        this.mImageViewSightList = new ImageView(this.getContext());
        FrameLayout.LayoutParams imageViewSightListParam = new FrameLayout.LayoutParams(-2, -2);
        imageViewSightListParam.gravity = 53;
        int iconMargin = (int)this.getResources().getDimension(R.dimen.sight_record_top_icon_margin);
        imageViewSightListParam.setMargins(0, iconMargin, iconMargin, 0);
        this.mImageViewSightList.setImageResource(R.drawable.rc_ic_sight_list);
        this.addView((View)this.mImageViewSightList, (ViewGroup.LayoutParams)imageViewSightListParam);
        this.mImageViewSightList.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (EasyVideoPlayer.this.mCallback != null) {
                    EasyVideoPlayer.this.mCallback.onSightListRequest();
                }
            }
        });
    }

    @Override
    public void setSource(@NonNull Uri source) {
        boolean hadSource;
        boolean bl = hadSource = this.mSource != null;
        if (hadSource) {
            this.stop();
        }
        this.mSource = source;
        RLog.i((String)TAG, (String)("mSource = " + this.mSource));
        if (this.mPlayer != null) {
            if (hadSource) {
                this.sourceChanged();
            } else {
                this.prepare();
            }
        }
    }

    @Override
    public void setCallback(@NonNull EasyVideoCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public void setProgressCallback(@NonNull EasyVideoProgressCallback callback) {
        this.mProgressCallback = callback;
    }

    @Override
    public void setHideControlsOnPlay(boolean hide) {
        this.mHideControlsOnPlay = hide;
    }

    @Override
    public void setAutoPlay(boolean autoPlay) {
        this.mAutoPlay = autoPlay;
    }

    @Override
    public void setInitialPosition(@IntRange(from=0L, to=0x7FFFFFFFL) int pos) {
        this.mInitialPosition = pos;
    }

    private void sourceChanged() {
        this.setControlsEnabled(false);
        this.mSeeker.setProgress(0);
        this.mSeeker.setEnabled(false);
        this.mPlayer.reset();
        if (this.mCallback != null) {
            this.mCallback.onPreparing(this);
        }
        try {
            this.setSourceInternal();
        }
        catch (IOException e) {
            this.throwError(e);
        }
    }

    private void setSourceInternal() throws IOException {
        if (this.mSource.getScheme() != null && (this.mSource.getScheme().equals("http") || this.mSource.getScheme().equals("https"))) {
            RLog.d((String)TAG, (String)("Loading web URI: " + this.mSource.toString()));
            this.mPlayer.setDataSource(this.mSource.toString());
        } else if (this.mSource.getScheme() != null && this.mSource.getScheme().equals("file") && this.mSource.getPath().contains("/android_assets/")) {
            RLog.d((String)TAG, (String)("Loading assets URI: " + this.mSource.toString()));
            AssetFileDescriptor afd = this.getContext().getAssets().openFd(this.mSource.toString().replace("file:///android_assets/", ""));
            this.mPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
        } else if (this.mSource.getScheme() != null && this.mSource.getScheme().equals("asset")) {
            RLog.d((String)TAG, (String)("Loading assets URI: " + this.mSource.toString()));
            AssetFileDescriptor afd = this.getContext().getAssets().openFd(this.mSource.toString().replace("asset://", ""));
            this.mPlayer.setDataSource(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength());
            afd.close();
        } else {
            RLog.d((String)TAG, (String)("Loading local URI: " + this.mSource.toString()));
            this.mPlayer.setDataSource(this.getContext(), this.mSource);
        }
        this.mPlayer.prepareAsync();
    }

    private void prepare() {
        if (!this.mSurfaceAvailable || this.mSource == null || this.mPlayer == null || this.mIsPrepared) {
            return;
        }
        if (this.mCallback != null) {
            this.mCallback.onPreparing(this);
        }
        try {
            this.mPlayer.setSurface(this.mSurface);
            this.setSourceInternal();
        }
        catch (IOException e) {
            this.throwError(e);
        }
    }

    private void setControlsEnabled(boolean enabled) {
        if (this.mSeeker == null) {
            return;
        }
        this.mSeeker.setEnabled(enabled);
        this.mBtnPlayPause.setEnabled(enabled);
        float disabledAlpha = 0.4f;
        this.mBtnPlayPause.setAlpha(enabled ? 1.0f : 0.4f);
        this.mClickFrame.setEnabled(enabled);
    }

    public void setFromSightListImageInVisible() {
        this.mImageViewSightList.setVisibility(4);
    }

    @Override
    public void showControls() {
        if (this.mControlsDisabled || this.isControlsShown() || this.mSeeker == null) {
            return;
        }
        this.mControlsFrame.animate().cancel();
        this.mControlsFrame.setAlpha(0.0f);
        this.mControlsFrame.setVisibility(0);
        this.mImageViewClose.setVisibility(0);
        this.mControlsFrame.animate().alpha(1.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (EasyVideoPlayer.this.mAutoFullscreen) {
                    EasyVideoPlayer.this.setFullscreen(false);
                }
            }
        }).start();
    }

    @Override
    public void hideControls() {
        if (this.mControlsDisabled || !this.isControlsShown() || this.mSeeker == null) {
            return;
        }
        this.mControlsFrame.animate().cancel();
        this.mControlsFrame.setAlpha(1.0f);
        this.mControlsFrame.setVisibility(0);
        this.mControlsFrame.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                EasyVideoPlayer.this.setFullscreen(true);
                if (EasyVideoPlayer.this.mControlsFrame != null) {
                    EasyVideoPlayer.this.mImageViewClose.setVisibility(4);
                    EasyVideoPlayer.this.mControlsFrame.setVisibility(4);
                }
            }
        }).start();
    }

    @Override
    @CheckResult
    public boolean isControlsShown() {
        return !this.mControlsDisabled && this.mControlsFrame != null && this.mControlsFrame.getAlpha() > 0.5f;
    }

    @Override
    public void toggleControls() {
        if (this.mControlsDisabled) {
            return;
        }
        if (this.isControlsShown()) {
            this.hideControls();
        } else {
            this.showControls();
        }
    }

    @Override
    public void enableControls(boolean andShow) {
        this.mControlsDisabled = false;
        if (andShow) {
            this.showControls();
        }
        this.mClickFrame.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                EasyVideoPlayer.this.toggleControls();
            }
        });
        this.mClickFrame.setClickable(true);
    }

    @Override
    public void disableControls() {
        this.mControlsDisabled = true;
        this.mControlsFrame.setVisibility(8);
        this.mClickFrame.setOnClickListener(null);
        this.mClickFrame.setClickable(false);
    }

    @Override
    @CheckResult
    public boolean isPrepared() {
        return this.mPlayer != null && this.mIsPrepared;
    }

    @Override
    @CheckResult
    public boolean isPlaying() {
        return this.mPlayer != null && this.mPlayer.isPlaying();
    }

    @Override
    @CheckResult
    public int getCurrentPosition() {
        if (this.mPlayer == null) {
            return -1;
        }
        return this.mPlayer.getCurrentPosition();
    }

    @Override
    @CheckResult
    public int getDuration() {
        if (this.mPlayer == null) {
            return -1;
        }
        return this.mPlayer.getDuration();
    }

    @Override
    public void start() {
        if (this.mPlayer == null) {
            return;
        }
        this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 3, 2);
        this.mPlayer.start();
        if (this.mCallback != null) {
            this.mCallback.onStarted(this);
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        this.mHandler.post(this.mUpdateCounters);
        this.mBtnPlayPause.setImageResource(R.drawable.rc_ic_sight_pause);
        this.mImageViewPlay.setVisibility(8);
    }

    @Override
    public void seekTo(@IntRange(from=0L, to=0x7FFFFFFFL) int pos) {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.seekTo(pos);
    }

    @Override
    public void setVolume(@FloatRange(from=0.0, to=1.0) float leftVolume, @FloatRange(from=0.0, to=1.0) float rightVolume) {
        if (this.mPlayer == null || !this.mIsPrepared) {
            throw new IllegalStateException("You cannot use setVolume(float, float) until the player is prepared.");
        }
        this.mPlayer.setVolume(leftVolume, rightVolume);
    }

    @Override
    public void pause() {
        if (this.mPlayer == null || !this.isPlaying()) {
            return;
        }
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.mPlayer.pause();
        this.mCallback.onPaused(this);
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mUpdateCounters);
        this.mBtnPlayPause.setImageResource(R.drawable.rc_ic_sight_play);
        this.mImageViewPlay.setVisibility(0);
    }

    @Override
    public void stop() {
        if (this.mPlayer == null) {
            return;
        }
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        try {
            this.mPlayer.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeCallbacks(this.mUpdateCounters);
        this.mBtnPlayPause.setImageResource(R.drawable.rc_ic_sight_pause);
    }

    @Override
    public void reset() {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.reset();
        this.mIsPrepared = false;
    }

    @Override
    public void release() {
        this.mIsPrepared = false;
        if (this.mPlayer != null) {
            try {
                this.mPlayer.release();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.mPlayer = null;
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mUpdateCounters);
            this.mHandler = null;
        }
        RLog.d((String)TAG, (String)"Released player and Handler");
    }

    @Override
    public void setAutoFullscreen(boolean autoFullscreen) {
        this.mAutoFullscreen = autoFullscreen;
    }

    @Override
    public void setLoop(boolean loop) {
        this.mLoop = loop;
        if (this.mPlayer != null) {
            this.mPlayer.setLooping(loop);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        RLog.d((String)TAG, (String)("Surface texture available: " + width + " " + height));
        this.mSurfaceAvailable = true;
        this.mSurface = new Surface(surfaceTexture);
        if (this.mIsPrepared) {
            this.mPlayer.setSurface(this.mSurface);
            if ("oppo".equals(Build.BRAND.toLowerCase()) && "OPPO R9sk".equals(Build.MODEL)) {
                this.mPlayer.seekTo(this.getCurrentPosition());
            }
        } else {
            this.prepare();
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        RLog.d((String)TAG, (String)("Surface texture changed: " + width + " " + height));
        this.adjustAspectRatio(width, height, this.mPlayer.getVideoWidth(), this.mPlayer.getVideoHeight());
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        RLog.d((String)TAG, (String)"Surface texture destroyed");
        if ("oppo".equals(Build.BRAND.toLowerCase()) && "OPPO R9sk".equals(Build.MODEL)) {
            this.currentPos = this.getCurrentPosition();
        }
        this.mSurfaceAvailable = false;
        this.mSurface = null;
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        RLog.d((String)TAG, (String)"onPrepared()");
        this.mIsPrepared = true;
        if (this.mCallback != null) {
            this.mCallback.onPrepared(this);
        }
        this.mCurrent.setText((CharSequence)Util.getDurationString(0L));
        this.mTime.setText((CharSequence)Util.getDurationString(Math.round((float)mediaPlayer.getDuration() * 1.0f / 1000.0f) * 1000));
        this.mSeeker.setProgress(0);
        this.mSeeker.setMax(mediaPlayer.getDuration());
        this.setControlsEnabled(true);
        if (this.mAutoPlay) {
            if (!this.mControlsDisabled && this.mHideControlsOnPlay) {
                this.hideControls();
            }
            this.start();
            if (this.mInitialPosition > 0) {
                this.seekTo(this.mInitialPosition);
                this.mInitialPosition = -1;
            }
        } else {
            this.mPlayer.start();
            this.mPlayer.pause();
        }
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int percent) {
        RLog.d((String)TAG, (String)("Buffering: " + percent + "%"));
        if (this.mCallback != null) {
            this.mCallback.onBuffering(percent);
        }
        if (this.mSeeker != null) {
            if (percent == 100) {
                this.mSeeker.setSecondaryProgress(0);
            } else {
                this.mSeeker.setSecondaryProgress(this.mSeeker.getMax() * (percent / 100));
            }
        }
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        RLog.d((String)TAG, (String)"onCompletion()");
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        if ("oppo".equals(Build.BRAND.toLowerCase()) && "OPPO R9sk".equals(Build.MODEL)) {
            this.currentPos = 0;
        }
        if (this.mLoop) {
            if (this.mHandler != null) {
                this.mHandler.removeCallbacks(this.mUpdateCounters);
            }
            this.mSeeker.setProgress(this.mSeeker.getMax());
            this.showControls();
        } else {
            this.seekTo(0);
            this.mSeeker.setProgress(0);
            this.mCurrent.setText((CharSequence)Util.getDurationString(0L));
            this.mBtnPlayPause.setImageResource(R.drawable.rc_ic_sight_play);
            this.mImageViewPlay.setVisibility(0);
        }
        if (this.mCallback != null) {
            this.mCallback.onCompletion(this);
            if (this.mLoop) {
                this.mCallback.onStarted(this);
            }
        }
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int width, int height) {
        RLog.d((String)TAG, (String)("Video size changed: " + width + " " + height));
        this.setFitToFillAspectRatio(mediaPlayer, width, height);
    }

    public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
        if (what == -38) {
            return false;
        }
        String errorMsg = "Preparation/playback error (" + what + "): ";
        switch (what) {
            default: {
                errorMsg = errorMsg + "Unknown error";
                break;
            }
            case -1004: {
                errorMsg = errorMsg + "I/O error";
                break;
            }
            case -1007: {
                errorMsg = errorMsg + "Malformed";
                break;
            }
            case 200: {
                errorMsg = errorMsg + "Not valid for progressive playback";
                break;
            }
            case 100: {
                errorMsg = errorMsg + "Server died";
                break;
            }
            case -110: {
                errorMsg = errorMsg + "Timed out";
                break;
            }
            case -1010: {
                errorMsg = errorMsg + "Unsupported";
            }
        }
        this.throwError(new Exception(errorMsg));
        return false;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.btnPlayPause) {
            if (this.mPlayer.isPlaying()) {
                this.pause();
            } else {
                if (this.mHideControlsOnPlay && !this.mControlsDisabled) {
                    this.hideControls();
                }
                this.start();
            }
        }
    }

    public void onProgressChanged(SeekBar seekBar, int value, boolean fromUser) {
        if (fromUser) {
            this.seekTo(value);
            this.mCurrent.setText((CharSequence)Util.getDurationString(value));
        }
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.mWasPlaying = this.isPlaying();
        if (this.mWasPlaying && this.mPlayer != null) {
            this.mPlayer.pause();
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.mWasPlaying && this.mPlayer != null) {
            this.mPlayer.start();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        RLog.d((String)TAG, (String)"Detached from window");
        this.release();
        this.mSeeker = null;
        this.mCurrent = null;
        this.mTime = null;
        this.mBtnPlayPause = null;
        this.mControlsFrame = null;
        this.mClickFrame = null;
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mUpdateCounters);
            this.mHandler = null;
        }
    }

    private void setFitToFillAspectRatio(MediaPlayer mp, int videoWidth, int videoHeight) {
        if (mp != null && this.mTextureView != null) {
            int screenWidth = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getWidth();
            int screenHeight = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getHeight();
            ViewGroup.LayoutParams videoParams = this.mTextureView.getLayoutParams();
            if (videoWidth > videoHeight) {
                int screenWidthFillHeight = screenWidth * videoHeight / videoWidth;
                int screenFitHeight = Math.min(screenHeight, screenWidthFillHeight);
                videoParams.width = screenWidth * screenFitHeight / screenWidthFillHeight;
                videoParams.height = screenFitHeight;
            } else {
                int screenFitWidth;
                int screenHeightFillWith = screenHeight * videoWidth / videoHeight;
                videoParams.width = screenFitWidth = Math.min(screenWidth, screenHeightFillWith);
                videoParams.height = screenHeight * screenFitWidth / screenHeightFillWith;
            }
            this.mTextureView.setLayoutParams(videoParams);
        }
    }

    private void adjustAspectRatio(int viewWidth, int viewHeight, int videoWidth, int videoHeight) {
        int newHeight;
        int newWidth;
        if (viewWidth < viewHeight) {
            return;
        }
        double aspectRatio = (double)videoHeight / (double)videoWidth;
        if (viewHeight > (int)((double)viewWidth * aspectRatio)) {
            newWidth = viewWidth;
            newHeight = (int)((double)viewWidth * aspectRatio);
        } else {
            newWidth = (int)((double)viewHeight / aspectRatio);
            newHeight = viewHeight;
        }
        int xoff = (viewWidth - newWidth) / 2;
        int yoff = (viewHeight - newHeight) / 2;
        Matrix txform = new Matrix();
        this.mTextureView.getTransform(txform);
        txform.setScale((float)newWidth / (float)viewWidth, (float)newHeight / (float)viewHeight);
        txform.postTranslate((float)xoff, (float)yoff);
        this.mTextureView.setTransform(txform);
    }

    private void throwError(Exception e) {
        if (this.mCallback == null) {
            throw new RuntimeException(e);
        }
        this.mCallback.onError(this, e);
    }

    private static void setTint(@NonNull SeekBar seekBar, @ColorInt int color) {
        ColorStateList s1 = ColorStateList.valueOf((int)color);
        if (Build.VERSION.SDK_INT >= 21) {
            seekBar.setThumbTintList(s1);
            seekBar.setProgressTintList(s1);
            seekBar.setSecondaryProgressTintList(s1);
        } else if (Build.VERSION.SDK_INT > 10) {
            Drawable progressDrawable = DrawableCompat.wrap((Drawable)seekBar.getProgressDrawable());
            seekBar.setProgressDrawable(progressDrawable);
            DrawableCompat.setTintList((Drawable)progressDrawable, (ColorStateList)s1);
            if (Build.VERSION.SDK_INT >= 16) {
                Drawable thumbDrawable = DrawableCompat.wrap((Drawable)seekBar.getThumb());
                DrawableCompat.setTintList((Drawable)thumbDrawable, (ColorStateList)s1);
                seekBar.setThumb(thumbDrawable);
            }
        } else {
            PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
            if (Build.VERSION.SDK_INT <= 10) {
                mode = PorterDuff.Mode.MULTIPLY;
            }
            if (seekBar.getIndeterminateDrawable() != null) {
                seekBar.getIndeterminateDrawable().setColorFilter(color, mode);
            }
            if (seekBar.getProgressDrawable() != null) {
                seekBar.getProgressDrawable().setColorFilter(color, mode);
            }
        }
    }

    private void invalidateThemeColors() {
        int labelColor = Util.isColorDark(this.mThemeColor) ? -1 : -16777216;
        this.mControlsFrame.setBackgroundColor(Util.adjustAlpha(this.mThemeColor, 0.8f));
        this.mTime.setTextColor(labelColor);
        this.mTime.setTextColor(labelColor);
        EasyVideoPlayer.setTint(this.mSeeker, labelColor);
    }

    @TargetApi(value=14)
    private void setFullscreen(boolean fullscreen) {
        if (this.mAutoFullscreen) {
            int flags;
            int n = flags = !fullscreen ? 0 : 1;
            if (Build.VERSION.SDK_INT >= 19) {
                flags |= 0x700;
                if (fullscreen) {
                    flags |= 0x806;
                }
            }
            this.mClickFrame.setSystemUiVisibility(flags);
        }
    }

    public ImageView getImageViewSightList() {
        return this.mImageViewSightList;
    }

    public boolean onInfo(MediaPlayer mp, int what, int extra) {
        if (what == 3 && this.onInfoCallBack != null) {
            this.onInfoCallBack.onInfo();
        }
        return false;
    }

    public void setOnInfoListener(OnInfoCallBack callBack) {
        this.onInfoCallBack = callBack;
    }

    public boolean onLongClick(View view) {
        String[] items = new String[]{this.getContext().getString(R.string.rc_save_video)};
        OptionsPopupDialog.newInstance((Context)this.getContext(), (String[])items).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

            public void onOptionsItemClicked(int which) {
                if (which == 0) {
                    if (EasyVideoPlayer.this.checkGrantedPermission()) {
                        return;
                    }
                    RLog.i((String)EasyVideoPlayer.TAG, (String)("onLongClick mSource = " + EasyVideoPlayer.this.mSource));
                    if (EasyVideoPlayer.this.mSource == null || TextUtils.isEmpty((CharSequence)EasyVideoPlayer.this.mSource.toString())) {
                        return;
                    }
                    File file = FileUtils.uriStartWithFile((Uri)EasyVideoPlayer.this.mSource) ? new File(EasyVideoPlayer.this.mSource.toString().substring(7)) : new File(EasyVideoPlayer.this.mSource.toString());
                    boolean result = KitStorageUtils.saveMediaToPublicDir((Context)EasyVideoPlayer.this.getContext(), (File)file, (String)"video");
                    if (result) {
                        Toast.makeText((Context)EasyVideoPlayer.this.getContext(), (CharSequence)EasyVideoPlayer.this.getContext().getString(R.string.rc_save_video_success), (int)0).show();
                    } else {
                        Toast.makeText((Context)EasyVideoPlayer.this.getContext(), (CharSequence)EasyVideoPlayer.this.getContext().getString(R.string.rc_src_file_not_found), (int)0).show();
                    }
                }
            }
        }).show();
        return true;
    }

    private boolean checkGrantedPermission() {
        String[] permissions = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};
        return !PermissionCheckUtil.requestPermissions((Activity)((Activity)this.getContext()), (String[])permissions);
    }

    public void setplayBtnVisible(int visible) {
        if (this.mBtnPlayPause != null) {
            this.mBtnPlayPause.setVisibility(visible);
        }
    }

    public void setSeekBarClickable(boolean pIsClickable) {
        if (this.mSeeker != null) {
            this.mSeeker.setOnTouchListener(pIsClickable ? null : new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return true;
                }
            });
        }
    }

    public void setLongClickable(boolean isLongClickable) {
        this.isLongClickable = isLongClickable;
        if (this.mClickFrame != null) {
            this.mClickFrame.setOnLongClickListener((View.OnLongClickListener)(isLongClickable ? this : null));
        }
    }

    public static interface OnInfoCallBack {
        public void onInfo();
    }
}

