/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sight;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import io.rong.common.FileUtils;
import io.rong.common.rlog.RLog;
import io.rong.imkit.R;
import io.rong.imkit.RongExtension;
import io.rong.imkit.RongIM;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.IPluginRequestPermissionResultCallback;
import io.rong.imkit.utilities.PermissionCheckUtil;
import io.rong.imkit.utils.RongOperationPermissionUtils;
import io.rong.imlib.IRongCallback;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import io.rong.imlib.model.MessageContent;
import io.rong.message.SightMessage;
import io.rong.sight.R;
import io.rong.sight.record.SightRecordActivity;
import java.io.File;

public class SightPlugin
implements IPluginModule,
IPluginRequestPermissionResultCallback {
    private static final String TAG = "SightPlugin";
    protected Conversation.ConversationType conversationType;
    protected String targetId;
    protected Context context;
    private static final int REQUEST_SIGHT = 104;
    private boolean isDestruct;

    public Drawable obtainDrawable(Context context) {
        this.context = context;
        return ContextCompat.getDrawable((Context)context, (int)R.drawable.rc_ext_plugin_sight_selector);
    }

    public String obtainTitle(Context context) {
        return context.getString(R.string.rc_plugin_sight);
    }

    public void onClick(Fragment currentFragment, RongExtension extension) {
        if (!RongOperationPermissionUtils.isMediaOperationPermit((Context)currentFragment.getActivity())) {
            return;
        }
        String[] permissions = new String[]{"android.permission.CAMERA", "android.permission.RECORD_AUDIO", "android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"};
        this.conversationType = extension.getConversationType();
        this.targetId = extension.getTargetId();
        this.isDestruct = extension.isFireStatus();
        if (PermissionCheckUtil.checkPermissions((Context)currentFragment.getActivity(), (String[])permissions)) {
            this.startSightRecord(currentFragment, extension);
        } else {
            extension.requestPermissionForPluginResult(permissions, 255, (IPluginModule)this);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        String fileUrl;
        File file;
        if (resultCode == -1 && requestCode == 104 && data != null && (file = new File(fileUrl = data.getStringExtra("recordSightUrl"))).exists()) {
            int recordTime = data.getIntExtra("recordSightTime", 0);
            SightMessage sightMessage = SightMessage.obtain((Uri)Uri.fromFile((File)file), (int)recordTime);
            String pushContent = null;
            if (this.isDestruct) {
                sightMessage.setDestructTime(10L);
                if (RongIM.getInstance().getApplicationContext() != null) {
                    pushContent = RongIM.getInstance().getApplicationContext().getString(R.string.rc_message_content_burn);
                }
            }
            Message message = Message.obtain((String)this.targetId, (Conversation.ConversationType)this.conversationType, (MessageContent)sightMessage);
            RongIM.getInstance().sendMediaMessage(message, pushContent, null, (IRongCallback.ISendMediaMessageCallback)null);
        }
    }

    private void startSightRecord(Fragment currentFragment, RongExtension extension) {
        boolean successMkdir;
        File saveDir = null;
        if (currentFragment.getActivity() == null || currentFragment.getContext() == null) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)currentFragment.getActivity(), (String)"android.permission.WRITE_EXTERNAL_STORAGE") == 0 && !(successMkdir = (saveDir = new File(FileUtils.getMediaDownloadDir((Context)currentFragment.getContext(), (String)"video"))).mkdirs())) {
            RLog.e((String)TAG, (String)"Created folders UnSuccessfully");
        }
        Intent intent = new Intent((Context)currentFragment.getActivity(), SightRecordActivity.class);
        if (saveDir != null) {
            intent.putExtra("recordSightDir", saveDir.getAbsolutePath());
        }
        int maxRecordDuration = 10;
        try {
            maxRecordDuration = currentFragment.getActivity().getResources().getInteger(R.integer.rc_sight_max_record_duration);
        }
        catch (Resources.NotFoundException e) {
            e.printStackTrace();
        }
        int videoLimitTime = RongIMClient.getInstance().getVideoLimitTime();
        if (maxRecordDuration > videoLimitTime) {
            maxRecordDuration = videoLimitTime;
        }
        intent.putExtra("maxRecordDuration", maxRecordDuration);
        extension.startActivityForPluginResult(intent, 104, (IPluginModule)this);
    }

    public boolean onRequestPermissionResult(Fragment fragment, RongExtension extension, int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (PermissionCheckUtil.checkPermissions((Context)fragment.getActivity(), (String[])permissions)) {
            this.startSightRecord(fragment, extension);
        } else if (fragment.getActivity() != null) {
            extension.showRequestPermissionFailedAlter(PermissionCheckUtil.getNotGrantedPermissionMsg((Context)fragment.getActivity(), (String[])permissions, (int[])grantResults));
        }
        return true;
    }
}

