/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushServiceReceiver;
import com.xiaomi.push.hw;
import com.xiaomi.push.im;
import java.io.Serializable;
import java.util.List;

public class PushMessageHelper {
    public static final String MESSAGE_TYPE = "message_type";
    public static final int MESSAGE_RAW = 1;
    public static final int MESSAGE_SENDMESSAGE = 2;
    public static final int MESSAGE_COMMAND = 3;
    public static final int MESSAGE_QUIT = 4;
    public static final int MESSAGE_ERROR = 5;
    public static final String ERROR_MESSAGE = "error_message";
    public static final String ERROR_TYPE = "error_type";
    public static final String ERROR_TYPE_NEED_PERMISSION = "error_lack_of_permission";
    public static final String KEY_MESSAGE = "key_message";
    public static final String KEY_COMMAND = "key_command";
    public static final int PUSH_MODE_CALLBACK = 1;
    public static final int PUSH_MODE_BROADCAST = 2;
    private static int pushMode = 0;

    private static boolean isIntentAvailable(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        try {
            List list = packageManager.queryBroadcastReceivers(intent, 32);
            return list != null && !list.isEmpty();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static int getPushMode(Context context) {
        if (pushMode == 0) {
            if (PushMessageHelper.isUseCallbackPushMode(context)) {
                PushMessageHelper.setPushMode(1);
            } else {
                PushMessageHelper.setPushMode(2);
            }
        }
        return pushMode;
    }

    private static void setPushMode(int n2) {
        pushMode = n2;
    }

    public static boolean isUseCallbackPushMode(Context context) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setClassName(context.getPackageName(), "com.xiaomi.mipush.sdk.PushServiceReceiver");
        return PushMessageHelper.isIntentAvailable(context, intent);
    }

    public static void sendCommandMessageBroadcast(Context context, MiPushCommandMessage miPushCommandMessage) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setPackage(context.getPackageName());
        intent.putExtra(MESSAGE_TYPE, 3);
        intent.putExtra(KEY_COMMAND, (Serializable)miPushCommandMessage);
        new PushServiceReceiver().onReceive(context, intent);
    }

    public static void sendQuitMessageBroadcast(Context context) {
        Intent intent = new Intent("com.xiaomi.mipush.RECEIVE_MESSAGE");
        intent.setPackage(context.getPackageName());
        intent.putExtra(MESSAGE_TYPE, 4);
        new PushServiceReceiver().onReceive(context, intent);
    }

    public static MiPushCommandMessage generateCommandMessage(String string, List<String> list, long l2, String string2, String string3) {
        MiPushCommandMessage miPushCommandMessage = new MiPushCommandMessage();
        miPushCommandMessage.setCommand(string);
        miPushCommandMessage.setCommandArguments(list);
        miPushCommandMessage.setResultCode(l2);
        miPushCommandMessage.setReason(string2);
        miPushCommandMessage.setCategory(string3);
        return miPushCommandMessage;
    }

    public static MiPushMessage generateMessage(im im2, hw hw2, boolean bl2) {
        MiPushMessage miPushMessage = new MiPushMessage();
        miPushMessage.setMessageId(im2.a());
        if (!TextUtils.isEmpty((CharSequence)im2.d())) {
            miPushMessage.setMessageType(1);
            miPushMessage.setAlias(im2.d());
        } else if (!TextUtils.isEmpty((CharSequence)im2.c())) {
            miPushMessage.setMessageType(2);
            miPushMessage.setTopic(im2.c());
        } else if (!TextUtils.isEmpty((CharSequence)im2.f())) {
            miPushMessage.setMessageType(3);
            miPushMessage.setUserAccount(im2.f());
        } else {
            miPushMessage.setMessageType(0);
        }
        miPushMessage.setCategory(im2.e());
        if (im2.a() != null) {
            miPushMessage.setContent(im2.a().c());
        }
        if (hw2 != null) {
            if (TextUtils.isEmpty((CharSequence)miPushMessage.getMessageId())) {
                miPushMessage.setMessageId(hw2.a());
            }
            if (TextUtils.isEmpty((CharSequence)miPushMessage.getTopic())) {
                miPushMessage.setTopic(hw2.b());
            }
            miPushMessage.setDescription(hw2.d());
            miPushMessage.setTitle(hw2.c());
            miPushMessage.setNotifyType(hw2.a());
            miPushMessage.setNotifyId(hw2.c());
            miPushMessage.setPassThrough(hw2.b());
            miPushMessage.setExtra(hw2.a());
        }
        miPushMessage.setNotified(bl2);
        return miPushMessage;
    }

    public static hw generateMessage(MiPushMessage miPushMessage) {
        hw hw2 = new hw();
        hw2.a(miPushMessage.getMessageId());
        hw2.b(miPushMessage.getTopic());
        hw2.d(miPushMessage.getDescription());
        hw2.c(miPushMessage.getTitle());
        hw2.c(miPushMessage.getNotifyId());
        hw2.a(miPushMessage.getNotifyType());
        hw2.b(miPushMessage.getPassThrough());
        hw2.a(miPushMessage.getExtra());
        return hw2;
    }
}

