/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import com.felipecsl.gifimageview.library.GifImageView;
import io.rong.imkit.utilities.RongUtils;
import io.rong.sticker.R;
import io.rong.sticker.businesslogic.GifImageLoader;
import io.rong.sticker.model.Sticker;

public class StickerPopupWindow
extends PopupWindow {
    private static StickerPopupWindow instance;

    public static synchronized StickerPopupWindow getInstance(Context context) {
        if (instance == null) {
            instance = new StickerPopupWindow(context);
        }
        return instance;
    }

    StickerPopupWindow(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.rc_sticker_popup, null);
        this.setContentView(view);
        this.setWidth(-2);
        this.setHeight(-2);
    }

    public void show(View view, Sticker sticker, Background bg) {
        int yoff;
        int xoff;
        View contentView = this.getContentView();
        View background = contentView.findViewById(R.id.bg);
        background.setBackgroundResource(bg.resId);
        final GifImageView gifImageView = (GifImageView)contentView.findViewById(R.id.gif_view);
        GifImageLoader.getInstance().obtain(sticker, new GifImageLoader.SimpleCallback(){

            @Override
            public void onSuccess(byte[] bytes) {
                gifImageView.setBytes(bytes);
                gifImageView.startAnimation();
            }

            @Override
            public void onFail() {
                gifImageView.setBytes(null);
            }
        });
        if (contentView.getHeight() == 0) {
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)RongUtils.getScreenWidth(), (int)Integer.MIN_VALUE);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)RongUtils.getScreenHeight(), (int)Integer.MIN_VALUE);
            contentView.measure(widthMeasureSpec, heightMeasureSpec);
            xoff = this.getXoff(view, bg, contentView.getMeasuredWidth());
            yoff = -(view.getHeight() + contentView.getMeasuredHeight());
        } else {
            xoff = this.getXoff(view, bg, contentView.getWidth());
            yoff = -(view.getHeight() + contentView.getHeight());
        }
        this.showAsDropDown(view, xoff, yoff);
    }

    private int getXoff(View view, Background bg, int bgWidth) {
        switch (bg) {
            case MIDDLE: {
                return (view.getWidth() - bgWidth) / 2;
            }
            case LEFT: {
                return (view.getWidth() - bgWidth) / 2 + view.getContext().getResources().getDimensionPixelSize(R.dimen.popup_window_xoff);
            }
            case RIGHT: {
                return (view.getWidth() - bgWidth) / 2 - view.getContext().getResources().getDimensionPixelSize(R.dimen.popup_window_xoff);
            }
        }
        return 0;
    }

    public static enum Background {
        LEFT(R.drawable.rc_zuoyulan),
        MIDDLE(R.drawable.rc_zhongyulan),
        RIGHT(R.drawable.rc_youyulan);

        private final int resId;

        private Background(int resId) {
            this.resId = resId;
        }
    }
}

