/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.GridView;
import io.rong.sticker.businesslogic.StickerSendMessageTask;
import io.rong.sticker.model.Sticker;
import io.rong.sticker.widget.StickerGridItemView;
import io.rong.sticker.widget.StickerPopupWindow;

public class StickerGridView
extends GridView {
    private GestureDetector gestureDetector;
    private boolean isInLongPress;
    private Rect rect = new Rect();
    private StickerGridItemView focusChild;
    private StickerPopupWindow popupWindow;

    public StickerGridView(Context context) {
        super(context);
        this.init();
    }

    public StickerGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureTap());
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.gestureDetector.onTouchEvent(ev);
        switch (ev.getAction()) {
            case 2: {
                this.getParent().requestDisallowInterceptTouchEvent(this.isInLongPress);
                this.checkFocusChild(ev);
                break;
            }
            case 1: 
            case 3: {
                this.isInLongPress = false;
                if (this.focusChild != null) {
                    this.focusChild.setPressed(false);
                }
                this.focusChild = null;
                this.hidePopupWindow();
            }
        }
        return true;
    }

    private void checkFocusChild(MotionEvent ev) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            StickerGridItemView child = (StickerGridItemView)this.getChildAt(i);
            child.getHitRect(this.rect);
            if (!this.rect.contains((int)ev.getX(), (int)ev.getY())) continue;
            if (this.focusChild == child) break;
            this.onFocusChildChanged(this.focusChild, child);
            this.focusChild = child;
            break;
        }
    }

    private void onFocusChildChanged(StickerGridItemView focusChild, StickerGridItemView newFocusChild) {
        if (focusChild != null) {
            focusChild.setPressed(false);
        }
        if (newFocusChild != null) {
            newFocusChild.setPressed(true);
        }
        if (this.isInLongPress) {
            this.showPopupWindow(newFocusChild);
        }
    }

    private void sendMessage(Sticker sticker) {
        StickerSendMessageTask.sendMessage(sticker);
    }

    private int getChildIndex(View view) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChildAt(i) != view) continue;
            return i;
        }
        return -1;
    }

    private void showPopupWindow(StickerGridItemView view) {
        this.hidePopupWindow();
        this.popupWindow = new StickerPopupWindow(this.getContext());
        int index = this.getChildIndex((View)view);
        int viewColumnIndex = this.getChildColumnIndex(index);
        StickerPopupWindow.Background bg = viewColumnIndex == 0 ? StickerPopupWindow.Background.LEFT : (viewColumnIndex < this.getNumColumns() - 1 ? StickerPopupWindow.Background.MIDDLE : StickerPopupWindow.Background.RIGHT);
        this.popupWindow.show((View)view, view.getSticker(), bg);
    }

    private void hidePopupWindow() {
        if (this.popupWindow != null) {
            this.popupWindow.dismiss();
        }
    }

    private int getChildColumnIndex(int index) {
        return index % this.getNumColumns();
    }

    private class GestureTap
    extends GestureDetector.SimpleOnGestureListener {
        private GestureTap() {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            for (int i = 0; i < StickerGridView.this.getChildCount(); ++i) {
                StickerGridItemView child = (StickerGridItemView)StickerGridView.this.getChildAt(i);
                child.getHitRect(StickerGridView.this.rect);
                if (!StickerGridView.this.rect.contains((int)e.getX(), (int)e.getY())) continue;
                StickerGridView.this.sendMessage(child.getSticker());
                break;
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            StickerGridView.this.isInLongPress = true;
            if (StickerGridView.this.focusChild != null) {
                StickerGridView.this.showPopupWindow(StickerGridView.this.focusChild);
            }
        }
    }
}

