/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.rong.sticker.R;
import io.rong.sticker.model.Sticker;

public class StickerGridItemView
extends LinearLayout {
    private static final int ROW_NUM = 2;
    private Sticker sticker;
    private ImageView imageView;
    private TextView textView;

    public StickerGridItemView(Context context) {
        super(context);
        this.init();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getParent() != null) {
            GridView parent = (GridView)this.getParent();
            int width = parent.getWidth() / parent.getNumColumns();
            int height = parent.getHeight() / 2;
            this.setMeasuredDimension(width, height);
        }
    }

    private void init() {
        StickerGridItemView.inflate((Context)this.getContext(), (int)R.layout.rc_sticker, (ViewGroup)this);
        this.setOrientation(1);
        this.setGravity(17);
        this.imageView = (ImageView)this.findViewById(R.id.iv);
        this.textView = (TextView)this.findViewById(R.id.tv);
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    public void setSticker(Sticker sticker) {
        this.sticker = sticker;
        this.updateView();
    }

    private void updateView() {
        Bitmap bitmap = BitmapFactory.decodeFile((String)this.sticker.getLocalThumbUrl());
        this.imageView.setImageBitmap(bitmap);
        this.textView.setText((CharSequence)this.sticker.getDigest());
    }
}

