/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.widget;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import io.rong.sticker.R;

public class IndicatorView
extends LinearLayout {
    public IndicatorView(Context context) {
        super(context);
    }

    public IndicatorView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public void setCount(int count) {
        this.updateView(count);
        this.setSelect(0);
    }

    public void setSelect(int index) {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            if (i == index) {
                view.setSelected(true);
                continue;
            }
            view.setSelected(false);
        }
    }

    private void updateView(int count) {
        this.removeAllViews();
        for (int i = 0; i < count; ++i) {
            View dotView = this.createDotView(i == 0);
            this.addView(dotView);
        }
    }

    private View createDotView(boolean isFirst) {
        View view = new View(this.getContext());
        view.setBackgroundResource(R.drawable.indicator_dot);
        int size = this.getResources().getDimensionPixelSize(R.dimen.indicator_dot_size);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(size, size);
        if (!isFirst) {
            int marginLeft = this.getResources().getDimensionPixelSize(R.dimen.indicator_dot_space);
            lp.setMargins(marginLeft, 0, 0, 0);
        }
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
        return view;
    }
}

