/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.widget;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import io.rong.imageloader.core.DisplayImageOptions;
import io.rong.imageloader.core.ImageLoader;
import io.rong.sticker.R;
import io.rong.sticker.businesslogic.StickerPackageDownloadTask;
import io.rong.sticker.model.StickerPackage;
import io.rong.sticker.util.DownloadUtil;
import io.rong.sticker.widget.DownloadProgressView;

public class DownloadStickerView
extends FrameLayout {
    private StickerPackage stickerPackage;
    private ImageView iv;
    private TextView tv;
    private DownloadProgressView downloadBtn;
    private boolean isDownloading;
    private DownloadUtil.DownloadListener downloadListener = new DownloadUtil.DownloadListener(){

        @Override
        public void onProgress(final int progress) {
            DownloadStickerView.this.post(new Runnable(){

                @Override
                public void run() {
                    DownloadStickerView.this.downloadBtn.setProgress(progress);
                }
            });
        }

        @Override
        public void onComplete(String path) {
        }

        @Override
        public void onError(Exception e) {
            DownloadStickerView.this.post(new Runnable(){

                @Override
                public void run() {
                    DownloadStickerView.this.downloadBtn.setStatus(0);
                    String content = DownloadStickerView.this.getResources().getString(R.string.sticker_download_fail, new Object[]{DownloadStickerView.this.stickerPackage.getName()});
                    Toast.makeText((Context)DownloadStickerView.this.getContext(), (CharSequence)content, (int)0).show();
                    DownloadStickerView.this.isDownloading = false;
                }
            });
        }
    };

    public DownloadStickerView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        DownloadStickerView.inflate((Context)this.getContext(), (int)R.layout.rc_sticker_download_page, (ViewGroup)this);
        this.iv = (ImageView)this.findViewById(R.id.iv_cover);
        this.tv = (TextView)this.findViewById(R.id.package_name);
        this.downloadBtn = (DownloadProgressView)this.findViewById(R.id.btn);
    }

    public void setStickerPackage(StickerPackage stickerPackage) {
        this.stickerPackage = stickerPackage;
        this.update();
    }

    private void update() {
        DisplayImageOptions options = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true).showImageOnLoading(R.drawable.rc_cover_loading).showImageOnFail(R.drawable.rc_cover_failed).build();
        ImageLoader.getInstance().displayImage(this.stickerPackage.getCover(), this.iv, options);
        this.tv.setText((CharSequence)this.stickerPackage.getName());
        this.downloadBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DownloadStickerView.this.isDownloading) {
                    return;
                }
                DownloadStickerView.this.isDownloading = true;
                StickerPackageDownloadTask task = new StickerPackageDownloadTask(DownloadStickerView.this.getContext(), DownloadStickerView.this.stickerPackage.getPackageId());
                task.downloadStickerPackage(DownloadStickerView.this.downloadListener);
            }
        });
    }
}

