/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import io.rong.sticker.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class DownloadProgressView
extends View {
    private Paint bgPaint;
    private Paint tvPaint;
    private RectF rectF;
    private int strokeWidth;
    private int radius;
    private int progress = 30;
    private int status = 0;
    public static final int NOT_DOWNLOAD = 0;
    public static final int DOWNLOADING = 1;

    public DownloadProgressView(Context context) {
        super(context);
        this.init();
    }

    public DownloadProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.bgPaint = new Paint(1);
        this.strokeWidth = this.getResources().getDimensionPixelOffset(R.dimen.download_progress_stroke_width);
        this.bgPaint.setStrokeWidth((float)this.strokeWidth);
        this.tvPaint = new Paint(1);
        this.tvPaint.setColor(-6710887);
        this.tvPaint.setTextSize((float)this.getResources().getDimensionPixelSize(R.dimen.download_progress_text_size));
        this.tvPaint.setTextAlign(Paint.Align.CENTER);
        this.rectF = new RectF();
        this.rectF.left = this.strokeWidth / 2;
        this.rectF.top = this.strokeWidth / 2;
        this.radius = this.getResources().getDimensionPixelSize(R.dimen.download_progress_radius);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (h != oldh) {
            this.rectF.bottom = h - this.strokeWidth / 2;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.status == 0) {
            this.drawNotDownload(canvas);
            this.tvPaint.setTextSize((float)this.getResources().getDimensionPixelSize(R.dimen.download_text_size));
            this.tvPaint.setColor(-1);
            this.drawText(canvas, this.getResources().getString(R.string.download_sticker));
        } else {
            this.drawDownloading(canvas);
            this.tvPaint.setTextSize((float)this.getResources().getDimensionPixelSize(R.dimen.download_progress_text_size));
            this.tvPaint.setColor(0x50333333);
            String text = this.progress + "%";
            this.drawText(canvas, text);
        }
    }

    public void setStatus(int status) {
        this.status = status;
        this.invalidate();
    }

    public void setProgress(int progress) {
        if (this.status == 0) {
            this.status = 1;
        }
        this.progress = progress;
        this.invalidate();
    }

    private void drawNotDownload(Canvas canvas) {
        this.bgPaint.setColor(-16737793);
        this.bgPaint.setStyle(Paint.Style.FILL);
        this.rectF.right = this.getWidth() - this.strokeWidth;
        canvas.drawRoundRect(this.rectF, (float)this.radius, (float)this.radius, this.bgPaint);
    }

    private void drawDownloading(Canvas canvas) {
        this.bgPaint.setColor(-9583361);
        this.bgPaint.setStyle(Paint.Style.STROKE);
        this.rectF.right = this.getWidth() - this.strokeWidth;
        canvas.drawRoundRect(this.rectF, (float)this.radius, (float)this.radius, this.bgPaint);
        this.rectF.right = this.rectF.left + (float)this.progress / 100.0f * (float)(this.getWidth() - this.strokeWidth);
        this.bgPaint.setStyle(Paint.Style.FILL);
        canvas.drawRoundRect(this.rectF, (float)this.radius, (float)this.radius, this.bgPaint);
    }

    private void drawText(Canvas canvas, String text) {
        int x = this.getWidth() / 2;
        int y = (int)((float)(this.getHeight() / 2) - (this.tvPaint.descent() + this.tvPaint.ascent()) / 2.0f);
        canvas.drawText(text, (float)x, (float)y, this.tvPaint);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

