/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.util;

import android.util.Log;
import io.rong.common.rlog.RLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    private static final String TAG = "ZipUtil";
    private static final int BUFFER = 2048;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String[] files, String zipFile) {
        FileInputStream fi = null;
        try {
            FileOutputStream dest = new FileOutputStream(zipFile);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[2048];
            for (String file : files) {
                int count;
                Log.v((String)"Compress", (String)("Adding: " + file));
                fi = new FileInputStream(file);
                BufferedInputStream origin = new BufferedInputStream(fi, 2048);
                ZipEntry entry = new ZipEntry(file.substring(file.lastIndexOf("/") + 1));
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"zip:", (Throwable)e);
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"zip:", (Throwable)e);
                }
            }
        }
    }

    public static void unzip(String zipFilePath) {
        File file = new File(zipFilePath);
        String location = file.getParent() + File.separator;
        ZipUtil.unzip(zipFilePath, location);
    }

    public static void unzip(String zipFile, String location) {
        try {
            ZipEntry ze;
            FileInputStream fin = new FileInputStream(zipFile);
            ZipInputStream zin = new ZipInputStream(fin);
            ZipUtil.dirChecker(location);
            while ((ze = zin.getNextEntry()) != null) {
                int count;
                if (ze.isDirectory()) {
                    ZipUtil.dirChecker(location + ze.getName());
                    continue;
                }
                FileOutputStream fout = new FileOutputStream(location + ze.getName());
                byte[] data = new byte[2048];
                while ((count = zin.read(data, 0, 2048)) != -1) {
                    fout.write(data, 0, count);
                }
                zin.closeEntry();
                fout.close();
            }
            zin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void dirChecker(String path) {
        boolean successMkdir;
        File f = new File(path);
        if (!f.isDirectory() && !(successMkdir = f.mkdirs())) {
            RLog.e((String)TAG, (String)"Created folders UnSuccessfully");
        }
    }
}

