/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.util;

import com.google.gson.Gson;
import io.rong.sticker.model.FullResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;

public class HttpUtil {
    private static Gson gson = new Gson();

    public static <T> void get(String urlString, Callback<T> callback) {
        HttpUtil.get(urlString, null, callback);
    }

    public static <T> void get(String urlString, Map<String, String> map, Callback<T> callback) {
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (map != null) {
                Set<Map.Entry<String, String>> set = map.entrySet();
                for (Map.Entry<String, String> entry : set) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            InputStream inputStream = connection.getInputStream();
            String result = HttpUtil.inputStreamToString(inputStream);
            Type[] types = callback.getClass().getGenericInterfaces();
            Type type = ((ParameterizedType)types[0]).getActualTypeArguments()[0];
            FullResponse response = (FullResponse)gson.fromJson(result, (Type)new ResultType(type));
            callback.onSuccess(response.getData());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            callback.onError(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            callback.onError(e);
        }
    }

    public static <T> T get(String urlString, Map<String, String> map, Type typeOfT) throws IOException {
        int responseCode;
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (map != null) {
            Set<Map.Entry<String, String>> set = map.entrySet();
            for (Map.Entry<String, String> entry : set) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if ((responseCode = connection.getResponseCode()) == 200) {
            InputStream inputStream = connection.getInputStream();
            String result = HttpUtil.inputStreamToString(inputStream);
            FullResponse response = (FullResponse)gson.fromJson(result, (Type)new ResultType(typeOfT));
            return response.getData();
        }
        throw new RuntimeException("http error: " + responseCode);
    }

    private static String inputStreamToString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    private static class ResultType
    implements ParameterizedType {
        private final Type type;

        public ResultType(Type type) {
            this.type = type;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.type};
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type getRawType() {
            return FullResponse.class;
        }
    }

    public static interface Callback<T> {
        public void onSuccess(T var1);

        public void onError(Exception var1);
    }
}

