/*
 * Decompiled with CFR 0.152.
 */
package io.rong.sticker.util;

import io.rong.common.rlog.RLog;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

public class FileUtil {
    private static final String TAG = "FileUtil";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String content, File file) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(File file) {
        BufferedReader reader = null;
        try {
            int read;
            reader = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = reader.read(buffer, 0, buffer.length)) != -1) {
                sb.append(buffer, 0, read);
            }
            String string2 = sb.toString();
            return string2;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String string3 = null;
            return string3;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string4 = null;
            return string4;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static byte[] toByteArray(String filePath) {
        File file = new File(filePath);
        return FileUtil.toByteArray(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(File file) {
        FileInputStream fis = null;
        InputStream inputStream = null;
        ByteArrayOutputStream result = null;
        try {
            int length;
            fis = new FileInputStream(file);
            inputStream = new BufferedInputStream(fis);
            result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            RLog.e((String)TAG, (String)"toByteArray", (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"toByteArray", (Throwable)e);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"toByteArray", (Throwable)e);
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    RLog.e((String)TAG, (String)"toByteArray", (Throwable)e);
                }
            }
        }
    }

    public static void recursiveDelete(File file) {
        boolean success;
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                FileUtil.recursiveDelete(f);
            }
        }
        if (!(success = file.delete())) {
            RLog.e((String)TAG, (String)"recursiveDelete unSuccessfully");
        }
    }
}

